/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.net.httpclient;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.antcontrib.net.httpclient.HttpClientType;
import net.sf.antcontrib.net.httpclient.MethodParams;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.util.FileUtils;

public abstract class AbstractMethodTask
extends Task {
    private HttpMethodBase method;
    private File responseDataFile;
    private String responseDataProperty;
    private String statusCodeProperty;
    private HttpClient httpClient;
    private List responseHeaders = new ArrayList();

    protected abstract HttpMethodBase createNewMethod();

    protected void configureMethod(HttpMethodBase method) {
    }

    protected void cleanupResources(HttpMethodBase method) {
    }

    public void addConfiguredResponseHeader(ResponseHeader responseHeader) {
        this.responseHeaders.add(responseHeader);
    }

    public void addConfiguredHttpClient(HttpClientType httpClientType) {
        this.httpClient = httpClientType.getClient();
    }

    protected HttpMethodBase createMethodIfNecessary() {
        if (this.method == null) {
            this.method = this.createNewMethod();
        }
        return this.method;
    }

    public void setResponseDataFile(File responseDataFile) {
        this.responseDataFile = responseDataFile;
    }

    public void setResponseDataProperty(String responseDataProperty) {
        this.responseDataProperty = responseDataProperty;
    }

    public void setStatusCodeProperty(String statusCodeProperty) {
        this.statusCodeProperty = statusCodeProperty;
    }

    public void setClientRefId(String clientRefId) {
        Object clientRef = this.getProject().getReference(clientRefId);
        if (clientRef == null) {
            throw new BuildException("Reference '" + clientRefId + "' does not exist.");
        }
        if (!(clientRef instanceof HttpClientType)) {
            throw new BuildException("Reference '" + clientRefId + "' is of the wrong type.");
        }
        this.httpClient = ((HttpClientType)((Object)clientRef)).getClient();
    }

    public void setDoAuthentication(boolean doAuthentication) {
        this.createMethodIfNecessary().setDoAuthentication(doAuthentication);
    }

    public void setFollowRedirects(boolean doFollowRedirects) {
        this.createMethodIfNecessary().setFollowRedirects(doFollowRedirects);
    }

    public void addConfiguredParams(MethodParams params) {
        this.createMethodIfNecessary().setParams((HttpMethodParams)params);
    }

    public void setPath(String path) {
        this.createMethodIfNecessary().setPath(path);
    }

    public void setURL(String url) {
        try {
            this.createMethodIfNecessary().setURI(new URI(url, false));
        }
        catch (URIException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void setQueryString(String queryString) {
        this.createMethodIfNecessary().setQueryString(queryString);
    }

    public void addConfiguredHeader(Header header) {
        this.createMethodIfNecessary().setRequestHeader(header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this.httpClient == null) {
            this.httpClient = new HttpClient();
        }
        HttpMethodBase method = this.createMethodIfNecessary();
        this.configureMethod(method);
        try {
            try {
                int statusCode = this.httpClient.executeMethod((HttpMethod)method);
                if (this.statusCodeProperty != null) {
                    Property p = (Property)this.getProject().createTask("property");
                    p.setName(this.statusCodeProperty);
                    p.setValue(String.valueOf(statusCode));
                    p.perform();
                }
                Iterator it = this.responseHeaders.iterator();
                while (it.hasNext()) {
                    ResponseHeader header = (ResponseHeader)it.next();
                    Property p = (Property)this.getProject().createTask("property");
                    p.setName(header.getProperty());
                    Header h = method.getResponseHeader(header.getName());
                    if (h == null || h.getValue() == null) continue;
                    p.setValue(h.getValue());
                    p.perform();
                }
                if (this.responseDataProperty != null) {
                    Property p = (Property)this.getProject().createTask("property");
                    p.setName(this.responseDataProperty);
                    p.setValue(method.getResponseBodyAsString());
                    p.perform();
                } else if (this.responseDataFile != null) {
                    FileOutputStream fos = null;
                    InputStream is = null;
                    try {
                        is = method.getResponseBodyAsStream();
                        fos = new FileOutputStream(this.responseDataFile);
                        byte[] buf = new byte[10240];
                        int read = 0;
                        while ((read = is.read(buf, 0, 10240)) != -1) {
                            fos.write(buf, 0, read);
                        }
                        Object var9_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_10 = null;
                        FileUtils.close(fos);
                        FileUtils.close((InputStream)is);
                        throw throwable;
                    }
                    FileUtils.close((OutputStream)fos);
                    FileUtils.close((InputStream)is);
                    {
                    }
                }
                Object var11_12 = null;
                this.cleanupResources(method);
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            this.cleanupResources(method);
            throw throwable;
        }
    }

    public static class ResponseHeader {
        private String name;
        private String property;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getProperty() {
            return this.property;
        }

        public void setProperty(String property) {
            this.property = property;
        }
    }
}

