/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.classpath;

import com.sun.tdk.signaturetest.classpath.ClasspathEntry;
import com.sun.tdk.signaturetest.core.AppContext;
import com.sun.tdk.signaturetest.core.ClassDescriptionLoader;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.sigfile.FileManager;
import com.sun.tdk.signaturetest.sigfile.MultipleFileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class SigFileEntry
extends ClasspathEntry
implements ClassDescriptionLoader {
    TreeMap<String, ClassDescription> readClasses;
    Iterator<Map.Entry<String, ClassDescription>> it;

    public SigFileEntry(ClasspathEntry previousEntry, String sigfile) throws IOException {
        super(previousEntry);
        this.init(sigfile);
    }

    @Override
    public void init(String sigFileName) throws IOException {
        FileManager fm = new FileManager();
        PrintWriter log = AppContext.getContext().getLogWriter();
        MultipleFileReader in = new MultipleFileReader(log, 1, fm);
        if (in != null) {
            ClassDescription currentClass;
            if (!in.readSignatureFile("", sigFileName)) {
                in.close();
                throw new IOException("Can't read " + sigFileName);
            }
            this.readClasses = new TreeMap();
            in.rewind();
            while ((currentClass = in.nextClass()) != null) {
                this.readClasses.put(currentClass.getQualifiedName(), currentClass);
            }
        }
        this.setListToBegin();
    }

    @Override
    public void close() {
        assert (this.readClasses != null);
        this.readClasses.clear();
    }

    @Override
    public InputStream findClass(String qualifiedClassName) throws IOException, ClassNotFoundException {
        throw new ClassNotFoundException(qualifiedClassName);
    }

    @Override
    public ClassDescription load(String qualifiedClassName) throws ClassNotFoundException {
        assert (this.readClasses != null);
        if (!this.readClasses.containsKey(qualifiedClassName)) {
            throw new ClassNotFoundException(qualifiedClassName);
        }
        return this.readClasses.get(qualifiedClassName);
    }

    @Override
    protected boolean contains(String className) {
        return this.readClasses.containsKey(className);
    }

    @Override
    public boolean isEmpty() {
        return this.readClasses.isEmpty();
    }

    @Override
    public boolean hasNext() {
        assert (this.it != null);
        return this.it.hasNext();
    }

    @Override
    public String nextClassName() {
        assert (this.it != null);
        return this.it.next().getKey();
    }

    @Override
    public void setListToBegin() {
        this.it = this.readClasses.entrySet().iterator();
    }
}

