/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class GenerateTOTPSharedSecretExtendedResult
extends ExtendedResult {
    public static final String GENERATE_TOTP_SHARED_SECRET_RESULT_OID = "1.3.6.1.4.1.30221.2.6.57";
    private static final byte TYPE_TOTP_SHARED_SECRET = -128;
    private static final long serialVersionUID = 8505040895542971346L;
    private final String totpSharedSecret;

    public GenerateTOTPSharedSecretExtendedResult(int messageID, String totpSharedSecret, Control ... responseControls) {
        this(messageID, ResultCode.SUCCESS, null, null, null, totpSharedSecret, responseControls);
    }

    public GenerateTOTPSharedSecretExtendedResult(int messageID, ResultCode resultCode, String diagnosticMessage, String matchedDN, String[] referralURLs, String totpSharedSecret, Control ... responseControls) {
        super(messageID, resultCode, diagnosticMessage, matchedDN, referralURLs, totpSharedSecret == null ? null : GENERATE_TOTP_SHARED_SECRET_RESULT_OID, GenerateTOTPSharedSecretExtendedResult.encodeValue(totpSharedSecret), responseControls);
        this.totpSharedSecret = totpSharedSecret;
        if (totpSharedSecret == null) {
            Validator.ensureTrue(resultCode != ResultCode.SUCCESS, "If the result code is SUCCESS, the TOTP shared secret must be non-null");
        }
    }

    public GenerateTOTPSharedSecretExtendedResult(ExtendedResult extendedResult) throws LDAPException {
        super(extendedResult);
        ASN1OctetString value = extendedResult.getValue();
        if (value == null) {
            this.totpSharedSecret = null;
        } else {
            try {
                ASN1Element[] elements = ASN1Sequence.decodeAsSequence(value.getValue()).elements();
                this.totpSharedSecret = ASN1OctetString.decodeAsOctetString(elements[0]).stringValue();
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_GEN_TOTP_SECRET_RESULT_ERROR_DECODING_VALUE.get(StaticUtils.getExceptionMessage(e)));
            }
        }
    }

    private static ASN1OctetString encodeValue(String totpSharedSecret) {
        if (totpSharedSecret == null) {
            return null;
        }
        return new ASN1OctetString(new ASN1Sequence(new ASN1OctetString(-128, totpSharedSecret)).encode());
    }

    public String getTOTPSharedSecret() {
        return this.totpSharedSecret;
    }

    @Override
    public String getExtendedResultName() {
        return ExtOpMessages.INFO_GEN_TOTP_SECRET_RESULT_NAME.get();
    }

    @Override
    public void toString(StringBuilder buffer) {
        Control[] responseControls;
        String[] referralURLs;
        String matchedDN;
        String diagnosticMessage;
        buffer.append("GenerateTOTPSharedSecretExtendedResult(resultCode=");
        buffer.append(this.getResultCode());
        int messageID = this.getMessageID();
        if (messageID >= 0) {
            buffer.append(", messageID=");
            buffer.append(messageID);
        }
        if ((diagnosticMessage = this.getDiagnosticMessage()) != null) {
            buffer.append(", diagnosticMessage='");
            buffer.append(diagnosticMessage);
            buffer.append('\'');
        }
        if ((matchedDN = this.getMatchedDN()) != null) {
            buffer.append(", matchedDN='");
            buffer.append(matchedDN);
            buffer.append('\'');
        }
        if ((referralURLs = this.getReferralURLs()).length > 0) {
            buffer.append(", referralURLs={");
            for (int i = 0; i < referralURLs.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append('\'');
                buffer.append(referralURLs[i]);
                buffer.append('\'');
            }
            buffer.append('}');
        }
        if ((responseControls = this.getResponseControls()).length > 0) {
            buffer.append(", responseControls={");
            for (int i = 0; i < responseControls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(responseControls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

