/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.audit;

import com.sun.javatest.InterviewParameters;
import com.sun.javatest.audit.Audit;
import com.sun.javatest.audit.AuditToolManager;
import com.sun.javatest.tool.Command;
import com.sun.javatest.tool.CommandContext;
import com.sun.javatest.tool.CommandManager;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.util.HelpTree;
import com.sun.javatest.util.I18NResourceBundle;
import java.util.ListIterator;

public class AuditCommandManager
extends CommandManager {
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(AuditCommandManager.class);

    @Override
    public HelpTree.Node getHelp() {
        String[] cmds = new String[]{"audit", "showAudit"};
        return new HelpTree.Node(i18n, "cmgr.help", cmds);
    }

    @Override
    public boolean parseCommand(String cmd, ListIterator argIter, CommandContext ctx) throws Command.Fault {
        if (cmd.equalsIgnoreCase(AuditCommand.getName())) {
            ctx.addCommand(new AuditCommand(argIter));
            return true;
        }
        if (cmd.equalsIgnoreCase(ShowAuditCommand.getName())) {
            ctx.addCommand(new ShowAuditCommand(argIter));
            return true;
        }
        return false;
    }

    private static class ShowAuditCommand
    extends Command {
        static String getName() {
            return "showAudit";
        }

        ShowAuditCommand(ListIterator argIter) {
            super(ShowAuditCommand.getName());
        }

        @Override
        public int getDesktopMode() {
            return 2;
        }

        @Override
        public void run(CommandContext ctx) {
            Desktop d = ctx.getDesktop();
            AuditToolManager tm = (AuditToolManager)d.getToolManager(AuditToolManager.class);
            tm.startTool();
        }
    }

    private static class AuditCommand
    extends Command {
        private boolean showAllEnvValues;
        private boolean showMultipleEnvValues;

        static String getName() {
            return "audit";
        }

        AuditCommand(ListIterator argIter) throws Command.Fault {
            super(AuditCommand.getName());
            while (argIter.hasNext()) {
                String arg = this.nextArg(argIter);
                if (arg.equalsIgnoreCase("-showEnvValues")) {
                    this.showAllEnvValues = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("-showMultipleEnvValues")) {
                    this.showMultipleEnvValues = true;
                    continue;
                }
                this.putbackArg(argIter);
                break;
            }
        }

        @Override
        public boolean isActionCommand() {
            return true;
        }

        @Override
        public void run(CommandContext ctx) throws Command.Fault {
            InterviewParameters p = this.getConfig(ctx);
            Audit a = new Audit(p);
            a.report(System.out, this.showAllEnvValues, this.showMultipleEnvValues);
            if (a.isOK()) {
                ctx.printMessage(i18n, "audit.ok");
            } else {
                ctx.printErrorMessage(i18n, "audit.failed");
            }
        }
    }
}

