/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.common;

import com.sun.ts.tests.jsonp.api.common.JsonValueType;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.json.JsonArrayBuilder;
import javax.json.JsonValue;

public class ArrayBuilder {
    public static JsonArrayBuilder add(JsonArrayBuilder builder, Object value) {
        switch (JsonValueType.getType(value)) {
            case String: {
                return builder.add((String)value);
            }
            case Integer: {
                return builder.add(((Integer)value).intValue());
            }
            case Long: {
                return builder.add(((Long)value).intValue());
            }
            case BigInteger: {
                return builder.add((BigInteger)value);
            }
            case Double: {
                return builder.add(((Double)value).doubleValue());
            }
            case BigDecimal: {
                return builder.add((BigDecimal)value);
            }
            case Boolean: {
                return builder.add(((Boolean)value).booleanValue());
            }
            case JsonValue: {
                return builder.add((JsonValue)value);
            }
            case Null: {
                return builder.addNull();
            }
        }
        throw new IllegalArgumentException("Value does not match known JSON value type");
    }

    public static JsonArrayBuilder add(JsonArrayBuilder builder, int index, Object value) {
        switch (JsonValueType.getType(value)) {
            case String: {
                return builder.add(index, (String)value);
            }
            case Integer: {
                return builder.add(index, ((Integer)value).intValue());
            }
            case Long: {
                return builder.add(index, ((Long)value).longValue());
            }
            case BigInteger: {
                return builder.add(index, (BigInteger)value);
            }
            case Double: {
                return builder.add(index, ((Double)value).doubleValue());
            }
            case BigDecimal: {
                return builder.add(index, (BigDecimal)value);
            }
            case Boolean: {
                return builder.add(index, ((Boolean)value).booleanValue());
            }
            case JsonValue: {
                return builder.add(index, (JsonValue)value);
            }
            case Null: {
                return builder.addNull(index);
            }
        }
        throw new IllegalArgumentException("Value does not match known JSON value type");
    }

    public static JsonArrayBuilder add(JsonArrayBuilder builder, JsonValueType type) {
        switch (type) {
            case String: {
                return builder.add((String)null);
            }
            case Integer: {
                throw new UnsupportedOperationException("Value null is not supported for int");
            }
            case Long: {
                throw new UnsupportedOperationException("Value null is not supported for long");
            }
            case BigInteger: {
                return builder.add((BigInteger)null);
            }
            case Double: {
                throw new UnsupportedOperationException("Value null is not supported for double");
            }
            case BigDecimal: {
                return builder.add((BigDecimal)null);
            }
            case Boolean: {
                return builder.add(((Boolean)null).booleanValue());
            }
            case JsonValue: {
                return builder.add((JsonValue)null);
            }
            case Null: {
                throw new UnsupportedOperationException("Value null is not supported for addNull()");
            }
        }
        throw new IllegalArgumentException("Value does not match known JSON value type");
    }

    public static JsonArrayBuilder add(JsonArrayBuilder builder, int index, JsonValueType type) {
        switch (type) {
            case String: {
                return builder.add(index, (String)null);
            }
            case Integer: {
                throw new UnsupportedOperationException("Value null is not supported for int");
            }
            case Long: {
                throw new UnsupportedOperationException("Value null is not supported for long");
            }
            case BigInteger: {
                return builder.add(index, (BigInteger)null);
            }
            case Double: {
                throw new UnsupportedOperationException("Value null is not supported for double");
            }
            case BigDecimal: {
                return builder.add(index, (BigDecimal)null);
            }
            case Boolean: {
                return builder.add(index, ((Boolean)null).booleanValue());
            }
            case JsonValue: {
                return builder.add(index, (JsonValue)null);
            }
            case Null: {
                throw new UnsupportedOperationException("Value null is not supported for addNull()");
            }
        }
        throw new IllegalArgumentException("Value does not match known JSON value type");
    }

    public static JsonArrayBuilder set(JsonArrayBuilder builder, int index, Object value) {
        switch (JsonValueType.getType(value)) {
            case String: {
                return builder.set(index, (String)value);
            }
            case Integer: {
                return builder.set(index, ((Integer)value).intValue());
            }
            case Long: {
                return builder.set(index, ((Long)value).longValue());
            }
            case BigInteger: {
                return builder.set(index, (BigInteger)value);
            }
            case Double: {
                return builder.set(index, ((Double)value).doubleValue());
            }
            case BigDecimal: {
                return builder.set(index, (BigDecimal)value);
            }
            case Boolean: {
                return builder.set(index, ((Boolean)value).booleanValue());
            }
            case JsonValue: {
                return builder.set(index, (JsonValue)value);
            }
            case Null: {
                return builder.setNull(index);
            }
        }
        throw new IllegalArgumentException("Value does not match known JSON value type");
    }

    public static JsonArrayBuilder set(JsonArrayBuilder builder, int index, JsonValueType type) {
        switch (type) {
            case String: {
                return builder.set(index, (String)null);
            }
            case Integer: {
                throw new UnsupportedOperationException("Value null is not supported for int");
            }
            case Long: {
                throw new UnsupportedOperationException("Value null is not supported for long");
            }
            case BigInteger: {
                return builder.set(index, (BigInteger)null);
            }
            case Double: {
                throw new UnsupportedOperationException("Value null is not supported for double");
            }
            case BigDecimal: {
                return builder.set(index, (BigDecimal)null);
            }
            case Boolean: {
                return builder.set(index, ((Boolean)null).booleanValue());
            }
            case JsonValue: {
                return builder.set(index, (JsonValue)null);
            }
            case Null: {
                throw new UnsupportedOperationException("Value null is not supported for addNull()");
            }
        }
        throw new IllegalArgumentException("Value does not match known JSON value type");
    }

    public static JsonArrayBuilder remove(JsonArrayBuilder builder, int index) {
        return builder.remove(index);
    }
}

