/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.common.callback;

import com.sun.ts.tests.ejb30.common.callback.CallbackBeanBase;
import com.sun.ts.tests.ejb30.common.helper.TLogger;
import com.sun.ts.tests.ejb30.common.messaging.StatusReporter;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;

public abstract class MDBCallbackBeanBase
extends CallbackBeanBase
implements MessageListener {
    public void onMessage(Message msg) {
        boolean status = false;
        String reason = null;
        String testname = null;
        try {
            testname = msg.getStringProperty("COM_SUN_JMS_TESTNAME");
        }
        catch (JMSException e) {
            status = false;
            reason = "Failed to get test name from message: " + msg;
            TLogger.log(reason);
            StatusReporter.report(testname, status, reason, (QueueConnectionFactory)this.getEJBContext().lookup("qFactory"), (Queue)this.getEJBContext().lookup("replyQueue"));
            return;
        }
        if (testname.equals("isInjectionDoneTest")) {
            status = this.isInjectionDone();
            reason = "isInjectionDone() in onMessage returns: " + status;
        } else if (testname.equals("isPostConstructCalledTest")) {
            status = this.isPostConstructCalled();
            reason = "isPostConstructCalled() in onMessage returns: " + status;
        } else if (testname.equals("isPostConstructOrPreDestroyCalledTest")) {
            status = this.isPostConstructCalled() || this.isPreDestroyCalled();
            reason = "isPostConstructCalled() or isPreDestroyCalled() in onMessage returns: " + status;
        } else {
            status = false;
            reason = "Unrecognized test: " + testname;
        }
        TLogger.log(reason);
        StatusReporter.report(testname, status, reason, (QueueConnectionFactory)this.getEJBContext().lookup("qFactory"), (Queue)this.getEJBContext().lookup("replyQueue"));
    }
}

