/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.bb.localaccess.mdbclient;

import com.sun.ts.tests.ejb30.bb.localaccess.common.CommonIF;
import com.sun.ts.tests.ejb30.bb.localaccess.common.Constants;
import com.sun.ts.tests.ejb30.bb.localaccess.common.DefaultLocalIF;
import com.sun.ts.tests.ejb30.bb.localaccess.common.LocalIF;
import com.sun.ts.tests.ejb30.bb.localaccess.common.StatefulDefaultLocalIF;
import com.sun.ts.tests.ejb30.bb.localaccess.common.StatefulLocalIF;
import com.sun.ts.tests.ejb30.bb.localaccess.common.TestBeanBase;
import com.sun.ts.tests.ejb30.common.calc.CalculatorException;
import com.sun.ts.tests.ejb30.common.helper.TLogger;
import com.sun.ts.tests.ejb30.common.helper.TestFailedException;
import com.sun.ts.tests.ejb30.common.messaging.StatusReporter;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.EJB;
import javax.ejb.EJBContext;
import javax.ejb.EJBTransactionRolledbackException;
import javax.ejb.EJBs;
import javax.ejb.MessageDriven;
import javax.ejb.MessageDrivenContext;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.transaction.UserTransaction;

@MessageDriven(name="MdbTestBean", messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue")})
@EJBs(value={@EJB(name="ejb/localStatelessRefName", beanName="StatelessLocalBean", beanInterface=LocalIF.class), @EJB(name="ejb/localStateless2RefName", beanName="StatelessLocal2Bean", beanInterface=LocalIF.class), @EJB(name="ejb/defaultLocalStatelessRefName", beanName="StatelessDefaultLocalBean", beanInterface=DefaultLocalIF.class), @EJB(name="ejb/localStatefulRefName", beanName="StatefulLocalBean", beanInterface=StatefulLocalIF.class), @EJB(name="ejb/defaultLocalStatefulRefName", beanName="StatefulDefaultLocalBean", beanInterface=StatefulDefaultLocalIF.class)})
@TransactionManagement(value=TransactionManagementType.BEAN)
public class MdbTestBean
extends TestBeanBase
implements MessageListener,
Constants {
    @Resource(name="mdc")
    private MessageDrivenContext context;
    @Resource(name="ut")
    private UserTransaction ut;
    @Resource(name="qFactory")
    private QueueConnectionFactory qFactory;
    @Resource(name="replyQueue")
    private Queue replyQueue;
    private static final Map mBeanTypes = new HashMap();
    private static final Map mBeanRefNames = new HashMap();

    @Override
    public EJBContext getEJBContext() {
        return this.context;
    }

    public void onMessage(Message msg) {
        boolean status = false;
        String reason = null;
        String testname = null;
        try {
            testname = msg.getStringProperty("COM_SUN_JMS_TESTNAME");
        }
        catch (JMSException e) {
            status = false;
            reason = "Failed to get test name from message: " + msg;
            TLogger.log(reason);
            StatusReporter.report(testname, status, reason, this.qFactory, this.replyQueue);
            return;
        }
        if (this.isPassByReferenceTest(testname)) {
            this.passByReferenceTest(testname, new String[]{"in client"}, this.getBeanRefName(testname), this.getBeanType(testname));
        } else if (this.isExceptionTest(testname)) {
            this.exceptionTest(testname, this.getBeanRefName(testname), this.getBeanType(testname));
        } else if (this.isRuntimeExceptionTest(testname)) {
            this.runtimeExceptionTest(testname, this.getBeanRefName(testname), this.getBeanType(testname));
        } else {
            this.unrecognizedTest(testname);
        }
    }

    @Override
    public void remove() {
    }

    public void unrecognizedTest(String testname) {
        boolean status = false;
        String reason = "Unrecognized test: " + testname;
        TLogger.log(reason);
        StatusReporter.report(testname, status, reason, this.qFactory, this.replyQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void passByReferenceTest(String testname, String[] args, String refName, Class klass) {
        boolean status = true;
        String reason = null;
        CommonIF bean = null;
        try {
            bean = this.lookup(refName, klass);
        }
        catch (TestFailedException e) {
            status = false;
            reason = e.getMessage();
            TLogger.log(status, reason);
            StatusReporter.report(testname, status, reason, this.qFactory, this.replyQueue);
            return;
        }
        try {
            bean.passByReferenceTest(args);
        }
        catch (Exception e) {
            status = false;
            reason = "Unexpected exception: " + e.toString();
            TLogger.log(status, reason);
            StatusReporter.report(testname, status, reason, this.qFactory, this.replyQueue);
            return;
        }
        finally {
            try {
                bean.remove();
            }
            catch (Exception exception) {}
        }
        String expected = "in server";
        String actual = args[0];
        if (expected.equals(actual)) {
            status = true;
            reason = "Got expected value '" + expected + "'";
        } else {
            status = false;
            reason = "Expect '" + expected + "', but actual '" + actual + "'";
        }
        TLogger.log(status, reason);
        StatusReporter.report(testname, status, reason, this.qFactory, this.replyQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionTest(String testname, String refName, Class klass) {
        String reason;
        boolean status;
        block28: {
            status = true;
            reason = null;
            CommonIF bean = null;
            try {
                bean = this.lookup(refName, klass);
            }
            catch (TestFailedException e) {
                status = false;
                reason = e.getMessage();
                TLogger.log(status, reason);
                StatusReporter.report(testname, status, reason, this.qFactory, this.replyQueue);
                return;
            }
            try {
                this.ut.begin();
                bean.exceptionTest();
                status = false;
                reason = "Expect CalculatorException, but got no exception.";
            }
            catch (CalculatorException e) {
                int code = 5;
                try {
                    code = this.ut.getStatus();
                    if (code == 0) {
                        status = true;
                        reason = "Good, got expected exception and tx status.";
                        break block28;
                    }
                    status = false;
                    reason = "Got expected CalculatorException, but tx status " + code + " is not expected " + 0;
                }
                catch (Exception e2) {
                    status = false;
                    reason = "Failed to get ut.getStatus " + e2;
                }
            }
            catch (Exception e) {
                status = false;
                reason = "Expecting CalculatorException, but got " + e;
            }
            finally {
                try {
                    bean.remove();
                }
                catch (Exception e) {}
                try {
                    this.ut.rollback();
                }
                catch (Exception e) {}
            }
        }
        TLogger.log(status, reason);
        StatusReporter.report(testname, status, reason, this.qFactory, this.replyQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runtimeExceptionTest(String testname, String refName, Class klass) {
        String reason;
        boolean status;
        block28: {
            status = true;
            reason = null;
            CommonIF bean = null;
            try {
                bean = this.lookup(refName, klass);
            }
            catch (TestFailedException e) {
                status = false;
                reason = e.getMessage();
                TLogger.log(status, reason);
                StatusReporter.report(testname, status, reason, this.qFactory, this.replyQueue);
                return;
            }
            try {
                this.ut.begin();
                bean.runtimeExceptionTest();
                status = false;
                reason = "Expect javax.ejb.EJBTransactionRolledbackException, but got no exception.";
            }
            catch (EJBTransactionRolledbackException e) {
                int code = 5;
                try {
                    code = this.ut.getStatus();
                    if (code == 1) {
                        status = true;
                        reason = "Good, got expected exception and tx status.";
                        break block28;
                    }
                    status = false;
                    reason = "Got expected EJBTransactionRolledbackException, but tx status " + code + " is not expected " + 1;
                }
                catch (Exception e2) {
                    status = false;
                    reason = "Failed to get ut.getStatus " + e2;
                }
            }
            catch (Exception e) {
                status = false;
                reason = "Expecting EJBTransactionRolledbackException, but got " + e;
            }
            finally {
                try {
                    bean.remove();
                }
                catch (Exception e) {}
                try {
                    this.ut.rollback();
                }
                catch (Exception e) {}
            }
        }
        TLogger.log(status, reason);
        StatusReporter.report(testname, status, reason, this.qFactory, this.replyQueue);
    }

    private String getBeanRefName(String testname) {
        return (String)mBeanRefNames.get(testname);
    }

    private Class getBeanType(String testname) {
        return (Class)mBeanTypes.get(testname);
    }

    private boolean isRuntimeExceptionTest(String testname) {
        return "runtimeExceptionTest1".equals(testname) || "runtimeExceptionTest2".equals(testname) || "runtimeExceptionTest3".equals(testname) || "runtimeExceptionTest4".equals(testname) || "runtimeExceptionTest5".equals(testname);
    }

    private boolean isPassByReferenceTest(String testname) {
        return "passByReferenceTest1".equals(testname) || "passByReferenceTest2".equals(testname) || "passByReferenceTest3".equals(testname) || "passByReferenceTest4".equals(testname) || "passByReferenceTest5".equals(testname);
    }

    private boolean isExceptionTest(String testname) {
        return "exceptionTest1".equals(testname) || "exceptionTest2".equals(testname) || "exceptionTest3".equals(testname) || "exceptionTest4".equals(testname) || "exceptionTest5".equals(testname);
    }

    static {
        mBeanTypes.put("passByReferenceTest1", LocalIF.class);
        mBeanTypes.put("exceptionTest1", LocalIF.class);
        mBeanTypes.put("runtimeExceptionTest1", LocalIF.class);
        mBeanRefNames.put("passByReferenceTest1", "ejb/localStatelessRefName");
        mBeanRefNames.put("exceptionTest1", "ejb/localStatelessRefName");
        mBeanRefNames.put("runtimeExceptionTest1", "ejb/localStatelessRefName");
        mBeanTypes.put("passByReferenceTest2", DefaultLocalIF.class);
        mBeanTypes.put("exceptionTest2", DefaultLocalIF.class);
        mBeanTypes.put("runtimeExceptionTest2", DefaultLocalIF.class);
        mBeanRefNames.put("passByReferenceTest2", "ejb/defaultLocalStatelessRefName");
        mBeanRefNames.put("exceptionTest2", "ejb/defaultLocalStatelessRefName");
        mBeanRefNames.put("runtimeExceptionTest2", "ejb/defaultLocalStatelessRefName");
        mBeanTypes.put("passByReferenceTest3", StatefulLocalIF.class);
        mBeanTypes.put("exceptionTest3", StatefulLocalIF.class);
        mBeanTypes.put("runtimeExceptionTest3", StatefulLocalIF.class);
        mBeanRefNames.put("passByReferenceTest3", "ejb/localStatefulRefName");
        mBeanRefNames.put("exceptionTest3", "ejb/localStatefulRefName");
        mBeanRefNames.put("runtimeExceptionTest3", "ejb/localStatefulRefName");
        mBeanTypes.put("passByReferenceTest4", DefaultLocalIF.class);
        mBeanTypes.put("exceptionTest4", DefaultLocalIF.class);
        mBeanTypes.put("runtimeExceptionTest4", DefaultLocalIF.class);
        mBeanRefNames.put("passByReferenceTest4", "ejb/defaultLocalStatefulRefName");
        mBeanRefNames.put("exceptionTest4", "ejb/defaultLocalStatefulRefName");
        mBeanRefNames.put("runtimeExceptionTest4", "ejb/defaultLocalStatefulRefName");
        mBeanTypes.put("passByReferenceTest5", LocalIF.class);
        mBeanTypes.put("exceptionTest5", LocalIF.class);
        mBeanTypes.put("runtimeExceptionTest5", LocalIF.class);
        mBeanRefNames.put("passByReferenceTest5", "ejb/localStateless2RefName");
        mBeanRefNames.put("exceptionTest5", "ejb/localStateless2RefName");
        mBeanRefNames.put("runtimeExceptionTest5", "ejb/localStateless2RefName");
    }
}

