/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.misc.jndi.earjar;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.tests.ejb30.common.helloejbjar.HelloRemoteIF;
import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.common.helper.ServiceLocator;
import com.sun.ts.tests.ejb30.lite.basic.common.GlobalJNDITest;
import com.sun.ts.tests.ejb30.misc.jndi.earjar.TestIF;
import java.util.Properties;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.naming.Context;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class Client
extends EETest {
    public static final String APPCLIENT_MODULE_NAME = "misc_jndi_earjar_client";
    public static final String TEST_BEAN_NAME = "TestBean";
    public static final String HELLO_EJB_MODULE_NAME = "ejb3_common_helloejbjar_standalone_component_ejb";
    public static final String HELLO_BEAN_NAME = "HelloBean";
    @EJB(lookup="java:global/misc_jndi_earjar/misc_jndi_earjar_ejb/TestBean")
    private static TestIF testBean;
    @Resource(lookup="java:module/ModuleName")
    private static String moduleNameInjected;
    @Resource(lookup="java:app/AppName")
    private static String appNameInjected;
    @Resource
    private static Validator validator;
    @Resource
    private static ValidatorFactory validatorFactory;
    protected Properties props;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) {
        this.props = p;
    }

    public void cleanup() {
    }

    private String lookupTestBeanAndAdd(String lookupName) {
        Helper.getLogger().info("About to look up " + lookupName);
        TestIF b = (TestIF)ServiceLocator.lookupNoTry((String)lookupName, (Context[])new Context[0]);
        int x = 1;
        int y = 2;
        int expected = x + y;
        return Helper.assertEquals(null, (Object)expected, (Object)b.add(x, y));
    }

    public void beanValidator() {
        Helper.getLogger().info("Injected Validator: " + validator.toString());
        Helper.getLogger().info("Injected ValidatorFactory: " + validatorFactory.toString());
        ValidatorFactory vf = (ValidatorFactory)ServiceLocator.lookupNoTry((String)"java:comp/ValidatorFactory", (Context[])new Context[0]);
        Validator v = (Validator)ServiceLocator.lookupNoTry((String)"java:comp/Validator", (Context[])new Context[0]);
        Helper.getLogger().info("Looked up Validator: " + v.toString());
        Helper.getLogger().info("Looked up ValidatorFactory: " + vf.toString());
    }

    public void appNameModuleName() {
        StringBuilder sb = new StringBuilder();
        String lookup = "java:module/ModuleName";
        String expected = APPCLIENT_MODULE_NAME;
        String actual = (String)ServiceLocator.lookupNoTry((String)lookup, (Context[])new Context[0]);
        Helper.assertEquals((String)("Check " + lookup), (Object)expected, (Object)actual, (StringBuilder)sb);
        Helper.assertEquals((String)"Check injected value ", (Object)expected, (Object)moduleNameInjected, (StringBuilder)sb);
        lookup = "java:app/AppName";
        expected = "misc_jndi_earjar";
        actual = (String)ServiceLocator.lookupNoTry((String)lookup, (Context[])new Context[0]);
        Helper.assertEquals((String)("Check " + lookup), (Object)expected, (Object)actual, (StringBuilder)sb);
        Helper.assertEquals((String)"Check injected value ", (Object)expected, (Object)appNameInjected, (StringBuilder)sb);
        Helper.getLogger().info(sb.toString());
    }

    public void appNameModuleNameFromEJB() {
        Helper.getLogger().info(testBean.appNameModuleName());
    }

    public void globalJNDIHelloEJB() {
        String lookupName = GlobalJNDITest.getGlobalJNDIName(null, (String)HELLO_EJB_MODULE_NAME, (String)HELLO_BEAN_NAME, HelloRemoteIF.class);
        HelloRemoteIF h = (HelloRemoteIF)ServiceLocator.lookupNoTry((String)lookupName, (Context[])new Context[0]);
        Helper.getLogger().info(h.getMessage().toString());
    }

    public void ejbRefHello() {
        String lookupName = "java:comp/env/ejb/hello";
        HelloRemoteIF h = (HelloRemoteIF)ServiceLocator.lookupNoTry((String)lookupName, (Context[])new Context[0]);
        Helper.getLogger().info(h.getMessage().toString());
    }

    public void globalJNDIHelloEJB2() {
        Helper.getLogger().info(testBean.globalJNDIHelloEJB(null, HELLO_EJB_MODULE_NAME, HELLO_BEAN_NAME, HelloRemoteIF.class));
    }

    public void globalJNDI() {
        String lookupName = GlobalJNDITest.getGlobalJNDIName((String)"misc_jndi_earjar", (String)"misc_jndi_earjar_ejb", (String)TEST_BEAN_NAME);
        Helper.getLogger().info(this.lookupTestBeanAndAdd(lookupName));
        lookupName = GlobalJNDITest.getGlobalJNDIName((String)"misc_jndi_earjar", (String)"misc_jndi_earjar_ejb", (String)TEST_BEAN_NAME, TestIF.class);
        Helper.getLogger().info(this.lookupTestBeanAndAdd(lookupName));
    }

    public void appJNDI() {
        String lookupName = GlobalJNDITest.getAppJNDIName((String)"misc_jndi_earjar_ejb", (String)TEST_BEAN_NAME);
        Helper.getLogger().info(this.lookupTestBeanAndAdd(lookupName));
        lookupName = GlobalJNDITest.getAppJNDIName((String)"misc_jndi_earjar_ejb", (String)TEST_BEAN_NAME, TestIF.class);
        Helper.getLogger().info(this.lookupTestBeanAndAdd(lookupName));
    }

    public void globalJNDI2() {
        Helper.getLogger().info(testBean.globalJNDI("misc_jndi_earjar", "misc_jndi_earjar_ejb"));
    }

    public void appJNDI2() {
        Helper.getLogger().info(testBean.appJNDI("misc_jndi_earjar_ejb"));
    }

    public void moduleJNDI2() {
        Helper.getLogger().info(testBean.moduleJNDI());
    }
}

