/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.wsi.w2j.rpc.literal.R2739;

import com.sun.ts.lib.util.TestUtil;
import java.io.OutputStream;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;

public class R2739Handler
extends GenericHandler {
    public QName[] getHeaders() {
        return new QName[]{new QName("http://extra-header.org", "extra-header")};
    }

    public boolean handleRequest(MessageContext context) {
        this.logSOAPMessage("Original", "Request", context);
        this.handle(context);
        this.logSOAPMessage("Modified", "Request", context);
        return true;
    }

    public boolean handleResponse(MessageContext context) {
        this.logSOAPMessage("Original", "Response", context);
        this.handle(context);
        this.logSOAPMessage("Modified", "Response", context);
        return true;
    }

    private void handle(MessageContext context) {
        try {
            this.addExtraHeader((SOAPMessageContext)context);
        }
        catch (SOAPException se) {
            TestUtil.printStackTrace((Throwable)se);
        }
    }

    private void addExtraHeader(SOAPMessageContext context) throws SOAPException {
        SOAPEnvelope env = context.getMessage().getSOAPPart().getEnvelope();
        if (env.getHeader() == null) {
            SOAPHeader header = env.addHeader();
            SOAPHeaderElement she = header.addHeaderElement(this.getExtraHeaderName(env));
            context.getMessage().saveChanges();
        }
    }

    private Name getExtraHeaderName(SOAPEnvelope env) throws SOAPException {
        return env.createName("extra-header", "ns1", "http://extra-header.org");
    }

    private void logSOAPMessage(String s1, String s2, MessageContext msgctx) {
        try {
            SOAPMessage msg = ((SOAPMessageContext)msgctx).getMessage();
            System.out.println("-----------------------------");
            System.out.println(s1 + " SOAP Message " + s2);
            System.out.println("-----------------------------");
            msg.writeTo((OutputStream)System.out);
            System.out.println("\n");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }
}

