/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.interop.csiv2.common.parser;

import com.sun.ts.tests.interop.csiv2.common.parser.Entry;
import com.sun.ts.tests.interop.csiv2.common.parser.ParseException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PrivilegeAuthorityEntry
extends Entry {
    private int serviceConfigSyntax;
    private byte[] serviceSpecificName;

    public PrivilegeAuthorityEntry(Element element) throws ParseException {
        if (!element.getTagName().equals("privilege-authority")) {
            throw new ParseException("Unexpected tag: " + element.getTagName());
        }
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals("service-config-syntax")) {
                this.serviceConfigSyntax = Integer.parseInt(this.getText(node));
                continue;
            }
            if (!node.getNodeName().equals("service-specific-name")) continue;
            this.serviceSpecificName = PrivilegeAuthorityEntry.parseBinHex(this.getText(node));
        }
    }

    public int getServiceConfigSyntax() {
        return this.serviceConfigSyntax;
    }

    public byte[] getServiceSpecificName() {
        return this.serviceSpecificName;
    }

    public String toString() {
        String result = "<privilege-authority>\n";
        result = result + "<service-config-syntax>" + this.serviceConfigSyntax + "</service-config-syntax>\n";
        result = result + "<service-specific-name>" + this.serviceSpecificName + "</service-specific-name>\n";
        result = result + "</privilege-authority>\n";
        return result;
    }
}

