/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.jsonarraytests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jsonp.api.common.ArrayBuilder;
import com.sun.ts.tests.jsonp.api.common.JsonAssert;
import com.sun.ts.tests.jsonp.api.common.JsonIO;
import com.sun.ts.tests.jsonp.api.common.JsonValueType;
import com.sun.ts.tests.jsonp.api.common.SimpleValues;
import com.sun.ts.tests.jsonp.api.common.TestResult;
import com.sun.ts.tests.jsonp.api.jsonarraytests.ArrayCommon;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

public class ArrayBuildSet
extends ArrayCommon {
    ArrayBuildSet() {
    }

    TestResult test() {
        TestResult result = new TestResult("JsonArrayBuilder API set() methods added in JSON-P 1.1.");
        TestUtil.logMsg((String)"JsonArrayBuilder API set() methods added in JSON-P 1.1.");
        this.testSet(result);
        this.testSetOutOfBounds(result);
        this.testSetNullBuilder(result);
        this.testSetNull(result);
        this.testSetNullOutOfBounds(result);
        this.testSetArrayBuilder(result);
        this.testSetArrayBuilderNull(result);
        this.testSetArrayBuilderOutOfBounds(result);
        this.testSetObjectBuilder(result);
        this.testSetObjectBuilderNull(result);
        this.testSetObjectBuilderOutOfBounds(result);
        return result;
    }

    private void testSet(TestResult result) {
        Object[] values;
        for (Object value : values = new Object[]{SimpleValues.OBJ_VALUE, "In a galaxy far far away", 42, 9223372036854775765L, 3.441073578556931E305, SimpleValues.BIN_VALUE, SimpleValues.BDC_VALUE, true}) {
            String typeName = JsonValueType.getType(value).name();
            TestUtil.logMsg((String)(" - set(int," + typeName + ")"));
            String json = "[" + JsonValueType.toStringValue(value) + "]";
            JsonValue check = JsonIO.read(json);
            JsonArrayBuilder builder = this.updateOperationBuilder(Json.createArrayBuilder().add((JsonValue)SimpleValues.DEF_OBJ_VALUE), 0, value);
            JsonArray out = builder.build();
            if (!this.operationFailed(check, (JsonValue)out)) continue;
            result.fail("set(" + typeName + ")", "Builder output " + JsonAssert.valueToString((JsonValue)out) + " value shall be " + JsonAssert.valueToString(check));
        }
    }

    private void testSetOutOfBounds(TestResult result) {
        Object[] values = new Object[]{SimpleValues.OBJ_VALUE, "In a galaxy far far away", 42, 9223372036854775765L, 3.441073578556931E305, SimpleValues.BIN_VALUE, SimpleValues.BDC_VALUE, true};
        int[] indexes = new int[]{-1, 2, 3};
        for (Object value : values) {
            String typeName = JsonValueType.getType(value).name();
            TestUtil.logMsg((String)(" - set(int," + typeName + ")"));
            String json = "[" + JsonValueType.toStringValue(value) + "]";
            JsonArrayBuilder builder = ArrayBuilder.add(Json.createArrayBuilder(), SimpleValues.DEF_OBJ_VALUE);
            for (int index : indexes) {
                try {
                    builder = this.updateOperationBuilder(Json.createArrayBuilder().add((JsonValue)SimpleValues.DEF_OBJ_VALUE), index, value);
                }
                catch (IndexOutOfBoundsException e) {
                    TestUtil.logMsg((String)("    - Expected exception for index=" + index + ": " + e.getMessage()));
                }
                catch (Throwable t) {
                    result.fail("set(int," + typeName + ")", "Calling method with with out of bounds index=" + index + " argument shall throw IndexOutOfBoundsException, not " + t.getClass().getSimpleName());
                }
            }
        }
    }

    private void testSetNullBuilder(TestResult result) {
        JsonValueType[] types;
        for (JsonValueType type : types = new JsonValueType[]{JsonValueType.JsonValue, JsonValueType.String, JsonValueType.BigInteger, JsonValueType.BigDecimal}) {
            String typeName = type.name();
            TestUtil.logMsg((String)(" - set(int,(" + typeName + ")null)"));
            try {
                ArrayBuilder.set(Json.createArrayBuilder(), 0, type);
                result.fail("set(int,(" + typeName + ")null)", "Calling method with null argument shall throw NullPointerException");
            }
            catch (NullPointerException e) {
                TestUtil.logMsg((String)("    - Expected exception: " + e.getMessage()));
            }
            catch (Throwable t) {
                result.fail("set(int,(" + typeName + ")null)", "Calling method with null argument shall throw NullPointerException, not " + t.getClass().getSimpleName());
            }
        }
    }

    private void testSetNull(TestResult result) {
        TestUtil.logMsg((String)" - setNull(int)");
        Object value = null;
        String json = "[" + JsonValueType.toStringValue(null) + "]";
        JsonValue check = JsonIO.read(json);
        JsonArrayBuilder builder = ArrayBuilder.set(Json.createArrayBuilder().add((JsonValue)SimpleValues.DEF_OBJ_VALUE), 0, value);
        JsonArray out = builder.build();
        if (this.operationFailed(check, (JsonValue)out)) {
            result.fail("setNull(int)", "Builder output " + JsonAssert.valueToString((JsonValue)out) + " value shall be " + JsonAssert.valueToString(check));
        }
    }

    private void testSetNullOutOfBounds(TestResult result) {
        int[] indexes = new int[]{-1, 2, 3};
        TestUtil.logMsg((String)" - setNull(int)");
        Object value = null;
        JsonArrayBuilder builder = ArrayBuilder.add(Json.createArrayBuilder(), value);
        for (int index : indexes) {
            try {
                builder = this.updateOperationBuilder(builder, index, value);
                result.fail("setNull(int)", "Calling method with out of bounds index=" + index + " argument shall throw IndexOutOfBoundsException");
            }
            catch (IndexOutOfBoundsException e) {
                TestUtil.logMsg((String)("    - Expected exception for index=" + index + ": " + e.getMessage()));
            }
            catch (Throwable t) {
                result.fail("setNull(int)", "Calling method with with out of bounds index=" + index + " argument shall throw IndexOutOfBoundsException, not " + t.getClass().getSimpleName());
            }
        }
    }

    private void testSetArrayBuilder(TestResult result) {
        TestUtil.logMsg((String)" - set(int,JsonArrayBuilder)");
        JsonValue check = JsonIO.read("[[" + JsonValueType.toStringValue("First value") + "," + JsonValueType.toStringValue("Second value") + "," + JsonValueType.toStringValue("Third value") + "," + JsonValueType.toStringValue("Fourth value") + "]]");
        JsonArrayBuilder in = Json.createArrayBuilder().add("Fifth value");
        JsonArrayBuilder arg = Json.createArrayBuilder().add("First value").add("Second value").add("Third value").add("Fourth value");
        this.verifySetBuilder(result, check, 0, arg, in);
    }

    private void testSetArrayBuilderNull(TestResult result) {
        TestUtil.logMsg((String)" - set(int,(JsonArrayBuilder)null)");
        JsonArrayBuilder in = Json.createArrayBuilder().add("John Smith");
        JsonArrayBuilder arg = null;
        try {
            in.set(0, arg);
            result.fail("set(int,(JsonArrayBuilder)null)", "Calling method with null argument shall throw NullPointerException");
        }
        catch (NullPointerException e) {
            TestUtil.logMsg((String)("    - Expected exception: " + e.getMessage()));
        }
        catch (Throwable t) {
            result.fail("set(int,(JsonArrayBuilder)null)", "Calling method with null argument shall throw NullPointerException, not " + t.getClass().getSimpleName());
        }
    }

    private void testSetArrayBuilderOutOfBounds(TestResult result) {
        TestUtil.logMsg((String)" - set(int,JsonArrayBuilder)");
        int[] indexes = new int[]{-1, 5, 6};
        JsonArrayBuilder in = Json.createArrayBuilder().add("First value").add("Second value").add("Third value").add("Fourth value");
        JsonArrayBuilder arg = Json.createArrayBuilder().add("Fifth value");
        for (int index : indexes) {
            try {
                in.set(index, arg);
                result.fail("set(int,JsonArrayBuilder)", "Calling method with out of bounds index=" + index + " argument shall throw IndexOutOfBoundsException");
            }
            catch (IndexOutOfBoundsException e) {
                TestUtil.logMsg((String)("    - Expected exception for index=" + index + ": " + e.getMessage()));
            }
            catch (Throwable t) {
                result.fail("set(int,JsonArrayBuilder)", "Calling method with with out of bounds index=" + index + " argument shall throw IndexOutOfBoundsException, not " + t.getClass().getSimpleName());
            }
        }
    }

    private void testSetObjectBuilder(TestResult result) {
        TestUtil.logMsg((String)" - set(int,JsonObjectBuilder)");
        JsonValue check = JsonIO.read("[{" + JsonValueType.toStringValue("address") + ":" + JsonValueType.toStringValue("In a galaxy far far away") + "}]");
        JsonArrayBuilder in = Json.createArrayBuilder().add("First value");
        JsonObjectBuilder arg = Json.createObjectBuilder().add("address", "In a galaxy far far away");
        this.verifySetBuilder(result, check, 0, arg, in);
    }

    private void testSetObjectBuilderNull(TestResult result) {
        TestUtil.logMsg((String)" - set(int,(JsonObjectBuilder)null)");
        JsonArrayBuilder in = Json.createArrayBuilder().add("John Smith");
        JsonObjectBuilder arg = null;
        try {
            in.set(0, arg);
            result.fail("set(int,(JsonObjectBuilder)null)", "Calling method with null argument shall throw NullPointerException");
        }
        catch (NullPointerException e) {
            TestUtil.logMsg((String)("    - Expected exception: " + e.getMessage()));
        }
        catch (Throwable t) {
            result.fail("set(int,(JsonObjectBuilder)null)", "Calling method with null argument shall throw NullPointerException, not " + t.getClass().getSimpleName());
        }
    }

    private void testSetObjectBuilderOutOfBounds(TestResult result) {
        TestUtil.logMsg((String)" - set(int,JsonObjectBuilder)");
        int[] indexes = new int[]{-1, 5, 6};
        JsonArrayBuilder in = Json.createArrayBuilder().add("First value").add("Second value").add("Third value").add("Fourth value");
        JsonObjectBuilder arg = Json.createObjectBuilder().add("address", "In a galaxy far far away");
        for (int index : indexes) {
            try {
                in.set(index, arg);
                result.fail("set(int,JsonObjectBuilder)", "Calling method with out of bounds index=" + index + " argument shall throw IndexOutOfBoundsException");
            }
            catch (IndexOutOfBoundsException e) {
                TestUtil.logMsg((String)("    - Expected exception for index=" + index + ": " + e.getMessage()));
            }
            catch (Throwable t) {
                result.fail("set(int,JsonObjectBuilder)", "Calling method with with out of bounds index=" + index + " argument shall throw IndexOutOfBoundsException, not " + t.getClass().getSimpleName());
            }
        }
    }

    private void verifySetBuilder(TestResult result, JsonValue check, int index, JsonArrayBuilder src, JsonArrayBuilder target) {
        JsonArray out = target.set(index, src).build();
        if (this.operationFailed(check, (JsonValue)out)) {
            result.fail("set(int,JsonArrayBuilder)", "Output builder " + JsonAssert.valueToString((JsonValue)out) + " value shall be " + JsonAssert.valueToString(check));
        }
    }

    private void verifySetBuilder(TestResult result, JsonValue check, int index, JsonObjectBuilder src, JsonArrayBuilder target) {
        JsonArray out = target.set(index, src).build();
        if (this.operationFailed(check, (JsonValue)out)) {
            result.fail("set(int,JsonObjectBuilder)", "Output builder " + JsonAssert.valueToString((JsonValue)out) + " value shall be " + JsonAssert.valueToString(check));
        }
    }

    @Override
    protected JsonArrayBuilder createArrayBuilder(Object value) {
        throw new UnsupportedOperationException("Method set is not implemented.");
    }

    @Override
    protected JsonArrayBuilder createArrayBuilder(int index, Object value) {
        return ArrayBuilder.set(Json.createArrayBuilder(), index, value);
    }

    @Override
    protected JsonArrayBuilder updateOperationBuilder(JsonArrayBuilder builder, Object value) {
        throw new UnsupportedOperationException("Method set is not implemented.");
    }

    @Override
    protected JsonArrayBuilder updateOperationBuilder(JsonArrayBuilder builder, int index, Object value) {
        return ArrayBuilder.set(builder, index, value);
    }
}

