/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.metamodelapi.embeddabletype;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.metamodelapi.embeddabletype.Address;
import com.sun.ts.tests.jpa.core.metamodelapi.embeddabletype.ZipCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.CollectionAttribute;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.ListAttribute;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.SetAttribute;
import javax.persistence.metamodel.SingularAttribute;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void embeddableTest() throws EETest.Fault {
        boolean pass = true;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("cZipcode");
        expected.add("street");
        expected.add("state");
        expected.add("city");
        expected.add("lZipcode");
        expected.add("mZipcode");
        expected.add("sZipcode");
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
                EmbeddableType eTypeOrder = metaModel.embeddable(Address.class);
                if (eTypeOrder != null) {
                    TestUtil.logTrace((String)"Obtained Non-null EmbeddableType");
                    Set attribSet = eTypeOrder.getDeclaredAttributes();
                    if (attribSet != null) {
                        if (attribSet.size() != expected.size()) {
                            pass = false;
                            TestUtil.logErr((String)"Received wrong number of results");
                        }
                        for (Attribute attrib : attribSet) {
                            String name = attrib.getName();
                            if (expected.contains(name)) {
                                TestUtil.logTrace((String)("Received expected result:" + name));
                                continue;
                            }
                            TestUtil.logErr((String)("Received unexpected result:" + name));
                            pass = false;
                        }
                    } else {
                        pass = false;
                        TestUtil.logErr((String)"getDeclaredAttributes() returned null");
                    }
                } else {
                    pass = false;
                    TestUtil.logErr((String)"embeddable() returned null");
                }
            } else {
                pass = false;
                TestUtil.logErr((String)"getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("embeddableTest failed");
        }
    }

    public void getAttribute() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity Address");
                Attribute attrib = eType.getAttribute("street");
                if (attrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + attrib.getName()));
                    String name = attrib.getName();
                    if (name.equals("street")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: street, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getAttribute(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getAttribute failed");
        }
    }

    public void getAttributeIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity Address");
                try {
                    eType.getAttribute("doesnotexist");
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getAttributeIllegalArgumentException failed");
        }
    }

    public void getAttributes() throws EETest.Fault {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("street");
        expected.add("state");
        expected.add("city");
        expected.add("cZipcode");
        expected.add("lZipcode");
        expected.add("mZipcode");
        expected.add("sZipcode");
        Collections.sort(expected);
        ArrayList<String> actual = new ArrayList<String>();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity Address");
                Set set = eType.getAttributes();
                if (set != null) {
                    if (set.size() > 0) {
                        for (Attribute attrib : set) {
                            actual.add(attrib.getName());
                        }
                        Collections.sort(actual);
                        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                            TestUtil.logTrace((String)"Received expected attributes");
                            for (String attribName : expected) {
                                TestUtil.logTrace((String)("attrib:" + attribName));
                            }
                            pass = true;
                        } else {
                            TestUtil.logErr((String)"Received unexpected attributes");
                            TestUtil.logErr((String)("Expected(" + expected.size() + "):"));
                            for (String attribName : expected) {
                                TestUtil.logErr((String)("attrib:" + attribName));
                            }
                            TestUtil.logErr((String)("Actual(" + actual.size() + "):"));
                            for (String attribName : actual) {
                                TestUtil.logErr((String)("attrib:" + attribName));
                            }
                        }
                    } else {
                        TestUtil.logErr((String)"getAttributes() returned 0 results");
                    }
                } else {
                    TestUtil.logErr((String)"getAttributes() returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getAttributes failed");
        }
    }

    public void getCollectionStringClass() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity Address");
                CollectionAttribute cAttrib = eType.getCollection("cZipcode", ZipCode.class);
                if (cAttrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + cAttrib.getName()));
                    String name = cAttrib.getName();
                    if (name.equals("cZipcode")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: cZipcode, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getCollection(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getCollectionStringClass failed");
        }
    }

    public void getCollectionStringClassIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getCollection("doesnotexist", Address.class);
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getCollectionStringClassIllegalArgumentException failed");
        }
    }

    public void getCollectionString() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity Address");
                CollectionAttribute cAttrib = eType.getCollection("cZipcode");
                if (cAttrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + cAttrib.getName()));
                    String name = cAttrib.getName();
                    if (name.equals("cZipcode")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: cZipcode, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getCollection(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getCollectionString failed");
        }
    }

    public void getCollectionStringIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getCollection("doesnotexist");
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getCollectionStringIllegalArgumentException failed");
        }
    }

    public void getDeclaredAttribute() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity Address");
                Attribute attrib = eType.getDeclaredAttribute("cZipcode");
                if (attrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + attrib.getName()));
                    String name = attrib.getName();
                    if (name.equals("cZipcode")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: cZipcode, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getDeclaredAttribute(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredAttribute failed");
        }
    }

    public void getDeclaredAttributeIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getDeclaredAttribute("doesnotexist");
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredAttributeIllegalArgumentException failed");
        }
    }

    public void getDeclaredAttributes() throws EETest.Fault {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("street");
        expected.add("state");
        expected.add("city");
        expected.add("cZipcode");
        expected.add("lZipcode");
        expected.add("mZipcode");
        expected.add("sZipcode");
        Collections.sort(expected);
        ArrayList<String> actual = new ArrayList<String>();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity Address");
                Set set = eType.getDeclaredAttributes();
                if (set != null) {
                    if (set.size() > 0) {
                        for (Attribute attrib : set) {
                            actual.add(attrib.getName());
                        }
                        Collections.sort(actual);
                        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                            TestUtil.logTrace((String)"Received expected attributes");
                            for (String attribName : expected) {
                                TestUtil.logTrace((String)("attrib:" + attribName));
                            }
                            pass = true;
                        } else {
                            TestUtil.logErr((String)"Received unexpected attributes:");
                            TestUtil.logErr((String)("Expected (" + expected.size() + "):"));
                            for (String attribName : expected) {
                                TestUtil.logErr((String)("attrib:" + attribName));
                            }
                            TestUtil.logErr((String)("Actual(" + actual.size() + "):"));
                            for (String attribName : actual) {
                                TestUtil.logErr((String)("attrib:" + attribName));
                            }
                        }
                    } else {
                        TestUtil.logErr((String)"getAttributes() returned 0 results");
                    }
                } else {
                    TestUtil.logErr((String)"getDeclaredAttributes() returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredAttributes failed");
        }
    }

    public void getDeclaredCollectionStringClass() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity Address");
                CollectionAttribute cAttrib = eType.getCollection("cZipcode", ZipCode.class);
                if (cAttrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + cAttrib.getName()));
                    String name = cAttrib.getName();
                    if (name.equals("cZipcode")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: cZipcode, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getCollection(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredCollectionStringClass failed");
        }
    }

    public void getDeclaredCollectionStringClassIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getDeclaredCollection("doesnotexist", Address.class);
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredCollectionStringClassIllegalArgumentException failed");
        }
    }

    public void getDeclaredCollectionString() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity Address");
                CollectionAttribute cAttrib = eType.getCollection("cZipcode", ZipCode.class);
                if (cAttrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + cAttrib.getName()));
                    String name = cAttrib.getName();
                    if (name.equals("cZipcode")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: cZipcode, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getCollection(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredCollectionString failed");
        }
    }

    public void getDeclaredCollectionStringIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getDeclaredCollection("doesnotexist", Address.class);
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredCollectionStringIllegalArgumentException failed");
        }
    }

    public void getDeclaredListStringClass() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity Address");
                ListAttribute lAttrib = eType.getDeclaredList("lZipcode", ZipCode.class);
                if (lAttrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + lAttrib.getName()));
                    String name = lAttrib.getName();
                    if (name.equals("lZipcode")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: lZipcode, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getDeclaredList(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredListStringClass failed");
        }
    }

    public void getDeclaredListStringClassIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getDeclaredList("doesnotexist", Address.class);
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredListStringClassIllegalArgumentException failed");
        }
    }

    public void getDeclaredListString() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity Address");
                ListAttribute lAttrib = eType.getDeclaredList("lZipcode");
                if (lAttrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + lAttrib.getName()));
                    String name = lAttrib.getName();
                    if (name.equals("lZipcode")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: lZipcode, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getDeclaredList(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredListString failed");
        }
    }

    public void getDeclaredListStringIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getDeclaredList("doesnotexist");
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredListStringIllegalArgumentException failed");
        }
    }

    public void getDeclaredMapStringClassClass() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity Address");
                MapAttribute mAttrib = eType.getDeclaredMap("mZipcode", ZipCode.class, String.class);
                if (mAttrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + mAttrib.getName()));
                    String name = mAttrib.getName();
                    if (name.equals("mZipcode")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: mZipcode, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getDeclaredMap(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredMapStringClassClass failed");
        }
    }

    public void getDeclaredMapStringClassClassIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getDeclaredMap("doesnotexist", Address.class, String.class);
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredMapStringClassClassIllegalArgumentException failed");
        }
    }

    public void getDeclaredMapString() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity Address");
                MapAttribute mAttrib = eType.getDeclaredMap("mZipcode");
                if (mAttrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + mAttrib.getName()));
                    String name = mAttrib.getName();
                    if (name.equals("mZipcode")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: mZipcode, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getDeclaredMap(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredMapString failed");
        }
    }

    public void getDeclaredMapStringIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getDeclaredMap("doesnotexist");
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredMapStringIllegalArgumentException failed");
        }
    }

    public void getDeclaredSetStringClass() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity Address");
                SetAttribute sAttrib = eType.getDeclaredSet("sZipcode", ZipCode.class);
                if (sAttrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + sAttrib.getName()));
                    String name = sAttrib.getName();
                    if (name.equals("sZipcode")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: sZipcode, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getDeclaredSet(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredSetStringClass failed");
        }
    }

    public void getDeclaredSetStringClassIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getDeclaredSet("doesnotexist", Address.class);
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredSetStringClassIllegalArgumentException failed");
        }
    }

    public void getDeclaredSetString() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity Address");
                SetAttribute sAttrib = eType.getDeclaredSet("sZipcode");
                if (sAttrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + sAttrib.getName()));
                    String name = sAttrib.getName();
                    if (name.equals("sZipcode")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: sZipcode, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getDeclaredSet(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredSetString failed");
        }
    }

    public void getDeclaredSetStringIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getDeclaredSet("doesnotexist");
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredSetStringIllegalArgumentException failed");
        }
    }

    public void getDeclaredSingularAttributeStringClass() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity Address");
                SingularAttribute singAttrib = eType.getDeclaredSingularAttribute("city", String.class);
                if (singAttrib != null) {
                    TestUtil.logTrace((String)("attribute city = " + singAttrib.getName()));
                    String name = singAttrib.getName();
                    if (name.equals("city")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: name, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getDeclaredSingularAttribute(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredSingularAttributeStringClass failed");
        }
    }

    public void getDeclaredSingularAttributeStringClassIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity Address");
                try {
                    eType.getDeclaredSingularAttribute("value", Integer.class);
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredSingularAttributeStringClassIllegalArgumentException failed");
        }
    }

    public void getDeclaredSingularAttributeString() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity Address");
                SingularAttribute singAttrib = eType.getDeclaredSingularAttribute("street");
                if (singAttrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + singAttrib.getName()));
                    String name = singAttrib.getName();
                    if (name.equals("street")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: street, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getDeclaredSingularAttribute(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredSingularAttributeString failed");
        }
    }

    public void getDeclaredSingularAttributeStringIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity Address");
                try {
                    eType.getDeclaredSingularAttribute("value");
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredSingularAttributeStringIllegalArgumentException failed");
        }
    }

    public void getDeclaredSingularAttributes() throws EETest.Fault {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("city");
        expected.add("state");
        expected.add("street");
        Collections.sort(expected);
        ArrayList<String> actual = new ArrayList<String>();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity Address");
                Set set = eType.getDeclaredSingularAttributes();
                if (set != null) {
                    if (set.size() > 0) {
                        for (Attribute attrib : set) {
                            actual.add(attrib.getName());
                        }
                        Collections.sort(actual);
                        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                            TestUtil.logTrace((String)"Received expected attributes");
                            for (String attribName : expected) {
                                TestUtil.logTrace((String)("attrib:" + attribName));
                            }
                            pass = true;
                        } else {
                            TestUtil.logErr((String)"Received unexpected attributes");
                            TestUtil.logErr((String)("Expected(" + expected.size() + "):"));
                            for (String attribName : expected) {
                                TestUtil.logErr((String)("attrib:" + attribName));
                            }
                            TestUtil.logErr((String)("Actual(" + actual.size() + "):"));
                            for (String attribName : actual) {
                                TestUtil.logErr((String)("attrib:" + attribName));
                            }
                        }
                    } else {
                        TestUtil.logErr((String)"getDeclaredSingularAttributes() returned 0 results");
                    }
                } else {
                    TestUtil.logErr((String)"getDeclaredSingularAttributes() returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredSingularAttributes failed");
        }
    }

    public void getListStringClass() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity Address");
                ListAttribute lAttrib = eType.getList("lZipcode", ZipCode.class);
                if (lAttrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + lAttrib.getName()));
                    String name = lAttrib.getName();
                    if (name.equals("lZipcode")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: lZipcode, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getList(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getListStringClass failed");
        }
    }

    public void getListStringClassIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getList("doesnotexist", Address.class);
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getListStringClassIllegalArgumentException failed");
        }
    }

    public void getListString() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity Address");
                ListAttribute lAttrib = eType.getList("lZipcode");
                if (lAttrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + lAttrib.getName()));
                    String name = lAttrib.getName();
                    if (name.equals("lZipcode")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: lZipcode, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getList(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getListString failed");
        }
    }

    public void getListStringIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getDeclaredList("doesnotexist");
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getListStringIllegalArgumentException failed");
        }
    }

    public void getMapStringClassClass() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity Address");
                MapAttribute mAttrib = eType.getMap("mZipcode", ZipCode.class, String.class);
                if (mAttrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + mAttrib.getName()));
                    String name = mAttrib.getName();
                    if (name.equals("mZipcode")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: mZipcode, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getMap(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getMapStringClassClass failed");
        }
    }

    public void getMapStringClassClassIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getMap("doesnotexist", Address.class, String.class);
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getMapStringClassClassIllegalArgumentException failed");
        }
    }

    public void getMapString() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity Address");
                MapAttribute mAttrib = eType.getMap("mZipcode");
                if (mAttrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + mAttrib.getName()));
                    String name = mAttrib.getName();
                    if (name.equals("mZipcode")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: mZipcode, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getMap(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getMapString failed");
        }
    }

    public void getMapStringIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getMap("doesnotexist");
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getMapStringIllegalArgumentException failed");
        }
    }

    public void getPluralAttributes() throws EETest.Fault {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("cZipcode");
        expected.add("lZipcode");
        expected.add("mZipcode");
        expected.add("sZipcode");
        Collections.sort(expected);
        ArrayList<String> actual = new ArrayList<String>();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity Address");
                Set set = eType.getPluralAttributes();
                if (set != null) {
                    if (set.size() > 0) {
                        for (Attribute attrib : set) {
                            actual.add(attrib.getName());
                        }
                        Collections.sort(actual);
                        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                            TestUtil.logTrace((String)"Received expected attributes");
                            for (String attribName : expected) {
                                TestUtil.logTrace((String)("attrib:" + attribName));
                            }
                            pass = true;
                        } else {
                            TestUtil.logErr((String)"Received Unexpected attributes");
                            TestUtil.logErr((String)("Expected(" + expected.size() + "):"));
                            for (String attribName : expected) {
                                TestUtil.logErr((String)("attrib:" + attribName));
                            }
                            TestUtil.logErr((String)("Actual(" + actual.size() + "):"));
                            for (String attribName : actual) {
                                TestUtil.logErr((String)("attrib:" + attribName));
                            }
                        }
                    } else {
                        TestUtil.logErr((String)"getPluralAttributes() returned 0 results");
                    }
                } else {
                    TestUtil.logErr((String)"getPluralAttributes() returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getPluralAttributes failed");
        }
    }

    public void getSetStringClass() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity Address");
                SetAttribute sAttrib = eType.getSet("sZipcode", ZipCode.class);
                if (sAttrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + sAttrib.getName()));
                    String name = sAttrib.getName();
                    if (name.equals("sZipcode")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: sZipcode, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getSet(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getSetStringClass failed");
        }
    }

    public void getSetStringClassIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getSet("doesnotexist", Address.class);
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getSetStringClassIllegalArgumentException failed");
        }
    }

    public void getSetString() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity Address");
                SetAttribute sAttrib = eType.getSet("sZipcode");
                if (sAttrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + sAttrib.getName()));
                    String name = sAttrib.getName();
                    if (name.equals("sZipcode")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: sZipcode, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getSet(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getSetString failed");
        }
    }

    public void getSetStringIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                try {
                    eType.getSet("doesnotexist");
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getSetStringIllegalArgumentException failed");
        }
    }

    public void getSingularAttributeStringClass() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity Address");
                SingularAttribute singAttrib = eType.getSingularAttribute("street", String.class);
                if (singAttrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + singAttrib.getName()));
                    String name = singAttrib.getName();
                    if (name.equals("street")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: street, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getSingularAttribute(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getSingularAttributeStringClass failed");
        }
    }

    public void getSingularAttributeStringClassIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity Address");
                try {
                    eType.getSingularAttribute("doesnotexist", Address.class);
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getSingularAttributeStringClassIllegalArgumentException failed");
        }
    }

    public void getSingularAttributeString() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity Address");
                SingularAttribute singAttrib = eType.getSingularAttribute("street");
                if (singAttrib != null) {
                    TestUtil.logTrace((String)("attribute Name = " + singAttrib.getName()));
                    String name = singAttrib.getName();
                    if (name.equals("street")) {
                        TestUtil.logTrace((String)("Received expected result:" + name));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: street, actual:" + name));
                    }
                } else {
                    TestUtil.logErr((String)"getSingularAttribute(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getSingularAttributeString failed");
        }
    }

    public void getSingularAttributeStringIllegalArgumentException() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity Address");
                try {
                    eType.getSingularAttribute("doesnotexist");
                    TestUtil.logErr((String)"Did not receive expected IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception ex) {
                    TestUtil.logErr((String)"Received unexpected exception:", (Throwable)ex);
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getSingularAttributeStringIllegalArgumentException failed");
        }
    }

    public void getSingularAttributes() throws EETest.Fault {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("city");
        expected.add("state");
        expected.add("street");
        Collections.sort(expected);
        ArrayList<String> actual = new ArrayList<String>();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                TestUtil.logTrace((String)"Obtained Non-null Entity Address");
                Set set = eType.getSingularAttributes();
                if (set != null) {
                    if (set.size() > 0) {
                        for (Attribute attrib : set) {
                            actual.add(attrib.getName());
                        }
                        Collections.sort(actual);
                        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                            TestUtil.logTrace((String)"Received expected attributes");
                            for (String attribName : expected) {
                                TestUtil.logTrace((String)("attrib:" + attribName));
                            }
                            pass = true;
                        } else {
                            TestUtil.logErr((String)"Received Unexpected attributes");
                            TestUtil.logErr((String)("Expected(" + expected.size() + "):"));
                            for (String attribName : expected) {
                                TestUtil.logErr((String)("attrib:" + attribName));
                            }
                            TestUtil.logErr((String)("Actual(" + actual.size() + "):"));
                            for (String attribName : actual) {
                                TestUtil.logErr((String)("attrib:" + attribName));
                            }
                        }
                    } else {
                        TestUtil.logErr((String)"getSingularAttributes() returned 0 results");
                    }
                } else {
                    TestUtil.logErr((String)"getSingularAttributes(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getSingularAttributes failed");
        }
    }

    public void getDeclaredPluralAttributes() throws EETest.Fault {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("cZipcode");
        expected.add("lZipcode");
        expected.add("mZipcode");
        expected.add("sZipcode");
        Collections.sort(expected);
        ArrayList<String> actual = new ArrayList<String>();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eType = metaModel.embeddable(Address.class);
            if (eType != null) {
                Set set = eType.getDeclaredPluralAttributes();
                if (set != null) {
                    if (set.size() > 0) {
                        for (Attribute attrib : set) {
                            actual.add(attrib.getName());
                        }
                        Collections.sort(actual);
                        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                            TestUtil.logTrace((String)"Received expected attributes");
                            for (String attribName : expected) {
                                TestUtil.logTrace((String)("attrib:" + attribName));
                            }
                            pass = true;
                        } else {
                            TestUtil.logErr((String)"Received Unexpected attributes");
                            TestUtil.logErr((String)("Expected(" + expected.size() + "):"));
                            for (String attribName : expected) {
                                TestUtil.logErr((String)("attrib:" + attribName));
                            }
                            TestUtil.logErr((String)("Actual(" + actual.size() + "):"));
                            for (String attribName : actual) {
                                TestUtil.logErr((String)("attrib:" + attribName));
                            }
                        }
                    } else {
                        TestUtil.logErr((String)"getPluralAttributes() returned 0 results");
                    }
                } else {
                    TestUtil.logErr((String)"getPluralAttributes() returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getDeclaredPluralAttributes failed");
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"Cleanup data");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
    }
}

