/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.interop.csiv2.common.parser;

import com.sun.ts.tests.interop.csiv2.common.parser.Entry;
import com.sun.ts.tests.interop.csiv2.common.parser.ParseException;
import com.sun.ts.tests.interop.csiv2.common.parser.PrivilegeAuthorityEntry;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IORSASContextEntry
extends Entry {
    private int targetSupports;
    private int targetRequires;
    private int supportedIdentityTypes;
    private Vector privilegeAuthorities = new Vector();
    private Vector supportedNamingMechanisms = new Vector();

    public IORSASContextEntry(Element element) throws ParseException {
        if (!element.getTagName().equals("ior-sas-context")) {
            throw new ParseException("Unexpected tag: " + element.getTagName());
        }
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals("target-supports")) {
                this.targetSupports = Integer.parseInt(this.getText(node));
                continue;
            }
            if (node.getNodeName().equals("target-requires")) {
                this.targetRequires = Integer.parseInt(this.getText(node));
                continue;
            }
            if (node.getNodeName().equals("privilege-authority")) {
                this.privilegeAuthorities.addElement(new PrivilegeAuthorityEntry((Element)node));
                continue;
            }
            if (node.getNodeName().equals("supported-naming-mechanism")) {
                this.supportedNamingMechanisms.addElement(IORSASContextEntry.parseBinHex(this.getText(node)));
                continue;
            }
            if (!node.getNodeName().equals("supported-identity-types")) continue;
            this.supportedIdentityTypes = Integer.parseInt(this.getText(node));
        }
    }

    public int getTargetSupports() {
        return this.targetSupports;
    }

    public int getTargetRequires() {
        return this.targetRequires;
    }

    public Vector getSupportedNamingMechanisms() {
        return this.supportedNamingMechanisms;
    }

    public int getSupportedIdentityTypes() {
        return this.supportedIdentityTypes;
    }

    public String toString() {
        int i;
        String result = "<ior-sas-context>\n";
        result = result + "<target-supports>" + this.targetSupports + "</target-supports>\n";
        result = result + "<target-requires>" + this.targetRequires + "</target-requires>\n";
        for (i = 0; i < this.privilegeAuthorities.size(); ++i) {
            PrivilegeAuthorityEntry authority = (PrivilegeAuthorityEntry)this.privilegeAuthorities.elementAt(i);
            result = result + authority.toString();
        }
        for (i = 0; i < this.supportedNamingMechanisms.size(); ++i) {
            byte[] mechanism = (byte[])this.supportedNamingMechanisms.elementAt(i);
            result = result + "<supported-naming-mechanism>" + IORSASContextEntry.binHex(mechanism) + "</supported-naming-mechanism>\n";
        }
        result = result + "<supported-identity-types>" + this.supportedIdentityTypes + "</supported-identity-types>\n";
        result = result + "</ior-sas-context>\n";
        return result;
    }

    public Vector getPrivilegeAuthorities() {
        return this.privilegeAuthorities;
    }
}

