/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxr.ee.javax_xml_registry.DeclarativeQueryManager;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxr.common.JAXRCommonClient;
import com.sun.ts.tests.jaxr.common.JAXR_Util;
import java.util.Collection;
import java.util.Properties;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.DeclarativeQueryManager;
import javax.xml.registry.Query;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.ClassificationScheme;

public class JAXRClient
extends JAXRCommonClient {
    JAXR_Util util = null;

    public static void main(String[] args) {
        JAXRClient theTests = new JAXRClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            super.setup(args, p);
            super.cleanUpRegistry();
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        try {
            super.cleanup();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.debug != null) {
                TestUtil.logTrace((String)this.debug.toString());
            }
        }
    }

    public void declarativeQueryManager_createQueryTest() throws EETest.Fault {
        String testName = "declarativeQueryManager_createQueryTest";
        int providerlevel = 0;
        int failcount = 0;
        try {
            providerlevel = this.rs.getCapabilityProfile().getCapabilityLevel();
            DeclarativeQueryManager dqm = this.rs.getDeclarativeQueryManager();
            this.debug.add(" create a SQL-92 query ");
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            ClassificationScheme phoneTypeClassificationScheme = bqm.findClassificationSchemeByName(null, "PhoneType");
            String queryString = "SELECT * FROM ClassificationScheme";
            Query query = dqm.createQuery(0, queryString);
            if (providerlevel == 0) {
                throw new EETest.Fault(testName + "Did not throw UnsupportedCapabilityException");
            }
            try {
                BulkResponse br = dqm.executeQuery(query);
                if (!JAXR_Util.checkBulkResponse("executeQuery", br, this.debug)) {
                    this.debug.add("Error:    executeQuery failed \n");
                    throw new EETest.Fault(testName + " due to errors, test did not complete!");
                }
                Collection css = br.getCollection();
                boolean found = false;
                if (css.contains(phoneTypeClassificationScheme)) {
                    this.debug.add("Found my PhoneType - good\n");
                } else {
                    this.debug.add("Did not Find my PhoneType - not good\n");
                    ++failcount;
                }
            }
            catch (UnsupportedCapabilityException uc) {
                this.debug.add(" Call to createQuery threw UnsupportedCapabilityException - ok\n");
            }
            catch (Exception e) {
                this.debug.add(" Call to createQuery threw an unexpected exception: " + e.getMessage());
                ++failcount;
            }
            if (failcount > 0) {
                throw new EETest.Fault(testName + " failed \n");
            }
        }
        catch (UnsupportedCapabilityException uc) {
            if (providerlevel == 0) {
                this.debug.add(" Call to createQuery threw UnsupportedCapabilityException as expected\n");
            }
            throw new EETest.Fault(testName + " unexpected UnsupportedCapabilityException was caught \n", uc);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }
}

