/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.mdb_sndToTopic;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsUtil;
import java.util.Properties;
import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.jms.TopicConnectionFactory;
import javax.sql.DataSource;

public class MsgBeanTopic
implements MessageDrivenBean,
MessageListener {
    private Properties p = null;
    private TSNamingContext context = null;
    private MessageDrivenContext mdc = null;
    private QueueConnectionFactory queueConFactory = null;
    private TopicConnectionFactory topicConFactory = null;
    private DataSource dataSource = null;
    private QueueConnectionFactory qcFactory = null;
    private QueueConnection connection = null;
    private Queue replyQueue = null;

    public MsgBeanTopic() {
        TestUtil.logTrace((String)"@MsgBeanTopic - @MsgBean()!");
    }

    public void ejbCreate() {
        TestUtil.logTrace((String)"@MsgBeanTopic - @MsgBean-ejbCreate() !!");
        try {
            TSNamingContext context = new TSNamingContext();
            this.qcFactory = (QueueConnectionFactory)context.lookup("java:comp/env/jms/MyQueueConnectionFactory");
            this.replyQueue = (Queue)context.lookup("java:comp/env/jms/MDB_QUEUE_REPLY");
            this.p = new Properties();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("MDB ejbCreate Error!", e);
        }
    }

    public void onMessage(Message msg) {
        JmsUtil.initHarnessProps(msg, this.p);
        TestUtil.logTrace((String)("@MsgBeanTopic - MsgBeanTopic - onMessage! " + msg));
        try {
            TestUtil.logTrace((String)("In MsgBeanForTopic::onMessage() : " + msg));
            TestUtil.logTrace((String)"calling sendReply");
            this.sendReply(msg);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendReply(Message msg) {
        try {
            this.connection = this.qcFactory.createQueueConnection();
            System.out.println("From sendReply");
            this.connection.start();
            System.out.println("started the connection");
            QueueSession session = this.connection.createQueueSession(true, 0);
            TextMessage reply = session.createTextMessage();
            QueueSender replier = session.createSender(this.replyQueue);
            reply.setText("MDB Responding to message receipt");
            reply.setStringProperty("MessageType", msg.getStringProperty("MessageType"));
            TestUtil.logTrace((String)"sending a msg to MDB_QUEUE_REPLY");
            replier.send((Message)reply);
            System.out.println("Sent the message");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (Exception ee) {
                    TestUtil.printStackTrace((Throwable)ee);
                }
            }
        }
    }

    public void setMessageDrivenContext(MessageDrivenContext mdc) {
        TestUtil.logTrace((String)"In MsgBean::setMessageDrivenContext()!!");
        this.mdc = mdc;
    }

    public void ejbRemove() {
        TestUtil.logTrace((String)"In MsgBean::remove()!!");
    }
}

