/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.sec.cmp20.common;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.sec.cmp20.common.SecTest;
import com.sun.ts.tests.ejb.ee.sec.cmp20.common.SecTestHome;
import com.sun.ts.tests.ejb.ee.sec.cmp20.common.SecTestRoleRef;
import com.sun.ts.tests.ejb.ee.sec.cmp20.common.SecTestRoleRefHome;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

public abstract class TestEJB
implements EntityBean {
    private EntityContext ectx = null;
    private static final String ejb1name = "java:comp/env/ejb/SecTest";
    private static final String ejb2name = "java:comp/env/ejb/SecTestRoleRef";
    private SecTestHome ejb1home = null;
    private SecTest ejb1ref = null;
    private SecTestRoleRefHome ejb2home = null;
    private SecTestRoleRef ejb2ref = null;
    private static final String UserNameProp = "user";
    private static final String UserPasswordProp = "password";
    private String username = "";
    private String password = "";
    private TSNamingContext nctx = null;

    public abstract Integer getId();

    public abstract void setId(Integer var1);

    public abstract String getBrandName();

    public abstract void setBrandName(String var1);

    public abstract float getPrice();

    public abstract void setPrice(float var1);

    public void TestEJB() throws CreateException {
        TestUtil.logTrace((String)"TestEJB ejbCreate OK!");
    }

    public Integer ejbCreate(int id, String brandName, float price) throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        Integer pk = new Integer(id);
        try {
            TestUtil.logMsg((String)"Obtain naming context");
            this.setId(pk);
            this.setBrandName(brandName);
            this.setPrice(price);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
        return null;
    }

    public void ejbRemove() throws RemoveException {
        TestUtil.logTrace((String)"ejbRemove");
    }

    public void ejbPostCreate(int id, String brandName, float price) {
        TestUtil.logTrace((String)"ejbPostCreate");
    }

    public void ejbStore() {
        TestUtil.logTrace((String)"ejbStore");
    }

    public void setEntityContext(EntityContext sc) {
        this.ectx = sc;
        try {
            this.nctx = new TSNamingContext();
            this.ejb1home = (SecTestHome)this.nctx.lookup(ejb1name, SecTestHome.class);
            this.ejb2home = (SecTestRoleRefHome)this.nctx.lookup(ejb2name, SecTestRoleRefHome.class);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("unable to obtain naming context");
        }
    }

    public void unsetEntityContext() {
        TestUtil.logTrace((String)"unsetEntityContext");
    }

    public void ejbLoad() {
        TestUtil.logTrace((String)"ejbLoad");
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    public boolean IsCallerB1(String caller) {
        String name = this.ectx.getCallerPrincipal().getName();
        TestUtil.logMsg((String)("IsCallerB1: " + name));
        return name.indexOf(caller) >= 0;
    }

    public boolean IsCallerB2(String caller, Properties props) {
        try {
            this.ejb1ref = this.ejb1home.create(1, "coffee-1", 1.0f);
            boolean result = this.ejb1ref.IsCaller(caller);
            this.ejb1ref.remove();
            return result;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    public boolean InRole(String role, Properties props) {
        try {
            this.ejb1ref = this.ejb1home.create(1, "coffee-1", 1.0f);
            boolean result = this.ejb1ref.EjbSecRoleRef(role);
            this.ejb1ref.remove();
            return result;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    public boolean EjbNotAuthz(Properties props) {
        try {
            this.ejb1ref = this.ejb1home.create(1, "coffee-1", 1.0f);
            this.ejb1ref.EjbNotAuthz();
            TestUtil.logErr((String)"Method call did not generate an expected java.rmi.RemoteException");
            this.ejb1ref.remove();
            return false;
        }
        catch (RemoteException e) {
            TestUtil.logMsg((String)"Caught java.rmi.RemoteException as expected");
            this.cleanup(this.ejb1ref);
            return true;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.cleanup(this.ejb1ref);
            return false;
        }
    }

    private void cleanup(SecTest ejbref) {
        if (ejbref != null) {
            try {
                ejbref.remove();
                ejbref = null;
            }
            catch (Exception ex) {
                TestUtil.logErr((String)"Cannot remove the bean: ", (Throwable)ex);
            }
        } else {
            TestUtil.logMsg((String)"ejbref == null");
        }
    }

    public boolean EjbIsAuthz(Properties props) {
        TestUtil.logMsg((String)"Starting Caller authorization test");
        try {
            this.ejb1ref = this.ejb1home.create(1, "coffee-1", 1.0f);
            boolean result = this.ejb1ref.EjbIsAuthz();
            this.ejb1ref.remove();
            if (!result) {
                return false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
        return true;
    }

    public boolean EjbSecRoleRef(String role, Properties props) {
        TestUtil.logMsg((String)"Starting Security role reference positive test");
        try {
            this.ejb1ref = this.ejb1home.create(1, "coffee-1", 1.0f);
            boolean result = this.ejb1ref.EjbSecRoleRef(role);
            this.ejb1ref.remove();
            return result;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    public boolean EjbSecRoleRef1(String role, Properties props) {
        TestUtil.logMsg((String)"Starting Security role reference negative test");
        try {
            this.ejb1ref = this.ejb1home.create(1, "coffee-1", 1.0f);
            boolean result = this.ejb1ref.EjbSecRoleRef(role);
            this.ejb1ref.remove();
            return !result;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    public boolean EjbSecRoleRefScope(String role, Properties props) {
        try {
            this.ejb1ref = this.ejb1home.create(1, "coffee-1", 1.0f);
            boolean result = this.ejb1ref.EjbSecRoleRef(role);
            this.ejb1ref.remove();
            if (!result) {
                return false;
            }
            this.ejb2ref = this.ejb2home.create(1, "coffee-1", 1.0f);
            result = this.ejb2ref.EjbSecRoleRefScope(role);
            this.ejb2ref.remove();
            return !result;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    public boolean EjbOverloadedSecRoleRefs(String role1, String role2, Properties props) {
        TestUtil.logMsg((String)"Starting Overloaded security role references test");
        try {
            this.ejb1ref = this.ejb1home.create(1, "coffee-1", 1.0f);
            boolean result = this.ejb1ref.EjbOverloadedSecRoleRefs(role1);
            this.ejb1ref.remove();
            if (!result) {
                TestUtil.logErr((String)"EjbOverloadedSecRoleRefs(emp_secrole_ref) returned false");
                return false;
            }
            this.ejb1ref = this.ejb1home.create(1, "coffee-1", 1.0f);
            result = this.ejb1ref.EjbOverloadedSecRoleRefs(role1, role2);
            this.ejb1ref.remove();
            if (result) {
                TestUtil.logErr((String)"EjbOverloadedSecRoleRefs(emp_secrole_ref,mgr_secrole_ref) returned true");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("EjbOverloadedSecRoleRefs(" + role1 + "," + role2 + ") failed with Exception: "), (Throwable)e);
            return false;
        }
    }

    public boolean checktest1(Properties props) {
        try {
            this.ejb1ref = this.ejb1home.create(1, "coffee-1", 1.0f);
            boolean result = this.ejb1ref.checktest1();
            this.ejb1ref.remove();
            return result;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception for checktest1: ", (Throwable)e);
            return false;
        }
    }

    public boolean excludetest1(Properties props) {
        try {
            this.ejb1ref = this.ejb1home.create(1, "coffee-1", 1.0f);
            boolean result = this.ejb1ref.excludetest1();
            this.ejb1ref.remove();
            return false;
        }
        catch (RemoteException e) {
            TestUtil.logTrace((String)"Got expected RemoteException");
            this.cleanup(this.ejb1ref);
            return true;
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Got wrong Exception in excludetest1:", (Throwable)ex);
            return false;
        }
    }
}

