/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.interop.csiv2.common.validation;

import com.sun.ts.lib.util.TestUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class GSSUtils {
    private static final int OBJECT_IDENTIFIER = 6;
    public static final String GSSUPMechOID = "oid:2.23.130.1.1.1";

    public static long[] extractComponentsFromOID(byte[] oid, int offset) throws GSSUtilsException {
        long[] result;
        ByteArrayInputStream in = new ByteArrayInputStream(oid, offset, oid.length - offset);
        try {
            int tag = in.read() & 0xFF;
            if (tag != 6) {
                throw new GSSUtilsException("Did not find OBJECT_IDENTIFIER (0x06) in octet 0 of OID");
            }
            int length = (int)GSSUtils.readVariableOctet(in);
            result = new long[length + 1];
            long value = GSSUtils.readVariableOctet(in);
            result[0] = value / 40L;
            result[1] = value - result[0] * 40L;
            int count = 2;
            for (int i = 1; i < length; ++i) {
                value = GSSUtils.readVariableOctet(in);
                result[count++] = value;
                do {
                } while ((value >>= 7) > 0L);
            }
            if (result.length > count) {
                long[] newresult = new long[count];
                System.arraycopy(result, 0, newresult, 0, count);
                result = newresult;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new GSSUtilsException("ArrayIndexOutOfBounds: " + e);
        }
        return result;
    }

    public static String formatComponents(long[] components) {
        String result = "oid:";
        for (int i = 0; i < components.length; ++i) {
            result = result + components[i];
            if (i >= components.length - 1) continue;
            result = result + ".";
        }
        return result;
    }

    private static byte[] convertOIDStringToOID(String oidString) throws GSSUtilsException {
        byte[] result;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        boolean offset = false;
        if (!oidString.startsWith("oid:")) {
            throw new GSSUtilsException("Given OIDString does not start with \"oid:\"");
        }
        oidString = oidString.substring(4);
        try {
            StringTokenizer st = new StringTokenizer(oidString, ".");
            int firstComponent = Integer.parseInt(st.nextToken());
            int secondComponent = Integer.parseInt(st.nextToken());
            out.write((byte)(firstComponent * 40 + secondComponent));
            while (st.hasMoreTokens()) {
                int comp = Integer.parseInt(st.nextToken());
                GSSUtils.writeVariableOctet(out, comp);
            }
            byte[] octets = out.toByteArray();
            ByteArrayOutputStream lengthOut = new ByteArrayOutputStream();
            GSSUtils.writeVariableOctet(lengthOut, octets.length);
            byte[] lengthOutArray = lengthOut.toByteArray();
            result = new byte[octets.length + lengthOutArray.length + 1];
            result[0] = 6;
            System.arraycopy(lengthOutArray, 0, result, 1, lengthOutArray.length);
            System.arraycopy(octets, 0, result, 1 + lengthOutArray.length, octets.length);
        }
        catch (NumberFormatException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new GSSUtilsException("Given OIDString is invalid: " + e);
        }
        catch (NoSuchElementException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new GSSUtilsException("Given OIDString is invalid: " + e);
        }
        return result;
    }

    public static byte[] encodeGSSUPExportedName(byte[] name) throws GSSUtilsException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(4);
        out.write(1);
        byte[] gssupOID = GSSUtils.convertOIDStringToOID(GSSUPMechOID);
        out.write(gssupOID.length >> 8);
        out.write(gssupOID.length & 0xFF);
        out.write(gssupOID, 0, gssupOID.length);
        out.write(name.length >> 24);
        out.write(name.length >> 16 & 0xFF);
        out.write(name.length >> 8 & 0xFF);
        out.write(name.length & 0xFF);
        out.write(name, 0, name.length);
        return out.toByteArray();
    }

    public static byte[] extractOIDFromExportedName(byte[] exportedName) throws GSSUtilsException {
        byte[] result;
        try {
            int tokenID0 = exportedName[0] & 0xFF;
            int tokenID1 = exportedName[1] & 0xFF;
            if (tokenID0 != 4 || tokenID1 != 1) {
                throw new GSSUtilsException("Given exported name does not start with 04 01");
            }
            int oidlen = ((exportedName[2] & 0xFF) << 8) + (exportedName[3] & 0xFF);
            result = new byte[oidlen];
            System.arraycopy(exportedName, 4, result, 0, oidlen);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new GSSUtilsException("Given exported name is invalid: " + e);
        }
        return result;
    }

    public static byte[] extractNameFromExportedName(byte[] exportedName) throws GSSUtilsException {
        byte[] result;
        try {
            int tokenID0 = exportedName[0] & 0xFF;
            int tokenID1 = exportedName[1] & 0xFF;
            if (tokenID0 != 4 || tokenID1 != 1) {
                throw new GSSUtilsException("Given exported name does not start with 04 01");
            }
            int oidlen = ((exportedName[2] & 0xFF) << 8) + (exportedName[3] & 0xFF);
            int namelen = ((exportedName[4 + oidlen] & 0xFF) << 24) + ((exportedName[4 + oidlen + 1] & 0xFF) << 16) + ((exportedName[4 + oidlen + 2] & 0xFF) << 8) + (exportedName[4 + oidlen + 3] & 0xFF);
            result = new byte[namelen];
            System.arraycopy(exportedName, 8 + oidlen, result, 0, namelen);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new GSSUtilsException("Given exported name is invalid: " + e);
        }
        return result;
    }

    private static long readVariableOctet(ByteArrayInputStream in) {
        boolean highbit;
        long result = 0L;
        do {
            int b;
            highbit = ((b = in.read() & 0xFF) & 0x80) == 128;
            result += (long)(b & 0x7F);
            if (!highbit) continue;
            result <<= 7;
        } while (highbit);
        return result;
    }

    private static void writeVariableOctet(OutputStream out, long value) {
        ByteArrayOutputStream out2 = new ByteArrayOutputStream();
        do {
            out2.write((byte)(value & 0x7FL));
        } while ((value >>= 7) > 0L);
        byte[] result = out2.toByteArray();
        for (int i = result.length - 1; i >= 0; --i) {
            try {
                int b = result[i] & 0xFF;
                if (i != 0) {
                    b |= 0x80;
                }
                out.write(b);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String binHex(byte[] bytes) {
        StringBuffer result = new StringBuffer("");
        char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            result.append(digits[(b & 0xF0) >> 4]);
            result.append(digits[b & 0xF]);
        }
        return result.toString();
    }

    public static byte[] parseBinHex(String data) {
        data = data.toUpperCase();
        byte[] result = new byte[data.length() / 2];
        for (int i = 0; i < data.length(); i += 2) {
            char d1 = data.charAt(i);
            char d2 = data.charAt(i + 1);
            int v1 = d1 - (d1 >= 'A' ? 55 : 48);
            int v2 = d2 - (d2 >= 'A' ? 55 : 48);
            result[i / 2] = (byte)(v1 * 16 + v2);
        }
        return result;
    }

    public static void main(String[] args) {
        byte[] testdata = GSSUtils.parseBinHex("0606678102010101");
        byte[] testname = GSSUtils.parseBinHex("0401000806066781020101010000000764656661756C74");
        try {
            long[] components = GSSUtils.extractComponentsFromOID(testdata, 0);
            TestUtil.logMsg((String)GSSUtils.formatComponents(components));
            byte[] encoded = GSSUtils.convertOIDStringToOID(GSSUPMechOID);
            TestUtil.logMsg((String)GSSUtils.binHex(encoded));
            TestUtil.logMsg((String)GSSUtils.binHex(GSSUtils.encodeGSSUPExportedName("default".getBytes())));
            TestUtil.logMsg((String)GSSUtils.binHex(GSSUtils.extractOIDFromExportedName(testname)));
            TestUtil.logMsg((String)new String(GSSUtils.extractNameFromExportedName(testname)));
        }
        catch (GSSUtilsException e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logMsg((String)("Error parsing: " + e));
        }
    }

    public static class GSSUtilsException
    extends Exception {
        public GSSUtilsException() {
        }

        public GSSUtilsException(String message) {
            super(message);
        }
    }
}

