/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.interop.csiv2.common.parser;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.interop.csiv2.common.parser.CSIv2LogEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.ParseException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Parser {
    public static void main(String[] args) {
        String usage = "java Parser <filename>";
        if (args.length != 1) {
            System.err.println(usage);
            System.exit(1);
        }
        String filename = args[0];
        Parser p = new Parser();
        String data = "";
        try {
            BufferedReader in = new BufferedReader(new FileReader(filename));
            String line = "";
            while ((line = in.readLine()) != null) {
                data = data + line + "\n";
            }
            in.close();
            CSIv2LogEntry csiv2log = p.parse(data);
            System.out.println("---\nLog\n---\n" + csiv2log);
        }
        catch (IOException e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        catch (ParseException e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public CSIv2LogEntry parse(String data) throws ParseException {
        CSIv2LogEntry result;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(data)));
            Element rootElement = document.getDocumentElement();
            result = this.parse(rootElement);
        }
        catch (SAXException e) {
            TestUtil.printStackTrace((Throwable)e);
            Exception x = e;
            if (e.getException() != null) {
                x = e.getException();
            }
            throw new ParseException("SAXException: " + x);
        }
        catch (ParserConfigurationException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new ParseException("ParserConfigurationException: " + e);
        }
        catch (IOException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new ParseException("IOException: " + e);
        }
        return result;
    }

    private CSIv2LogEntry parse(Element root) throws ParseException {
        return new CSIv2LogEntry(root);
    }
}

