/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.sec.bmp.sec;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.porting.TSLoginContext;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.tests.ejb.ee.sec.bmp.common.SecTest;
import com.sun.ts.tests.ejb.ee.sec.bmp.common.SecTestHome;
import com.sun.ts.tests.ejb.ee.sec.bmp.common.SecTestRoleRef;
import com.sun.ts.tests.ejb.ee.sec.bmp.common.SecTestRoleRefHome;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.ejb.RemoveException;

public class Client
extends EETest {
    private static final String ejb1name = "java:comp/env/ejb/SecTest";
    private static final String ejb2name = "java:comp/env/ejb/SecTestRoleRef";
    private SecTestHome ejb1home = null;
    private SecTest ejb1ref = null;
    private SecTestRoleRefHome ejb2home = null;
    private SecTestRoleRef ejb2ref = null;
    private static final String emp_secrole_ref = "EMP";
    private static final String admin_secrole_ref = "ADMIN";
    private static final String mgr_secrole_ref = "MGR";
    private static final String testDir = System.getProperty("user.dir");
    private static final String UserNameProp = "user";
    private static final String UserPasswordProp = "password";
    private String username = "";
    private String password = "";
    private Properties props = null;
    private TSNamingContext nctx = null;
    private TSLoginContext lc = null;
    private boolean newTable = true;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        try {
            this.username = this.props.getProperty(UserNameProp);
            this.password = this.props.getProperty(UserPasswordProp);
            this.nctx = new TSNamingContext();
            this.lc = new TSLoginContext();
            this.lc.login(this.username, this.password);
            this.ejb1home = (SecTestHome)this.nctx.lookup(ejb1name, SecTestHome.class);
            this.ejb2home = (SecTestRoleRefHome)this.nctx.lookup(ejb2name, SecTestRoleRefHome.class);
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void test1() throws EETest.Fault {
        this.logMsg("Starting No caller authorization test");
        try {
            this.ejb1ref = this.ejb1home.create(this.props, this.newTable, 1, "coffee-1", 1.0f);
            this.ejb1ref.EjbNotAuthz();
            this.logErr("Method call did not generate an expected java.rmi.RemoteException");
            this.ejb1ref.remove();
            throw new EETest.Fault("No caller authorization test failed");
        }
        catch (RemoteException e) {
            try {
                if (this.ejb1ref != null) {
                    this.ejb1ref.remove();
                }
            }
            catch (RemoveException ex1) {
                this.logErr("Cannot remove ejb: ", ex1);
            }
            catch (RemoteException ex2) {
                this.logErr("Cannot remove ejb: ", ex2);
            }
            finally {
                this.logMsg("Caught java.rmi.RemoteException as expected");
                this.logMsg("No authorization test passed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("No caller authorization test failed:", e);
        }
    }

    public void test2() throws EETest.Fault {
        this.logMsg("Starting Caller authorization test");
        try {
            this.ejb1ref = this.ejb1home.create(this.props, this.newTable, 1, "coffee-1", 1.0f);
            boolean pass = this.ejb1ref.EjbIsAuthz();
            this.ejb1ref.remove();
            if (!pass) {
                throw new EETest.Fault("Caller authorization test failed");
            }
            this.logMsg("Caller authorization test passed");
        }
        catch (Exception e) {
            try {
                if (this.ejb1ref != null) {
                    this.ejb1ref.remove();
                }
            }
            catch (RemoveException ex1) {
                this.logErr("Cannot remove ejb: ", ex1);
            }
            catch (RemoteException ex2) {
                this.logErr("Cannot remove ejb: ", ex2);
            }
            throw new EETest.Fault("Caller authorization test failed: ", e);
        }
    }

    public void test3() throws EETest.Fault {
        this.logMsg("Starting Security role reference positive test");
        try {
            this.ejb1ref = this.ejb1home.create(this.props, this.newTable, 1, "coffee-1", 1.0f);
            boolean pass = this.ejb1ref.EjbSecRoleRef(emp_secrole_ref);
            this.ejb1ref.remove();
            if (!pass) {
                this.logErr("EjbSecRoleRef(EMP) returned false");
                throw new EETest.Fault("Security role reference positive test failed");
            }
            this.logMsg("Security role reference positive test passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("Security role reference positive test failed: ", e);
        }
    }

    public void test4() throws EETest.Fault {
        this.logMsg("Starting Security role reference negative test");
        try {
            this.ejb1ref = this.ejb1home.create(this.props, this.newTable, 1, "coffee-1", 1.0f);
            boolean pass = !this.ejb1ref.EjbSecRoleRef(mgr_secrole_ref);
            this.ejb1ref.remove();
            if (!pass) {
                this.logErr("EjbSecRoleRef(MGR) returned true");
                throw new EETest.Fault("Security role reference negative test failed");
            }
            this.logMsg("Security role reference negative test passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("Security role reference negative test failed: ", e);
        }
    }

    public void test5() throws EETest.Fault {
        boolean pass;
        this.logMsg("Starting Security role reference scope test");
        try {
            this.ejb1ref = this.ejb1home.create(this.props, this.newTable, 1, "coffee-1", 1.0f);
            pass = this.ejb1ref.EjbSecRoleRef(emp_secrole_ref);
            this.ejb1ref.remove();
            if (!pass) {
                this.logErr("isCallerInRole(EMP) returned false");
                throw new EETest.Fault("Security role reference scope test failed");
            }
            this.logMsg("(ejb1) isCallerInRole(EMP) returned true as expected");
        }
        catch (Exception e) {
            throw new EETest.Fault("Security role reference scope test failed: ", e);
        }
        try {
            this.ejb2ref = this.ejb2home.create(this.props, this.newTable, 1, "coffee-1", 1.0f);
            pass = this.ejb2ref.EjbSecRoleRefScope(emp_secrole_ref);
            this.ejb2ref.remove();
            if (pass) {
                this.logMsg("isCallerInRole(EMP) returned true");
                throw new EETest.Fault("Security role reference scope test failed");
            }
            this.logMsg("(ejb2) isCallerInRole(EMP) returned false as expected");
            this.logMsg("Security role reference scope test passed");
        }
        catch (Exception e) {
            throw new EETest.Fault("Security role reference scope test failed: ", e);
        }
    }

    public void test6() throws EETest.Fault {
        this.logMsg("Starting Overloaded security role references test");
        this.ejb1ref = null;
        try {
            this.ejb1ref = this.ejb1home.create(this.props, this.newTable, 1, "coffee-1", 1.0f);
            if (!this.ejb1ref.EjbOverloadedSecRoleRefs(emp_secrole_ref)) {
                this.logErr("EjbOverloadedSecRoleRefs(EMP) returned false");
                throw new EETest.Fault("Overloaded security role references test failed");
            }
            this.logMsg("EjbOverloadedSecRoleRefs(EMP) returned true as expected");
            if (this.ejb1ref.EjbOverloadedSecRoleRefs(emp_secrole_ref, mgr_secrole_ref)) {
                this.logErr("EjbOverloadedRoleRefs(EMP,MGR) returned true");
                throw new EETest.Fault("Overloaded security role references test failed");
            }
            this.logMsg("EjbOverloadedSecRoleRefs(EMP,MGR) returned false as expected");
        }
        catch (Exception e) {
            throw new EETest.Fault("Overloaded security role references test failed: ", e);
        }
        finally {
            try {
                if (this.ejb1ref != null) {
                    this.logMsg("Removing object reference");
                    this.ejb1ref.remove();
                }
            }
            catch (Exception e) {
                throw new EETest.Fault("Overloaded security role references test failed: ", e);
            }
        }
        this.logMsg("Overloaded security role references test passed");
    }

    public void test7() throws EETest.Fault {
        this.logMsg("Starting unchecked test1");
        try {
            this.ejb1ref = this.ejb1home.create(this.props, this.newTable, 1, "coffee-1", 1.0f);
            if (!this.ejb1ref.checktest1()) {
                this.logErr("unchecked test returned false");
                throw new EETest.Fault("unchecked test1 failed");
            }
            this.logMsg("unchecked test1 passed.");
        }
        catch (Exception e) {
            try {
                if (this.ejb1ref != null) {
                    this.ejb1ref.remove();
                }
            }
            catch (RemoveException ex1) {
                this.logErr("Cannot remove ejb: ", ex1);
            }
            catch (RemoteException ex2) {
                this.logErr("Cannot remove ejb: ", ex2);
            }
            throw new EETest.Fault("unchecked test1 failed", e);
        }
    }

    public void test8() throws EETest.Fault {
        this.logMsg("Starting exclude-list test1");
        try {
            this.ejb1ref = this.ejb1home.create(this.props, this.newTable, 1, "coffee-1", 1.0f);
            this.ejb1ref.excludetest1();
        }
        catch (RemoteException e) {
            try {
                if (this.ejb1ref != null) {
                    this.ejb1ref.remove();
                }
            }
            catch (RemoveException ex1) {
                this.logErr("Cannot remove ejb: ", ex1);
            }
            catch (RemoteException ex2) {
                this.logErr("Cannot remove ejb: ", ex2);
            }
            this.logMsg("Caught java.rmi.RemoteException as expected");
            this.logMsg("exclude-list test1 passed");
        }
        catch (Exception e) {
            try {
                if (this.ejb1ref != null) {
                    this.ejb1ref.remove();
                }
            }
            catch (RemoveException ex1) {
                this.logErr("Cannot remove ejb: ", ex1);
            }
            catch (RemoteException ex2) {
                this.logErr("Cannot remove ejb: ", ex2);
            }
            throw new EETest.Fault("exclude-list test1 failed:", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup");
    }
}

