/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.wsi.w2j.rpc.literal.R1005;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxrpc.sharedclients.ClientFactory;
import com.sun.ts.tests.jaxrpc.wsi.constants.WSIConstants;
import com.sun.ts.tests.jaxrpc.wsi.requests.SOAPRequests;
import com.sun.ts.tests.jaxrpc.wsi.w2j.rpc.literal.R1005.W2JRLR1005Client;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public class Client
extends ServiceEETest
implements WSIConstants,
SOAPRequests {
    private W2JRLR1005Client client;

    public static void main(String[] args) {
        Client tests = new Client();
        Status status = tests.run(args, System.out, System.err);
        status.exit();
    }

    public void setup(String[] args, Properties properties) throws EETest.Fault {
        this.client = (W2JRLR1005Client)ClientFactory.getClient(W2JRLR1005Client.class, properties);
        this.logMsg("setup ok");
    }

    public void cleanup() {
        this.logMsg("cleanup");
    }

    public void testNoEncodingStyleOnResponseEnvelopeElements() throws EETest.Fault {
        SOAPMessage response = null;
        try {
            response = this.client.makeSaajRequest("<?xml version='1.0' encoding='UTF-8'?><!-- Copyright (c) 2003 Oracle Corporation.  All rights reserved. --><env:Envelope xmlns:env='http://schemas.xmlsoap.org/soap/envelope/' xmlns:xsd='http://www.w3.org/2001/XMLSchema' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xmlns:enc='http://schemas.xmlsoap.org/soap/encoding/' xmlns:ns0='http://simpletestservice.org/wsdl' xmlns:ns1='http://simpletestservice.org/types'><env:Header><cts:test env:actor='http://conformance-checker.org' xmlns:cts='http://cts.org'>response</cts:test></env:Header><env:Body><ns0:helloWorld/></env:Body></env:Envelope>");
        }
        catch (Exception e) {
            throw new EETest.Fault("Test didn't complete properly: ", e);
        }
        try {
            this.validateNoEncodingStyleOnEnvelopeElements(response);
        }
        catch (SOAPException se) {
            throw new EETest.Fault("Error creating response object", se);
        }
        this.client.logMessageInHarness(response);
    }

    public void testNoEncodingStyleOnRequestEnvelopeElements() throws EETest.Fault {
        String response = null;
        try {
            response = this.client.helloWorld();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Test didn't complete properly: ", e);
        }
        if (response.startsWith("failed")) {
            throw new EETest.Fault(response);
        }
    }

    private void validateNoEncodingStyleOnEnvelopeElements(SOAPMessage response) throws EETest.Fault, SOAPException {
        this.validateNoEncodingStyleOnEnvelopeElements((SOAPElement)response.getSOAPPart().getEnvelope(), response);
    }

    private void validateNoEncodingStyleOnEnvelopeElements(Iterator soapElements, SOAPMessage response) throws EETest.Fault {
        while (soapElements.hasNext()) {
            Node n = (Node)soapElements.next();
            if (!(n instanceof SOAPElement)) continue;
            this.validateNoEncodingStyleOnEnvelopeElements((SOAPElement)n, response);
        }
    }

    private void validateNoEncodingStyleOnEnvelopeElements(SOAPElement element, SOAPMessage response) throws EETest.Fault {
        boolean fails = this.hasEncodingStyleAttr(element);
        if (fails) {
            this.client.logMessageInHarness(response);
            throw new EETest.Fault("Invalid element: elements with namespace http://schemas.xmlsoap.org/soap/envelope/ cannot have soap:encodingStyle attribute (BP-R1005):  " + element.getElementName().getQualifiedName());
        }
        this.validateNoEncodingStyleOnEnvelopeElements(element.getChildElements(), response);
    }

    private boolean hasEncodingStyleAttr(SOAPElement elem) {
        Iterator attrs = elem.getAllAttributes();
        while (attrs.hasNext()) {
            Name name = (Name)attrs.next();
            String uri = name.getURI();
            if (uri == null) {
                uri = "";
            }
            if (!name.getLocalName().equals("encodingStyle") || !uri.equals("http://schemas.xmlsoap.org/soap/envelope/")) continue;
            return true;
        }
        return false;
    }
}

