/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxr.api.javax_xml_registry_infomodel.InternationalString;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxr.common.JAXRCommonClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Properties;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.LocalizedString;

public class JAXRClient
extends JAXRCommonClient {
    public static void main(String[] args) {
        JAXRClient theTests = new JAXRClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            super.setup(args, p);
            this.debug.clear();
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        if (this.debug != null) {
            TestUtil.logTrace((String)this.debug.toString());
        }
    }

    public void internationalString_addLocalizedString() throws EETest.Fault {
        String testName = "internationalString_addLocalizedString";
        try {
            Locale l = Locale.US;
            String value = "USLocale";
            LocalizedString ls = this.blm.createLocalizedString(l, value);
            InternationalString is = this.blm.createInternationalString(Locale.CANADA, "Canada");
            this.debug.add("Created an InternationalString Localized string count should be 1");
            this.debug.add("localized string count is " + is.getLocalizedStrings().size() + "\n");
            is.addLocalizedString(ls);
            this.debug.add("Added a localized string. InternationalString Localized string count should be 2");
            this.debug.add("localized string count is " + is.getLocalizedStrings().size() + "\n");
            LocalizedString lsReturned = is.getLocalizedString(l, "UTF-8");
            this.debug.add("Check the value of the LocalizedString returned: " + value + "\n");
            this.debug.add("LocalizedString returned: " + lsReturned.getValue() + "\n");
            if (!lsReturned.getValue().equals(value)) {
                this.debug.add("Error: unexpected String returned for localestring returned  \n");
                throw new EETest.Fault(testName + " failed ");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void internationalString_getValue() throws EETest.Fault {
        String testName = "internationalString_getValue";
        String[] value = new String[]{"US", "UK", "Canada", "French"};
        Locale[] l = new Locale[]{Locale.US, Locale.UK, Locale.CANADA, Locale.FRENCH};
        try {
            ArrayList<LocalizedString> cls = new ArrayList<LocalizedString>();
            for (int i = 0; i < value.length; ++i) {
                LocalizedString ls = this.blm.createLocalizedString(l[i], value[i]);
                cls.add(ls);
            }
            InternationalString is = this.blm.createInternationalString();
            is.addLocalizedStrings(cls);
            is.setValue(value[3]);
            if (!is.getValue().equals(value[3])) {
                this.debug.add("Error: unexpected String returned for default locale  \n");
                throw new EETest.Fault(testName + " failed ");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void internationalString_getValueLocale() throws EETest.Fault {
        String testName = "internationalString_getValueLocale";
        String[] value = new String[]{"US", "UK", "Canada", "French"};
        Locale[] l = new Locale[]{Locale.US, Locale.UK, Locale.CANADA, Locale.FRENCH};
        try {
            ArrayList<LocalizedString> cls = new ArrayList<LocalizedString>();
            for (int i = 0; i < value.length; ++i) {
                LocalizedString ls = this.blm.createLocalizedString(l[i], value[i]);
                cls.add(ls);
            }
            InternationalString is = this.blm.createInternationalString();
            is.addLocalizedStrings(cls);
            this.debug.add("Verify that each locale returns the matching value\n");
            for (int i = 0; i < value.length; ++i) {
                this.debug.add("Locale: " + l[i] + " maps to " + value[i] + "\n");
                this.debug.add("is.getValue[" + i + "] = " + is.getValue(l[i]) + "\n");
                if (is.getValue(l[i]).equals(value[i])) continue;
                this.debug.add("Error: locale and value did not match \n");
                throw new EETest.Fault(testName + " failed ");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void internationalString_getValueNull() throws EETest.Fault {
        String testName = "internationalString_getValueNull";
        String[] value = new String[]{"US", "UK", "Canada", "French"};
        Locale[] l = new Locale[]{Locale.US, Locale.UK, Locale.CANADA, Locale.FRENCH};
        try {
            ArrayList<LocalizedString> cls = new ArrayList<LocalizedString>();
            for (int i = 0; i < value.length; ++i) {
                LocalizedString ls = (LocalizedString)this.blm.createObject("LocalizedString");
                ls.setLocale(l[i]);
                cls.add(ls);
            }
            InternationalString is = this.blm.createInternationalString();
            is.addLocalizedStrings(cls);
            this.debug.add("No values have been mapped to the locales, values should return null \n");
            for (int i = 0; i < value.length; ++i) {
                this.debug.add("For Locale: " + l[i] + "\n");
                this.debug.add("is.getValue[" + i + "] = " + is.getValue(l[i]) + "\n");
                if (is.getValue(l[i]) == null) continue;
                this.debug.add("Error: value was not null as expected \n");
                throw new EETest.Fault(testName + " failed ");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void internationalString_setValueLocaleString() throws EETest.Fault {
        String testName = "internationalString_setValueLocaleString";
        String[] value = new String[]{"US", "UK", "Canada", "French"};
        Locale[] l = new Locale[]{Locale.US, Locale.UK, Locale.CANADA, Locale.FRENCH};
        try {
            int i;
            ArrayList<LocalizedString> cls = new ArrayList<LocalizedString>();
            this.debug.add("Create a collection of LocalizedStrings that do not have locale or value specified\n");
            for (int i2 = 0; i2 < value.length; ++i2) {
                LocalizedString ls = (LocalizedString)this.blm.createObject("LocalizedString");
                ls.setLocale(l[i2]);
                cls.add(ls);
            }
            InternationalString is = this.blm.createInternationalString();
            this.debug.add("Add the collection of LocalizedStrings to an InternationalString \n");
            is.addLocalizedStrings(cls);
            this.debug.add("Verify that the value for each locale returns null \n");
            for (i = 0; i < value.length; ++i) {
                this.debug.add("Locale: " + l[i] + "\n");
                this.debug.add("is.getValue[" + i + "] = " + is.getValue(l[i]) + "\n");
                if (is.getValue(l[i]) == null) continue;
                this.debug.add("Error: value should be null - test did not complete \n");
                throw new EETest.Fault(testName + " failed ");
            }
            this.debug.add("For each Localized String in the InternationalString -  set the value \n");
            for (i = 0; i < value.length; ++i) {
                is.setValue(l[i], value[i]);
            }
            this.debug.add("Verify the value with InternationalString.getValue(Locale)  \n");
            for (i = 0; i < value.length; ++i) {
                this.debug.add("Locale: " + l[i] + " maps to " + value[i] + "\n");
                this.debug.add("is.getValue[" + i + "] = " + is.getValue(l[i]) + "\n");
                if (is.getValue(l[i]).equals(value[i])) continue;
                this.debug.add("Error: locale and value did not match \n");
                throw new EETest.Fault(testName + " failed ");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void internationalString_addLocalizedStrings() throws EETest.Fault {
        String testName = "internationalString_addLocalizedStrings";
        String[] value = new String[]{"US", "UK", "Canada", "French"};
        Locale[] l = new Locale[]{Locale.US, Locale.UK, Locale.CANADA, Locale.FRENCH};
        try {
            this.debug.add("Create a collection of LocalizedStrings\n");
            ArrayList<LocalizedString> cls = new ArrayList<LocalizedString>();
            for (int i = 0; i < value.length; ++i) {
                LocalizedString ls = this.blm.createLocalizedString(l[i], value[i]);
                cls.add(ls);
            }
            InternationalString is = this.blm.createInternationalString();
            this.debug.add("Add the collection to InternationalString\n");
            is.addLocalizedStrings(cls);
            this.debug.add("Verify the LocalizedStrings were adding by checking with InternationalString.getValue(Locale)  \n");
            for (int i = 0; i < value.length; ++i) {
                this.debug.add("Locale: " + l[i] + " maps to " + value[i] + "\n");
                this.debug.add("is.getValue[" + i + "] = " + is.getValue(l[i]) + "\n");
                if (is.getValue(l[i]).equals(value[i])) continue;
                this.debug.add("Error: locale and value did not match \n");
                throw new EETest.Fault(testName + " failed ");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void internationalString_removeLocalizedString() throws EETest.Fault {
        String testName = "internationalString_removeLocalizedString";
        String valueCanada = "Canada";
        Locale localeCanada = Locale.CANADA;
        String valueUS = "US";
        Locale localeUS = Locale.US;
        try {
            this.debug.add("Create a LocalizedString for Canada \n");
            LocalizedString ls = this.blm.createLocalizedString(localeCanada, valueCanada);
            InternationalString is = this.blm.createInternationalString(localeUS, valueUS);
            this.debug.add("Add the LocalizedString to InternationalString\n");
            is.addLocalizedString(ls);
            this.debug.add("Verify that the InternationalString contains the LocalizedString for Canada \n");
            this.debug.add("is.getValue(Locale.Canada) is :" + is.getValue(localeCanada) + "\n");
            if (!is.getValue(localeCanada).equals(valueCanada)) {
                throw new EETest.Fault(testName + " failed  - test did not complete");
            }
            this.debug.add("Remove the LocalizedString for Canada\n");
            is.removeLocalizedString(ls);
            this.debug.add("Canada locale removed from InternationalString, LocalizedString count should be 1 \n");
            this.debug.add("LocalizedString count is " + is.getLocalizedStrings().size() + "\n");
            if (is.getLocalizedStrings().size() != 1) {
                throw new EETest.Fault(testName + " failed  - test did not complete");
            }
            this.debug.add("Verify that there is no Locale for Canada\n");
            this.debug.add("is.getLocalizedString(localeCanada,LocalizedString.DEFAULT_CHARSET_NAME) returns " + is.getLocalizedString(localeCanada, "UTF-8") + "\n");
            if (is.getLocalizedString(localeCanada, "UTF-8") != null) {
                throw new EETest.Fault(testName + " failed  ");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void internationalString_removeLocalizedStrings() throws EETest.Fault {
        String testName = "internationalString_removeLocalizedStrings";
        String[] value = new String[]{"US", "UK", "Canada", "French"};
        Locale[] l = new Locale[]{Locale.US, Locale.UK, Locale.CANADA, Locale.FRENCH};
        try {
            int i;
            InternationalString is = this.blm.createInternationalString();
            ArrayList<LocalizedString> cls = new ArrayList<LocalizedString>();
            for (i = 0; i < value.length; ++i) {
                LocalizedString ls = this.blm.createLocalizedString(l[i], value[i]);
                is.addLocalizedString(ls);
                cls.add(ls);
            }
            this.debug.add("Created and added LocalizedStrings to InternationalString\n");
            this.debug.add("Verify that they were added \n");
            for (i = 0; i < value.length; ++i) {
                this.debug.add("Locale: " + l[i] + " maps to " + value[i] + "\n");
                this.debug.add("is.getValue(" + i + ") = " + is.getValue(l[i]) + "\n");
                if (is.getValue(l[i]).equals(value[i])) continue;
                this.debug.add("Error: Failed to find a Locale\n");
                throw new EETest.Fault(testName + " failed - test did not complete ");
            }
            this.debug.add("Remove the localized strings\n");
            is.removeLocalizedStrings(cls);
            this.debug.add("Verify the removal\n");
            this.debug.add("LocalizedString count should be o \n");
            this.debug.add("LocalizedString count is " + is.getLocalizedStrings().size() + "\n");
            if (is.getLocalizedStrings().size() != 0) {
                throw new EETest.Fault(testName + " failed  - LocalizedString count should be 0!");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void internationalString_getLocalizedString() throws EETest.Fault {
        String testName = "internationalString_getLocalizedString";
        Locale l = Locale.CANADA;
        String value = "Canada";
        try {
            InternationalString is = this.blm.createInternationalString(l, value);
            this.debug.add("Create an InternationalString with a LocalizedString for Canada \n");
            LocalizedString lsReturned = is.getLocalizedString(l, "UTF-8");
            this.debug.add("Check the value of the LocalizedString returned: " + value + "\n");
            this.debug.add("LocalizedString returned: " + lsReturned.getValue() + "\n");
            if (!lsReturned.getValue().equals(value)) {
                this.debug.add("Error: unexpected String returned for localestring returned  \n");
                throw new EETest.Fault(testName + " failed ");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void internationalString_getLocalizedStrings() throws EETest.Fault {
        String testName = "internationalString_getLocalizedStrings";
        int foundCount = 0;
        String[] value = new String[]{"US", "UK", "Canada", "French"};
        Locale[] l = new Locale[]{Locale.US, Locale.UK, Locale.CANADA, Locale.FRENCH};
        try {
            ArrayList<LocalizedString> cls = new ArrayList<LocalizedString>();
            ArrayList<String> values = new ArrayList<String>();
            for (int i = 0; i < value.length; ++i) {
                LocalizedString ls = this.blm.createLocalizedString(l[i], value[i]);
                cls.add(ls);
                values.add(value[i]);
                this.debug.add("Creating LocalizedString for : " + value[i] + "\n");
            }
            InternationalString is = this.blm.createInternationalString();
            is.addLocalizedStrings(cls);
            Collection returnLs = is.getLocalizedStrings();
            for (LocalizedString ls : returnLs) {
                if (!values.contains(ls.getValue())) continue;
                this.debug.add("Found " + ls.getValue() + "\n");
                ++foundCount;
            }
            if (foundCount != value.length) {
                throw new EETest.Fault(testName + " failed ");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }
}

