/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.interop.ejb.entity.cmp20.clientviewtest;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.bb.entity.cmp20.clientviewtest.TestBean;
import com.sun.ts.tests.ejb.ee.bb.entity.cmp20.clientviewtest.TestBeanHome;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.ejb.FinderException;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import javax.ejb.ObjectNotFoundException;
import javax.rmi.PortableRemoteObject;

public class Client
extends EETest {
    private static final String testBean = "java:comp/env/ejb/TestBean";
    private TestBean beanRef = null;
    private Properties props = new Properties();
    private TestBeanHome beanHome = null;
    private TSNamingContext nctx = null;
    private boolean setupOK = false;
    private static final int NUMEJBS = 5;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        try {
            this.logMsg("Obtain naming context");
            this.nctx = new TSNamingContext();
            this.logMsg("Looking up home interface for EJB: java:comp/env/ejb/TestBean");
            this.beanHome = (TestBeanHome)this.nctx.lookup(testBean, TestBeanHome.class);
            this.setupOK = true;
            this.logMsg("Setup ok");
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void interopEntityCmp20Test1() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Looking up home in interopEntityCmp20Test1");
            this.beanHome = (TestBeanHome)this.nctx.lookup(testBean, TestBeanHome.class);
            if (this.beanHome == null) {
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception interopEntityCmp20Test1: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("interopEntityCmp20Test1 failed : " + e);
        }
        if (!pass) {
            throw new EETest.Fault("interopEntityCmp20Test1 failed");
        }
    }

    public void interopEntityCmp20Test2() throws EETest.Fault {
        boolean pass = true;
        TestBean beanRef = null;
        try {
            TestUtil.logMsg((String)"Create EJB instance interopEntityCmp20Test2");
            beanRef = this.beanHome.create(1, "coffee-1", 1.0f);
            beanRef.initLogging(this.props);
            beanRef.ping("ping em");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception interopEntityCmp20Test2: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("interopEntityCmp20Test2 failed", e);
        }
        finally {
            try {
                beanRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("interopEntityCmp20Test2 failed");
        }
    }

    public void interopEntityCmp20Test3() throws EETest.Fault {
        boolean pass = false;
        TestBean beanRef = null;
        try {
            TestUtil.logMsg((String)"Create EJB instance interopEntityCmp20Test3");
            beanRef = this.beanHome.create(1, "coffee-1", 1.0f);
            beanRef.initLogging(this.props);
            TestUtil.logMsg((String)"Get object handle for bean instance");
            Handle handle = beanRef.getHandle();
            TestUtil.logMsg((String)("handle= " + handle));
            if (handle == null) {
                TestUtil.logErr((String)"handle for EJB is null");
                throw new EETest.Fault("interopEntityCmp20Test3 failed");
            }
            TestUtil.logMsg((String)"remove EJB via handle");
            this.beanHome.remove(handle);
            try {
                TestUtil.logMsg((String)"Calling beanRef.ping()");
                beanRef.ping("ping em");
            }
            catch (NoSuchObjectException e) {
                TestUtil.logMsg((String)"Caught inner NoSuchObjectException in interopEntityCmp20Test3 as expected");
                pass = true;
            }
            catch (RemoteException e) {
                TestUtil.logMsg((String)("RemoteException received as expected " + e));
                pass = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught inner exception interopEntityCmp20Test3: " + e));
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault("interopEntityCmp20Test3 failed : " + e);
            }
            if (!pass) {
                throw new EETest.Fault("interopEntityCmp20Test3 failed");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception interopEntityCmp20Test3: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("interopEntityCmp20Test3 failed : " + e);
        }
        finally {
            try {
                beanRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public void interopEntityCmp20Test4() throws EETest.Fault {
        boolean pass = false;
        TestBean beanRef = null;
        Object primaryKey = null;
        try {
            TestUtil.logMsg((String)"Create EJB instance interopEntityCmp20Test4");
            beanRef = this.beanHome.create(1, "coffee-1", 1.0f);
            beanRef.initLogging(this.props);
            try {
                TestUtil.logMsg((String)"This is before the beanRef.getPrimaryKey() ");
                primaryKey = beanRef.getPrimaryKey();
                pass = true;
                TestUtil.logMsg((String)"This is after the beanRef.getPrimaryKey() ");
            }
            catch (RemoteException e) {
                TestUtil.logErr((String)("Caught RemoteException interopEntityCmp20Test4 unexpected: " + e), (Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)"Check if primary key object is proper class type");
            if (!(primaryKey instanceof Integer)) {
                TestUtil.logErr((String)"primary key not an Integer object - unexpected");
                pass = false;
            } else {
                TestUtil.logMsg((String)"primary key is an Integer object - expected");
                Integer i = (Integer)primaryKey;
                if (i != 1) {
                    TestUtil.logErr((String)"primaryKey value is not 1 - unexpected");
                    pass = false;
                } else {
                    TestUtil.logMsg((String)"primaryKey value is 1 - expected");
                    pass = true;
                }
            }
            if (!pass) {
                throw new EETest.Fault("interopEntityCmp20Test4 failed");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception interopEntityCmp20Test4: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("interopEntityCmp20Test4 failed", e);
        }
        finally {
            try {
                beanRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public void interopEntityCmp20Test5() throws EETest.Fault {
        boolean pass = false;
        TestBean beanRef = null;
        try {
            TestUtil.logMsg((String)"Create EJB instance interopEntityCmp20Test5");
            beanRef = this.beanHome.create(1, "coffee-1", 1.0f);
            beanRef.initLogging(this.props);
            try {
                TestUtil.logMsg((String)"This is before the beanRef.getPrimaryKey()");
                Object primaryKey = beanRef.getPrimaryKey();
                TestUtil.logMsg((String)"This is before the beanRef.remove(primaryKey)");
                this.beanHome.remove(primaryKey);
                try {
                    TestUtil.logMsg((String)"This is before the ping of removed method");
                    beanRef.ping("Is Bean still alive");
                    pass = false;
                }
                catch (NoSuchObjectException e) {
                    TestUtil.logMsg((String)"Caught inner NoSuchObjectException in interopEntityCmp20Test5 as expected");
                    pass = true;
                }
                catch (RemoteException e) {
                    TestUtil.logMsg((String)("RemoteException received as expected " + e));
                    pass = true;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught inner exception interopEntityCmp20Test5: " + e));
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault("interopEntityCmp20Test5 failed : " + e);
            }
            if (!pass) {
                throw new EETest.Fault("interopEntityCmp20Test5 failed");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception interopEntityCmp20Test5: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("interopEntityCmp20Test5 failed", e);
        }
        finally {
            try {
                beanRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public void interopEntityCmp20Test6() throws EETest.Fault {
        boolean pass = false;
        TestBean beanRef = null;
        try {
            TestUtil.logMsg((String)"Create EJB instance interopEntityCmp20Test6");
            beanRef = this.beanHome.create(1, "coffee-1", 1.0f);
            beanRef.initLogging(this.props);
            TestUtil.logMsg((String)"Get EJBMetaData interface");
            EJBMetaData metaData = this.beanHome.getEJBMetaData();
            TestUtil.logMsg((String)("metaData=" + metaData));
            if (metaData != null) {
                pass = true;
            } else {
                TestUtil.logErr((String)"EJBMetaData interface is null");
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("interopEntityCmp20Test6 failed");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception interopEntityCmp20Test6: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("interopEntityCmp20Test6 failed", e);
        }
        finally {
            try {
                beanRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public void interopEntityCmp20Test6a() throws EETest.Fault {
        boolean pass = false;
        Object beanRef = null;
        try {
            TestUtil.logMsg((String)"Get HomeHandle");
            HomeHandle homeHandle = this.beanHome.getHomeHandle();
            if (homeHandle != null) {
                pass = true;
            } else {
                TestUtil.logErr((String)"homeHandle is null");
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("interopEntityCmp20Test6a failed");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception interopEntityCmp20Test6a: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("interopEntityCmp20Test6a failed", e);
        }
    }

    public void interopEntityCmp20Test7() throws EETest.Fault {
        boolean pass = false;
        TestBean beanRef = null;
        try {
            TestUtil.logMsg((String)"Create EJB instance interopEntityCmp20Test7");
            beanRef = this.beanHome.create(1, "coffee-1", 1.0f);
            beanRef.initLogging(this.props);
            TestUtil.logMsg((String)"This is before the beanRef.getEJBHome() ");
            EJBHome beanHome2 = beanRef.getEJBHome();
            TestUtil.logMsg((String)"This is after the beanRef.getEJBHome() ");
            if (beanHome2 != null) {
                pass = true;
            } else {
                TestUtil.logErr((String)"Home Interface is null");
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("interopEntityCmp20Test7 failed");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception interopEntityCmp20Test7: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("interopEntityCmp20Test7 failed", e);
        }
        finally {
            try {
                beanRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public void interopEntityCmp20Test8() throws EETest.Fault {
        boolean pass = false;
        TestBean beanRef = null;
        try {
            TestUtil.logMsg((String)"Create EJB instance interopEntityCmp20Test8");
            beanRef = this.beanHome.create(1, "coffee-1", 1.0f);
            beanRef.initLogging(this.props);
            TestUtil.logMsg((String)"This is before the beanRef.getHandle() ");
            Handle handle = beanRef.getHandle();
            TestUtil.logMsg((String)"This is after the beanRef.getHandle() ");
            TestUtil.logMsg((String)("handle= " + handle));
            if (handle != null) {
                pass = true;
            } else {
                TestUtil.logErr((String)"handle is null");
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("interopEntityCmp20Test8 failed");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception interopEntityCmp20Test8: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("interopEntityCmp20Test8 failed", e);
        }
        finally {
            try {
                beanRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public void interopEntityCmp20Test9() throws EETest.Fault {
        boolean pass = false;
        TestBean beanRef = null;
        try {
            TestUtil.logMsg((String)"Create EJB instance interopEntityCmp20Test9");
            beanRef = this.beanHome.create(1, "coffee-1", 1.0f);
            beanRef.initLogging(this.props);
            TestUtil.logMsg((String)"This is before the beanRef.remove() ");
            beanRef.remove();
            TestUtil.logMsg((String)"This is after the beanRef.remove() ");
            beanRef.ping("ping em");
        }
        catch (NoSuchObjectException e) {
            TestUtil.logMsg((String)"Caught NoSuchObjectException in interopEntityCmp20Test9 as expected");
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("interopEntityCmp20Test9 failed : " + e);
        }
        finally {
            try {
                beanRef.remove();
                if (!pass) {
                    throw new EETest.Fault("interopEntityCmp20Test9 failed");
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public void interopEntityCmp20Test10() throws EETest.Fault {
        boolean pass = false;
        TestBean beanRef = null;
        try {
            TestUtil.logMsg((String)"Create beanRef instance interopEntityCmp20Test10");
            beanRef = this.beanHome.create(1, "coffee-1", 1.0f);
            beanRef.initLogging(this.props);
            TestUtil.logMsg((String)"Getting ready to do the compare of 2 objects that are identical");
            if (beanRef.isIdentical(beanRef)) {
                TestUtil.logMsg((String)"The EJBObjects are Identical");
                pass = true;
            } else {
                TestUtil.logMsg((String)"The EJBObjects are not Identical");
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("interopEntityCmp20Test10 failed");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception interopEntityCmp20Test10: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("interopEntityCmp20Test10 failed", e);
        }
        finally {
            try {
                beanRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public void interopEntityCmp20Test11() throws EETest.Fault {
        boolean pass = false;
        TestBean beanRef2 = null;
        TestBean beanRef1 = null;
        try {
            TestUtil.logMsg((String)"Create beanRef1 instance interopEntityCmp20Test11");
            beanRef1 = this.beanHome.create(1, "coffee-1", 1.0f);
            TestUtil.logMsg((String)"Create beanRef2 instance interopEntityCmp20Test11");
            beanRef2 = this.beanHome.create(2, "coffee-2", 2.0f);
            beanRef1.initLogging(this.props);
            beanRef2.initLogging(this.props);
            TestUtil.logMsg((String)"Getting ready to do the compare 2 different objects");
            if (beanRef1.isIdentical(beanRef2)) {
                TestUtil.logMsg((String)"The EJBObjects are Identical");
                pass = false;
            } else {
                TestUtil.logMsg((String)"The EJBObjects are not Identical");
                pass = true;
            }
            if (!pass) {
                throw new EETest.Fault("interopEntityCmp20Test11 failed");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception interopEntityCmp20Test11: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("interopEntityCmp20Test11 failed", e);
        }
        finally {
            try {
                beanRef1.remove();
                beanRef2.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public void interopEntityCmp20Test12() throws EETest.Fault {
        boolean pass = false;
        TestBean beanRef = null;
        try {
            TestUtil.logMsg((String)"Create EJB instance interopEntityCmp20Test12");
            beanRef = this.beanHome.create(1, "coffee-1", 1.0f);
            beanRef.initLogging(this.props);
            TestUtil.logMsg((String)"This is before the beanRef.businessMethod() ");
            TestUtil.logMsg((String)beanRef.ping("This is the message inside the beanRef.businessMethod() "));
            TestUtil.logMsg((String)"This is after the beanRef.businessMethod() ");
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception interopEntityCmp20Test12: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("interopEntityCmp20Test12 failed", e);
        }
        finally {
            try {
                beanRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public TestBean echoMethod(TestBean tb) {
        try {
            TestUtil.logMsg((String)tb.ping("Test Ping"));
            return tb;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception in echoMethod : " + e));
            TestUtil.printStackTrace((Throwable)e);
            return null;
        }
    }

    public void interopEntityCmp20Test13() throws EETest.Fault {
        boolean pass = false;
        TestBean beanRef = null;
        try {
            TestUtil.logMsg((String)"Create EJB instance interopEntityCmp20Test13");
            beanRef = this.beanHome.create(1, "coffee-1", 1.0f);
            beanRef.initLogging(this.props);
            TestUtil.logMsg((String)"This is before the echoMethod(EJBObject) ");
            pass = beanRef.isIdentical(this.echoMethod(beanRef));
            TestUtil.logMsg((String)("This is after the echoMethod(EJBObject) := " + pass));
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception interopEntityCmp20Test13: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("interopEntityCmp20Test13 failed", e);
        }
        finally {
            try {
                beanRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public void interopEntityCmp20Test14() throws EETest.Fault {
        boolean pass = false;
        TestBean beanRef = null;
        try {
            TestUtil.logMsg((String)"Create EJB instance interopEntityCmp20Test14");
            beanRef = this.beanHome.create(1, "coffee-1", 1.0f);
            beanRef.initLogging(this.props);
            TestUtil.logMsg((String)"Before the call to get MetaData() interopEntityCmp20Test14!");
            EJBMetaData metaData = this.beanHome.getEJBMetaData();
            TestUtil.logMsg((String)("metaData=" + metaData));
            TestUtil.logMsg((String)"This is before the metaData.getEJBHome()");
            EJBHome home = metaData.getEJBHome();
            TestUtil.logMsg((String)"This is after the metaData.getEJBHome() ");
            if (home != null) {
                pass = true;
            } else {
                TestUtil.logErr((String)"Home is = null");
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("interopEntityCmp20Test14 failed");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception interopEntityCmp20Test14: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("interopEntityCmp20Test14 failed", e);
        }
        finally {
            try {
                beanRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public void interopEntityCmp20Test15() throws EETest.Fault {
        boolean pass = false;
        TestBean beanRef = null;
        try {
            TestUtil.logMsg((String)"Create EJB instance interopEntityCmp20Test15");
            beanRef = this.beanHome.create(1, "coffee-1", 1.0f);
            beanRef.initLogging(this.props);
            TestUtil.logMsg((String)"Before the call to get MetaData() interopEntityCmp20Test15!");
            EJBMetaData metaData = this.beanHome.getEJBMetaData();
            TestUtil.logMsg((String)("metaData=" + metaData));
            TestUtil.logMsg((String)"Before the metaData.getHomeInterfaceClass()");
            Class cls = metaData.getHomeInterfaceClass();
            TestUtil.logMsg((String)"After the metaData.getHomeInterfaceClass() ");
            TestUtil.logMsg((String)("class=" + cls));
            if (cls.isInstance(this.beanHome)) {
                pass = true;
            } else {
                TestUtil.logErr((String)"The getHomeInterfaceClass returned null");
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("interopEntityCmp20Test15 failed");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception interopEntityCmp20Test15: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("interopEntityCmp20Test15 failed", e);
        }
        finally {
            try {
                beanRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interopEntityCmp20Test16() throws EETest.Fault {
        boolean pass = false;
        TestBean beanRef = null;
        try {
            TestUtil.logMsg((String)"Create EJB instance interopEntityCmp20Test16");
            beanRef = this.beanHome.create(1, "coffee-1", 1.0f);
            beanRef.initLogging(this.props);
            TestUtil.logMsg((String)"Before the call to get MetaData() interopEntityCmp20Test16!");
            EJBMetaData metaData = this.beanHome.getEJBMetaData();
            TestUtil.logMsg((String)("metaData=" + metaData));
            TestUtil.logMsg((String)"Before the metaData.getPrimaryKeyClass()");
            try {
                Class cls = metaData.getPrimaryKeyClass();
                TestUtil.logMsg((String)"After the metaData.getPrimaryKeyClass() ");
                TestUtil.logMsg((String)("class=" + cls));
                if (cls.isInstance(new Integer(1))) {
                    pass = true;
                }
            }
            catch (RuntimeException e) {
                TestUtil.logErr((String)("Caught RuntimeException in interopEntityCmp20Test16 unexpected: " + e), (Throwable)e);
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught Exception interopEntityCmp20Test16 : " + e));
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        catch (RemoteException e) {
            TestUtil.logErr((String)("Caught RemoteException interopEntityCmp20Test16: " + e));
            TestUtil.printStackTrace((Throwable)e);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught Exception interopEntityCmp20Test16: " + e));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            try {
                beanRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("interopEntityCmp20Test16 failed");
        }
    }

    public void interopEntityCmp20Test17() throws EETest.Fault {
        boolean pass = false;
        TestBean beanRef = null;
        try {
            TestUtil.logMsg((String)"Create EJB instance interopEntityCmp20Test17");
            beanRef = this.beanHome.create(1, "coffee-1", 1.0f);
            beanRef.initLogging(this.props);
            TestUtil.logMsg((String)"Before the call to get MetaData() interopEntityCmp20Test17!");
            EJBMetaData metaData = this.beanHome.getEJBMetaData();
            TestUtil.logMsg((String)("metaData=" + metaData));
            TestUtil.logMsg((String)"Before the metaData.getRemoteInterfaceClass()");
            Class cls = metaData.getRemoteInterfaceClass();
            TestUtil.logMsg((String)"After the metaData.getRemoteInterfaceClass() ");
            TestUtil.logMsg((String)("class=" + cls));
            if (cls.isInstance(beanRef)) {
                pass = true;
            } else {
                TestUtil.logErr((String)"getRemoteInterfaceClass Returned a null value interopEntityCmp20Test17");
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("interopEntityCmp20Test17 failed");
            }
        }
        catch (RemoteException e) {
            TestUtil.logErr((String)("Caught exception interopEntityCmp20Test17: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("interopEntityCmp20Test17 failed", e);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception interopEntityCmp20Test17: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("interopEntityCmp20Test17 failed", e);
        }
        finally {
            try {
                beanRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public void interopEntityCmp20Test18() throws EETest.Fault {
        boolean pass = false;
        TestBean beanRef = null;
        try {
            TestUtil.logMsg((String)"Create EJB instance interopEntityCmp20Test18");
            beanRef = this.beanHome.create(1, "coffee-1", 1.0f);
            beanRef.initLogging(this.props);
            TestUtil.logMsg((String)"Before the call to get MetaData() interopEntityCmp20Test18!");
            EJBMetaData metaData = this.beanHome.getEJBMetaData();
            TestUtil.logMsg((String)("metaData=" + metaData));
            TestUtil.logMsg((String)"This is before the metaData.isSession()");
            boolean isSession = metaData.isSession();
            TestUtil.logMsg((String)"This is after the metaData.isSession() ");
            TestUtil.logMsg((String)("isSession =" + isSession));
            pass = isSession;
            if (pass) {
                throw new EETest.Fault("interopEntityCmp20Test18 failed");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception interopEntityCmp20Test18: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("interopEntityCmp20Test18 failed", e);
        }
        finally {
            try {
                beanRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public void interopEntityCmp20Test19() throws EETest.Fault {
        boolean pass = true;
        TestBean[] beanRef = new TestBean[5];
        TestBean beanRef2 = null;
        try {
            TestUtil.logMsg((String)"Create EJB instances for interopEntityCmp20Test19");
            int i = 0;
            int j = 1;
            while (i < 5) {
                this.logMsg("Creating entity EJB #" + j + " with Primary Key = " + j + " and Price = " + j);
                beanRef[i] = this.beanHome.create(j, "coffee-" + j, j);
                beanRef[i].initLogging(this.props);
                ++i;
                ++j;
            }
            TestUtil.logMsg((String)"Find EJB reference with Primary Key = 3");
            beanRef2 = this.beanHome.findByPrimaryKey(new Integer(3));
            TestUtil.logMsg((String)"Check if we found the correct EJB reference");
            if (beanRef[2].isIdentical(beanRef2)) {
                TestUtil.logMsg((String)"findByPrimaryKey returned correct reference");
                pass = true;
            } else {
                TestUtil.logErr((String)"findByPrimaryKey returned incorrect reference");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception interopEntityCmp20Test19: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("interopEntityCmp20Test19 failed", e);
        }
        finally {
            try {
                for (int i = 0; i < 5; ++i) {
                    beanRef[i].remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("interopEntityCmp20Test19 failed");
        }
    }

    public void interopEntityCmp20Test20() throws EETest.Fault {
        boolean pass = true;
        TestBean[] beanRef = new TestBean[5];
        TestBean beanRef2 = null;
        try {
            TestUtil.logMsg((String)"Create EJB instances for interopEntityCmp20Test20");
            int i = 0;
            int j = 1;
            while (i < 5) {
                this.logMsg("Creating entity EJB #" + j + " with Primary Key = " + j + " and Price = " + j);
                beanRef[i] = this.beanHome.create(j, "coffee-" + j, j);
                beanRef[i].initLogging(this.props);
                ++i;
                ++j;
            }
            TestUtil.logMsg((String)"Find EJB reference with Coffee Name = coffee-3");
            Collection c = this.beanHome.findByName("coffee-3");
            TestUtil.logMsg((String)("Number of EJB references returned = " + c.size()));
            if (c.size() != 1) {
                TestUtil.logErr((String)("findByName returned " + c.size() + " references, expected 1 reference"));
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check if we found the correct EJB reference");
                Iterator i2 = c.iterator();
                beanRef2 = (TestBean)PortableRemoteObject.narrow(i2.next(), TestBean.class);
                if (beanRef[2].isIdentical(beanRef2)) {
                    TestUtil.logMsg((String)"findByName returned correct reference");
                    pass = true;
                } else {
                    TestUtil.logErr((String)"findByName returned incorrect reference");
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception interopEntityCmp20Test20: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("interopEntityCmp20Test20 failed", e);
        }
        finally {
            try {
                for (int i = 0; i < 5; ++i) {
                    beanRef[i].remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("interopEntityCmp20Test20 failed");
        }
    }

    public void interopEntityCmp20Test21() throws EETest.Fault {
        boolean pass = true;
        TestBean[] beanRef = new TestBean[5];
        TestBean beanRef2 = null;
        try {
            TestUtil.logMsg((String)"Create EJB instances for interopEntityCmp20Test21");
            int i = 0;
            int j = 1;
            while (i < 5) {
                this.logMsg("Creating entity EJB #" + j + " with Primary Key = " + j + " and Price = " + j);
                beanRef[i] = this.beanHome.create(j, "coffee-" + j, j);
                beanRef[i].initLogging(this.props);
                ++i;
                ++j;
            }
            TestUtil.logMsg((String)"Find EJB reference with Coffee Price = 3.0");
            Collection c = this.beanHome.findByPrice(3.0f);
            TestUtil.logMsg((String)("Number of EJB references returned = " + c.size()));
            if (c.size() != 1) {
                TestUtil.logErr((String)("findByPrice returned " + c.size() + " references, expected 1 reference"));
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check if we found the correct EJB reference");
                Iterator i2 = c.iterator();
                beanRef2 = (TestBean)PortableRemoteObject.narrow(i2.next(), TestBean.class);
                if (beanRef[2].isIdentical(beanRef2)) {
                    TestUtil.logMsg((String)"findByPrice returned correct reference");
                    pass = true;
                } else {
                    TestUtil.logErr((String)"findByPrice returned incorrect reference");
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception interopEntityCmp20Test21: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("interopEntityCmp20Test21 failed", e);
        }
        finally {
            try {
                for (int i = 0; i < 5; ++i) {
                    beanRef[i].remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("interopEntityCmp20Test21 failed");
        }
    }

    public void interopEntityCmp20Test22() throws EETest.Fault {
        boolean pass = true;
        TestBean[] beanRef = new TestBean[5];
        TestBean[] beanRef2 = new TestBean[5];
        try {
            TestUtil.logMsg((String)"Create EJB instances for interopEntityCmp20Test22");
            int i = 0;
            int j = 1;
            while (i < 5) {
                this.logMsg("Creating entity EJB #" + j + " with Primary Key = " + j + " and Price = " + j);
                beanRef[i] = this.beanHome.create(j, "coffee-" + j, j);
                beanRef[i].initLogging(this.props);
                ++i;
                ++j;
            }
            TestUtil.logMsg((String)"Find EJB references for Price Range of [2-4]");
            Collection c = this.beanHome.findWithinPriceRange(2.0f, 4.0f);
            TestUtil.logMsg((String)"Check if we found the correct EJB references");
            TestUtil.logMsg((String)("Number of EJB references returned = " + c.size()));
            Iterator i2 = c.iterator();
            int j2 = 0;
            while (i2.hasNext()) {
                beanRef2[j2++] = (TestBean)PortableRemoteObject.narrow(i2.next(), TestBean.class);
            }
            if (c.size() != 3) {
                TestUtil.logErr((String)("findWithinPriceRange returned " + c.size() + " references, expected 3 references"));
                pass = false;
            }
            for (int k = 0; k < c.size(); ++k) {
                boolean found = false;
                for (int l = 1; l < 4; ++l) {
                    if (!beanRef[l].isIdentical(beanRef2[k])) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    TestUtil.logErr((String)("findWithinPriceRange returned incorrect reference for k=" + k));
                    pass = false;
                    continue;
                }
                TestUtil.logMsg((String)("findWithinPriceRange returned correct reference for k=" + k));
            }
            if (beanRef2[0].isIdentical(beanRef2[1]) || beanRef2[0].isIdentical(beanRef2[2]) || beanRef2[1].isIdentical(beanRef2[0]) || beanRef2[1].isIdentical(beanRef2[2]) || beanRef2[2].isIdentical(beanRef2[0]) || beanRef2[2].isIdentical(beanRef2[1])) {
                TestUtil.logErr((String)"findWithinPriceRange returned references not all unique");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception interopEntityCmp20Test22: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("interopEntityCmp20Test22 failed", e);
        }
        finally {
            try {
                for (int i = 0; i < 5; ++i) {
                    beanRef[i].remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("interopEntityCmp20Test22 failed");
        }
    }

    public void interopEntityCmp20Test23() throws EETest.Fault {
        boolean pass = true;
        TestBean[] beanRef = new TestBean[5];
        TestBean[] beanRef2 = new TestBean[5];
        try {
            TestUtil.logMsg((String)"Create EJB instances for interopEntityCmp20Test23");
            int i = 0;
            int j = 1;
            while (i < 5) {
                this.logMsg("Creating entity EJB #" + j + " with Primary Key = " + j + " and Price = " + j);
                beanRef[i] = this.beanHome.create(j, "coffee-" + j, j);
                beanRef[i].initLogging(this.props);
                ++i;
                ++j;
            }
            TestUtil.logMsg((String)"Find EJB references for Primary Key Range of [2-4]");
            Integer min = new Integer(2);
            Integer max = new Integer(4);
            Collection c = this.beanHome.findWithinPrimaryKeyRange(min, max);
            TestUtil.logMsg((String)"Check if we found the correct EJB references");
            TestUtil.logMsg((String)("Number of EJB references returned = " + c.size()));
            Iterator i2 = c.iterator();
            int j2 = 0;
            while (i2.hasNext()) {
                beanRef2[j2++] = (TestBean)PortableRemoteObject.narrow(i2.next(), TestBean.class);
            }
            if (c.size() != 3) {
                TestUtil.logErr((String)("findWithinPrimaryKeyRange returned " + c.size() + " references, expected 3 references"));
                pass = false;
            }
            for (int k = 0; k < c.size(); ++k) {
                boolean found = false;
                for (int l = 1; l < 4; ++l) {
                    if (!beanRef[l].isIdentical(beanRef2[k])) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    TestUtil.logErr((String)("findWithinPrimaryKeyRange returned incorrect reference for k=" + k));
                    pass = false;
                    continue;
                }
                TestUtil.logMsg((String)("findWithinPrimaryKeyRange returned correct reference for k=" + k));
            }
            if (beanRef2[0].isIdentical(beanRef2[1]) || beanRef2[0].isIdentical(beanRef2[2]) || beanRef2[1].isIdentical(beanRef2[0]) || beanRef2[1].isIdentical(beanRef2[2]) || beanRef2[2].isIdentical(beanRef2[0]) || beanRef2[2].isIdentical(beanRef2[1])) {
                TestUtil.logErr((String)"findWithinPrimaryKeyRange returned references not all unique");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception interopEntityCmp20Test23: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("interopEntityCmp20Test23 failed", e);
        }
        finally {
            try {
                for (int i = 0; i < 5; ++i) {
                    beanRef[i].remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("interopEntityCmp20Test23 failed");
        }
    }

    public void interopEntityCmp20Test24() throws EETest.Fault {
        boolean pass = true;
        TestBean[] beanRef = new TestBean[5];
        try {
            TestUtil.logMsg((String)"Create EJB instances for interopEntityCmp20Test24");
            int i = 0;
            int j = 1;
            while (i < 5) {
                this.logMsg("Creating entity EJB #" + j + " with Primary Key = " + j + " and Price = " + j);
                beanRef[i] = this.beanHome.create(j, "coffee-" + j, j);
                beanRef[i].initLogging(this.props);
                ++i;
                ++j;
            }
            TestUtil.logMsg((String)"Attempt multi-object finder to find non-existant EJB should return EMPTY collection");
            Collection c = this.beanHome.findByPrice(1.5f);
            TestUtil.logMsg((String)("Number of EJB references returned = " + c.size()));
            if (!c.isEmpty()) {
                TestUtil.logErr((String)"findByPrice returned non-EMPTY collection - unexpected");
                pass = false;
            } else {
                TestUtil.logErr((String)"findByPrice returned EMPTY collection - expected");
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception interopEntityCmp20Test24: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("interopEntityCmp20Test24 failed", e);
        }
        finally {
            try {
                for (int i = 0; i < 5; ++i) {
                    beanRef[i].remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("interopEntityCmp20Test24 failed");
        }
    }

    public void interopEntityCmp20Test25() throws EETest.Fault {
        boolean pass = true;
        TestBean[] beanRef = new TestBean[5];
        TestBean beanRef2 = null;
        try {
            TestUtil.logMsg((String)"Create EJB instances for interopEntityCmp20Test25");
            int i = 0;
            int j = 1;
            while (i < 5) {
                this.logMsg("Creating entity EJB #" + j + " with Primary Key = " + j + " and Price = " + j);
                beanRef[i] = this.beanHome.create(j, "coffee-" + j, j);
                beanRef[i].initLogging(this.props);
                ++i;
                ++j;
            }
            TestUtil.logMsg((String)"Attempt single-object finder to find non-existant EJB reference should return ObjectNotFoundException (subclass of FinderException)");
            beanRef2 = this.beanHome.findByNameSingle("coffee-foo");
            TestUtil.logErr((String)"No exception occurred from single-object finder whoase Entity does not exist");
            pass = false;
        }
        catch (ObjectNotFoundException e) {
            TestUtil.logMsg((String)"ObjectNotFoundException caught as expected");
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception interopEntityCmp20Test25: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("interopEntityCmp20Test25 failed", e);
        }
        finally {
            try {
                for (int i = 0; i < 5; ++i) {
                    beanRef[i].remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("interopEntityCmp20Test25 failed");
        }
    }

    public void interopEntityCmp20Test26() throws EETest.Fault {
        boolean pass = true;
        TestBean[] beanRef = new TestBean[5];
        TestBean beanRef2 = null;
        try {
            TestUtil.logMsg((String)"Create EJB instances for interopEntityCmp20Test26");
            beanRef[0] = this.beanHome.create(0, "coffee-1", 1.0f);
            beanRef[0].initLogging(this.props);
            int i = 1;
            int j = 1;
            while (i < 5) {
                this.logMsg("Creating entity EJB #" + j + " with Primary Key = " + j + " and Price = " + j);
                beanRef[i] = this.beanHome.create(j, "coffee-" + j, j);
                beanRef[i].initLogging(this.props);
                ++i;
                ++j;
            }
            TestUtil.logMsg((String)"Attempt a single-object finder that matches more than 1 Entity instance should return FinderException");
            beanRef2 = this.beanHome.findByNameSingle("coffee-1");
            TestUtil.logErr((String)"No exception occurred from single-object finder whose Entity does not exist");
            pass = false;
        }
        catch (FinderException e) {
            TestUtil.logMsg((String)"FinderException caught as expected");
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception interopEntityCmp20Test26: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("interopEntityCmp20Test26 failed", e);
        }
        finally {
            try {
                for (int i = 0; i < 5; ++i) {
                    beanRef[i].remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("interopEntityCmp20Test26 failed");
        }
    }

    public void interopEntityCmp20Test27() throws EETest.Fault {
        boolean pass = true;
        TestBean[] beanRef = new TestBean[5];
        Object beanRef2 = null;
        try {
            TestUtil.logMsg((String)"Create EJB instances for interopEntityCmp20Test27");
            int i = 0;
            int j = 1;
            while (i < 5) {
                this.logMsg("Creating entity EJB #" + j + " with Primary Key = " + j + " and Price = " + j);
                beanRef[i] = this.beanHome.create(j, "coffee-" + j, j);
                beanRef[i].initLogging(this.props);
                ++i;
                ++j;
            }
            Collection c = this.beanHome.findAllBeans();
            if (c.size() != 5) {
                pass = false;
                TestUtil.logErr((String)("Collection size, expected: 5, received: " + c.size()));
            } else {
                pass = true;
                TestUtil.logMsg((String)("Collection size, expected: 5, received: " + c.size()));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception interopEntityCmp20Test27: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("interopEntityCmp20Test27 failed", e);
        }
        finally {
            try {
                for (int i = 0; i < 5; ++i) {
                    beanRef[i].remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("interopEntityCmp20Test27 failed");
        }
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }
}

