/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.entityManagerFactory;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.CleanupMethod;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.entityManagerFactory.Member;
import com.sun.ts.tests.jpa.core.entityManagerFactory.Member_;
import com.sun.ts.tests.jpa.core.entityManagerFactory.Order;
import com.sun.ts.tests.jpa.core.entityManagerFactory.Order_;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.Metamodel;

public class Client
extends PMClientBase {
    Properties props = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setupNoData(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setupNoData");
        this.props = p;
        try {
            super.setup(args, p);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        this.props = p;
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createOrderTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void setupMember(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        this.props = p;
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createMemberTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void cleanupNoData() throws EETest.Fault {
        super.cleanup();
    }

    @Override
    public void cleanup() throws EETest.Fault {
        this.removeTestData();
        TestUtil.logTrace((String)"done cleanup, calling super.cleanup");
        super.cleanup();
    }

    @SetupMethod(name="setupNoData")
    @CleanupMethod(name="cleanupNoData")
    public void getMetamodelTest() throws EETest.Fault {
        boolean pass = false;
        try {
            Metamodel mm = this.getEntityManager().getEntityManagerFactory().getMetamodel();
            if (mm == null) {
                TestUtil.logErr((String)"getMetamodel() returned a null result");
            } else {
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("getMetamodelTest failed");
        }
    }

    @SetupMethod(name="setupNoData")
    @CleanupMethod(name="cleanupNoData")
    public void getPersistenceUnitUtil() throws EETest.Fault {
        boolean pass = false;
        try {
            PersistenceUnitUtil puu = this.getEntityManager().getEntityManagerFactory().getPersistenceUnitUtil();
            if (puu == null) {
                TestUtil.logErr((String)"getPersistenceUnitUtil() returned a null result");
            } else {
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("getPersistenceUnitUtil failed");
        }
    }

    @SetupMethod(name="setupNoData")
    @CleanupMethod(name="cleanupNoData")
    public void getCriteriaBuilderTest() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
            if (cbuilder != null) {
                this.getEntityTransaction().begin();
                CriteriaQuery cquery = cbuilder.createQuery();
                if (cquery != null) {
                    TestUtil.logTrace((String)"Obtained Non-null Criteria Query");
                    pass = true;
                } else {
                    TestUtil.logErr((String)"Failed to get Non-null Criteria Query");
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"getCriteriaBuilder() returned null");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("getCriteriaBuilderTest failed");
        }
    }

    public void addNamedQueryMaxResultTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        boolean pass5 = false;
        boolean pass6 = false;
        boolean pass7 = false;
        try {
            TypedQuery namedTypeQuery;
            ArrayList<Integer> iList;
            block94: {
                block93: {
                    block92: {
                        boolean foundOne;
                        List lResult;
                        boolean configOK;
                        Query namedQuery;
                        block91: {
                            int i;
                            block90: {
                                block89: {
                                    CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
                                    TestUtil.logTrace((String)"Defining queries");
                                    Query nativeQuery = this.getEntityManager().createNativeQuery("Select o.ID from PURCHASE_ORDER o ORDER BY o.ID ASC");
                                    nativeQuery.setMaxResults(1);
                                    this.getEntityManagerFactory().addNamedQuery("native_query", nativeQuery);
                                    Query query = this.getEntityManager().createQuery("Select o.id from Order o ORDER BY o.id ASC");
                                    query.setMaxResults(1);
                                    this.getEntityManagerFactory().addNamedQuery("query", query);
                                    CriteriaQuery cquery = cbuilder.createQuery(Integer.class);
                                    Root order = cquery.from(Order.class);
                                    cquery.select((Selection)order.get(Order_.id));
                                    cquery.orderBy(new javax.persistence.criteria.Order[]{cbuilder.asc((Expression)order.get("id"))});
                                    TypedQuery typedQuery = this.getEntityManager().createQuery(cquery);
                                    typedQuery.setMaxResults(1);
                                    this.getEntityManagerFactory().addNamedQuery("typed_query", (Query)typedQuery);
                                    try {
                                        this.getEntityTransaction().begin();
                                        TestUtil.logMsg((String)"*********************************");
                                        TestUtil.logMsg((String)"Testing native query with different max result than the original");
                                        namedQuery = this.getEntityManager().createNamedQuery("native_query");
                                        configOK = true;
                                        if (namedQuery.getMaxResults() == 1) {
                                            TestUtil.logTrace((String)("Received expected Max Result before change:" + namedQuery.getMaxResults()));
                                        } else {
                                            TestUtil.logErr((String)("Expected Max Result before change:1, actual:" + namedQuery.getMaxResults()));
                                            configOK = false;
                                        }
                                        namedQuery.setMaxResults(2);
                                        if (namedQuery.getMaxResults() == 2) {
                                            TestUtil.logTrace((String)("Received expected Max Result after change:" + namedQuery.getMaxResults()));
                                        } else {
                                            TestUtil.logErr((String)("Expected Max Result after change:2, actual:" + namedQuery.getMaxResults()));
                                            configOK = false;
                                        }
                                        lResult = namedQuery.getResultList();
                                        iList = new ArrayList();
                                        for (Object o : lResult) {
                                            iList.add(this.convertToInt(o));
                                        }
                                        foundOne = false;
                                        boolean foundTwo = false;
                                        if (iList.size() == 2) {
                                            Iterator iterator = iList.iterator();
                                            while (iterator.hasNext()) {
                                                i = (Integer)iterator.next();
                                                if (i == 1) {
                                                    foundOne = true;
                                                    TestUtil.logTrace((String)"Found expected id:1");
                                                    continue;
                                                }
                                                if (i == 2) {
                                                    foundTwo = true;
                                                    TestUtil.logTrace((String)"Found expected id:2");
                                                    continue;
                                                }
                                                TestUtil.logErr((String)("Received unexpected result:" + i));
                                            }
                                        } else {
                                            TestUtil.logErr((String)("Did not get expected number of results, expected:2, actual:" + iList.size()));
                                            for (Integer i2 : iList) {
                                                TestUtil.logErr((String)("Ids received:" + i2));
                                            }
                                        }
                                        if (foundOne && foundTwo && configOK) {
                                            pass1 = true;
                                        }
                                        this.getEntityTransaction().commit();
                                    }
                                    catch (Exception e) {
                                        TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
                                        if (!this.getEntityTransaction().isActive()) break block89;
                                        this.getEntityTransaction().rollback();
                                    }
                                }
                                try {
                                    this.getEntityTransaction().begin();
                                    TestUtil.logMsg((String)"*********************************");
                                    TestUtil.logMsg((String)"Testing native query verify original max result is still active");
                                    namedQuery = this.getEntityManager().createNamedQuery("native_query");
                                    configOK = true;
                                    if (namedQuery.getMaxResults() == 1) {
                                        TestUtil.logTrace((String)("Received expected Max Result before change:" + namedQuery.getMaxResults()));
                                    } else {
                                        TestUtil.logErr((String)("Expected Max Result before change:1, actual:" + namedQuery.getMaxResults()));
                                        configOK = false;
                                    }
                                    lResult = namedQuery.getResultList();
                                    iList = new ArrayList<Integer>();
                                    for (Object o : lResult) {
                                        iList.add(this.convertToInt(o));
                                    }
                                    foundOne = false;
                                    if (iList.size() == 1) {
                                        int result = (Integer)iList.get(0);
                                        if (result == 1) {
                                            TestUtil.logTrace((String)"Received expected Order");
                                            foundOne = true;
                                        } else {
                                            TestUtil.logErr((String)("Expected id:1, actual:" + result));
                                        }
                                    } else {
                                        TestUtil.logErr((String)("Did not get correct number of results, expected:1, actual:" + iList.size()));
                                        Iterator result = iList.iterator();
                                        while (result.hasNext()) {
                                            int i3 = (Integer)result.next();
                                            TestUtil.logErr((String)("Ids received:" + i3));
                                        }
                                    }
                                    if (foundOne && configOK) {
                                        pass2 = true;
                                    }
                                    this.getEntityTransaction().commit();
                                }
                                catch (Exception e) {
                                    TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
                                    if (!this.getEntityTransaction().isActive()) break block90;
                                    this.getEntityTransaction().rollback();
                                }
                            }
                            try {
                                this.getEntityTransaction().begin();
                                TestUtil.logMsg((String)"*********************************");
                                TestUtil.logMsg((String)"Testing query with different max result than the original");
                                namedQuery = this.getEntityManager().createNamedQuery("query");
                                configOK = true;
                                if (namedQuery.getMaxResults() == 1) {
                                    TestUtil.logTrace((String)("Received expected Max Result before change:" + namedQuery.getMaxResults()));
                                } else {
                                    TestUtil.logErr((String)("Expected Max Result before change:1, actual:" + namedQuery.getMaxResults()));
                                    configOK = false;
                                }
                                namedQuery.setMaxResults(2);
                                if (namedQuery.getMaxResults() == 2) {
                                    TestUtil.logTrace((String)("Received expected Max Result after change:" + namedQuery.getMaxResults()));
                                } else {
                                    TestUtil.logErr((String)("Expected Max Result after change:2, actual:" + namedQuery.getMaxResults()));
                                    configOK = false;
                                }
                                lResult = namedQuery.getResultList();
                                iList = new ArrayList();
                                for (Object o : lResult) {
                                    iList.add(this.convertToInt(o));
                                }
                                foundOne = false;
                                boolean foundTwo = false;
                                if (iList.size() == 2) {
                                    Iterator i3 = iList.iterator();
                                    while (i3.hasNext()) {
                                        i = (Integer)i3.next();
                                        if (i == 1) {
                                            foundOne = true;
                                            TestUtil.logTrace((String)"Found expected id:1");
                                            continue;
                                        }
                                        if (i == 2) {
                                            foundTwo = true;
                                            TestUtil.logTrace((String)"Found expected id:2");
                                            continue;
                                        }
                                        TestUtil.logErr((String)("Received unexpected result:" + i));
                                    }
                                } else {
                                    TestUtil.logErr((String)("Did not get expected number of results, expected:2, actual:" + iList.size()));
                                    for (Integer i4 : iList) {
                                        TestUtil.logErr((String)("Ids received:" + i4));
                                    }
                                }
                                if (foundOne && foundTwo && configOK) {
                                    pass3 = true;
                                }
                                this.getEntityTransaction().commit();
                            }
                            catch (Exception e) {
                                TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
                                if (!this.getEntityTransaction().isActive()) break block91;
                                this.getEntityTransaction().rollback();
                            }
                        }
                        try {
                            this.getEntityTransaction().begin();
                            TestUtil.logMsg((String)"*********************************");
                            TestUtil.logMsg((String)"Testing query verify original max result is active");
                            namedQuery = this.getEntityManager().createNamedQuery("query");
                            configOK = true;
                            if (namedQuery.getMaxResults() == 1) {
                                TestUtil.logTrace((String)("Received expected Max Result before change:" + namedQuery.getMaxResults()));
                            } else {
                                TestUtil.logErr((String)("Expected Max Result before change:1, actual:" + namedQuery.getMaxResults()));
                                configOK = false;
                            }
                            lResult = namedQuery.getResultList();
                            iList = new ArrayList();
                            for (Object o : lResult) {
                                iList.add(this.convertToInt(o));
                            }
                            foundOne = false;
                            if (iList.size() == 1) {
                                int result = (Integer)iList.get(0);
                                if (result == 1) {
                                    TestUtil.logTrace((String)("Received expected id:" + result));
                                    foundOne = true;
                                } else {
                                    TestUtil.logErr((String)("Expected id:1, actual:" + result));
                                }
                            } else {
                                TestUtil.logErr((String)("Did not get correct number of results, expected:1, actual:" + iList.size()));
                                Iterator result = iList.iterator();
                                while (result.hasNext()) {
                                    int i = (Integer)result.next();
                                    TestUtil.logErr((String)("Ids received:" + i));
                                }
                            }
                            if (foundOne && configOK) {
                                pass4 = true;
                            }
                            this.getEntityTransaction().commit();
                        }
                        catch (Exception e) {
                            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
                            if (!this.getEntityTransaction().isActive()) break block92;
                            this.getEntityTransaction().rollback();
                        }
                    }
                    try {
                        this.getEntityTransaction().begin();
                        TestUtil.logMsg((String)"*********************************");
                        TestUtil.logMsg((String)"Testing query definition can be replaced ");
                        Query query2 = this.getEntityManager().createQuery("Select o.id from Order o where o.id in (1,2) ");
                        query2.setMaxResults(2);
                        this.getEntityManagerFactory().addNamedQuery("query", query2);
                        Query namedQuery = this.getEntityManager().createNamedQuery("query");
                        boolean configOK = true;
                        if (namedQuery.getMaxResults() == 2) {
                            TestUtil.logTrace((String)("Received expected Max Result before change:" + namedQuery.getMaxResults()));
                        } else {
                            TestUtil.logErr((String)("Expected Max Result before change:2, actual:" + namedQuery.getMaxResults()));
                            configOK = false;
                        }
                        List lResult = namedQuery.getResultList();
                        ArrayList<Integer> iList2 = new ArrayList<Integer>();
                        for (Object o : lResult) {
                            iList2.add(this.convertToInt(o));
                        }
                        ArrayList<Integer> lExpected = new ArrayList<Integer>();
                        lExpected.add(1);
                        lExpected.add(2);
                        if (iList2.containsAll(lExpected) && lExpected.containsAll(iList2) && iList2.size() == lExpected.size()) {
                            TestUtil.logTrace((String)"Received expected ids");
                            if (configOK) {
                                pass5 = true;
                            }
                        } else {
                            TestUtil.logErr((String)"Did not receive expected results:");
                            for (Integer i : lExpected) {
                                TestUtil.logErr((String)("Expected:" + i));
                            }
                            for (Integer i : iList2) {
                                TestUtil.logErr((String)("Expected:" + i));
                            }
                        }
                        this.getEntityTransaction().commit();
                    }
                    catch (Exception e) {
                        TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
                        if (!this.getEntityTransaction().isActive()) break block93;
                        this.getEntityTransaction().rollback();
                    }
                }
                try {
                    this.getEntityTransaction().begin();
                    TestUtil.logMsg((String)"*********************************");
                    TestUtil.logMsg((String)"Testing TypedQuery with max result different than the original");
                    namedTypeQuery = this.getEntityManager().createNamedQuery("typed_query", Integer.class);
                    boolean configOK = true;
                    if (namedTypeQuery.getMaxResults() == 1) {
                        TestUtil.logTrace((String)("Received expected Max Result before change:" + namedTypeQuery.getMaxResults()));
                    } else {
                        TestUtil.logErr((String)("Expected Max Result before change:1, actual:" + namedTypeQuery.getMaxResults()));
                        configOK = false;
                    }
                    namedTypeQuery.setMaxResults(2);
                    if (namedTypeQuery.getMaxResults() == 2) {
                        TestUtil.logTrace((String)("Received expected Max Result after change:" + namedTypeQuery.getMaxResults()));
                    } else {
                        TestUtil.logErr((String)("Expected Max Result after change:2, actual:" + namedTypeQuery.getMaxResults()));
                        configOK = false;
                    }
                    List lResult = namedTypeQuery.getResultList();
                    iList = new ArrayList();
                    for (Object o : lResult) {
                        iList.add(this.convertToInt(o));
                    }
                    boolean foundOne = false;
                    boolean foundTwo = false;
                    if (iList.size() == 2) {
                        Iterator o = iList.iterator();
                        while (o.hasNext()) {
                            int i = (Integer)o.next();
                            if (i == 1) {
                                foundOne = true;
                                TestUtil.logTrace((String)"Found expected id:1");
                                continue;
                            }
                            if (i == 2) {
                                foundTwo = true;
                                TestUtil.logTrace((String)"Found expected id:2");
                                continue;
                            }
                            TestUtil.logErr((String)("Received unexpected result:" + i));
                        }
                    } else {
                        TestUtil.logErr((String)("Did not get expected number of results, expected:2, actual:" + iList.size()));
                        for (Integer i : iList) {
                            TestUtil.logErr((String)("Ids received:" + i));
                        }
                    }
                    if (foundOne && foundTwo && configOK) {
                        pass6 = true;
                    }
                    this.getEntityTransaction().commit();
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
                    if (!this.getEntityTransaction().isActive()) break block94;
                    this.getEntityTransaction().rollback();
                }
            }
            try {
                this.getEntityTransaction().begin();
                TestUtil.logMsg((String)"*********************************");
                TestUtil.logMsg((String)"Testing TypedQuery verify original max result is active");
                namedTypeQuery = this.getEntityManager().createNamedQuery("typed_query", Integer.class);
                boolean configOK = true;
                if (namedTypeQuery.getMaxResults() == 1) {
                    TestUtil.logTrace((String)("Received expected Max Result before change:" + namedTypeQuery.getMaxResults()));
                } else {
                    TestUtil.logErr((String)("Expected Max Result before change:1, actual:" + namedTypeQuery.getMaxResults()));
                    configOK = false;
                }
                List lResult = namedTypeQuery.getResultList();
                iList = new ArrayList();
                for (Object o : lResult) {
                    iList.add(this.convertToInt(o));
                }
                boolean foundOne = false;
                if (iList.size() == 1) {
                    int result = (Integer)iList.get(0);
                    if (result == 1) {
                        TestUtil.logTrace((String)("Received expected id:" + result));
                        foundOne = true;
                    } else {
                        TestUtil.logErr((String)("Expected id:1, actual:" + result));
                    }
                } else {
                    TestUtil.logErr((String)("Did not get correct number of results, expected:1, actual:" + iList.size()));
                    Iterator iterator = iList.iterator();
                    while (iterator.hasNext()) {
                        int i = (Integer)iterator.next();
                        TestUtil.logErr((String)("Ids received:" + i));
                    }
                }
                if (foundOne && configOK) {
                    pass7 = true;
                }
                this.getEntityTransaction().commit();
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5 && pass6 && pass7)) {
            throw new EETest.Fault("addNamedQueryMaxResultTest failed");
        }
    }

    public void addNamedQueryFlushModeTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        boolean pass5 = false;
        boolean pass6 = false;
        boolean pass7 = false;
        try {
            TypedQuery namedTypeQuery;
            block85: {
                block84: {
                    block83: {
                        int i;
                        boolean foundOne;
                        List lResult;
                        boolean configOK;
                        Query namedQuery;
                        block82: {
                            block81: {
                                int result3;
                                block80: {
                                    CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
                                    TestUtil.logTrace((String)"Defining queries");
                                    Query nativeQuery = this.getEntityManager().createNativeQuery("Select ID from PURCHASE_ORDER where ID=1");
                                    nativeQuery.setFlushMode(FlushModeType.AUTO);
                                    this.getEntityManagerFactory().addNamedQuery("native_query", nativeQuery);
                                    Query query = this.getEntityManager().createQuery("select o.id from Order o where o.id=1");
                                    query.setFlushMode(FlushModeType.AUTO);
                                    this.getEntityManagerFactory().addNamedQuery("query", query);
                                    CriteriaQuery cquery = cbuilder.createQuery(Integer.class);
                                    Root order = cquery.from(Order.class);
                                    cquery.select((Selection)order.get(Order_.id));
                                    cquery.where((Expression)cbuilder.equal((Expression)order.get(Order_.id), (Object)1));
                                    TypedQuery typedQuery = this.getEntityManager().createQuery(cquery);
                                    typedQuery.setFlushMode(FlushModeType.AUTO);
                                    this.getEntityManagerFactory().addNamedQuery("typed_query", (Query)typedQuery);
                                    try {
                                        this.getEntityTransaction().begin();
                                        TestUtil.logMsg((String)"*********************************");
                                        TestUtil.logMsg((String)"Testing native query with different flush mode than the original");
                                        namedQuery = this.getEntityManager().createNamedQuery("native_query");
                                        configOK = true;
                                        if (namedQuery.getFlushMode().equals((Object)FlushModeType.AUTO)) {
                                            TestUtil.logTrace((String)("Received expected flush mode before change:" + namedQuery.getFlushMode()));
                                        } else {
                                            TestUtil.logErr((String)("Expected flush mode before change:" + FlushModeType.AUTO + ", actual:" + namedQuery.getFlushMode()));
                                            configOK = false;
                                        }
                                        namedQuery.setFlushMode(FlushModeType.COMMIT);
                                        if (namedQuery.getFlushMode().equals((Object)FlushModeType.COMMIT)) {
                                            TestUtil.logTrace((String)("Received expected flush mode after change:" + namedQuery.getFlushMode()));
                                        } else {
                                            TestUtil.logErr((String)("Expected flush mode after change:" + FlushModeType.AUTO + ", actual:" + namedQuery.getFlushMode()));
                                            configOK = false;
                                        }
                                        lResult = namedQuery.getResultList();
                                        foundOne = false;
                                        if (lResult.size() == 1) {
                                            result3 = this.convertToInt(lResult.get(0));
                                            if (result3 == 1) {
                                                TestUtil.logTrace((String)("Received expected id:" + result3));
                                                foundOne = true;
                                            } else {
                                                TestUtil.logErr((String)("Expected id:1, actual:" + result3));
                                            }
                                        } else {
                                            TestUtil.logErr((String)("Did not get correct number of results, expected:1, actual:" + lResult.size()));
                                            Iterator result2 = lResult.iterator();
                                            while (result2.hasNext()) {
                                                i = (Integer)result2.next();
                                                TestUtil.logErr((String)("Ids received:" + i));
                                            }
                                        }
                                        if (foundOne && configOK) {
                                            pass1 = true;
                                        }
                                        this.getEntityTransaction().commit();
                                    }
                                    catch (Exception e) {
                                        TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
                                        if (!this.getEntityTransaction().isActive()) break block80;
                                        this.getEntityTransaction().rollback();
                                    }
                                }
                                try {
                                    this.getEntityTransaction().begin();
                                    TestUtil.logMsg((String)"*********************************");
                                    TestUtil.logMsg((String)"Testing native query verify original flush mode is still active");
                                    namedQuery = this.getEntityManager().createNamedQuery("native_query");
                                    configOK = true;
                                    if (namedQuery.getFlushMode().equals((Object)FlushModeType.AUTO)) {
                                        TestUtil.logTrace((String)("Received expected flush mode before change:" + namedQuery.getFlushMode()));
                                    } else {
                                        TestUtil.logErr((String)("Expected flush mode before change:" + FlushModeType.AUTO.name() + ", actual:" + namedQuery.getFlushMode()));
                                        configOK = false;
                                    }
                                    lResult = namedQuery.getResultList();
                                    foundOne = false;
                                    if (lResult.size() == 1) {
                                        result3 = this.convertToInt(lResult.get(0));
                                        if (result3 == 1) {
                                            TestUtil.logTrace((String)("Received expected id:" + result3));
                                            foundOne = true;
                                        } else {
                                            TestUtil.logErr((String)("Expected id:1, actual:" + result3));
                                        }
                                    } else {
                                        TestUtil.logErr((String)("Did not get correct number of results, expected:1, actual:" + lResult.size()));
                                        Iterator result3 = lResult.iterator();
                                        while (result3.hasNext()) {
                                            i = (Integer)result3.next();
                                            TestUtil.logErr((String)("Ids received:" + i));
                                        }
                                    }
                                    if (foundOne && configOK) {
                                        pass2 = true;
                                    }
                                    this.getEntityTransaction().commit();
                                }
                                catch (Exception e) {
                                    TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
                                    if (!this.getEntityTransaction().isActive()) break block81;
                                    this.getEntityTransaction().rollback();
                                }
                            }
                            try {
                                this.getEntityTransaction().begin();
                                TestUtil.logMsg((String)"*********************************");
                                TestUtil.logMsg((String)"Testing query with different flush mode than the original");
                                namedQuery = this.getEntityManager().createNamedQuery("query");
                                configOK = true;
                                if (namedQuery.getFlushMode().equals((Object)FlushModeType.AUTO)) {
                                    TestUtil.logTrace((String)("Received expected flush mode before change:" + namedQuery.getFlushMode()));
                                } else {
                                    TestUtil.logErr((String)("Expected flush mode before change:" + FlushModeType.AUTO + ", actual:" + namedQuery.getFlushMode()));
                                    configOK = false;
                                }
                                namedQuery.setFlushMode(FlushModeType.COMMIT);
                                if (namedQuery.getFlushMode().equals((Object)FlushModeType.COMMIT)) {
                                    TestUtil.logTrace((String)("Received expected flush mode after change:" + namedQuery.getFlushMode()));
                                } else {
                                    TestUtil.logErr((String)("Expected flush mode after change:" + FlushModeType.AUTO + ", actual:" + namedQuery.getFlushMode()));
                                    configOK = false;
                                }
                                lResult = namedQuery.getResultList();
                                foundOne = false;
                                if (lResult.size() == 1) {
                                    int result = (Integer)lResult.get(0);
                                    if (result == 1) {
                                        TestUtil.logTrace((String)("Received expected id:" + result));
                                        foundOne = true;
                                    } else {
                                        TestUtil.logErr((String)("Expected id:1, actual:" + result));
                                    }
                                } else {
                                    TestUtil.logErr((String)("Did not get correct number of results, expected:1, actual:" + lResult.size()));
                                    Iterator result = lResult.iterator();
                                    while (result.hasNext()) {
                                        i = (Integer)result.next();
                                        TestUtil.logErr((String)("Ids received:" + i));
                                    }
                                }
                                if (foundOne && configOK) {
                                    pass3 = true;
                                }
                                this.getEntityTransaction().commit();
                            }
                            catch (Exception e) {
                                TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
                                if (!this.getEntityTransaction().isActive()) break block82;
                                this.getEntityTransaction().rollback();
                            }
                        }
                        try {
                            this.getEntityTransaction().begin();
                            TestUtil.logMsg((String)"*********************************");
                            TestUtil.logMsg((String)"Testing query verify original flush mode is active");
                            namedQuery = this.getEntityManager().createNamedQuery("query");
                            configOK = true;
                            if (namedQuery.getFlushMode().equals((Object)FlushModeType.AUTO)) {
                                TestUtil.logTrace((String)("Received expected flush mode before change:" + namedQuery.getFlushMode()));
                            } else {
                                TestUtil.logErr((String)("Expected flush mode before change:" + FlushModeType.AUTO.name() + ", actual:" + namedQuery.getFlushMode()));
                                configOK = false;
                            }
                            lResult = namedQuery.getResultList();
                            foundOne = false;
                            if (lResult.size() == 1) {
                                int result = (Integer)lResult.get(0);
                                if (result == 1) {
                                    TestUtil.logTrace((String)("Received expected id:" + result));
                                    foundOne = true;
                                } else {
                                    TestUtil.logErr((String)("Expected id:1, actual:" + result));
                                }
                            } else {
                                TestUtil.logErr((String)("Did not get correct number of results, expected:1, actual:" + lResult.size()));
                                Iterator result = lResult.iterator();
                                while (result.hasNext()) {
                                    i = (Integer)result.next();
                                    TestUtil.logErr((String)("Ids received:" + i));
                                }
                            }
                            if (foundOne && configOK) {
                                pass4 = true;
                            }
                            this.getEntityTransaction().commit();
                        }
                        catch (Exception e) {
                            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
                            if (!this.getEntityTransaction().isActive()) break block83;
                            this.getEntityTransaction().rollback();
                        }
                    }
                    try {
                        this.getEntityTransaction().begin();
                        TestUtil.logMsg((String)"*********************************");
                        TestUtil.logMsg((String)"Testing query definition can be replaced ");
                        Query query2 = this.getEntityManager().createQuery("Select o.id from Order o where o.id = 2").setFlushMode(FlushModeType.COMMIT);
                        this.getEntityManagerFactory().addNamedQuery("query", query2);
                        Query namedQuery = this.getEntityManager().createNamedQuery("query");
                        boolean configOK = true;
                        if (namedQuery.getFlushMode().equals((Object)FlushModeType.COMMIT)) {
                            TestUtil.logTrace((String)("Received expected flush mode before change:" + namedQuery.getFlushMode()));
                        } else {
                            TestUtil.logErr((String)("Expected flush mode before change:" + FlushModeType.COMMIT.name() + ", actual:" + namedQuery.getFlushMode()));
                            configOK = false;
                        }
                        List lResult = namedQuery.getResultList();
                        boolean foundOne = false;
                        if (lResult.size() == 1) {
                            int result = (Integer)lResult.get(0);
                            if (result == 2) {
                                TestUtil.logTrace((String)("Received expected id:" + result));
                                foundOne = true;
                            } else {
                                TestUtil.logErr((String)("Expected id:2, actual:" + result));
                            }
                        } else {
                            TestUtil.logErr((String)("Did not get correct number of results, expected:1, actual:" + lResult.size()));
                            Iterator result = lResult.iterator();
                            while (result.hasNext()) {
                                int i = (Integer)result.next();
                                TestUtil.logErr((String)("Ids received:" + i));
                            }
                        }
                        if (foundOne && configOK) {
                            pass5 = true;
                        }
                        this.getEntityTransaction().commit();
                    }
                    catch (Exception e) {
                        TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
                        if (!this.getEntityTransaction().isActive()) break block84;
                        this.getEntityTransaction().rollback();
                    }
                }
                try {
                    this.getEntityTransaction().begin();
                    TestUtil.logMsg((String)"*********************************");
                    TestUtil.logMsg((String)"Testing TypedQuery with flush mode different than the original");
                    namedTypeQuery = this.getEntityManager().createNamedQuery("typed_query", Integer.class);
                    boolean configOK = true;
                    if (namedTypeQuery.getFlushMode().equals((Object)FlushModeType.AUTO)) {
                        TestUtil.logTrace((String)("Received expected flush mode before change:" + namedTypeQuery.getFlushMode()));
                    } else {
                        TestUtil.logErr((String)("Expected flush mode before change:" + FlushModeType.AUTO + ", actual:" + namedTypeQuery.getFlushMode()));
                        configOK = false;
                    }
                    namedTypeQuery.setFlushMode(FlushModeType.COMMIT);
                    if (namedTypeQuery.getFlushMode().equals((Object)FlushModeType.COMMIT)) {
                        TestUtil.logTrace((String)("Received expected flush mode after change:" + namedTypeQuery.getFlushMode()));
                    } else {
                        TestUtil.logErr((String)("Expected flush mode after change:" + FlushModeType.AUTO + ", actual:" + namedTypeQuery.getFlushMode()));
                        configOK = false;
                    }
                    List lResult = namedTypeQuery.getResultList();
                    boolean foundOne = false;
                    if (lResult.size() == 1) {
                        int result = (Integer)lResult.get(0);
                        if (result == 1) {
                            TestUtil.logTrace((String)("Received expected id:" + result));
                            foundOne = true;
                        } else {
                            TestUtil.logErr((String)("Expected id:1, actual:" + result));
                        }
                    } else {
                        TestUtil.logErr((String)("Did not get correct number of results, expected:1, actual:" + lResult.size()));
                        Iterator result = lResult.iterator();
                        while (result.hasNext()) {
                            int i = (Integer)result.next();
                            TestUtil.logErr((String)("Ids received:" + i));
                        }
                    }
                    if (foundOne && configOK) {
                        pass6 = true;
                    }
                    this.getEntityTransaction().commit();
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
                    if (!this.getEntityTransaction().isActive()) break block85;
                    this.getEntityTransaction().rollback();
                }
            }
            try {
                this.getEntityTransaction().begin();
                TestUtil.logMsg((String)"*********************************");
                TestUtil.logMsg((String)"Testing TypedQuery verify original flush mode is active");
                namedTypeQuery = this.getEntityManager().createNamedQuery("typed_query", Integer.class);
                boolean configOK = true;
                if (namedTypeQuery.getFlushMode().equals((Object)FlushModeType.AUTO)) {
                    TestUtil.logTrace((String)("Received expected flush mode before change:" + namedTypeQuery.getFlushMode()));
                } else {
                    TestUtil.logErr((String)("Expected flush mode before change:" + FlushModeType.AUTO.name() + ", actual:" + namedTypeQuery.getFlushMode()));
                    configOK = false;
                }
                List lResult = namedTypeQuery.getResultList();
                boolean foundOne = false;
                if (lResult.size() == 1) {
                    int result = (Integer)lResult.get(0);
                    if (result == 1) {
                        TestUtil.logTrace((String)("Received expected id:" + result));
                        foundOne = true;
                    } else {
                        TestUtil.logErr((String)("Expected id:1, actual:" + result));
                    }
                } else {
                    TestUtil.logErr((String)("Did not get correct number of results, expected:1, actual:" + lResult.size()));
                    Iterator iterator = lResult.iterator();
                    while (iterator.hasNext()) {
                        int i = (Integer)iterator.next();
                        TestUtil.logErr((String)("Ids received:" + i));
                    }
                }
                if (foundOne && configOK) {
                    pass7 = true;
                }
                this.getEntityTransaction().commit();
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5 && pass6 && pass7)) {
            throw new EETest.Fault("addNamedQueryFlushModeTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SetupMethod(name="setupMember")
    public void addNamedQueryLockModeTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        boolean pass5 = false;
        try {
            TypedQuery namedTypeQuery;
            Object result;
            LockModeType lmt;
            boolean ok1;
            Query namedQuery;
            CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            TestUtil.logTrace((String)"Defining queries");
            Query query = this.getEntityManager().createQuery("select m from Member m where m.memberId=1");
            query.setLockMode(LockModeType.NONE);
            this.getEntityManagerFactory().addNamedQuery("query", query);
            CriteriaQuery cquery = cbuilder.createQuery(Member.class);
            Root member = cquery.from(Member.class);
            cquery.select((Selection)member);
            cquery.where((Expression)cbuilder.equal((Expression)member.get(Member_.memberId), (Object)1));
            TypedQuery typedQuery = this.getEntityManager().createQuery(cquery);
            typedQuery.setLockMode(LockModeType.NONE);
            this.getEntityManagerFactory().addNamedQuery("typed_query", (Query)typedQuery);
            try {
                this.getEntityTransaction().begin();
                TestUtil.logMsg((String)"*********************************");
                TestUtil.logMsg((String)"Testing query with different lock mode than the original");
                namedQuery = this.getEntityManager().createNamedQuery("query");
                ok1 = false;
                lmt = namedQuery.getLockMode();
                if (lmt != null) {
                    if (lmt.equals((Object)LockModeType.NONE)) {
                        TestUtil.logTrace((String)("Received expected lock mode before change:" + lmt.name()));
                        ok1 = true;
                    } else {
                        TestUtil.logErr((String)("Expected lock mode before change:" + LockModeType.NONE.name() + ", actual:" + lmt.name()));
                    }
                } else {
                    TestUtil.logErr((String)"getLockModeType returned null");
                }
                namedQuery.setLockMode(LockModeType.PESSIMISTIC_READ);
                lmt = namedQuery.getLockMode();
                boolean ok2 = false;
                if (lmt.equals((Object)LockModeType.PESSIMISTIC_READ)) {
                    TestUtil.logTrace((String)("Received LockModeType:" + lmt.name()));
                    ok2 = true;
                } else if (lmt.equals((Object)LockModeType.PESSIMISTIC_WRITE)) {
                    TestUtil.logTrace((String)("Received LockModeType:" + lmt + " inplace of " + LockModeType.PESSIMISTIC_READ.name()));
                    ok2 = true;
                } else {
                    TestUtil.logErr((String)("Expected lock mode after change:" + LockModeType.PESSIMISTIC_READ.name() + ", actual:" + lmt.name()));
                }
                List lResult = namedQuery.getResultList();
                boolean foundOne = false;
                if (lResult.size() == 1) {
                    result = (Member)lResult.get(0);
                    if (result.getMemberId() == 1) {
                        TestUtil.logTrace((String)("Received expected id:" + result.getMemberId()));
                        foundOne = true;
                    } else {
                        TestUtil.logErr((String)("Expected id:1, actual:" + result.getMemberId()));
                    }
                } else {
                    TestUtil.logErr((String)("Did not get correct number of results, expected:1, actual:" + lResult.size()));
                    for (Member m : lResult) {
                        TestUtil.logErr((String)("Ids received:" + m.getMemberId()));
                    }
                }
                if (foundOne && ok1 && ok2) {
                    pass1 = true;
                }
                this.getEntityTransaction().commit();
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            }
            finally {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            try {
                this.getEntityTransaction().begin();
                TestUtil.logMsg((String)"*********************************");
                TestUtil.logMsg((String)"Testing query verify original lock mode is active");
                namedQuery = this.getEntityManager().createNamedQuery("query");
                ok1 = false;
                lmt = namedQuery.getLockMode();
                if (lmt != null) {
                    if (lmt.equals((Object)LockModeType.NONE)) {
                        TestUtil.logTrace((String)("Received expected lock mode before change:" + lmt.name()));
                        ok1 = true;
                    } else {
                        TestUtil.logErr((String)("Expected lock mode before change:" + LockModeType.NONE.name() + ", actual:" + lmt.name()));
                    }
                } else {
                    TestUtil.logErr((String)"getLockModeType returned null");
                }
                List lResult = namedQuery.getResultList();
                boolean foundOne = false;
                if (lResult.size() == 1) {
                    Member result2 = (Member)lResult.get(0);
                    if (result2.getMemberId() == 1) {
                        TestUtil.logTrace((String)("Received expected id:" + result2.getMemberId()));
                        foundOne = true;
                    } else {
                        TestUtil.logErr((String)("Expected id:1, actual:" + result2.getMemberId()));
                    }
                } else {
                    TestUtil.logErr((String)("Did not get correct number of results, expected:1, actual:" + lResult.size()));
                    for (Member m : lResult) {
                        TestUtil.logErr((String)("Ids received:" + m.getMemberId()));
                    }
                }
                if (foundOne && ok1) {
                    pass2 = true;
                }
                this.getEntityTransaction().commit();
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            }
            finally {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            try {
                this.getEntityTransaction().begin();
                TestUtil.logMsg((String)"*********************************");
                TestUtil.logMsg((String)"Testing query definition can be replaced ");
                Query query2 = this.getEntityManager().createQuery("select m from Member m where m.memberId=2").setLockMode(LockModeType.PESSIMISTIC_READ);
                this.getEntityManagerFactory().addNamedQuery("query", query2);
                Query namedQuery2 = this.getEntityManager().createNamedQuery("query");
                boolean ok12 = false;
                LockModeType lmt2 = namedQuery2.getLockMode();
                if (lmt2 != null) {
                    if (lmt2.equals((Object)LockModeType.PESSIMISTIC_READ)) {
                        TestUtil.logTrace((String)("Received LockModeType:" + lmt2.name()));
                        ok12 = true;
                    } else if (lmt2.equals((Object)LockModeType.PESSIMISTIC_WRITE)) {
                        TestUtil.logTrace((String)("Received LockModeType:" + lmt2 + " inplace of " + LockModeType.PESSIMISTIC_READ.name()));
                        ok12 = true;
                    } else {
                        TestUtil.logErr((String)("Expected lock mode after change:" + LockModeType.PESSIMISTIC_READ.name() + ", actual:" + lmt2.name()));
                    }
                } else {
                    TestUtil.logErr((String)"getLockModeType returned null");
                }
                List lResult = namedQuery2.getResultList();
                boolean foundOne = false;
                if (lResult.size() == 1) {
                    result = (Member)lResult.get(0);
                    if (result.getMemberId() == 2) {
                        TestUtil.logTrace((String)("Received expected id:" + result.getMemberId()));
                        foundOne = true;
                    } else {
                        TestUtil.logErr((String)("Expected id:2, actual:" + result.getMemberId()));
                    }
                } else {
                    TestUtil.logErr((String)("Did not get correct number of results, expected:2, actual:" + lResult.size()));
                    for (Member m : lResult) {
                        TestUtil.logErr((String)("Ids received:" + m.getMemberId()));
                    }
                }
                if (foundOne && ok12) {
                    pass3 = true;
                }
                this.getEntityTransaction().commit();
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            }
            finally {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            try {
                this.getEntityTransaction().begin();
                TestUtil.logMsg((String)"*********************************");
                TestUtil.logMsg((String)"Testing TypedQuery with lock mode different than the original");
                namedTypeQuery = this.getEntityManager().createNamedQuery("typed_query", Member.class);
                boolean ok13 = false;
                LockModeType lmt3 = namedTypeQuery.getLockMode();
                if (lmt3 != null) {
                    if (lmt3.equals((Object)LockModeType.NONE)) {
                        TestUtil.logTrace((String)("Received expected lock mode before change:" + lmt3.name()));
                        ok13 = true;
                    } else {
                        TestUtil.logErr((String)("Expected lock mode before change:" + LockModeType.NONE.name() + ", actual:" + lmt3.name()));
                    }
                } else {
                    TestUtil.logErr((String)"getLockModeType returned null");
                }
                namedTypeQuery.setLockMode(LockModeType.PESSIMISTIC_READ);
                lmt3 = namedTypeQuery.getLockMode();
                boolean ok2 = false;
                if (lmt3.equals((Object)LockModeType.PESSIMISTIC_READ)) {
                    TestUtil.logTrace((String)("Received expected lock mode after change:" + lmt3.name()));
                    ok2 = true;
                } else if (lmt3.equals((Object)LockModeType.PESSIMISTIC_WRITE)) {
                    TestUtil.logTrace((String)("Received LockModeType:" + lmt3 + " inplace of " + LockModeType.PESSIMISTIC_READ.name()));
                    ok2 = true;
                } else {
                    TestUtil.logErr((String)("Expected lock mode after change:" + LockModeType.PESSIMISTIC_READ.name() + ", actual:" + lmt3.name()));
                }
                List lResult = namedTypeQuery.getResultList();
                boolean foundOne = false;
                if (lResult.size() == 1) {
                    result = (Member)lResult.get(0);
                    if (result.getMemberId() == 1) {
                        TestUtil.logTrace((String)("Received expected id:" + result.getMemberId()));
                        foundOne = true;
                    } else {
                        TestUtil.logErr((String)("Expected id:1, actual:" + result.getMemberId()));
                    }
                } else {
                    TestUtil.logErr((String)("Did not get correct number of results, expected:1, actual:" + lResult.size()));
                    for (Member m : lResult) {
                        TestUtil.logErr((String)("Ids received:" + m.getMemberId()));
                    }
                }
                if (foundOne && ok13 && ok2) {
                    pass4 = true;
                }
                this.getEntityTransaction().commit();
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            }
            finally {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            try {
                this.getEntityTransaction().begin();
                TestUtil.logMsg((String)"*********************************");
                TestUtil.logMsg((String)"Testing TypedQuery verify original lock mode is active");
                namedTypeQuery = this.getEntityManager().createNamedQuery("typed_query", Member.class);
                boolean ok14 = false;
                LockModeType lmt4 = namedTypeQuery.getLockMode();
                if (lmt4 != null) {
                    if (lmt4.equals((Object)LockModeType.NONE)) {
                        TestUtil.logTrace((String)("Received expected lock mode before change:" + lmt4.name()));
                        ok14 = true;
                    } else {
                        TestUtil.logErr((String)("Expected lock mode before change:" + LockModeType.NONE.name() + ", actual:" + lmt4.name()));
                    }
                } else {
                    TestUtil.logErr((String)"getLockModeType returned null");
                }
                List lResult = namedTypeQuery.getResultList();
                boolean foundOne = false;
                if (lResult.size() == 1) {
                    Member result3 = (Member)lResult.get(0);
                    if (result3.getMemberId() == 1) {
                        TestUtil.logTrace((String)("Received expected id:" + result3.getMemberId()));
                        foundOne = true;
                    } else {
                        TestUtil.logErr((String)("Expected id:1, actual:" + result3.getMemberId()));
                    }
                } else {
                    TestUtil.logErr((String)("Did not get correct number of results, expected:1, actual:" + lResult.size()));
                    for (Member m : lResult) {
                        TestUtil.logErr((String)("Ids received:" + m.getMemberId()));
                    }
                }
                if (foundOne && ok14) {
                    pass5 = true;
                }
                this.getEntityTransaction().commit();
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            }
            finally {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5)) {
            throw new EETest.Fault("addNamedQueryLockModeTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createOrderTestData() {
        try {
            this.getEntityTransaction().begin();
            Order[] orders = new Order[]{new Order(1, 111), new Order(2, 222), new Order(3, 333), new Order(4, 444), new Order(5, 555)};
            for (Order o : orders) {
                TestUtil.logTrace((String)("Persisting order:" + o.toString()));
                this.getEntityManager().persist((Object)o);
            }
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMemberTestData() {
        try {
            this.getEntityTransaction().begin();
            Member[] members = new Member[]{new Member(1, "1"), new Member(2, "2"), new Member(3, "3"), new Member(4, "4"), new Member(5, "5")};
            for (Member m : members) {
                TestUtil.logTrace((String)("Persisting member:" + m.toString()));
                this.getEntityManager().persist((Object)m);
            }
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            this.getEntityManager().createNativeQuery("DELETE FROM PURCHASE_ORDER").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM MEMBER").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

