/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.webservices.ejb.marshalltest;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxrpc.common.JAXRPC_Data;
import com.sun.ts.tests.webservices.ejb.marshalltest.MarshallTest;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;

public class Client
extends EETest {
    MarshallTest port = null;

    private void getStub() throws Exception {
        TestUtil.logMsg((String)"JNDI lookup for Service1");
        InitialContext ctx = new InitialContext();
        Service svc = (Service)ctx.lookup("java:comp/env/service/ejbmarshalltest");
        TestUtil.logMsg((String)"Get port from Service1");
        this.port = (MarshallTest)svc.getPort(MarshallTest.class);
        TestUtil.logMsg((String)"Port obtained");
    }

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            this.getStub();
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    private void printSeperationLine() {
        TestUtil.logMsg((String)"---------------------------");
    }

    public void MarshallSimpleTypesTest() throws EETest.Fault {
        TestUtil.logMsg((String)"MarshallSimpleTypesTest");
        boolean pass = true;
        if (!this.StringTest()) {
            pass = false;
        }
        this.printSeperationLine();
        if (!this.IntegerTest()) {
            pass = false;
        }
        this.printSeperationLine();
        if (!this.IntTest()) {
            pass = false;
        }
        this.printSeperationLine();
        if (!this.LongTest()) {
            pass = false;
        }
        this.printSeperationLine();
        if (!this.ShortTest()) {
            pass = false;
        }
        this.printSeperationLine();
        if (!this.DecimalTest()) {
            pass = false;
        }
        this.printSeperationLine();
        if (!this.FloatTest()) {
            pass = false;
        }
        this.printSeperationLine();
        if (!this.DoubleTest()) {
            pass = false;
        }
        this.printSeperationLine();
        if (!this.BooleanTest()) {
            pass = false;
        }
        this.printSeperationLine();
        if (!this.ByteTest()) {
            pass = false;
        }
        this.printSeperationLine();
        if (!this.QNameTest()) {
            pass = false;
        }
        this.printSeperationLine();
        if (!this.DateTimeTest()) {
            pass = false;
        }
        this.printSeperationLine();
        if (!this.Base64BinaryTest()) {
            pass = false;
        }
        this.printSeperationLine();
        if (!this.HexBinaryTest()) {
            pass = false;
        }
        this.printSeperationLine();
        if (!pass) {
            throw new EETest.Fault("MarshallSimpleTypesTest failed");
        }
    }

    public void MarshallArraysOfSimpleTypesTest() throws EETest.Fault {
        TestUtil.logMsg((String)"MarshallArraysOfSimpleTypesTest");
        boolean pass = true;
        if (!this.StringArrayTest()) {
            pass = false;
        }
        this.printSeperationLine();
        if (!this.IntegerArrayTest()) {
            pass = false;
        }
        this.printSeperationLine();
        if (!this.IntArrayTest()) {
            pass = false;
        }
        this.printSeperationLine();
        if (!this.LongArrayTest()) {
            pass = false;
        }
        this.printSeperationLine();
        if (!this.ShortArrayTest()) {
            pass = false;
        }
        this.printSeperationLine();
        if (!this.DecimalArrayTest()) {
            pass = false;
        }
        this.printSeperationLine();
        if (!this.FloatArrayTest()) {
            pass = false;
        }
        this.printSeperationLine();
        if (!this.DoubleArrayTest()) {
            pass = false;
        }
        this.printSeperationLine();
        if (!this.BooleanArrayTest()) {
            pass = false;
        }
        this.printSeperationLine();
        if (!this.ByteArrayTest()) {
            pass = false;
        }
        this.printSeperationLine();
        if (!this.QNameArrayTest()) {
            pass = false;
        }
        this.printSeperationLine();
        if (!this.DateTimeArrayTest()) {
            pass = false;
        }
        this.printSeperationLine();
        if (!pass) {
            throw new EETest.Fault("MarshallArraysOfSimpleTypesTest failed");
        }
    }

    private boolean printTestStatus(boolean pass, String test) {
        if (pass) {
            TestUtil.logMsg((String)("" + test + " ... PASSED"));
        } else {
            TestUtil.logErr((String)("" + test + " ... FAILED"));
        }
        return pass;
    }

    private boolean StringTest() {
        TestUtil.logMsg((String)"StringTest");
        boolean pass = true;
        String[] values = JAXRPC_Data.String_data;
        TestUtil.logMsg((String)"Passing/Returning data to/from JAXRPC Service");
        try {
            for (int i = 0; i < values.length; ++i) {
                String response = this.port.echoString(values[i]);
                if (values[i] == null && response == null || response.equals(values[i])) continue;
                TestUtil.logErr((String)("StringTest failed - expected " + values[i] + ",  received: " + response));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "StringTest");
        return pass;
    }

    private boolean IntegerTest() {
        TestUtil.logMsg((String)"IntegerTest");
        boolean pass = true;
        BigInteger[] values = JAXRPC_Data.BigInteger_data;
        TestUtil.logMsg((String)"Passing/Returning data to/from JAXRPC Service");
        try {
            for (int i = 0; i < values.length; ++i) {
                BigInteger response = this.port.echoInteger(values[i]);
                if (values[i] == null && response == null || response.equals(values[i])) continue;
                TestUtil.logErr((String)("IntegerTest failed - expected " + values[i] + ",  received: " + response));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "IntegerTest");
        return pass;
    }

    private boolean IntTest() {
        TestUtil.logMsg((String)"IntTest");
        boolean pass = true;
        int[] values = JAXRPC_Data.int_data;
        TestUtil.logMsg((String)"Passing/Returning data to/from JAXRPC Service");
        try {
            for (int i = 0; i < values.length; ++i) {
                int response = this.port.echoInt(values[i]);
                if (response == values[i]) continue;
                TestUtil.logErr((String)("IntTest failed - expected " + values[i] + ",  received: " + response));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "IntTest");
        return pass;
    }

    private boolean LongTest() {
        TestUtil.logMsg((String)"LongTest");
        boolean pass = true;
        long[] values = JAXRPC_Data.long_data;
        TestUtil.logMsg((String)"Passing/Returning data to/from JAXRPC Service");
        try {
            for (int i = 0; i < values.length; ++i) {
                long response = this.port.echoLong(values[i]);
                if (response == values[i]) continue;
                TestUtil.logErr((String)("LongTest failed - expected " + values[i] + ",  received: " + response));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "LongTest");
        return pass;
    }

    private boolean ShortTest() {
        TestUtil.logMsg((String)"ShortTest");
        boolean pass = true;
        short[] values = JAXRPC_Data.short_data;
        TestUtil.logMsg((String)"Passing/Returning data to/from JAXRPC Service");
        try {
            for (int i = 0; i < values.length; ++i) {
                short response = this.port.echoShort(values[i]);
                if (response == values[i]) continue;
                TestUtil.logErr((String)("ShortTest failed - expected " + values[i] + ",  received: " + response));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "ShortTest");
        return pass;
    }

    private boolean DecimalTest() {
        TestUtil.logMsg((String)"DecimalTest");
        boolean pass = true;
        BigDecimal[] values = JAXRPC_Data.BigDecimal_data;
        TestUtil.logMsg((String)"Passing/Returning data to/from JAXRPC Service");
        try {
            for (int i = 0; i < values.length; ++i) {
                BigDecimal response = this.port.echoDecimal(values[i]);
                if (values[i] == null && response == null || response.equals(values[i])) continue;
                TestUtil.logErr((String)("DecimalTest failed - expected " + values[i] + ",  received: " + response));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "DecimalTest");
        return pass;
    }

    private boolean FloatTest() {
        TestUtil.logMsg((String)"FloatTest");
        boolean pass = true;
        float[] values = JAXRPC_Data.float_data;
        TestUtil.logMsg((String)"Passing/Returning data to/from JAXRPC Service");
        try {
            for (int i = 0; i < values.length; ++i) {
                float response = this.port.echoFloat(values[i]);
                if (response == values[i]) continue;
                TestUtil.logErr((String)("FloatTest failed - expected " + values[i] + ",  received: " + response));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "FloatTest");
        return pass;
    }

    private boolean DoubleTest() {
        TestUtil.logMsg((String)"DoubleTest");
        boolean pass = true;
        double[] values = JAXRPC_Data.double_data;
        TestUtil.logMsg((String)"Passing/Returning data to/from JAXRPC Service");
        try {
            for (int i = 0; i < values.length; ++i) {
                double response = this.port.echoDouble(values[i]);
                if (response == values[i]) continue;
                TestUtil.logErr((String)("DoubleTest failed - expected " + values[i] + ",  received: " + response));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "DoubleTest");
        return pass;
    }

    private boolean BooleanTest() {
        TestUtil.logMsg((String)"BooleanTest");
        boolean pass = true;
        boolean[] values = JAXRPC_Data.boolean_data;
        TestUtil.logMsg((String)"Passing/Returning data to/from JAXRPC Service");
        try {
            for (int i = 0; i < values.length; ++i) {
                boolean response = this.port.echoBoolean(values[i]);
                if (!response != values[i]) continue;
                TestUtil.logErr((String)("BooleanTest failed - expected " + values[i] + ",  received: " + response));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "BooleanTest");
        return pass;
    }

    private boolean ByteTest() {
        TestUtil.logMsg((String)"ByteTest");
        boolean pass = true;
        byte[] values = JAXRPC_Data.byte_data;
        TestUtil.logMsg((String)"Passing/Returning data to/from JAXRPC Service");
        try {
            for (int i = 0; i < values.length; ++i) {
                byte response = this.port.echoByte(values[i]);
                if (response == values[i]) continue;
                TestUtil.logErr((String)("ByteTest failed - expected " + values[i] + ",  received: " + response));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "ByteTest");
        return pass;
    }

    private boolean QNameTest() {
        TestUtil.logMsg((String)"QNameTest");
        boolean pass = true;
        QName[] values = JAXRPC_Data.QName_data;
        TestUtil.logMsg((String)"Passing/Returning data to/from JAXRPC Service");
        try {
            for (int i = 0; i < values.length; ++i) {
                QName response = this.port.echoQName(values[i]);
                if (values[i] == null && response == null || response.equals(values[i])) continue;
                TestUtil.logErr((String)("QNameTest failed - expected " + values[i] + ",  received: " + response));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "QNameTest");
        return pass;
    }

    private boolean DateTimeTest() {
        TestUtil.logMsg((String)"DateTimeTest");
        boolean pass = true;
        GregorianCalendar[] values = JAXRPC_Data.GregorianCalendar_data;
        TestUtil.logMsg((String)"Passing/Returning data to/from JAXRPC Service");
        try {
            for (int i = 0; i < values.length; ++i) {
                Calendar response = this.port.echoDateTime(values[i]);
                if (JAXRPC_Data.compareValues(values[i], response, "Calendar")) continue;
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "DateTimeTest");
        return pass;
    }

    private boolean Base64BinaryTest() {
        TestUtil.logMsg((String)"Base64BinaryTest");
        boolean pass = false;
        byte[] values = JAXRPC_Data.byte_data;
        TestUtil.logMsg((String)"Passing/Returning data to/from JAXRPC Service");
        try {
            byte[] response = this.port.echoBase64Binary(values);
            pass = JAXRPC_Data.compareArrayValues(values, response, "byte");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "Base64BinaryTest");
        return pass;
    }

    private boolean HexBinaryTest() {
        TestUtil.logMsg((String)"HexBinaryTest");
        boolean pass = false;
        byte[] values = JAXRPC_Data.byte_data;
        TestUtil.logMsg((String)"Passing/Returning data to/from JAXRPC Service");
        try {
            byte[] response = this.port.echoHexBinary(values);
            pass = JAXRPC_Data.compareArrayValues(values, response, "byte");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "HexBinaryTest");
        return pass;
    }

    private boolean StringArrayTest() {
        TestUtil.logMsg((String)"StringArrayTest");
        boolean pass = false;
        String[] values = JAXRPC_Data.String_data;
        TestUtil.logMsg((String)"Passing/Returning array data to/from JAXRPC Service");
        try {
            JAXRPC_Data.dumpArrayValues(values, "String");
            String[] response = this.port.echoStringArray(values);
            TestUtil.logMsg((String)"Compare response with input ....");
            pass = JAXRPC_Data.compareArrayValues(values, response, "String");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "StringArrayTest");
        return pass;
    }

    private boolean IntegerArrayTest() {
        TestUtil.logMsg((String)"IntegerArrayTest");
        boolean pass = false;
        BigInteger[] values = JAXRPC_Data.BigInteger_data;
        TestUtil.logMsg((String)"Passing/Returning array data to/from JAXRPC Service");
        try {
            BigInteger[] response = this.port.echoIntegerArray(values);
            pass = JAXRPC_Data.compareArrayValues(values, response, "BigInteger");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "IntegerArrayTest");
        return pass;
    }

    private boolean IntArrayTest() {
        TestUtil.logMsg((String)"IntArrayTest");
        boolean pass = false;
        int[] values = JAXRPC_Data.int_data;
        TestUtil.logMsg((String)"Passing/Returning array data to/from JAXRPC Service");
        try {
            int[] response = this.port.echoIntArray(values);
            pass = JAXRPC_Data.compareArrayValues(values, response, "int");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "IntArrayTest");
        return pass;
    }

    private boolean LongArrayTest() {
        TestUtil.logMsg((String)"LongArrayTest");
        boolean pass = false;
        long[] values = JAXRPC_Data.long_data;
        TestUtil.logMsg((String)"Passing/Returning array data to/from JAXRPC Service");
        try {
            long[] response = this.port.echoLongArray(values);
            pass = JAXRPC_Data.compareArrayValues(values, response, "long");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "LongArrayTest");
        return pass;
    }

    private boolean ShortArrayTest() {
        TestUtil.logMsg((String)"ShortArrayTest");
        boolean pass = false;
        short[] values = JAXRPC_Data.short_data;
        TestUtil.logMsg((String)"Passing/Returning array data to/from JAXRPC Service");
        try {
            short[] response = this.port.echoShortArray(values);
            pass = JAXRPC_Data.compareArrayValues(values, response, "short");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "ShortArrayTest");
        return pass;
    }

    private boolean FloatArrayTest() {
        TestUtil.logMsg((String)"FloatArrayTest");
        boolean pass = false;
        float[] values = JAXRPC_Data.float_data;
        TestUtil.logMsg((String)"Passing/Returning array data to/from JAXRPC Service");
        try {
            float[] response = this.port.echoFloatArray(values);
            pass = JAXRPC_Data.compareArrayValues(values, response, "float");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "FloatArrayTest");
        return pass;
    }

    private boolean DoubleArrayTest() {
        TestUtil.logMsg((String)"DoubleArrayTest");
        boolean pass = false;
        double[] values = JAXRPC_Data.double_data;
        TestUtil.logMsg((String)"Passing/Returning array data to/from JAXRPC Service");
        try {
            double[] response = this.port.echoDoubleArray(values);
            pass = JAXRPC_Data.compareArrayValues(values, response, "double");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "DoubleArrayTest");
        return pass;
    }

    private boolean DecimalArrayTest() {
        TestUtil.logMsg((String)"DecimalArrayTest");
        boolean pass = false;
        BigDecimal[] values = JAXRPC_Data.BigDecimal_data;
        TestUtil.logMsg((String)"Passing/Returning array data to/from JAXRPC Service");
        try {
            BigDecimal[] response = this.port.echoDecimalArray(values);
            pass = JAXRPC_Data.compareArrayValues(values, response, "BigDecimal");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "DecimalArrayTest");
        return pass;
    }

    private boolean BooleanArrayTest() {
        TestUtil.logMsg((String)"BooleanArrayTest");
        boolean pass = false;
        boolean[] values = JAXRPC_Data.boolean_data;
        TestUtil.logMsg((String)"Passing/Returning array data to/from JAXRPC Service");
        try {
            boolean[] response = this.port.echoBooleanArray(values);
            pass = JAXRPC_Data.compareArrayValues(values, response, "boolean");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "BooleanArrayTest");
        return pass;
    }

    private boolean ByteArrayTest() {
        TestUtil.logMsg((String)"ByteArrayTest");
        boolean pass = false;
        byte[] values = JAXRPC_Data.byte_data;
        TestUtil.logMsg((String)"Passing/Returning array data to/from JAXRPC Service");
        try {
            byte[] response = this.port.echoByteArray(values);
            pass = JAXRPC_Data.compareArrayValues(values, response, "byte");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "ByteArrayTest");
        return pass;
    }

    private boolean QNameArrayTest() {
        TestUtil.logMsg((String)"QNameArrayTest");
        boolean pass = false;
        QName[] values = JAXRPC_Data.QName_data;
        TestUtil.logMsg((String)"Passing/Returning array data to/from JAXRPC Service");
        try {
            QName[] response = this.port.echoQNameArray(values);
            pass = JAXRPC_Data.compareArrayValues(values, response, "QName");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "QNameArrayTest");
        return pass;
    }

    private boolean DateTimeArrayTest() {
        TestUtil.logMsg((String)"DateTimeArrayTest");
        boolean pass = false;
        Calendar[] values = JAXRPC_Data.GregorianCalendar_data;
        TestUtil.logMsg((String)"Passing/Returning array data to/from JAXRPC Service");
        try {
            Calendar[] response = this.port.echoDateTimeArray(values);
            pass = JAXRPC_Data.compareArrayValues(values, response, "Calendar");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        this.printTestStatus(pass, "DateTimeArrayTest");
        return pass;
    }
}

