/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import java.util.Properties;
import javax.batch.runtime.BatchStatus;

public class JobAttributeRestartTests
extends ServiceEETest {
    private JobOperatorBridge jobOp = null;
    private long TIMEOUT = 5000L;

    public void testJobAttributeRestartableTrue() throws EETest.Fault {
        String METHOD = "testJobAttributeRestartableTrue";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"starting job");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            jobParams.put("execution.number", "1");
            TCKJobExecutionWrapper jobExec = this.jobOp.startJobAndWaitForResult("job_attributes_restart_true_test", jobParams);
            TestUtil.logMsg((String)("Job Status = " + jobExec.getBatchStatus()));
            AssertionUtils.assertWithMessage("Job failed ", BatchStatus.FAILED, jobExec.getBatchStatus());
            TestUtil.logMsg((String)"restarting job");
            Properties restartParams = new Properties();
            TestUtil.logMsg((String)"execution.number=2");
            restartParams.put("execution.number", "2");
            TCKJobExecutionWrapper newJobExec = this.jobOp.restartJobAndWaitForResult(jobExec.getExecutionId(), restartParams);
            TestUtil.logMsg((String)("Job Status = " + newJobExec.getBatchStatus()));
            AssertionUtils.assertWithMessage("Job completed", BatchStatus.COMPLETED, newJobExec.getBatchStatus());
            TestUtil.logMsg((String)"job completed");
        }
        catch (Exception e) {
            JobAttributeRestartTests.handleException(METHOD, e);
        }
    }

    private static void handleException(String methodName, Exception e) throws EETest.Fault {
        TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
        TestUtil.printStackTrace((Throwable)e);
        throw new EETest.Fault(methodName + " failed", e);
    }

    public void setup(String[] args, Properties props) throws EETest.Fault {
        String METHOD = "setup";
        TestUtil.logTrace((String)METHOD);
        try {
            this.jobOp = new JobOperatorBridge();
        }
        catch (Exception e) {
            JobAttributeRestartTests.handleException(METHOD, e);
        }
    }

    public void cleanup() {
    }

    public void beforeTest() throws ClassNotFoundException {
        this.jobOp = new JobOperatorBridge();
    }

    public void afterTest() {
        this.jobOp = null;
    }
}

