/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.types.generator;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.types.generator.DataTypes;
import com.sun.ts.tests.jpa.core.types.generator.DataTypes2;
import com.sun.ts.tests.jpa.core.types.generator.DataTypes3;
import com.sun.ts.tests.jpa.core.types.generator.DataTypes4;
import java.util.Properties;

public class Client
extends PMClientBase {
    private DataTypes d0;
    private DataTypes d1;
    private DataTypes d2;
    private DataTypes d3;
    private DataTypes d4;
    private DataTypes d5;
    private DataTypes d6;
    private DataTypes2 d10;
    private DataTypes3 d11;
    private DataTypes4 d12;
    private boolean supports_sequence = false;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        block4: {
            TestUtil.logTrace((String)"setup");
            try {
                super.setup(args, p);
                String s = p.getProperty("db.supports.sequence");
                if (s != null) {
                    this.supports_sequence = Boolean.parseBoolean(s);
                    TestUtil.logMsg((String)("db.supports.sequence:" + this.supports_sequence));
                    if (this.supports_sequence) {
                        this.removeTestData();
                        this.createTestData();
                    }
                    break block4;
                }
                TestUtil.logErr((String)"The property db.supports.sequence is not defined in the ts.jte, this must be corrected before running tests");
                throw new EETest.Fault("setupDataTypes2 failed");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Exception: ", (Throwable)e);
                throw new EETest.Fault("Setup failed:", e);
            }
        }
    }

    public void setupDataTypes2(String[] args, Properties p) throws EETest.Fault {
        block4: {
            TestUtil.logTrace((String)"setupDataTypes2");
            try {
                super.setup(args, p);
                String s = p.getProperty("db.supports.sequence");
                if (s != null) {
                    this.supports_sequence = Boolean.parseBoolean(s);
                    TestUtil.logMsg((String)("db.supports.sequence:" + this.supports_sequence));
                    if (this.supports_sequence) {
                        this.removeTestData();
                        this.createDataTypes2Data();
                    }
                    break block4;
                }
                TestUtil.logErr((String)"The property db.supports.sequence is not defined in the ts.jte, this must be corrected before running tests");
                throw new EETest.Fault("setupDataTypes2 failed");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Exception: ", (Throwable)e);
                throw new EETest.Fault("setupDataTypes2 failed:", e);
            }
        }
    }

    public void setupDataTypes3(String[] args, Properties p) throws EETest.Fault {
        block4: {
            TestUtil.logTrace((String)"setupDataTypes3");
            try {
                super.setup(args, p);
                String s = p.getProperty("db.supports.sequence");
                if (s != null) {
                    this.supports_sequence = Boolean.parseBoolean(s);
                    TestUtil.logMsg((String)("db.supports.sequence:" + this.supports_sequence));
                    if (this.supports_sequence) {
                        this.removeTestData();
                        this.createDataTypes3Data();
                    }
                    break block4;
                }
                TestUtil.logErr((String)"The property db.supports.sequence is not defined in the ts.jte, this must be corrected before running tests");
                throw new EETest.Fault("setupDataTypes3 failed");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Exception: ", (Throwable)e);
                throw new EETest.Fault("setupDataTypes3 failed:", e);
            }
        }
    }

    public void setupDataTypes4(String[] args, Properties p) throws EETest.Fault {
        block4: {
            TestUtil.logTrace((String)"setupDataTypes4");
            try {
                super.setup(args, p);
                String s = p.getProperty("db.supports.sequence");
                if (s != null) {
                    this.supports_sequence = Boolean.parseBoolean(s);
                    TestUtil.logMsg((String)("db.supports.sequence:" + this.supports_sequence));
                    if (this.supports_sequence) {
                        this.removeTestData();
                        this.createDataTypes4Data();
                    }
                    break block4;
                }
                TestUtil.logErr((String)"The property db.supports.sequence is not defined in the ts.jte, this must be corrected before running tests");
                throw new EETest.Fault("setupDataTypes4 failed");
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Exception: ", (Throwable)e);
                throw new EETest.Fault("setupDataTypes4 failed:", e);
            }
        }
    }

    public void generatorTypeTest1() throws EETest.Fault {
        boolean pass;
        block8: {
            pass = false;
            if (this.supports_sequence) {
                Character newChar = Character.valueOf('b');
                try {
                    this.getEntityTransaction().begin();
                    int id = this.d0.getId();
                    TestUtil.logTrace((String)("Doing a find of id: " + id));
                    this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)id);
                    if (null != this.d1) {
                        if (this.d1.getCharacterData().equals(Character.valueOf('a'))) {
                            this.d1.setCharacterData(newChar);
                        }
                        this.getEntityManager().merge((Object)this.d1);
                        this.getEntityManager().flush();
                        if (this.d1.getCharacterData().equals(newChar)) {
                            pass = true;
                        }
                        this.getEntityTransaction().commit();
                        break block8;
                    }
                    TestUtil.logErr((String)"EntityManager.find returned null result");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
                }
            } else {
                TestUtil.logMsg((String)"WARNING: Test not run because db.supports.sequence set to false in ts.jte");
                pass = true;
            }
        }
        if (!pass) {
            throw new EETest.Fault("generatorTypeTest1 failed");
        }
    }

    public void generatorTypeTest2() throws EETest.Fault {
        boolean pass;
        block8: {
            pass = false;
            if (this.supports_sequence) {
                Short newShort = 101;
                try {
                    this.getEntityTransaction().begin();
                    int id = this.d0.getId();
                    TestUtil.logTrace((String)("Doing a find of id: " + id));
                    this.d2 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)id);
                    if (null != this.d2) {
                        if (this.d2.getShortData().equals((short)100)) {
                            this.d2.setShortData(newShort);
                        }
                        this.getEntityManager().merge((Object)this.d2);
                        this.getEntityManager().flush();
                        if (this.d2.getShortData().equals(newShort)) {
                            pass = true;
                        }
                        this.getEntityTransaction().commit();
                        break block8;
                    }
                    TestUtil.logErr((String)"EntityManager.find returned null result");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
                }
            } else {
                TestUtil.logMsg((String)"WARNING: Test not run because db.supports.sequence set to false in ts.jte");
                pass = true;
            }
        }
        if (!pass) {
            throw new EETest.Fault("generatorTypeTest2 failed");
        }
    }

    public void generatorTypeTest3() throws EETest.Fault {
        boolean pass;
        block8: {
            pass = false;
            if (this.supports_sequence) {
                Integer newInt = 500;
                try {
                    this.getEntityTransaction().begin();
                    int id = this.d0.getId();
                    TestUtil.logTrace((String)("Doing a find of id: " + id));
                    this.d3 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)id);
                    if (null != this.d3) {
                        if (this.d3.getIntegerData().equals(500)) {
                            this.d3.setIntegerData(newInt);
                        }
                        this.getEntityManager().merge((Object)this.d3);
                        this.getEntityManager().flush();
                        if (this.d3.getIntegerData().equals(newInt)) {
                            pass = true;
                        }
                        this.getEntityTransaction().commit();
                        break block8;
                    }
                    TestUtil.logErr((String)"EntityManager.find returned null result");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
                }
            } else {
                TestUtil.logMsg((String)"WARNING: Test not run because db.supports.sequence set to false in ts.jte");
                pass = true;
            }
        }
        if (!pass) {
            throw new EETest.Fault("generatorTypeTest3 failed");
        }
    }

    public void generatorTypeTest4() throws EETest.Fault {
        boolean pass;
        block8: {
            pass = false;
            if (this.supports_sequence) {
                Long newLong = 600L;
                try {
                    this.getEntityTransaction().begin();
                    int id = this.d0.getId();
                    TestUtil.logTrace((String)("Doing a find of id: " + id));
                    this.d4 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)id);
                    if (null != this.d4) {
                        if (this.d4.getLongData().equals(300L)) {
                            this.d4.setLongData(newLong);
                        }
                        this.getEntityManager().merge((Object)this.d4);
                        this.getEntityManager().flush();
                        if (this.d4.getLongData().equals(newLong)) {
                            pass = true;
                        }
                        this.getEntityTransaction().commit();
                        break block8;
                    }
                    TestUtil.logErr((String)"EntityManager.find returned null result");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
                }
            } else {
                TestUtil.logMsg((String)"WARNING: Test not run because db.supports.sequence set to false in ts.jte");
                pass = true;
            }
        }
        if (!pass) {
            throw new EETest.Fault("generatorTypeTest4 failed");
        }
    }

    public void generatorTypeTest5() throws EETest.Fault {
        boolean pass;
        block8: {
            pass = false;
            if (this.supports_sequence) {
                Double newDbl = 80.0;
                try {
                    this.getEntityTransaction().begin();
                    int id = this.d0.getId();
                    TestUtil.logTrace((String)("Doing a find of id: " + id));
                    this.d5 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)id);
                    if (null != this.d5) {
                        if (this.d5.getDoubleData().equals(50.0)) {
                            this.d5.setDoubleData(newDbl);
                        }
                        this.getEntityManager().merge((Object)this.d5);
                        this.getEntityManager().flush();
                        if (this.d5.getDoubleData().equals(newDbl)) {
                            pass = true;
                        }
                        this.getEntityTransaction().commit();
                        break block8;
                    }
                    TestUtil.logErr((String)"EntityManager.find returned null result");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
                }
            } else {
                TestUtil.logMsg((String)"WARNING: Test not run because db.supports.sequence set to false in ts.jte");
                pass = true;
            }
        }
        if (!pass) {
            throw new EETest.Fault("generatorTypeTest5 failed");
        }
    }

    public void generatorTypeTest6() throws EETest.Fault {
        boolean pass;
        block8: {
            pass = false;
            if (this.supports_sequence) {
                Float newFloat = Float.valueOf(3.0f);
                try {
                    this.getEntityTransaction().begin();
                    int id = this.d0.getId();
                    TestUtil.logTrace((String)("Doing a find of id: " + id));
                    this.d6 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)id);
                    if (null != this.d6) {
                        if (this.d6.getFloatData().equals(Float.valueOf(1.0f))) {
                            this.d6.setFloatData(newFloat);
                        }
                        this.getEntityManager().merge((Object)this.d6);
                        this.getEntityManager().flush();
                        if (this.d6.getFloatData().equals(newFloat)) {
                            pass = true;
                        }
                        this.getEntityTransaction().commit();
                        break block8;
                    }
                    TestUtil.logErr((String)"EntityManager.find returned null result");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
                }
            } else {
                TestUtil.logMsg((String)"WARNING: Test not run because db.supports.sequence set to false in ts.jte");
                pass = true;
            }
        }
        if (!pass) {
            throw new EETest.Fault("generatorTypeTest6 failed");
        }
    }

    @SetupMethod(name="setupDataTypes2")
    public void generatorTypeSequenceTest() throws EETest.Fault {
        boolean pass;
        block10: {
            pass = true;
            if (this.supports_sequence) {
                Float newFloat = Float.valueOf(3.0f);
                try {
                    this.getEntityTransaction().begin();
                    int id = this.d10.getId();
                    TestUtil.logTrace((String)("Doing a find of id: " + id));
                    DataTypes2 d = (DataTypes2)this.getEntityManager().find(DataTypes2.class, (Object)id);
                    if (null != d) {
                        Float f = d.getFloatData();
                        if (f.equals(this.d10.getFloatData())) {
                            TestUtil.logTrace((String)("find returned correct float value:" + f));
                            d.setFloatData(newFloat);
                        } else {
                            TestUtil.logErr((String)("find did not return correct float value, expected: 1.0, actual:" + f));
                            pass = false;
                        }
                        this.getEntityManager().merge((Object)d);
                        this.getEntityManager().flush();
                        f = d.getFloatData();
                        if (f.equals(newFloat)) {
                            TestUtil.logTrace((String)("Successfully set float value to:" + newFloat));
                        } else {
                            TestUtil.logErr((String)("Could not update float value, expected: " + newFloat + ", actual:" + f));
                            pass = false;
                        }
                        this.getEntityTransaction().commit();
                        break block10;
                    }
                    TestUtil.logErr((String)"find returned null result");
                    pass = false;
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
                    pass = false;
                }
            } else {
                TestUtil.logMsg((String)"WARNING: Test not run because db.supports.sequence set to false in ts.jte");
            }
        }
        if (!pass) {
            throw new EETest.Fault("generatorTypeSequenceTest failed");
        }
    }

    @SetupMethod(name="setupDataTypes3")
    public void sequenceGeneratorOnEntityTest() throws EETest.Fault {
        boolean pass;
        block10: {
            pass = true;
            if (this.supports_sequence) {
                Integer newInt = 1000;
                try {
                    this.getEntityTransaction().begin();
                    this.clearCache();
                    TestUtil.logMsg((String)("Doing a find of id: " + this.d11.getId()));
                    DataTypes3 d = (DataTypes3)this.getEntityManager().find(DataTypes3.class, (Object)this.d11.getId());
                    if (d != null) {
                        Integer i = d.getIntegerData();
                        if (i.equals(this.d11.getIntegerData())) {
                            TestUtil.logTrace((String)("find returned correct Integer value:" + i));
                            d.setIntegerData(newInt);
                        } else {
                            TestUtil.logErr((String)("find did not return correct Integer value, expected: " + this.d11.getIntegerData() + ", actual:" + i));
                            pass = false;
                        }
                        this.getEntityManager().merge((Object)d);
                        this.getEntityManager().flush();
                        this.clearCache();
                        TestUtil.logMsg((String)("Doing a find of merged data for id: " + d.getId()));
                        DataTypes3 d2 = (DataTypes3)this.getEntityManager().find(DataTypes3.class, (Object)d.getId());
                        i = d2.getIntegerData();
                        if (i.equals(d2.getIntegerData())) {
                            TestUtil.logTrace((String)("find returned correct merged Integer value:" + i));
                        } else {
                            TestUtil.logErr((String)("find did not return correct Integer value, expected: " + d.getIntegerData() + ", actual:" + i));
                            pass = false;
                        }
                        this.getEntityTransaction().commit();
                        break block10;
                    }
                    TestUtil.logErr((String)"find returned null result");
                    pass = false;
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
                    pass = false;
                }
            } else {
                TestUtil.logMsg((String)"WARNING: Test not run because db.supports.sequence set to false in ts.jte");
            }
        }
        if (!pass) {
            throw new EETest.Fault("sequenceGeneratorOnEntityTest failed");
        }
    }

    @SetupMethod(name="setupDataTypes4")
    public void sequenceGeneratorOnPropertyTest() throws EETest.Fault {
        boolean pass;
        block10: {
            pass = true;
            if (this.supports_sequence) {
                Integer newInt = 1000;
                try {
                    this.getEntityTransaction().begin();
                    this.clearCache();
                    TestUtil.logMsg((String)("Doing a find of id: " + this.d12.getId()));
                    DataTypes4 d = (DataTypes4)this.getEntityManager().find(DataTypes4.class, (Object)this.d12.getId());
                    if (d != null) {
                        Integer i = d.getIntegerData();
                        if (i.equals(this.d12.getIntegerData())) {
                            TestUtil.logTrace((String)("find returned correct Integer value:" + i));
                            d.setIntegerData(newInt);
                        } else {
                            TestUtil.logErr((String)("find did not return correct Integer value, expected: " + this.d12.getIntegerData() + ", actual:" + i));
                            pass = false;
                        }
                        this.getEntityManager().merge((Object)d);
                        this.getEntityManager().flush();
                        this.clearCache();
                        TestUtil.logMsg((String)("Doing a find of merged data for id: " + d.getId()));
                        DataTypes4 d2 = (DataTypes4)this.getEntityManager().find(DataTypes4.class, (Object)d.getId());
                        i = d2.getIntegerData();
                        if (i.equals(d2.getIntegerData())) {
                            TestUtil.logTrace((String)("find returned correct merged Integer value:" + i));
                        } else {
                            TestUtil.logErr((String)("find did not return correct Integer value, expected: " + d.getIntegerData() + ", actual:" + i));
                            pass = false;
                        }
                        this.getEntityTransaction().commit();
                        break block10;
                    }
                    TestUtil.logErr((String)"find returned null result");
                    pass = false;
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
                    pass = false;
                }
            } else {
                TestUtil.logMsg((String)"WARNING: Test not run because db.supports.sequence set to false in ts.jte");
            }
        }
        if (!pass) {
            throw new EETest.Fault("sequenceGeneratorOnEntityTest failed");
        }
    }

    public void createTestData() {
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"in createTestData");
            TestUtil.logTrace((String)"new DataType");
            this.d0 = new DataTypes(Character.valueOf('a'), Short.valueOf((short)100), Integer.valueOf(500), Long.valueOf(300L), Double.valueOf(50.0), Float.valueOf(1.0f));
            TestUtil.logTrace((String)"Persist DataType");
            this.getEntityManager().persist((Object)this.d0);
            TestUtil.logTrace((String)("DataType id:" + this.d0.getId()));
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
    }

    public void createDataTypes2Data() {
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"in createDataTypes2Data");
            TestUtil.logTrace((String)"new DataType2");
            this.d10 = new DataTypes2(Character.valueOf('a'), Short.valueOf((short)100), Integer.valueOf(500), Long.valueOf(300L), Double.valueOf(50.0), Float.valueOf(1.0f));
            TestUtil.logTrace((String)"Persist DataType2");
            this.getEntityManager().persist((Object)this.d10);
            TestUtil.logTrace((String)("DataType2 id:" + this.d10.getId()));
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
    }

    public void createDataTypes3Data() {
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"in createDataTypes3Data");
            TestUtil.logTrace((String)"new DataType3");
            this.d11 = new DataTypes3(Integer.valueOf(500));
            TestUtil.logTrace((String)"Persist DataType3");
            this.getEntityManager().persist((Object)this.d11);
            TestUtil.logTrace((String)("DataType3 id:" + this.d11.getId()));
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
    }

    public void createDataTypes4Data() {
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"in createDataTypes4Data");
            TestUtil.logTrace((String)"new DataType4");
            this.d12 = new DataTypes4(Integer.valueOf(500));
            TestUtil.logTrace((String)"Persist DataType4");
            this.getEntityManager().persist((Object)this.d12);
            TestUtil.logTrace((String)("DataType4 id:" + this.d12.getId()));
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"Cleanup data");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM DATATYPES").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

