/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.annotations.orderby;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.CleanupMethod;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.annotations.orderby.A;
import com.sun.ts.tests.jpa.core.annotations.orderby.A2;
import com.sun.ts.tests.jpa.core.annotations.orderby.Address;
import com.sun.ts.tests.jpa.core.annotations.orderby.Address2;
import com.sun.ts.tests.jpa.core.annotations.orderby.Customer;
import com.sun.ts.tests.jpa.core.annotations.orderby.Customer2;
import com.sun.ts.tests.jpa.core.annotations.orderby.Department;
import com.sun.ts.tests.jpa.core.annotations.orderby.Employee;
import com.sun.ts.tests.jpa.core.annotations.orderby.Insurance;
import com.sun.ts.tests.jpa.core.annotations.orderby.ZipCode;
import com.sun.ts.tests.jpa.core.annotations.orderby.ZipCode2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class Client
extends PMClientBase {
    List<Address> addrRef;
    Address addr1 = null;
    Address addr2 = null;
    Address addr3 = null;
    List<Address2> addrRef2;
    Address2 addr11 = null;
    Address2 addr12 = null;
    Address2 addr13 = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void setupAddress(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setupAddress");
        try {
            super.setup(args, p);
            this.removeAddressData();
            this.createAddressData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void setupCust(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeCustTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void orderByTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin orderByTest1");
        boolean pass1 = true;
        boolean pass2 = false;
        ArrayList<String> resultsList = new ArrayList<String>();
        Object[] expectedResult = new String[]{"Zoe", "Song", "Jie", "Ay"};
        try {
            this.getEntityTransaction().begin();
            Employee empChange = (Employee)this.getEntityManager().find(Employee.class, (Object)65);
            empChange.setFirstName("Ay");
            this.getEntityManager().merge((Object)empChange);
            this.getEntityManager().flush();
            Insurance newIns = (Insurance)this.getEntityManager().find(Insurance.class, (Object)60);
            this.getEntityManager().refresh((Object)newIns);
            List insResult = newIns.getEmployees();
            if (insResult.size() != 4) {
                TestUtil.logTrace((String)("orderByTest1:  Did not get expected results.  Expected: 4, got: " + insResult.size()));
                pass1 = false;
            } else if (pass1) {
                Iterator i1 = insResult.iterator();
                TestUtil.logTrace((String)"Check Employee Collection for expected first names");
                while (i1.hasNext()) {
                    Employee e1 = (Employee)i1.next();
                    resultsList.add(e1.getFirstName());
                    TestUtil.logTrace((String)("orderByTest1: got Employee FirstName:" + e1.getFirstName()));
                }
                TestUtil.logTrace((String)"Compare first names received with expected first names ");
                Object[] result = resultsList.toArray(new String[resultsList.size()]);
                pass2 = Arrays.equals(expectedResult, result);
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass2 = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("orderByTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void orderByTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin orderByTest2");
        boolean pass1 = true;
        boolean pass2 = false;
        ArrayList<String> resultsList = new ArrayList<String>();
        Object[] expectedResult = new String[]{"Jie", "Song", "Yay", "Zoe"};
        try {
            this.getEntityTransaction().begin();
            Employee emp2Change = (Employee)this.getEntityManager().find(Employee.class, (Object)65);
            emp2Change.setFirstName("Yay");
            this.getEntityManager().merge((Object)emp2Change);
            this.getEntityManager().flush();
            Department newDept = (Department)this.getEntityManager().find(Department.class, (Object)50);
            this.getEntityManager().refresh((Object)newDept);
            List deptResult = newDept.getEmployees();
            if (deptResult.size() != 4) {
                TestUtil.logTrace((String)("orderByTest2:  Did not get expected results.  Expected: 4, got: " + deptResult.size()));
                pass1 = false;
            } else if (pass1) {
                Iterator i2 = deptResult.iterator();
                TestUtil.logTrace((String)"Check Employee Collection for expected first names");
                while (i2.hasNext()) {
                    Employee e2 = (Employee)i2.next();
                    resultsList.add(e2.getFirstName());
                    TestUtil.logTrace((String)("orderByTest2: got Employee FirstName:" + e2.getFirstName()));
                }
                TestUtil.logTrace((String)"Compare first names received with expected first names ");
                Object[] result = resultsList.toArray(new String[resultsList.size()]);
                pass2 = Arrays.equals(expectedResult, result);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("orderByTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void orderByTest3() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin orderByTest3");
        boolean pass1 = true;
        boolean pass2 = false;
        ArrayList<String> resultsList = new ArrayList<String>();
        Object[] expectedResult = new String[]{"Zoe", "Song", "Penelope", "May", "Jie"};
        try {
            this.getEntityTransaction().begin();
            Employee emp3Change = (Employee)this.getEntityManager().find(Employee.class, (Object)85);
            Insurance ins = (Insurance)this.getEntityManager().find(Insurance.class, (Object)60);
            emp3Change.setInsurance(ins);
            this.getEntityManager().merge((Object)emp3Change);
            ins.getEmployees().add(emp3Change);
            this.getEntityManager().merge((Object)ins);
            this.getEntityManager().flush();
            this.getEntityManager().refresh((Object)ins);
            List insResult = ins.getEmployees();
            if (insResult.size() != 5) {
                TestUtil.logErr((String)("orderByTest3: Expected List Size of 5 got: " + insResult.size()));
                pass1 = false;
            } else if (pass1) {
                Iterator i3 = insResult.iterator();
                TestUtil.logTrace((String)"Check Employee Collection for expected first names");
                while (i3.hasNext()) {
                    Employee e3 = (Employee)i3.next();
                    resultsList.add(e3.getFirstName());
                    TestUtil.logTrace((String)("orderByTest3: got Employee FirstName:" + e3.getFirstName()));
                }
                TestUtil.logTrace((String)"orderByTest3: Expected size received, check ordering . . .");
                Object[] result = resultsList.toArray(new String[resultsList.size()]);
                pass2 = Arrays.equals(expectedResult, result);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("orderByTest3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void orderByTest4() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin orderByTest4");
        boolean pass1 = true;
        boolean pass2 = false;
        ArrayList<String> resultsList = new ArrayList<String>();
        Object[] expectedResult = new String[]{"Jie", "May", "Penelope", "Song", "Zoe"};
        try {
            this.getEntityTransaction().begin();
            Employee emp4Change = (Employee)this.getEntityManager().find(Employee.class, (Object)85);
            Department dept = (Department)this.getEntityManager().find(Department.class, (Object)50);
            emp4Change.setDepartment(dept);
            this.getEntityManager().merge((Object)emp4Change);
            dept.getEmployees().add(emp4Change);
            this.getEntityManager().merge((Object)dept);
            this.getEntityManager().flush();
            this.getEntityManager().refresh((Object)dept);
            List deptResult = dept.getEmployees();
            if (deptResult.size() != 5) {
                TestUtil.logErr((String)("orderByTest4: Expected Collection Size of 5 got: " + deptResult.size()));
                pass1 = false;
            } else if (pass1) {
                Iterator i4 = deptResult.iterator();
                TestUtil.logTrace((String)"Check Employee Collection for expected first names");
                while (i4.hasNext()) {
                    Employee e4 = (Employee)i4.next();
                    resultsList.add(e4.getFirstName());
                    TestUtil.logTrace((String)("orderByTest4: got Employee FirstName:" + e4.getFirstName()));
                }
                TestUtil.logTrace((String)"orderByTest4: Expected size received, check ordering . . .");
                Object[] result = resultsList.toArray(new String[resultsList.size()]);
                pass2 = Arrays.equals(expectedResult, result);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("orderByTest4 failed");
        }
    }

    @SetupMethod(name="setupAddress")
    @CleanupMethod(name="cleanupAddress")
    public void propertyDotNotationTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.addrRef = new ArrayList<Address>();
            ArrayList<Address> expected = new ArrayList<Address>();
            expected.add(this.addr2);
            expected.add(this.addr3);
            expected.add(this.addr1);
            this.clearCache();
            A a = (A)this.getEntityManager().find(A.class, (Object)"1");
            List actual = a.getAddressList();
            if (actual.size() == expected.size()) {
                int count = 0;
                for (int i = 0; i < expected.size(); ++i) {
                    TestUtil.logTrace((String)("Testing - expected[" + expected.get(i) + "], actual[" + actual.get(i) + "]"));
                    if (!((Address)expected.get(i)).equals(actual.get(i))) continue;
                    ++count;
                }
                if (count == expected.size()) {
                    pass = true;
                } else {
                    TestUtil.logErr((String)("count=" + count + ", expected size:" + expected.size()));
                    for (Address aa : expected) {
                        TestUtil.logErr((String)("expected:" + aa));
                    }
                    TestUtil.logErr((String)"------------");
                    for (Address aa : actual) {
                        TestUtil.logErr((String)("actual:" + aa));
                    }
                }
            } else {
                TestUtil.logErr((String)("Expected list size:" + expected.size() + ", actual size:" + actual.size()));
                for (Address aa : expected) {
                    TestUtil.logErr((String)("expected:" + aa));
                }
                TestUtil.logErr((String)"------------");
                for (Address aa : actual) {
                    TestUtil.logErr((String)("actual:" + aa));
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("propertyDotNotationTest failed");
        }
    }

    @SetupMethod(name="setupAddress")
    @CleanupMethod(name="cleanupAddress")
    public void fieldDotNotationTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.addrRef = new ArrayList<Address>();
            ArrayList<Address2> expected = new ArrayList<Address2>();
            expected.add(this.addr12);
            expected.add(this.addr13);
            expected.add(this.addr11);
            TestUtil.logTrace((String)"Clearing the cache");
            this.clearCache();
            A2 a = (A2)this.getEntityManager().find(A2.class, (Object)"2");
            List actual = a.getAddressList();
            if (actual.size() == expected.size()) {
                int count = 0;
                for (int i = 0; i < expected.size(); ++i) {
                    TestUtil.logTrace((String)("Testing - expected[" + expected.get(i) + "], actual[" + actual.get(i) + "]"));
                    if (!((Address2)expected.get(i)).equals(actual.get(i))) continue;
                    ++count;
                }
                if (count == expected.size()) {
                    pass = true;
                } else {
                    TestUtil.logTrace((String)("count=" + count + ", expected size:" + expected.size()));
                    for (Address2 aa : expected) {
                        TestUtil.logErr((String)("expected:" + aa));
                    }
                    TestUtil.logErr((String)"------------");
                    for (Address2 aa : actual) {
                        TestUtil.logErr((String)("actual:" + aa));
                    }
                }
            } else {
                TestUtil.logErr((String)("Expected list size:" + expected.size() + ", actual size:" + actual.size()));
                for (Address2 aa : expected) {
                    TestUtil.logErr((String)("expected:" + aa));
                }
                TestUtil.logErr((String)"------------");
                for (Address2 aa : actual) {
                    TestUtil.logErr((String)("actual:" + aa));
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("propertyDotNotationTest failed");
        }
    }

    @SetupMethod(name="setupCust")
    @CleanupMethod(name="cleanupCust")
    public void propertyElementCollectionBasicType() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Customer expected = new Customer("1");
            ArrayList<String> expectedphones = new ArrayList<String>();
            expectedphones.add("781-442-2010");
            expectedphones.add("781-442-2011");
            expectedphones.add("781-442-2012");
            expected.setPhones(expectedphones);
            TestUtil.logTrace((String)("Persisting Customer:" + expected.toString()));
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find the previously persisted Customer and Country and verify them");
            Customer cust = (Customer)this.getEntityManager().find(Customer.class, (Object)expected.getId());
            if (cust != null) {
                TestUtil.logTrace((String)("Found Customer: " + cust.toString()));
                if (cust.getPhones().containsAll(expectedphones) && expectedphones.containsAll(cust.getPhones()) && cust.getPhones().size() == expectedphones.size()) {
                    TestUtil.logTrace((String)"Received expected Phones:");
                    for (String s : cust.getPhones()) {
                        TestUtil.logTrace((String)("phone:" + s));
                    }
                    pass = true;
                } else {
                    TestUtil.logErr((String)"Did not get expected results.");
                    for (String s : expectedphones) {
                        TestUtil.logErr((String)("expected:" + s));
                    }
                    TestUtil.logErr((String)"actual:");
                    for (String s : cust.getPhones()) {
                        TestUtil.logErr((String)("actual:" + s));
                    }
                }
            } else {
                TestUtil.logErr((String)"Find returned null Customer");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred: ", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("propertyElementCollectionBasicType failed");
        }
    }

    @SetupMethod(name="setupCust")
    @CleanupMethod(name="cleanupCust")
    public void fieldElementCollectionBasicType() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Customer2 expected = new Customer2("2");
            ArrayList<String> expectedphones = new ArrayList<String>();
            expectedphones.add("781-442-2010");
            expectedphones.add("781-442-2011");
            expectedphones.add("781-442-2012");
            expected.setPhones(expectedphones);
            TestUtil.logTrace((String)("Persisting Customer2:" + expected.toString()));
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            Customer2 cust = (Customer2)this.getEntityManager().find(Customer2.class, (Object)expected.getId());
            if (cust != null) {
                TestUtil.logTrace((String)("Found Customer2: " + cust.toString()));
                if (cust.getPhones().containsAll(expectedphones) && expectedphones.containsAll(cust.getPhones()) && cust.getPhones().size() == expectedphones.size()) {
                    TestUtil.logTrace((String)"Received expected Phones:");
                    for (String s : cust.getPhones()) {
                        TestUtil.logTrace((String)("phone:" + s));
                    }
                    pass = true;
                } else {
                    TestUtil.logErr((String)"Did not get expected results.");
                    for (String s : expectedphones) {
                        TestUtil.logErr((String)("expected:" + s));
                    }
                    TestUtil.logErr((String)"actual:");
                    for (String s : cust.getPhones()) {
                        TestUtil.logErr((String)("actual:" + s));
                    }
                }
            } else {
                TestUtil.logErr((String)"Find returned null Customer");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred: ", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("fieldElementCollectionBasicType failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTestData() throws Exception {
        try {
            TestUtil.logTrace((String)"createTestData");
            this.getEntityTransaction().begin();
            float salary = 10000.0f;
            Department d1 = new Department(50, "SJSAS Appserver");
            this.getEntityManager().persist((Object)d1);
            Insurance s1 = new Insurance(60, "United");
            this.getEntityManager().persist((Object)s1);
            Employee e1 = new Employee(70, "Jie", "Leng", 10000.0f, d1, s1);
            Employee e2 = new Employee(80, "Zoe", "Leng", 10000.0f, d1, s1);
            Employee e3 = new Employee(90, "Song", "Leng", 10000.0f, d1, s1);
            Employee e4 = new Employee(65, "May", "Leng", 10000.0f, d1, s1);
            Employee e5 = new Employee(85, "Penelope", "Leng", 10000.0f);
            this.getEntityManager().persist((Object)e1);
            this.getEntityManager().persist((Object)e2);
            this.getEntityManager().persist((Object)e3);
            this.getEntityManager().persist((Object)e4);
            this.getEntityManager().persist((Object)e5);
            ArrayList<Employee> link = new ArrayList<Employee>();
            link.add(e1);
            link.add(e2);
            link.add(e3);
            link.add(e4);
            d1.setEmployees(link);
            this.getEntityManager().merge((Object)d1);
            s1.setEmployees(link);
            this.getEntityManager().merge((Object)s1);
            TestUtil.logTrace((String)"persisted Entity Data");
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception creating test data:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
    }

    private void createAddressData() throws Exception {
        try {
            TestUtil.logTrace((String)"createAddressData");
            this.getEntityTransaction().begin();
            this.addr1 = new Address("1 Network Drive", "Burlington", "MA", new ZipCode("01801"));
            this.addr2 = new Address("634 Goldstar Road", "Peabody", "MA", new ZipCode("88444"));
            this.addr3 = new Address("3212 Boston Road", "Chelmsford", "MA", new ZipCode("01824"));
            this.addrRef = new ArrayList<Address>();
            this.addrRef.add(this.addr1);
            this.addrRef.add(this.addr2);
            this.addrRef.add(this.addr3);
            A a1 = new A("1", "b1", this.addrRef);
            this.addr11 = new Address2("1 Network Drive", "Burlington", "MA", new ZipCode2("01801"));
            this.addr12 = new Address2("634 Goldstar Road", "Peabody", "MA", new ZipCode2("88444"));
            this.addr13 = new Address2("3212 Boston Road", "Chelmsford", "MA", new ZipCode2("01824"));
            this.addrRef2 = new ArrayList<Address2>();
            this.addrRef2.add(this.addr11);
            this.addrRef2.add(this.addr12);
            this.addrRef2.add(this.addr13);
            A2 a2 = new A2("2", "b2", this.addrRef2);
            this.getEntityManager().persist((Object)a1);
            this.getEntityManager().persist((Object)a2);
            this.getEntityManager().flush();
            this.getEntityManager().refresh((Object)a1);
            this.getEntityManager().refresh((Object)a2);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception creating test data:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    public void cleanupAddress() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeAddressData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    public void cleanupCust() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeCustTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeCustTestData() {
        TestUtil.logTrace((String)"removeCustTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM CUST_TABLE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PHONES").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("Delete from EMPLOYEE").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from DEPARTMENT").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from INSURANCE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }

    private void removeAddressData() {
        TestUtil.logTrace((String)"removeAddressData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("Delete from COLTAB_ADDRESS").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from COLTAB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

