/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ant.taskdefs.common;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.util.StringUtils;

public class PathTranslator
extends Task {
    private String propname;
    private String type;
    private boolean escape;

    public void setEscape(boolean b) {
        this.escape = b;
    }

    public void setPropname(String propName) {
        this.propname = propName;
    }

    public void setType(String s) {
        this.type = s;
    }

    public void execute() throws BuildException {
        if (this.propname == null || this.propname.length() == 0) {
            return;
        }
        String oldVal = this.project.getProperty(this.propname);
        String oldUserVal = this.project.getUserProperty(this.propname);
        if (oldVal == null && oldUserVal == null) {
            throw new BuildException("Property " + this.propname + " has not been set. Do not know how to translate it.");
        }
        String newVal = this.translatePath(oldVal);
        if (oldUserVal == null) {
            this.project.setProperty(this.propname, newVal);
        } else {
            this.project.setUserProperty(this.propname, newVal);
        }
    }

    private String normalizeInitialFile(String oldVal) {
        if (oldVal == null) {
            return oldVal;
        }
        String result = "";
        oldVal = oldVal.replace('\\', '/');
        while (oldVal.endsWith("/")) {
            oldVal = oldVal.substring(0, oldVal.length() - 1);
        }
        if (oldVal.endsWith("/src")) {
            return result;
        }
        int pos = oldVal.indexOf("/src/");
        if (pos == -1) {
            this.log(this.propname + "=" + oldVal + ", does not contain '/src/'");
            return oldVal;
        }
        result = oldVal.substring(pos + 5);
        return result;
    }

    private String translatePath(String oldVal) {
        String result = null;
        if (this.type == null) {
            result = Project.translatePath((String)oldVal);
            if (this.escape && Os.isFamily((String)"windows")) {
                result = StringUtils.replace((String)result, (String)"\\", (String)"\\\\");
            }
        } else if (this.type.equalsIgnoreCase("initialfile")) {
            result = this.normalizeInitialFile(oldVal);
        }
        return result;
    }
}

