/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.httpd;

import com.sun.javatest.httpd.httpURL;
import com.sun.javatest.util.DynamicArray;
import java.io.PrintWriter;

public abstract class JThttpProvider {
    private String[] regURLs = new String[0];
    protected static boolean debug = Boolean.getBoolean("debug." + JThttpProvider.class.getName());

    public abstract void serviceRequest(httpURL var1, PrintWriter var2);

    public String getRootURL() {
        if (this.regURLs != null && this.regURLs.length > 0) {
            return this.regURLs[0];
        }
        return null;
    }

    public String[] getRegisteredURLs() {
        String[] cp = new String[this.regURLs.length];
        System.arraycopy(this.regURLs, 0, cp, 0, this.regURLs.length);
        return cp;
    }

    protected static void print(PrintWriter out, String str) {
        if (str == null) {
            return;
        }
        out.print(JThttpProvider.filterTags(str));
    }

    protected static void println(PrintWriter out, String str) {
        if (str == null) {
            return;
        }
        out.println(JThttpProvider.filterTags(str));
    }

    protected static String filterTags(String original) {
        int beginIndex = 0;
        if (original == null) {
            return null;
        }
        StringBuffer workStr = new StringBuffer(original);
        for (int currIndex = 0; currIndex < workStr.length(); ++currIndex) {
            char currChar = workStr.charAt(currIndex);
            if (currChar == '<') {
                workStr.setCharAt(currIndex, '&');
                workStr.insert(currIndex + 1, "lt;");
                beginIndex = currIndex + 4;
                currIndex += 3;
                continue;
            }
            if (currChar != '>') continue;
            workStr.setCharAt(currIndex, '&');
            workStr.insert(currIndex + 1, "gt;");
            beginIndex = currIndex + 4;
            currIndex += 3;
        }
        return workStr.toString();
    }

    void addRegistredURL(String url) {
        if (url != null) {
            this.regURLs = (String[])DynamicArray.append(this.regURLs, url);
            if (debug) {
                System.out.println("PROV-registered URL (" + url + ") in " + this);
            }
        }
    }

    void removeRegisteredURL(String url) {
        for (int i = 0; i < this.regURLs.length; ++i) {
            if (!this.regURLs[i].equals(url)) continue;
            this.regURLs = (String[])DynamicArray.remove((Object[])this.regURLs, i);
            break;
        }
    }
}

