/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.jpa22.repeatable.namednativequery;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.jpa22.repeatable.namednativequery.Coffee;
import java.util.Properties;

public class Client
extends PMClientBase {
    private static final long serialVersionUID = 22L;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.logTrace("Cleanup data");
            this.removeTestData();
            this.logTrace("Create Test data");
            this.createTestData();
            this.logTrace("Done creating test data");
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findTest() throws Exception {
        this.logTrace("Begin findTest1");
        boolean pass = false;
        this.getEntityTransaction().begin();
        try {
            for (int i = 1; i != 5; ++i) {
                Coffee coffeeFound = (Coffee)this.getEntityManager().find(Coffee.class, (Object)i);
                this.assertTrue(coffeeFound != null, "cofee id = " + i + " not found");
                this.assertTrue(coffeeFound.getId() == i, "Unexpected id found:" + coffeeFound.getId() + " expected " + i);
            }
            pass = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("findTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTestData() throws Exception {
        try {
            this.logTrace("createTestData");
            this.getEntityTransaction().begin();
            this.logTrace("Create 5 Coffees");
            Coffee[] cRef = new Coffee[]{new Coffee(1, "hazelnut", 1.0f), new Coffee(2, "vanilla creme", 2.0f), new Coffee(3, "decaf", 3.0f), new Coffee(4, "breakfast blend", 4.0f), new Coffee(5, "mocha", 5.0f)};
            this.logTrace("Start to persist coffees ");
            for (Coffee c : cRef) {
                if (c == null) continue;
                this.getEntityManager().persist((Object)c);
                this.logTrace("persisted coffee " + String.valueOf(c));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception creating test data:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM COFFEE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }

    private void assertTrue(boolean b, String message) throws Exception {
        if (!b) {
            throw new Exception(message);
        }
    }
}

