/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.connector.localTx.security;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.common.connector.whitebox.TSConnection;
import com.sun.ts.tests.common.connector.whitebox.TSDataSource;
import com.sun.ts.tests.connector.util.DBSupport;
import java.io.Serializable;
import java.util.Properties;
import java.util.Vector;

public class securityClient1
extends ServiceEETest
implements Serializable {
    private TSNamingContext nctx = null;
    private TSConnection con = null;
    private TSConnection con2 = null;
    private String whitebox_tx = null;
    private String whitebox_tx_param = null;
    private String uname = null;
    private String password = null;
    private TSDataSource ds1 = null;
    private TSDataSource ds2 = null;
    private DBSupport dbutil = null;

    public static void main(String[] args) {
        securityClient1 theTests = new securityClient1();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.whitebox_tx = p.getProperty("whitebox-tx");
        this.whitebox_tx_param = p.getProperty("whitebox-tx-param");
        this.uname = p.getProperty("rauser1");
        this.password = p.getProperty("rapassword1");
        this.logMsg("Using: " + this.whitebox_tx);
        this.logMsg("Using: " + this.whitebox_tx_param);
        try {
            this.dbutil = new DBSupport();
        }
        catch (Exception e) {
            throw new Exception("Exception constructing DBSupport object: " + e.getMessage(), e);
        }
        try {
            this.nctx = new TSNamingContext();
            this.ds1 = (TSDataSource)this.nctx.lookup(this.whitebox_tx);
            this.ds2 = (TSDataSource)this.nctx.lookup(this.whitebox_tx_param);
            TestUtil.logMsg((String)("ds1 JNDI lookup: " + String.valueOf(this.ds1)));
            TestUtil.logMsg((String)("ds2 JNDI lookup: " + String.valueOf(this.ds2)));
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logMsg((String)("Exception during JNDI lookup: " + e.getMessage()));
        }
    }

    public void testContainerManaged() throws Exception {
        try {
            this.con = this.ds1.getConnection();
            TestUtil.logMsg((String)"Got connection from the TSDataSource.");
        }
        catch (Exception e) {
            TestUtil.logMsg((String)"Exception caught on creating connection.");
            throw new Exception(e.getMessage(), e);
        }
        TestUtil.logMsg((String)"Checking for Connection Validity.");
        try {
            this.dbutil.insertIntoTable(this.con);
            TestUtil.logMsg((String)"Values inserted into table!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception inserting into table.");
            throw new Exception(sqle.getMessage(), sqle);
        }
        try {
            this.dbutil.dropTable(this.con);
            TestUtil.logMsg((String)"Table has been dropped!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception dropping table.");
            throw new Exception(sqle.getMessage(), sqle);
        }
    }

    public void testComponentManaged() throws Exception {
        try {
            this.logMsg("Using: " + this.whitebox_tx_param);
            this.con = this.ds2.getConnection(this.uname, this.password);
            TestUtil.logMsg((String)"Got connection object from the TSDataSource.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection.");
            throw new Exception(sqle.getMessage(), sqle);
        }
        TestUtil.logMsg((String)"Checking for Connection Validity.");
        try {
            this.dbutil.insertIntoTable(this.con);
            TestUtil.logMsg((String)"Values inserted into table!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception inserting into table.");
            throw new Exception(sqle.getMessage(), sqle);
        }
        try {
            this.dbutil.dropTable(this.con);
            TestUtil.logMsg((String)"Table has been dropped!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception dropping table.");
            throw new Exception(sqle.getMessage(), sqle);
        }
    }

    public void testAppEISSignon() throws Exception {
        try {
            this.logMsg("Using: " + this.whitebox_tx_param);
            this.con = this.ds2.getConnection(this.uname, this.password);
            TestUtil.logMsg((String)"Got connection object from the TSDataSource.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection.");
            throw new Exception(sqle.getMessage(), sqle);
        }
        TestUtil.logMsg((String)"Checking for Connection Validity.");
        try {
            this.dbutil.insertIntoTable(this.con);
            TestUtil.logMsg((String)"Values inserted into table!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception inserting into table.");
            throw new Exception(sqle.getMessage(), sqle);
        }
        try {
            this.dbutil.dropTable(this.con);
            TestUtil.logMsg((String)"Table has been dropped!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception dropping table.");
            throw new Exception(sqle.getMessage(), sqle);
        }
    }

    public void testCBTestCPCandNullPrin() throws Exception {
        Vector log1 = null;
        boolean b1 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            this.ds1.setLogFlag(true);
            this.con = this.ds1.getConnection();
            log1 = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new Exception(sqle.getMessage(), sqle);
        }
        String toCheck1 = "cbTestCPCandNullPrin:  Case-1 security callbacks handled.";
        TestUtil.logTrace((String)("Searching for string:  " + toCheck1));
        TestUtil.logTrace((String)log1.toString());
        for (int i = 0; i < log1.size(); ++i) {
            String str = (String)log1.elementAt(i);
            if (!str.startsWith(toCheck1)) continue;
            b1 = true;
        }
        if (!b1) {
            TestUtil.logMsg((String)"couldnt find string in log1 = whitebox-tx");
            throw new Exception("testCBTestCPCandNullPrin() failed.");
        }
        TestUtil.logMsg((String)"testCBTestCPCandNullPrin() passed");
    }

    public void testCBTestCPCandGPC() throws Exception {
        Vector log2 = null;
        boolean b2 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            this.ds2.setLogFlag(true);
            this.con2 = this.ds1.getConnection();
            log2 = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new Exception(sqle.getMessage(), sqle);
        }
        String toCheck1 = "cbTestCPCandGPC:  callbacks handled.";
        TestUtil.logTrace((String)("Searching for string:  " + toCheck1));
        TestUtil.logTrace((String)log2.toString());
        for (int i = 0; i < log2.size(); ++i) {
            String str = (String)log2.elementAt(i);
            if (!str.startsWith(toCheck1)) continue;
            b2 = true;
        }
        if (!b2) {
            TestUtil.logMsg((String)"couldnt find string in log2 = whitebox-tx-param");
            throw new Exception("testCBTestCPCandGPC() failed.");
        }
        TestUtil.logMsg((String)"testCBTestCPCandGPC() passed");
    }

    public void testCBTestAllCallbacksAndPrin() throws Exception {
        Vector log1 = null;
        boolean b1 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            this.ds1.setLogFlag(true);
            this.con = this.ds1.getConnection();
            log1 = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new Exception(sqle.getMessage(), sqle);
        }
        String toCheck1 = "cbTestAllCallbacksAndPrin:  callbacks handled.";
        TestUtil.logTrace((String)("Searching for string:  " + toCheck1));
        TestUtil.logTrace((String)log1.toString());
        for (int i = 0; i < log1.size(); ++i) {
            String str = (String)log1.elementAt(i);
            if (!str.startsWith(toCheck1)) continue;
            b1 = true;
        }
        if (!b1) {
            TestUtil.logMsg((String)"couldnt find string in log1 = whitebox-tx");
            throw new Exception("testCBTestAllCallbacksAndPrin() failed.");
        }
        TestUtil.logMsg((String)"testCBTestAllCallbacksAndPrin() passed");
    }

    public void testCBTestCPCandPrin() throws Exception {
        Vector log1 = null;
        boolean b1 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            this.ds1.setLogFlag(true);
            this.con = this.ds1.getConnection();
            log1 = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new Exception(sqle.getMessage(), sqle);
        }
        String toCheck1 = "cbTestCPCandPrin:  callbacks handled.";
        TestUtil.logTrace((String)("Searching for string:  " + toCheck1));
        TestUtil.logTrace((String)log1.toString());
        for (int i = 0; i < log1.size(); ++i) {
            String str = (String)log1.elementAt(i);
            if (!str.startsWith(toCheck1)) continue;
            b1 = true;
        }
        if (!b1) {
            TestUtil.logMsg((String)"couldnt find string in log1 for rar = whitebox-tx");
            throw new Exception("testCBTestCPCandPrin() failed.");
        }
        TestUtil.logMsg((String)"testCBTestCPCandPrin() passed");
    }

    public void testCBTestAllCallbacksNullPrin() throws Exception {
        Vector log1 = null;
        boolean b1 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            this.ds1.setLogFlag(true);
            this.con = this.ds1.getConnection();
            log1 = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new Exception(sqle.getMessage(), sqle);
        }
        String toCheck1 = "cbTestAllCallbacksNullPrin:  callbacks handled.";
        TestUtil.logTrace((String)("Searching for string:  " + toCheck1));
        TestUtil.logTrace((String)log1.toString());
        for (int i = 0; i < log1.size(); ++i) {
            String str = (String)log1.elementAt(i);
            if (!str.startsWith(toCheck1)) continue;
            b1 = true;
        }
        if (!b1) {
            TestUtil.logMsg((String)"couldnt find string in log1 for rar = whitebox-tx");
            throw new Exception("testCBTestAllCallbacksNullPrin() failed.");
        }
        TestUtil.logMsg((String)"testCBTestAllCallbacksNullPrin() passed");
    }

    public void testCBTestCPCandPVC() throws Exception {
        Vector log1 = null;
        boolean b1 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            this.ds1.setLogFlag(true);
            this.con = this.ds1.getConnection();
            log1 = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new Exception(sqle.getMessage(), sqle);
        }
        String toCheck1 = "cbTestCPCandPVC:  callbacks handled.";
        TestUtil.logTrace((String)("Searching for string:  " + toCheck1));
        TestUtil.logTrace((String)log1.toString());
        for (int i = 0; i < log1.size(); ++i) {
            String str = (String)log1.elementAt(i);
            if (!str.startsWith(toCheck1)) continue;
            b1 = true;
        }
        if (!b1) {
            TestUtil.logMsg((String)"couldnt find string in log1 for rar = whitebox-tx");
            throw new Exception("testCBTestCPCandPVC() failed.");
        }
        TestUtil.logMsg((String)"testCBTestCPCandPVC() passed");
    }

    public void testCBTestGPCandCPCFail() throws Exception {
        Vector log2 = null;
        boolean b2 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            this.ds2.setLogFlag(true);
            this.con = this.ds1.getConnection();
            log2 = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new Exception(sqle.getMessage(), sqle);
        }
        String toCheck1 = "cbTestGPCandCPCFail:  callbacks are NOT handled - as expected.";
        TestUtil.logTrace((String)("Searching for string:  " + toCheck1));
        TestUtil.logTrace((String)log2.toString());
        for (int i = 0; i < log2.size(); ++i) {
            String str = (String)log2.elementAt(i);
            if (!str.startsWith(toCheck1)) continue;
            b2 = true;
        }
        if (!b2) {
            TestUtil.logMsg((String)"couldnt find string in log1 for rar = whitebox-tx-param");
            throw new Exception("testCBTestGPCandCPCFail() failed.");
        }
        TestUtil.logMsg((String)"testCBTestGPCandCPCFail() passed");
    }

    public void testCBTestEISCPCandPrin() throws Exception {
        Vector log2 = null;
        boolean b2 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            this.ds2.setLogFlag(true);
            this.con = this.ds1.getConnection();
            log2 = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new Exception(sqle.getMessage(), sqle);
        }
        String toCheck1 = "cbEISTestCPCandPrin:  callbacks handled.";
        TestUtil.logTrace((String)("Searching for string:  " + toCheck1));
        TestUtil.logTrace((String)log2.toString());
        for (int i = 0; i < log2.size(); ++i) {
            String str = (String)log2.elementAt(i);
            if (!str.startsWith(toCheck1)) continue;
            b2 = true;
        }
        if (!b2) {
            TestUtil.logMsg((String)"couldnt find string in log1 for rar = whitebox-tx-param");
            throw new Exception("testCBTestEISCPCandPrin() failed.");
        }
        TestUtil.logMsg((String)"testCBTestEISCPCandPrin() passed");
    }

    public void testConnManagerAllocateConnection() throws Exception {
        try {
            this.con = this.ds1.getConnection();
            TestUtil.logMsg((String)"Got connection from the TSDataSource.");
        }
        catch (Exception e) {
            TestUtil.logMsg((String)"Exception caught on creating connection.");
            throw new Exception(e.getMessage(), e);
        }
        TestUtil.logMsg((String)"Checking for Connection Validity.");
        try {
            this.dbutil.insertIntoTable(this.con);
            TestUtil.logMsg((String)"Values inserted into table!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception inserting into table.");
            throw new Exception(sqle.getMessage(), sqle);
        }
        try {
            this.dbutil.dropTable(this.con);
            TestUtil.logMsg((String)"Table has been dropped!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception dropping table.");
            throw new Exception(sqle.getMessage(), sqle);
        }
    }

    public void cleanup() throws Exception {
        this.ds1.clearLog();
        this.ds2.clearLog();
        TestUtil.logMsg((String)"Cleanup");
        try {
            TestUtil.logTrace((String)"Closing connection in cleanup.");
            if (this.con != null) {
                this.con.close();
            }
            if (this.con2 != null) {
                this.con2.close();
            }
        }
        catch (Exception sqle) {
            TestUtil.logErr((String)("Exception on cleanup: " + sqle.getMessage()), (Throwable)sqle);
        }
    }
}

