/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.xa;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsUtil;
import com.sun.ts.tests.jms.commonee.Client;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSession;
import jakarta.jms.Topic;
import java.util.Properties;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MDBClientIT
extends Client {
    private Queue cmtQ;
    private Queue bmtQ;
    private Topic bmtT;
    private Topic cmtT;
    private static final System.Logger logger = System.getLogger(MDBClientIT.class.getName());

    @BeforeEach
    public void setup() throws Exception {
        this.props = new Properties();
        this.props.put("jms_timeout", System.getProperty("jms_property"));
        this.props.put("user", System.getProperty("user"));
        this.props.put("password", System.getProperty("password"));
        super.setup(new String[0], this.props);
        try {
            this.cmtQ = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE_CMT");
            this.bmtQ = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE_BMT");
            this.rcvrQueue = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE_REPLY");
            this.bmtT = (Topic)this.context.lookup("java:comp/env/jms/MDB_DURABLE_BMT");
            this.cmtT = (Topic)this.context.lookup("java:comp/env/jms/MDB_DURABLE_CMT");
        }
        catch (Exception e) {
            throw new Exception("Setup Failed!", e);
        }
    }

    @Test
    public void Test1() throws Exception {
        String TestCase = "xaTest1";
        int TestNum = 1;
        try {
            this.qSender = this.session.createSender(this.cmtQ);
            this.createTestMessage(TestCase, TestNum);
            JmsUtil.addPropsToMessage((Message)this.msg, (Properties)this.props);
            System.out.println("Client: sending test message");
            this.qSender.send((Message)this.msg);
            System.out.println("Client:  response  message");
            if (!this.checkOnResponse(TestCase)) {
                throw new Exception("oops! error!");
            }
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void Test2() throws Exception {
        String TestCase = "xaTest2";
        int TestNum = 2;
        try {
            this.tPub = this.tSession.createPublisher(this.cmtT);
            this.createTestMessage(TestCase, TestNum);
            JmsUtil.addPropsToMessage((Message)this.msg, (Properties)this.props);
            this.tPub.publish((Message)this.msg);
            System.out.println("Client:  response  message");
            if (!this.checkOnResponse(TestCase)) {
                throw new Exception("oops! error!");
            }
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void Test3() throws Exception {
        String TestCase = "xaTest3";
        int TestNum = 3;
        try {
            this.qSender = this.session.createSender(this.cmtQ);
            this.createTestMessage(TestCase, TestNum);
            JmsUtil.addPropsToMessage((Message)this.msg, (Properties)this.props);
            this.qSender.send((Message)this.msg);
            if (!this.checkOnResponse(TestCase)) {
                throw new Exception("Test3 - getRollbackOnly returned wrong value");
            }
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void Test4() throws Exception {
        String TestCase = "xaTest4";
        int TestNum = 4;
        try {
            this.qSender = this.session.createSender(this.bmtQ);
            this.createTestMessage(TestCase, TestNum);
            JmsUtil.addPropsToMessage((Message)this.msg, (Properties)this.props);
            this.qSender.send((Message)this.msg);
            if (!this.checkOnResponse(TestCase)) {
                throw new Exception("Test4 - ");
            }
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void Test5() throws Exception {
        String TestCase = "xaTest5";
        int TestNum = 5;
        try {
            this.qSender = this.session.createSender(this.bmtQ);
            this.createTestMessage(TestCase, TestNum);
            JmsUtil.addPropsToMessage((Message)this.msg, (Properties)this.props);
            this.qSender.send((Message)this.msg);
            if (!this.checkOnResponse(TestCase)) {
                throw new Exception("Test5 - ");
            }
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void Test6() throws Exception {
        String TestCase = "xaTest6";
        int TestNum = 6;
        try {
            this.tPub = this.tSession.createPublisher(this.bmtT);
            this.createTestMessage(TestCase, TestNum);
            JmsUtil.addPropsToMessage((Message)this.msg, (Properties)this.props);
            this.tPub.publish((Message)this.msg);
            if (!this.checkOnResponse(TestCase)) {
                throw new Exception("Test6 - ");
            }
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void Test7() throws Exception {
        String TestCase = "xaTest7";
        int TestNum = 7;
        try {
            this.tPub = this.tSession.createPublisher(this.cmtT);
            this.createTestMessage(TestCase, TestNum);
            JmsUtil.addPropsToMessage((Message)this.msg, (Properties)this.props);
            this.msg.setStringProperty("TestCase", TestCase);
            this.tPub.publish((Message)this.msg);
            System.out.println("Client:  response  message");
            if (!this.checkOnResponse(TestCase)) {
                throw new Exception("oops! error!");
            }
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void Test8() throws Exception {
        String TestCase = "xaTest8";
        int TestNum = 8;
        try {
            this.qSender = this.session.createSender(this.bmtQ);
            this.createTestMessage(TestCase, TestNum);
            JmsUtil.addPropsToMessage((Message)this.msg, (Properties)this.props);
            this.qSender.send((Message)this.msg);
            if (!this.checkOnResponse(TestCase)) {
                throw new Exception("Test8 - ");
            }
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void Test9() throws Exception {
        String TestCase = "xaTest9";
        int TestNum = 9;
        try {
            this.tPub = this.tSession.createPublisher(this.bmtT);
            this.createTestMessage(TestCase, TestNum);
            JmsUtil.addPropsToMessage((Message)this.msg, (Properties)this.props);
            this.tPub.publish((Message)this.msg);
            if (!this.checkOnResponse(TestCase)) {
                throw new Exception("Test9 - ");
            }
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void Test10() throws Exception {
        String TestCase = "xaTest10";
        int TestNum = 10;
        try {
            this.qSender = this.session.createSender(this.cmtQ);
            this.createTestMessage(TestCase, TestNum);
            JmsUtil.addPropsToMessage((Message)this.msg, (Properties)this.props);
            this.qSender.send((Message)this.msg);
            System.out.println("Client:  response  message");
            if (!this.checkOnResponse(TestCase)) {
                throw new Exception("oops! error!");
            }
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    public void createTestMessage(String TestCase, int num) {
        String myMessage = "Transaction tests";
        try {
            this.msg = this.session.createTextMessage();
            this.msg.setStringProperty("user", this.jmsUser);
            this.msg.setStringProperty("password", this.jmsPassword);
            this.msg.setText(myMessage);
            this.msg.setIntProperty("TestCaseNum", num);
            this.msg.setStringProperty("COM_SUN_JMS_TESTNAME", TestCase);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            logger.log(System.Logger.Level.INFO, "Error setting user and password in jms msg");
        }
    }

    public boolean checkOnResponse(String prop) {
        boolean status = false;
        try {
            logger.log(System.Logger.Level.TRACE, "@checkOnResponse");
            status = this.recvMessageInternal(this.session, prop);
            logger.log(System.Logger.Level.TRACE, "Close the session");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        return status;
    }

    public boolean recvMessageInternal(QueueSession session, String prop) throws JMSException {
        boolean retcode = false;
        logger.log(System.Logger.Level.TRACE, "@recvMessageInternal");
        QueueReceiver rcvr = session.createReceiver(this.rcvrQueue);
        Message msgRec = null;
        for (int i = 0; i < 10; ++i) {
            logger.log(System.Logger.Level.TRACE, "@recvMessageInternal trying to receive the message: " + i);
            msgRec = rcvr.receive(this.timeout);
            if (msgRec != null) break;
        }
        if (msgRec != null) {
            if (msgRec.getStringProperty("TestCase").equals(prop) && msgRec.getStringProperty("Status").equals("Pass")) {
                logger.log(System.Logger.Level.TRACE, "TestCase: " + msgRec.getStringProperty("TestCase"));
                logger.log(System.Logger.Level.TRACE, "Status from msg: " + msgRec.getStringProperty("Status"));
                logger.log(System.Logger.Level.TRACE, "Pass: we got the expected msg back! ");
                retcode = true;
            } else if (msgRec.getStringProperty("Status").equals("Fail")) {
                logger.log(System.Logger.Level.TRACE, "TestCase: " + msgRec.getStringProperty("TestCase"));
                logger.log(System.Logger.Level.TRACE, "Status from msg: " + msgRec.getStringProperty("Status"));
                logger.log(System.Logger.Level.TRACE, "Fail: Error(s) occurred! ");
            } else {
                logger.log(System.Logger.Level.TRACE, "Fail: we didnt get the expected msg back! ");
                logger.log(System.Logger.Level.TRACE, "TestCase:  " + msgRec.getStringProperty("TestCase"));
            }
        } else if (msgRec == null) {
            logger.log(System.Logger.Level.TRACE, "Fail: we didnt get the expected msg back! ");
        }
        return retcode;
    }

    private void cleanTheQueue() {
    }
}

