/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.mdb_sndToQueue;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsUtil;
import jakarta.ejb.EJBException;
import jakarta.ejb.MessageDrivenBean;
import jakarta.ejb.MessageDrivenContext;
import jakarta.jms.BytesMessage;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import java.io.Serializable;
import java.util.Properties;

public class MsgBean
implements MessageDrivenBean,
MessageListener {
    private Properties p = null;
    private TSNamingContext context = null;
    private MessageDrivenContext mdc = null;
    private static final System.Logger logger = System.getLogger(MsgBean.class.getName());
    private QueueConnectionFactory qFactory = null;
    private QueueConnection qConnection = null;
    private Queue queue = null;
    private QueueSender mSender = null;
    private QueueSession qSession = null;

    public MsgBean() {
        logger.log(System.Logger.Level.TRACE, "@MsgBean()!");
    }

    public void ejbCreate() {
        logger.log(System.Logger.Level.TRACE, "@MsgBean-ejbCreate() !!");
        try {
            this.context = new TSNamingContext();
            this.qFactory = (QueueConnectionFactory)this.context.lookup("java:comp/env/jms/MyQueueConnectionFactory");
            if (this.qFactory == null) {
                logger.log(System.Logger.Level.ERROR, "qFactory error");
            }
            logger.log(System.Logger.Level.TRACE, "got a qFactory !!");
            this.queue = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE_REPLY");
            if (this.queue == null) {
                logger.log(System.Logger.Level.ERROR, "queue error");
            }
            logger.log(System.Logger.Level.TRACE, "got a queue ");
            this.p = new Properties();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("MDB ejbCreate Error!", e);
        }
    }

    public void onMessage(Message msg) {
        JmsUtil.initHarnessProps((Message)msg, (Properties)this.p);
        logger.log(System.Logger.Level.TRACE, "@onMessage! " + msg);
        try {
            this.qConnection = this.qFactory.createQueueConnection();
            if (this.qConnection == null) {
                logger.log(System.Logger.Level.ERROR, "connection error");
            } else {
                this.qConnection.start();
                this.qSession = this.qConnection.createQueueSession(true, 0);
            }
            logger.log(System.Logger.Level.TRACE, "started the connection !!");
            if (msg.getObjectProperty("properties") != null) {
                this.initLogging((Properties)msg.getObjectProperty("properties"));
            }
            if (msg.getStringProperty("MessageType").equals("TextMessage")) {
                this.sendATextMessage();
            } else if (msg.getStringProperty("MessageType").equals("BytesMessage")) {
                this.sendABytesMessage();
            } else if (msg.getStringProperty("MessageType").equals("MapMessage")) {
                this.sendAMapMessage();
            } else if (msg.getStringProperty("MessageType").equals("StreamMessage")) {
                this.sendAStreamMessage();
            } else if (msg.getStringProperty("MessageType").equals("ObjectMessage")) {
                this.sendAnObjectMessage();
            } else {
                logger.log(System.Logger.Level.TRACE, "@onMessage - invalid message type found in StringProperty");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception caught in onMessage!", (Throwable)e);
        }
        finally {
            if (this.qConnection != null) {
                try {
                    this.qConnection.close();
                }
                catch (Exception e) {
                    TestUtil.printStackTrace((Throwable)e);
                }
            }
        }
    }

    public void initLogging(Properties p) {
        try {
            TestUtil.init((Properties)p);
            logger.log(System.Logger.Level.TRACE, "MsgBean initLogging OK.");
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            logger.log(System.Logger.Level.INFO, "MsgBean initLogging failed.");
            throw new EJBException(e.getMessage());
        }
    }

    private void sendATextMessage() {
        logger.log(System.Logger.Level.TRACE, "@sendATextMessage");
        try {
            String myMsg = "I am sending a text message as requested";
            this.mSender = this.qSession.createSender(this.queue);
            TextMessage msg = this.qSession.createTextMessage();
            msg.setText(myMsg);
            msg.setStringProperty("MessageType", "TextMessageFromMsgBean");
            this.mSender.send((Message)msg);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception caught sending a TextMessage!", (Throwable)e);
        }
    }

    private void sendABytesMessage() {
        logger.log(System.Logger.Level.TRACE, "@sendABytesMessage");
        try {
            byte aByte = 10;
            this.mSender = this.qSession.createSender(this.queue);
            BytesMessage msg = this.qSession.createBytesMessage();
            JmsUtil.addPropsToMessage((Message)msg, (Properties)this.p);
            msg.writeByte(aByte);
            msg.setStringProperty("MessageType", "BytesMessageFromMsgBean");
            this.mSender.send((Message)msg);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception caught sending a BytesMessage!", (Throwable)e);
        }
    }

    private void sendAMapMessage() {
        logger.log(System.Logger.Level.TRACE, "@sendAMapMessage");
        try {
            String myMsg = "I am sending a map message as requested";
            this.mSender = this.qSession.createSender(this.queue);
            MapMessage msg = this.qSession.createMapMessage();
            JmsUtil.addPropsToMessage((Message)msg, (Properties)this.p);
            msg.setString("MapMessage", myMsg);
            msg.setStringProperty("MessageType", "MapMessageFromMsgBean");
            this.mSender.send((Message)msg);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception caught sending a MapMessage!", (Throwable)e);
        }
    }

    private void sendAStreamMessage() {
        logger.log(System.Logger.Level.TRACE, "@sendAStreamMessage");
        try {
            String myMsg = "I am sending a stream message as requested";
            this.mSender = this.qSession.createSender(this.queue);
            StreamMessage msg = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)msg, (Properties)this.p);
            msg.writeString(myMsg);
            msg.setStringProperty("MessageType", "StreamMessageFromMsgBean");
            this.mSender.send((Message)msg);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception caught sending a StreamMessage!", (Throwable)e);
        }
    }

    private void sendAnObjectMessage() {
        logger.log(System.Logger.Level.TRACE, "@sendAnObjectMessage");
        try {
            String myMsg = "I am sending a text message as requested";
            this.mSender = this.qSession.createSender(this.queue);
            ObjectMessage msg = this.qSession.createObjectMessage();
            JmsUtil.addPropsToMessage((Message)msg, (Properties)this.p);
            msg.setObject((Serializable)((Object)myMsg));
            msg.setStringProperty("MessageType", "ObjectMessageFromMsgBean");
            this.mSender.send((Message)msg);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception caught sending an ObjectMessage!", (Throwable)e);
        }
    }

    public void setMessageDrivenContext(MessageDrivenContext mdc) {
        logger.log(System.Logger.Level.TRACE, "In MsgBean::setMessageDrivenContext()!!");
        this.mdc = mdc;
    }

    public void ejbRemove() {
        logger.log(System.Logger.Level.TRACE, "In MsgBean::remove()!!");
    }
}

