/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.mdb_msgTypesT2;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsUtil;
import jakarta.ejb.EJBException;
import jakarta.ejb.MessageDrivenBean;
import jakarta.ejb.MessageDrivenContext;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageListener;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicConnectionFactory;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSession;
import java.io.Serializable;
import java.util.Properties;

public class MsgBeanMsgTestT2
implements MessageDrivenBean,
MessageListener {
    private Properties p = null;
    private TSNamingContext context = null;
    private MessageDrivenContext mdc = null;
    private static final System.Logger logger = System.getLogger(MsgBeanMsgTestT2.class.getName());
    private QueueConnectionFactory qFactory = null;
    private QueueConnection qConnection = null;
    private Queue queueR = null;
    private QueueSender mSender = null;
    private QueueSession qSession = null;
    private TopicConnectionFactory tFactory = null;
    private TopicConnection tConnection = null;
    private Topic topic = null;
    private TopicPublisher tPublisher = null;
    private TopicSession tSession = null;

    public MsgBeanMsgTestT2() {
        logger.log(System.Logger.Level.TRACE, "@MsgBeanMsgTest2()!");
    }

    public void ejbCreate() {
        logger.log(System.Logger.Level.TRACE, "jms.ee.mdb.mdb_msgTypesT2  - @MsgBeanMsgTest2-ejbCreate() !!");
        try {
            this.context = new TSNamingContext();
            this.qFactory = (QueueConnectionFactory)this.context.lookup("java:comp/env/jms/MyQueueConnectionFactory");
            if (this.qFactory == null) {
                logger.log(System.Logger.Level.TRACE, "qFactory error");
            }
            logger.log(System.Logger.Level.TRACE, "got a qFactory !!");
            this.queueR = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE_REPLY");
            if (this.queueR == null) {
                logger.log(System.Logger.Level.TRACE, "queueR error");
            }
            this.tFactory = (TopicConnectionFactory)this.context.lookup("java:comp/env/jms/MyTopicConnectionFactory");
            if (this.tFactory == null) {
                logger.log(System.Logger.Level.TRACE, "tFactory error");
            }
            logger.log(System.Logger.Level.TRACE, "got a tFactory !!");
            this.topic = (Topic)this.context.lookup("java:comp/env/jms/MDB_TOPIC");
            if (this.topic == null) {
                logger.log(System.Logger.Level.TRACE, "topic error");
            }
            this.p = new Properties();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("MDB ejbCreate Error!", e);
        }
    }

    public void onMessage(Message msg) {
        JmsUtil.initHarnessProps((Message)msg, (Properties)this.p);
        logger.log(System.Logger.Level.TRACE, "from jms.ee.mdb.mdb_msgTypesT2 @onMessage!" + msg);
        try {
            logger.log(System.Logger.Level.TRACE, "TestCase:" + msg.getStringProperty("TestCase"));
            logger.log(System.Logger.Level.TRACE, "onMessage will run TestCase: " + msg.getStringProperty("TestCase"));
            this.qConnection = this.qFactory.createQueueConnection();
            if (this.qConnection == null) {
                logger.log(System.Logger.Level.TRACE, "connection error");
            } else {
                this.qConnection.start();
                this.qSession = this.qConnection.createQueueSession(true, 0);
            }
            this.tConnection = this.tFactory.createTopicConnection();
            if (this.tConnection == null) {
                logger.log(System.Logger.Level.TRACE, "connection error");
            } else {
                this.tConnection.start();
                this.tSession = this.tConnection.createTopicSession(true, 0);
            }
            if (msg.getStringProperty("TestCase").equals("messageObjectCopyTopicTestCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running messageObjectCopyTopicTestCreate - create the message");
                this.messageObjectCopyTopicTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("messageObjectCopyTopicTest")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running messageObjectCopyTopicTest - read and verify the message");
                this.messageObjectCopyTopicTest((ObjectMessage)msg);
            }
            if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsBooleanCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running streamMessageConversionTopicTestsBooleanCreate - create the message");
                this.streamMessageConversionTopicTestsBooleanCreate();
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsBoolean")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running streamMessageConversionTopicTestsBoolean - read and verify the message");
                this.streamMessageConversionTopicTestsBoolean((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsByteCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running streamMessageConversionTopicTestsByteCreate - create the message");
                this.streamMessageConversionTopicTestsByteCreate();
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsByte")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running streamMessageConversionTopicTestsByte - read and verify the message");
                this.streamMessageConversionTopicTestsByte((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsShortCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running streamMessageConversionTopicTestsShortCreate - create the message");
                this.streamMessageConversionTopicTestsShortCreate();
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsShort")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running streamMessageConversionTopicTestsShort - read and verify the message");
                this.streamMessageConversionTopicTestsShort((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsIntCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running streamMessageConversionTopicTestsIntCreate - create the message");
                this.streamMessageConversionTopicTestsIntCreate();
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsInt")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running streamMessageConversionTopicTestsInt - read and verify the message");
                this.streamMessageConversionTopicTestsInt((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsLongCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running streamMessageConversionTopicTestsLongCreate - create the message");
                this.streamMessageConversionTopicTestsLongCreate();
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsLong")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running streamMessageConversionTopicTestsLong - read and verify the message");
                this.streamMessageConversionTopicTestsLong((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsFloatCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running streamMessageConversionTopicTestsFloatCreate - create the message");
                this.streamMessageConversionTopicTestsFloatCreate();
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsFloat")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running streamMessageConversionTopicTestsFloat - read and verify the message");
                this.streamMessageConversionTopicTestsFloat((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsDoubleCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running streamMessageConversionTopicTestsDoubleCreate - create the message");
                this.streamMessageConversionTopicTestsDoubleCreate();
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsDouble")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running streamMessageConversionTopicTestsDouble - read and verify the message");
                this.streamMessageConversionTopicTestsDouble((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsStringCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running streamMessageConversionTopicTestsStringCreate - create the message");
                this.streamMessageConversionTopicTestsStringCreate();
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsString")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running streamMessageConversionTopicTestsString - read and verify the message");
                this.streamMessageConversionTopicTestsString((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsCharCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running streamMessageConversionTopicTestsCharCreate - create the message");
                this.streamMessageConversionTopicTestsCharCreate();
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsChar")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running streamMessageConversionTopicTestsChar - read and verify the message");
                this.streamMessageConversionTopicTestsChar((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsBytesCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running streamMessageConversionTopicTestsBytesCreate - create the message");
                this.streamMessageConversionTopicTestsBytesCreate();
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsBytes")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running streamMessageConversionTopicTestsBytes - read and verify the message");
                this.streamMessageConversionTopicTestsBytes((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsInvFormatStringCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running streamMessageConversionTopicTestsInvFormatStringCreate - create the message");
                this.streamMessageConversionTopicTestsInvFormatStringCreate();
            } else if (msg.getStringProperty("TestCase").equals("streamMessageConversionTopicTestsInvFormatString")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running streamMessageConversionTopicTestsInvFormatString - read and verify the message");
                this.streamMessageConversionTopicTestsInvFormatString((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("streamMessageTopicTestsFullMsgCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running streamMessageTopicTestsFullMsgCreate - create the message");
                this.streamMessageTopicTestsFullMsgCreate();
            } else if (msg.getStringProperty("TestCase").equals("streamMessageTopicTestsFullMsg")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running streamMessageTopicTestsFullMsg - read and verify the message");
                this.streamMessageTopicTestsFullMsg((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("streamMessageTopicTestNullCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running streamMessageTopicTestNullCreate - create the message");
                this.streamMessageTopicTestNullCreate();
            } else if (msg.getStringProperty("TestCase").equals("streamMessageTopicTestNull")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running streamMessageTopicTestNull - read and verify the message");
                this.streamMessageTopicTestNull((StreamMessage)msg);
            } else {
                logger.log(System.Logger.Level.TRACE, "@onMessage - invalid message type found in StringProperty");
            }
            logger.log(System.Logger.Level.TRACE, "@onMessage - Finished for this test!");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.qConnection != null) {
                try {
                    this.qConnection.close();
                }
                catch (Exception e) {
                    TestUtil.printStackTrace((Throwable)e);
                }
            }
            if (this.tConnection != null) {
                try {
                    this.tConnection.close();
                }
                catch (Exception e) {
                    TestUtil.printStackTrace((Throwable)e);
                }
            }
        }
    }

    public void messageObjectCopyTopicTestCreate() {
        boolean pass = true;
        try {
            ObjectMessage messageSentObjectMsg = null;
            StringBuffer sBuff = new StringBuffer("This is");
            String initial = "This is";
            messageSentObjectMsg = this.qSession.createObjectMessage();
            JmsUtil.addPropsToMessage((Message)messageSentObjectMsg, (Properties)this.p);
            messageSentObjectMsg.setObject((Serializable)sBuff);
            sBuff.append("a test ");
            messageSentObjectMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "messageObjectCopyTopicTest");
            messageSentObjectMsg.setStringProperty("TestCase", "messageObjectCopyTopicTest");
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)messageSentObjectMsg);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsBooleanCreate() {
        try {
            StreamMessage messageSent = null;
            boolean abool = true;
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionTopicTestsBoolean");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for boolean primitive type section 3.11.3");
            messageSent.setStringProperty("TestCase", "streamMessageConversionTopicTestsBoolean");
            messageSent.writeBoolean(abool);
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsByteCreate() {
        try {
            StreamMessage messageSent = null;
            byte bValue = 127;
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionTopicTestsByte");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setStringProperty("TestCase", "streamMessageConversionTopicTestsByte");
            messageSent.writeByte(bValue);
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsShortCreate() {
        try {
            StreamMessage messageSent = null;
            short sValue = 1;
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionTopicTestsShort");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setStringProperty("TestCase", "streamMessageConversionTopicTestsShort");
            messageSent.writeShort(sValue);
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsIntCreate() {
        try {
            StreamMessage messageSent = null;
            int iValue = 6;
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionTopicTestsInt");
            messageSent.setStringProperty("TestCase", "streamMessageConversionTopicTestsInt");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for byte primitive type section 3.11.3");
            messageSent.writeInt(iValue);
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsLongCreate() {
        try {
            StreamMessage messageSent = null;
            long lValue = 2L;
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionTopicTestsLong");
            messageSent.setStringProperty("TestCase", "streamMessageConversionTopicTestsLong");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for byte primitive type section 3.11.3");
            messageSent.writeLong(lValue);
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsFloatCreate() {
        try {
            StreamMessage messageSent = null;
            float fValue = 5.0f;
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionTopicTestsFloat");
            messageSent.setStringProperty("TestCase", "streamMessageConversionTopicTestsFloat");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for byte primitive type section 3.11.3");
            messageSent.writeFloat(fValue);
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsDoubleCreate() {
        try {
            StreamMessage messageSent = null;
            double dValue = 3.0;
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionTopicTestsDouble");
            messageSent.setStringProperty("TestCase", "streamMessageConversionTopicTestsDouble");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for byte primitive type section 3.11.3");
            messageSent.writeDouble(dValue);
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsStringCreate() {
        try {
            StreamMessage messageSent = null;
            String myString = "10";
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionTopicTestsString");
            messageSent.setStringProperty("TestCase", "streamMessageConversionTopicTestsString");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for byte primitive type section 3.11.3");
            messageSent.writeString(myString);
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsCharCreate() {
        try {
            StreamMessage messageSent = null;
            char charValue = 'a';
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionTopicTestsChar");
            messageSent.setStringProperty("TestCase", "streamMessageConversionTopicTestsChar");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for byte primitive type section 3.11.3");
            messageSent.writeChar(charValue);
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsBytesCreate() {
        try {
            StreamMessage messageSent = null;
            byte[] bValues = new byte[]{1, 2, 3};
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionTopicTestsBytes");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for byte[] primitive type section 3.11.3");
            messageSent.setStringProperty("TestCase", "streamMessageConversionTopicTestsBytes");
            messageSent.writeBytes(bValues);
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsInvFormatStringCreate() {
        try {
            StreamMessage messageSent = null;
            String myString = "mytest string";
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionTopicTestsInvFormatString");
            logger.log(System.Logger.Level.TRACE, "Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setStringProperty("TestCase", "streamMessageConversionTopicTestsInvFormatString");
            messageSent.writeString(myString);
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageTopicTestsFullMsgCreate() {
        try {
            StreamMessage messageSent = null;
            byte bValue = 127;
            boolean abool = false;
            byte[] bValues = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
            byte[] bValues2 = new byte[]{11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
            char charValue = 'Z';
            short sValue = Short.MAX_VALUE;
            long lValue = Long.MAX_VALUE;
            double dValue = 6.02E23;
            float fValue = 6.02E23f;
            int iValue = 6;
            boolean pass = true;
            String myString = "text";
            String sTesting = "Testing StreamMessages";
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageTopicTestsFullMsg");
            messageSent.writeBytes(bValues2, 0, bValues.length);
            messageSent.writeBoolean(abool);
            messageSent.writeByte(bValue);
            messageSent.writeBytes(bValues);
            messageSent.writeChar(charValue);
            messageSent.writeDouble(dValue);
            messageSent.writeFloat(fValue);
            messageSent.writeInt(iValue);
            messageSent.writeLong(lValue);
            messageSent.writeObject((Object)sTesting);
            messageSent.writeShort(sValue);
            messageSent.writeString(myString);
            messageSent.writeObject(null);
            messageSent.setStringProperty("TestCase", "streamMessageTopicTestsFullMsg");
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageTopicTestNullCreate() {
        try {
            StreamMessage messageSent = null;
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageTopicTestNull");
            logger.log(System.Logger.Level.TRACE, "writeString(null) ");
            messageSent.setStringProperty("TestCase", "streamMessageTopicTestNull");
            messageSent.writeString(null);
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void messageObjectCopyTopicTest(ObjectMessage messageReceivedObjectMsg) {
        boolean pass = true;
        String testCase = "messageObjectCopyTopicTest";
        String initial = "This is";
        try {
            logger.log(System.Logger.Level.INFO, "Ensure that changing the object did not change the message");
            StringBuffer s = (StringBuffer)messageReceivedObjectMsg.getObject();
            logger.log(System.Logger.Level.TRACE, "s is " + s);
            if (s.toString().equals(initial)) {
                logger.log(System.Logger.Level.TRACE, "Pass: msg was not changed");
            } else {
                logger.log(System.Logger.Level.TRACE, "Fail: msg was changed!");
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsBoolean(StreamMessage messageReceived) {
        String testCase = "streamMessageConversionTopicTestsBoolean";
        try {
            int bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            boolean pass = true;
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readBoolean to read a boolean");
            try {
                if (messageReceived.readBoolean() == abool) {
                    logger.log(System.Logger.Level.TRACE, "Pass: boolean to boolean - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readString to read a boolean");
            try {
                messageReceived.reset();
                if (messageReceived.readString().equals(Boolean.valueOf(abool).toString())) {
                    logger.log(System.Logger.Level.TRACE, "Pass: boolean to string - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readBytes[] to read a boolean - expect MessageFormatException");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "Count returned from readBytes is : " + nCount);
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readByte to read a boolean - expect MessageFormatException");
            try {
                messageReceived.reset();
                bValue = messageReceived.readByte();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readShort to read a boolean - expect MessageFormatException");
            try {
                messageReceived.reset();
                messageReceived.readShort();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readChar to read a boolean - expect MessageFormatException");
            try {
                messageReceived.reset();
                messageReceived.readChar();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readInt to read a boolean - expect MessageFormatException");
            try {
                messageReceived.reset();
                messageReceived.readInt();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readLong to read a boolean - expect MessageFormatException");
            try {
                messageReceived.reset();
                messageReceived.readLong();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readFloat to read a boolean - expect MessageFormatException");
            try {
                messageReceived.reset();
                messageReceived.readFloat();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readDouble to read a boolean - expect MessageFormatException");
            try {
                messageReceived.reset();
                messageReceived.readDouble();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsByte(StreamMessage messageReceived) {
        String testCase = "streamMessageConversionTopicTestsByte";
        try {
            byte bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            int charValue = 97;
            boolean sValue = true;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readByte to read a boolean - this is not valid");
            try {
                messageReceived.reset();
                boolean b = messageReceived.readBoolean();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readString to read a byte");
            try {
                messageReceived.reset();
                if (messageReceived.readString().equals(Byte.toString(bValue))) {
                    logger.log(System.Logger.Level.TRACE, "Pass: byte to string - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readBytes[] to read a byte - expect MessageFormatException");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "Count returned from readBytes is : " + nCount);
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readByte to read a byte");
            try {
                messageReceived.reset();
                if (messageReceived.readByte() == bValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: byte to byte - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readShort to read a byte");
            try {
                messageReceived.reset();
                if (messageReceived.readShort() == bValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: byte to short - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readChar to read a boolean - this is not valid");
            try {
                messageReceived.reset();
                char c = messageReceived.readChar();
                pass = false;
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readInt to read a byte");
            try {
                messageReceived.reset();
                if (messageReceived.readInt() == bValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: byte to int - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readLong to read a byte");
            try {
                messageReceived.reset();
                if (messageReceived.readLong() == (long)bValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: byte to long - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readFloat to read a boolean - this is not valid");
            try {
                messageReceived.reset();
                float f = messageReceived.readFloat();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readDouble to read a boolean - this is not valid");
            try {
                messageReceived.reset();
                double d = messageReceived.readDouble();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsShort(StreamMessage messageReceived) {
        String testCase = "streamMessageConversionTopicTestsShort";
        try {
            int bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            int charValue = 97;
            short sValue = 1;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readBoolean to read a short - this is not valid");
            try {
                messageReceived.reset();
                boolean b = messageReceived.readBoolean();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readString to read a short");
            try {
                messageReceived.reset();
                if (messageReceived.readString().equals(Short.toString(sValue))) {
                    logger.log(System.Logger.Level.TRACE, "Pass: short to string - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readBytes[] to read a short - expect MessageFormatException");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "Count returned from readBytes is : " + nCount);
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readByte to read a short - this is not valid");
            try {
                messageReceived.reset();
                byte b = messageReceived.readByte();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readShort to read a short");
            try {
                messageReceived.reset();
                if (messageReceived.readShort() == sValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: short to short - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readChar to read a short - this is not valid");
            try {
                messageReceived.reset();
                char c = messageReceived.readChar();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readInt to read a byte");
            try {
                messageReceived.reset();
                if (messageReceived.readInt() == sValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: short to int - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readLong to read a short");
            try {
                messageReceived.reset();
                if (messageReceived.readLong() == (long)sValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: short to long - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readFloat to read a short - this is not valid");
            try {
                messageReceived.reset();
                float f = messageReceived.readFloat();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readDouble to read a short - this is not valid");
            try {
                messageReceived.reset();
                double d = messageReceived.readDouble();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsInt(StreamMessage messageReceived) {
        String testCase = "streamMessageConversionTopicTestsInt";
        try {
            int bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            int charValue = 97;
            boolean sValue = true;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readBoolean to read an int - this is not valid");
            try {
                messageReceived.reset();
                boolean b = messageReceived.readBoolean();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readString to read an int");
            try {
                messageReceived.reset();
                if (messageReceived.readString().equals(Integer.toString(iValue))) {
                    logger.log(System.Logger.Level.TRACE, "Pass: int to string - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readBytes[] to read an int - expect MessageFormatException");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "Count returned from readBytes is : " + nCount);
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readByte to read an int - this is not valid");
            try {
                messageReceived.reset();
                byte b = messageReceived.readByte();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readShort to read an int");
            try {
                messageReceived.reset();
                short s = messageReceived.readShort();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readChar to read an int - this is not valid");
            try {
                messageReceived.reset();
                char c = messageReceived.readChar();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readInt to read an int");
            try {
                messageReceived.reset();
                if (messageReceived.readInt() == iValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: int to int - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readLong to read an int");
            try {
                messageReceived.reset();
                if (messageReceived.readLong() == (long)iValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: int to long - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readFloat to read an int - this is not valid");
            try {
                messageReceived.reset();
                float f = messageReceived.readFloat();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readDouble to read an int - this is not valid");
            try {
                messageReceived.reset();
                double d = messageReceived.readDouble();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsLong(StreamMessage messageReceived) {
        String testCase = "streamMessageConversionTopicTestsLong";
        try {
            int bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            int charValue = 97;
            boolean sValue = true;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readBoolean to read a long - this is not valid");
            try {
                messageReceived.reset();
                boolean b = messageReceived.readBoolean();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readString to read a long");
            try {
                messageReceived.reset();
                if (messageReceived.readString().equals(Long.toString(lValue))) {
                    logger.log(System.Logger.Level.TRACE, "Pass: long to string - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readBytes[] to read  a long - expect MessageFormatException");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "Count returned from readBytes is : " + nCount);
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readByte to read an long - this is not valid");
            try {
                messageReceived.reset();
                byte b = messageReceived.readByte();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readShort to read a long");
            try {
                messageReceived.reset();
                short s = messageReceived.readShort();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readChar to read a long - this is not valid");
            try {
                messageReceived.reset();
                char c = messageReceived.readChar();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readInt to read a long");
            try {
                messageReceived.reset();
                int i = messageReceived.readInt();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readLong to read a long");
            try {
                messageReceived.reset();
                if (messageReceived.readLong() == lValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: int to long - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readFloat to read a long - this is not valid");
            try {
                messageReceived.reset();
                float f = messageReceived.readFloat();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readDouble to read an long - this is not valid");
            try {
                messageReceived.reset();
                double d = messageReceived.readDouble();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsFloat(StreamMessage messageReceived) {
        String testCase = "streamMessageConversionTopicTestsFloat";
        try {
            int bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            int charValue = 97;
            boolean sValue = true;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readBoolean to read a float  ");
            try {
                messageReceived.reset();
                boolean b = messageReceived.readBoolean();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readString to read a float");
            try {
                messageReceived.reset();
                if (messageReceived.readString().equals(Float.toString(fValue))) {
                    logger.log(System.Logger.Level.TRACE, "Pass: float to string - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readBytes[] to read  a float ");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "Count returned from readBytes is : " + nCount);
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readByte to read a float  ");
            try {
                messageReceived.reset();
                byte b = messageReceived.readByte();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readShort to read a float");
            try {
                messageReceived.reset();
                short s = messageReceived.readShort();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readChar to read a long  ");
            try {
                messageReceived.reset();
                char c = messageReceived.readChar();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readInt to read a float");
            try {
                messageReceived.reset();
                int i = messageReceived.readInt();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readLong to read a long");
            try {
                messageReceived.reset();
                long l = messageReceived.readLong();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readFloat to read a float  ");
            try {
                messageReceived.reset();
                if (messageReceived.readFloat() == fValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: float to float - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readDouble to read an float  ");
            try {
                messageReceived.reset();
                if (messageReceived.readDouble() == (double)fValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: float to double - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsDouble(StreamMessage messageReceived) {
        String testCase = "streamMessageConversionTopicTestsDouble";
        try {
            int bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            int charValue = 97;
            boolean sValue = true;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readBoolean to read a double  ");
            try {
                messageReceived.reset();
                boolean b = messageReceived.readBoolean();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readString to read a double");
            try {
                messageReceived.reset();
                if (messageReceived.readString().equals(Double.toString(dValue))) {
                    logger.log(System.Logger.Level.TRACE, "Pass: double to string");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readBytes[] to read  a double ");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "Count returned from readBytes is : " + nCount);
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readByte to read a double  ");
            try {
                messageReceived.reset();
                byte b = messageReceived.readByte();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readShort to read a double");
            try {
                messageReceived.reset();
                short s = messageReceived.readShort();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readChar to read a double  ");
            try {
                messageReceived.reset();
                char c = messageReceived.readChar();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readInt to read a double");
            try {
                messageReceived.reset();
                int i = messageReceived.readInt();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readLong to read a double");
            try {
                messageReceived.reset();
                long l = messageReceived.readLong();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readFloat to read a double  ");
            try {
                messageReceived.reset();
                float f = messageReceived.readFloat();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readDouble to read a double  ");
            try {
                messageReceived.reset();
                if (messageReceived.readDouble() == dValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: double to double ");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsString(StreamMessage messageReceived) {
        String testCase = "streamMessageConversionTopicTestsString";
        try {
            int bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            int charValue = 97;
            boolean sValue = true;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            String myString = "10";
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readString to read a String");
            try {
                messageReceived.reset();
                if (messageReceived.readString().equals(myString)) {
                    logger.log(System.Logger.Level.TRACE, "Pass: string to string - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readBytes[] to read a String");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "Count returned from readBytes is : " + nCount);
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readByte to read a String");
            try {
                messageReceived.reset();
                if (messageReceived.readByte() == Byte.parseByte(myString)) {
                    logger.log(System.Logger.Level.TRACE, "Pass: String to byte ");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readShort to read a string");
            try {
                messageReceived.reset();
                if (messageReceived.readShort() == Short.parseShort(myString)) {
                    logger.log(System.Logger.Level.TRACE, "Pass: String to short ");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readChar to read a String ");
            try {
                messageReceived.reset();
                char c = messageReceived.readChar();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readInt to read a String");
            try {
                messageReceived.reset();
                if (messageReceived.readInt() == Integer.parseInt(myString)) {
                    logger.log(System.Logger.Level.TRACE, "Pass: String to int ");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readLong to read a String");
            try {
                messageReceived.reset();
                if (messageReceived.readLong() == Long.parseLong(myString)) {
                    logger.log(System.Logger.Level.TRACE, "Pass: String to long ");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readFloat to read a String");
            try {
                messageReceived.reset();
                if (messageReceived.readFloat() == Float.parseFloat(myString)) {
                    logger.log(System.Logger.Level.TRACE, "Pass: String to float ");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readDouble to read a String");
            try {
                messageReceived.reset();
                if (messageReceived.readDouble() == Double.parseDouble(myString)) {
                    logger.log(System.Logger.Level.TRACE, "Pass: String to double ");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readBoolean to read a string ");
            try {
                messageReceived.clearBody();
                messageReceived.writeString("true");
                messageReceived.reset();
                if (messageReceived.readBoolean() == abool) {
                    logger.log(System.Logger.Level.TRACE, "Pass: String to boolean ");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readBoolean to read a string  that is !true ");
            try {
                messageReceived.reset();
                boolean b = messageReceived.readBoolean();
                if (!b) {
                    logger.log(System.Logger.Level.TRACE, "Fail: !true should return false");
                    pass = false;
                } else {
                    logger.log(System.Logger.Level.TRACE, "Pass: !true returned false");
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsChar(StreamMessage messageReceived) {
        String testCase = "streamMessageConversionTopicTestsChar";
        try {
            int bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            int charValue = 97;
            boolean sValue = true;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readBoolean to read a char - this is not valid");
            try {
                messageReceived.reset();
                boolean b = messageReceived.readBoolean();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readString to read a char");
            try {
                messageReceived.reset();
                String s = messageReceived.readString();
                logger.log(System.Logger.Level.TRACE, "char returned for \"a\" is : " + s);
                if (s.equals("a")) {
                    logger.log(System.Logger.Level.TRACE, "Pass: char to string - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readBytes[] to read a char - expect MessageFormatException");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "Count returned from readBytes is : " + nCount);
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readByte to read a char - this is not valid");
            try {
                messageReceived.reset();
                byte b = messageReceived.readByte();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readShort to read a char");
            try {
                messageReceived.reset();
                short s = messageReceived.readShort();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readChar to read a char ");
            try {
                messageReceived.reset();
                if (messageReceived.readChar() == 'a') {
                    logger.log(System.Logger.Level.TRACE, "Pass: char to char - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readInt to read a char ");
            try {
                messageReceived.reset();
                int i = messageReceived.readInt();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readLong to read a char");
            try {
                messageReceived.reset();
                long l = messageReceived.readLong();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readFloat to read a char - this is not valid");
            try {
                messageReceived.reset();
                float f = messageReceived.readFloat();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readDouble to read a char - this is not valid");
            try {
                messageReceived.reset();
                double d = messageReceived.readDouble();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsBytes(StreamMessage messageReceived) {
        String testCase = "streamMessageConversionTopicTestsBytes";
        try {
            int bValue = 127;
            boolean abool = true;
            byte[] bValues2 = new byte[]{0, 0, 0};
            boolean sValue = true;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readBytes[] to read a byte[] ");
            boolean nCount = false;
            try {
                messageReceived.reset();
                if (messageReceived.readBytes(bValues2) == 3) {
                    logger.log(System.Logger.Level.TRACE, "Pass: byte[] to byte[] - valid");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: count incorrect");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readBoolean to read a byte[]");
            messageReceived.reset();
            try {
                boolean b = messageReceived.readBoolean();
                logger.log(System.Logger.Level.TRACE, "Fail: byte[] to boolean conversion should have thrown MessageFormatException");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readString to read a byte[]");
            try {
                messageReceived.reset();
                String s = messageReceived.readString();
                logger.log(System.Logger.Level.TRACE, "Fail: byte[] to boolean conversion should have thrown MessageFormatException");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readByte to read a byte[] - expect MessageFormatException");
            try {
                messageReceived.reset();
                byte b = messageReceived.readByte();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readShort to read a byte[] - expect MessageFormatException");
            try {
                messageReceived.reset();
                short s = messageReceived.readShort();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readChar to read a byte[] - expect MessageFormatException");
            try {
                messageReceived.reset();
                char c = messageReceived.readChar();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readInt to read a byte[] - expect MessageFormatException");
            try {
                messageReceived.reset();
                int i = messageReceived.readInt();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readLong to read a byte[] - expect MessageFormatException");
            try {
                messageReceived.reset();
                long l = messageReceived.readLong();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readFloat to read a byte[] - expect MessageFormatException");
            try {
                messageReceived.reset();
                float f = messageReceived.readFloat();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readDouble to read a byte[] - expect MessageFormatException");
            try {
                messageReceived.reset();
                double d = messageReceived.readDouble();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageConversionTopicTestsInvFormatString(StreamMessage messageReceived) {
        String testCase = "streamMessageConversionTopicTestsInvFormatString";
        try {
            boolean pass = true;
            String myString = "mytest string";
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readByte to read a String that is not valid ");
            try {
                byte b = messageReceived.readByte();
                logger.log(System.Logger.Level.TRACE, "Fail: java.lang.NumberFormatException expected");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof NumberFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: NumberFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Verify that the data can be read as a string and pointer did not move");
            try {
                String s = messageReceived.readString();
                logger.log(System.Logger.Level.TRACE, "message read: " + s);
                if (s.equals(myString)) {
                    logger.log(System.Logger.Level.TRACE, "Pass: able to read the string");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: string not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readShort to read a string that is not valid ");
            try {
                messageReceived.reset();
                short s = messageReceived.readShort();
                logger.log(System.Logger.Level.TRACE, "Fail: NumberFormatException was expected");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof NumberFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: NumberFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readInt to read a String that is not valid ");
            try {
                messageReceived.reset();
                int i = messageReceived.readInt();
                logger.log(System.Logger.Level.TRACE, "Fail: NumberFormatException was expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof NumberFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: NumberFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readLong to read a String that is not valid ");
            try {
                messageReceived.reset();
                long l = messageReceived.readLong();
                logger.log(System.Logger.Level.TRACE, "Fail: NumberFormatException was expected");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof NumberFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: NumberFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readFloat to read a String that is not valid ");
            try {
                messageReceived.reset();
                float f = messageReceived.readFloat();
                logger.log(System.Logger.Level.TRACE, "Fail: NumberFormatException was expected");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof NumberFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: NumberFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "--");
            logger.log(System.Logger.Level.TRACE, "Use readDouble to read a String that is not valid ");
            try {
                messageReceived.reset();
                double d = messageReceived.readDouble();
                logger.log(System.Logger.Level.TRACE, "Fail: NumberFormatException was expected");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof NumberFormatException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: NumberFormatException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageTopicTestsFullMsg(StreamMessage messageReceived) {
        String testCase = "streamMessageTopicTestsFullMsg";
        try {
            int i;
            byte bValue = 127;
            boolean abool = false;
            byte[] bValues2 = new byte[]{11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
            byte[] bValuesReturned = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            byte[] bValuesReturned2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            char charValue = 'Z';
            short sValue = Short.MAX_VALUE;
            long lValue = Long.MAX_VALUE;
            double dValue = 6.02E23;
            float fValue = 6.02E23f;
            int iValue = 6;
            boolean pass = true;
            String myString = "text";
            String sTesting = "Testing StreamMessages";
            try {
                int nCount = bValuesReturned2.length;
                do {
                    nCount = messageReceived.readBytes(bValuesReturned2);
                    logger.log(System.Logger.Level.TRACE, "nCount is " + nCount);
                    if (nCount == -1) continue;
                    for (i = 0; i < bValuesReturned2.length; ++i) {
                        if (bValuesReturned2[i] != bValues2[i]) {
                            logger.log(System.Logger.Level.TRACE, "Fail: byte[] " + i + " is not valid");
                            pass = false;
                            continue;
                        }
                        logger.log(System.Logger.Level.TRACE, "PASS: byte[]" + i + " is valid");
                    }
                } while (nCount >= bValuesReturned2.length);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readBoolean() == abool) {
                    logger.log(System.Logger.Level.TRACE, "Pass: boolean returned ok");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: boolean not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readByte() == bValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: Byte returned ok");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: Byte not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                int nCount = bValuesReturned.length;
                do {
                    nCount = messageReceived.readBytes(bValuesReturned);
                    logger.log(System.Logger.Level.TRACE, "nCount is " + nCount);
                    if (nCount == -1) continue;
                    for (i = 0; i < bValuesReturned2.length; ++i) {
                        if (bValuesReturned2[i] != bValues2[i]) {
                            logger.log(System.Logger.Level.TRACE, "Fail: byte[] " + i + " is not valid");
                            pass = false;
                            continue;
                        }
                        logger.log(System.Logger.Level.TRACE, "PASS: byte[]" + i + " is valid");
                    }
                } while (nCount >= bValuesReturned.length);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readChar() == charValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: correct char");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: char not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readDouble() == dValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: correct double");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: double not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readFloat() == fValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: correct float");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: float not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readInt() == iValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: correct int");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: int not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readLong() == lValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: correct long");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: long not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readObject().equals(sTesting)) {
                    logger.log(System.Logger.Level.TRACE, "Pass: correct object");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: object not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readShort() == sValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: correct short");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: short not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readString().equals(myString)) {
                    logger.log(System.Logger.Level.TRACE, "Pass: correct string");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: string not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readObject() == null) {
                    logger.log(System.Logger.Level.TRACE, "Pass: correct object");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: object not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void streamMessageTopicTestNull(StreamMessage messageReceived) {
        String testCase = "streamMessageTopicTestNull";
        try {
            boolean pass = true;
            try {
                if (messageReceived.readObject() == null) {
                    logger.log(System.Logger.Level.TRACE, "Pass: Read a null");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: null value not returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error trying to read a null object");
                logger.log(System.Logger.Level.TRACE, "Error: unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void sendTestResults(String testCase, boolean results) {
        TextMessage msg = null;
        try {
            this.mSender = this.qSession.createSender(this.queueR);
            msg = this.qSession.createTextMessage();
            msg.setStringProperty("TestCase", testCase);
            msg.setText(testCase);
            if (results) {
                msg.setStringProperty("Status", "Pass");
            } else {
                msg.setStringProperty("Status", "Fail");
            }
            logger.log(System.Logger.Level.TRACE, "Sending response message");
            this.mSender.send((Message)msg);
        }
        catch (JMSException je) {
            TestUtil.printStackTrace((Throwable)je);
            logger.log(System.Logger.Level.TRACE, "Error: " + ((Object)((Object)je)).getClass().getName() + " was thrown");
        }
        catch (Exception ee) {
            TestUtil.printStackTrace((Throwable)ee);
            logger.log(System.Logger.Level.TRACE, "Error: " + ee.getClass().getName() + " was thrown");
        }
    }

    public void setMessageDrivenContext(MessageDrivenContext mdc) {
        logger.log(System.Logger.Level.TRACE, "jms.ee.mdb.mdb_msgTypesT2  In MsgBeanMsgTest2::setMessageDrivenContext()!!");
        this.mdc = mdc;
    }

    public void ejbRemove() {
        logger.log(System.Logger.Level.TRACE, "jms.ee.mdb.mdb_msgTypesT2  In MsgBeanMsgTest2::remove()!!");
    }
}

