/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.mdb_msgPropsQ;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsUtil;
import jakarta.ejb.EJBException;
import jakarta.ejb.MessageDrivenBean;
import jakarta.ejb.MessageDrivenContext;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageNotWriteableException;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.TextMessage;
import java.util.Enumeration;
import java.util.Properties;

public class MsgBeanMsgTestPropsQ
implements MessageDrivenBean,
MessageListener {
    private Properties p = null;
    private TSNamingContext context = null;
    private MessageDrivenContext mdc = null;
    private QueueConnectionFactory qFactory = null;
    private QueueConnection qConnection = null;
    private Queue queueR = null;
    private Queue queue = null;
    private QueueSender mSender = null;
    private QueueSession qSession = null;
    private TextMessage messageSent = null;
    private static final System.Logger logger = System.getLogger(MsgBeanMsgTestPropsQ.class.getName());

    public MsgBeanMsgTestPropsQ() {
        System.out.println("@MsgBeanMsgTestPropsQ()!");
    }

    public void ejbCreate() {
        System.out.println("jms.ee.mdb.mdb_msgPropsQ  - @MsgBeanMsgTestPropsQ-ejbCreate() !!");
        try {
            this.context = new TSNamingContext();
            this.qFactory = (QueueConnectionFactory)this.context.lookup("java:comp/env/jms/MyQueueConnectionFactory");
            if (this.qFactory == null) {
                System.out.println("qFactory error");
            }
            System.out.println("got a qFactory !!");
            this.queueR = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE_REPLY");
            if (this.queueR == null) {
                System.out.println("queueR error");
            }
            this.queue = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("MDB ejbCreate Error!", e);
        }
        this.p = new Properties();
    }

    public void onMessage(Message msg) {
        System.out.println("from jms.ee.mdb.mdb_msgPropsQ @onMessage!" + msg);
        try {
            JmsUtil.initHarnessProps((Message)msg, (Properties)this.p);
            System.out.println("onMessage will run TestCase: " + msg.getStringProperty("TestCase"));
            this.qConnection = this.qFactory.createQueueConnection();
            if (this.qConnection == null) {
                System.out.println("connection error");
            } else {
                this.qConnection.start();
                this.qSession = this.qConnection.createQueueSession(true, 0);
            }
            this.messageSent = this.qSession.createTextMessage();
            JmsUtil.addPropsToMessage((Message)this.messageSent, (Properties)this.p);
            if (msg.getStringProperty("TestCase").equals("msgPropertiesQTestCreate")) {
                System.out.println("@onMessage - running msgPropertiesQTestCreate - create the message");
                this.msgPropertiesQTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgPropertiesQTest")) {
                System.out.println("@onMessage - msgPropertiesQTest!");
                this.msgPropertiesQTest(msg);
            } else if (msg.getStringProperty("TestCase").equals("msgPropertiesConversionQTestCreate")) {
                System.out.println("@onMessage - msgPropertiesConversionQTestCreate!");
                this.msgPropertiesConversionQTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgPropertiesConversionQTest")) {
                System.out.println("@onMessage - msgPropertiesConversionQTest!");
                this.msgPropertiesConversionQTest(msg);
            } else {
                System.out.println("@onMessage - invalid message type found in StringProperty");
                System.out.println("Do not have a method for this testcase: " + msg.getStringProperty("TestCase"));
            }
            System.out.println("@onMessage - Finished for this test!");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.qConnection != null) {
                try {
                    this.qConnection.close();
                }
                catch (Exception e) {
                    TestUtil.printStackTrace((Throwable)e);
                }
            }
        }
    }

    private void msgPropertiesQTestCreate() {
        boolean pass = true;
        boolean bool = true;
        byte bValue = 127;
        short nShort = 10;
        int nInt = 5;
        long nLong = 333L;
        float nFloat = 1.0f;
        double nDouble = 100.0;
        String testString = "test";
        Object propertyNames = null;
        Object jmsxDefined = null;
        boolean NUMPROPS = false;
        String testMessageBody = "Testing...";
        JmsUtil.addPropsToMessage((Message)this.messageSent, (Properties)this.p);
        try {
            this.messageSent.setText(testMessageBody);
            this.messageSent.setBooleanProperty("TESTBOOLEAN", bool);
            this.messageSent.setByteProperty("TESTBYTE", bValue);
            this.messageSent.setShortProperty("TESTSHORT", nShort);
            this.messageSent.setIntProperty("TESTINT", nInt);
            this.messageSent.setFloatProperty("TESTFLOAT", nFloat);
            this.messageSent.setDoubleProperty("TESTDOUBLE", nDouble);
            this.messageSent.setStringProperty("TESTSTRING", "test");
            this.messageSent.setLongProperty("TESTLONG", nLong);
            this.messageSent.setObjectProperty("OBJTESTBOOLEAN", (Object)bool);
            this.messageSent.setObjectProperty("OBJTESTBYTE", (Object)bValue);
            this.messageSent.setObjectProperty("OBJTESTSHORT", (Object)nShort);
            this.messageSent.setObjectProperty("OBJTESTINT", (Object)nInt);
            this.messageSent.setObjectProperty("OBJTESTFLOAT", (Object)new Float(nFloat));
            this.messageSent.setObjectProperty("OBJTESTDOUBLE", (Object)new Double(nDouble));
            this.messageSent.setObjectProperty("OBJTESTSTRING", (Object)"test");
            this.messageSent.setObjectProperty("OBJTESTLONG", (Object)new Long(nLong));
            this.messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgPropertiesQTest");
            this.messageSent.setStringProperty("TestCase", "msgPropertiesQTest");
            Enumeration e = this.messageSent.getPropertyNames();
            String key = null;
            int i = 0;
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                logger.log(System.Logger.Level.TRACE, "+++++++   Property Name is: " + key);
                if (key.indexOf("JMS") == 0) continue;
                ++i;
            }
            this.messageSent.setIntProperty("NUMPROPS", ++i);
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)this.messageSent);
            try {
                this.messageSent.setObjectProperty("OBJTESTLONG", new Object());
                logger.log(System.Logger.Level.INFO, "Error: expected MessageFormatException from invalid ");
                logger.log(System.Logger.Level.INFO, "call to setObjectProperty did not occur!");
                pass = false;
            }
            catch (MessageFormatException fe) {
                logger.log(System.Logger.Level.TRACE, "Pass: ");
                logger.log(System.Logger.Level.TRACE, "      MessageFormatException as expected from invalid setObjectProperty call");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "from call to setObjectProperty!");
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void msgPropertiesQTest(Message msg) {
        block78: {
            boolean pass = true;
            boolean bool = true;
            byte bValue = 127;
            short nShort = 10;
            int nInt = 5;
            long nLong = 333L;
            float nFloat = 1.0f;
            double nDouble = 100.0;
            String testString = "test";
            Enumeration propertyNames = null;
            Object jmsxDefined = null;
            String testCase = "msgPropertiesQTest";
            String testMessageBody = "Testing...";
            TextMessage messageReceived = (TextMessage)msg;
            try {
                try {
                    messageReceived.setBooleanProperty("TESTBOOLEAN", bool);
                    logger.log(System.Logger.Level.INFO, "Error: exception should have occurred for setBooleanProperty");
                    pass = false;
                }
                catch (MessageNotWriteableException aBool) {
                    logger.log(System.Logger.Level.TRACE, "Pass: exception as expected for setBooleanProperty ");
                }
                try {
                    messageReceived.setByteProperty("TESTBYTE", bValue);
                    logger.log(System.Logger.Level.INFO, "Error: exception should have occurred for setByteProperty");
                    pass = false;
                }
                catch (MessageNotWriteableException aBool) {
                    logger.log(System.Logger.Level.TRACE, "Pass: exception as expected for setByteProperty ");
                }
                try {
                    messageReceived.setShortProperty("TESTSHORT", nShort);
                    pass = false;
                    logger.log(System.Logger.Level.INFO, "Error: exception should have occurred for setShortProperty");
                }
                catch (MessageNotWriteableException aBool) {
                    logger.log(System.Logger.Level.TRACE, "Pass: exception as expected for setShortProperty ");
                }
                try {
                    messageReceived.setIntProperty("TESTINT", nInt);
                    logger.log(System.Logger.Level.INFO, "Error: exception should have occurred for setIntProperty");
                    pass = false;
                }
                catch (MessageNotWriteableException aBool) {
                    logger.log(System.Logger.Level.TRACE, "Pass: exception as expected for setIntProperty ");
                }
                try {
                    messageReceived.setFloatProperty("TESTFLOAT", nFloat);
                    logger.log(System.Logger.Level.INFO, "Error: exception should have occurred for setFloatProperty");
                    pass = false;
                }
                catch (MessageNotWriteableException aBool) {
                    logger.log(System.Logger.Level.TRACE, "Pass: exception as expected for setFloatProperty ");
                }
                try {
                    messageReceived.setDoubleProperty("TESTDOUBLE", nDouble);
                    logger.log(System.Logger.Level.INFO, "Error: exception should have occurred for setDoubleProperty");
                    pass = false;
                }
                catch (MessageNotWriteableException aBool) {
                    logger.log(System.Logger.Level.TRACE, "Pass: exception as expected for setDoubleProperty ");
                }
                try {
                    messageReceived.setStringProperty("TESTSTRING", testString);
                    logger.log(System.Logger.Level.INFO, "Error: exception should have occurred for setStringProperty");
                    pass = false;
                }
                catch (MessageNotWriteableException aBool) {
                    logger.log(System.Logger.Level.TRACE, "Pass: exception as expected for setStringProperty ");
                }
                try {
                    messageReceived.setLongProperty("TESTLONG", nLong);
                    logger.log(System.Logger.Level.INFO, "Error: exception should have occurred for setLongProperty");
                    pass = false;
                }
                catch (MessageNotWriteableException aBool) {
                    logger.log(System.Logger.Level.TRACE, "Pass: exception as expected for setLongProperty ");
                }
                try {
                    messageReceived.setObjectProperty("OBJTESTBOOLEAN", (Object)bool);
                    logger.log(System.Logger.Level.INFO, "Error: exception should have occurred for setObjectProperty");
                    pass = false;
                }
                catch (MessageNotWriteableException aBool) {
                    logger.log(System.Logger.Level.TRACE, "Pass: exception as expected for setObjectProperty ");
                }
                int numPropertyNames = messageReceived.getIntProperty("NUMPROPS");
                int i = 0;
                propertyNames = messageReceived.getPropertyNames();
                do {
                    String tmp = (String)propertyNames.nextElement();
                    logger.log(System.Logger.Level.TRACE, "+++++++   Property Name is: " + tmp);
                    if (tmp.indexOf("JMS") == 0) continue;
                    ++i;
                } while (propertyNames.hasMoreElements());
                if (i == numPropertyNames) {
                    logger.log(System.Logger.Level.TRACE, "Pass: # of properties is " + numPropertyNames + " as expected");
                } else {
                    logger.log(System.Logger.Level.INFO, "Error: expected " + numPropertyNames + "property names");
                    logger.log(System.Logger.Level.INFO, "       But " + i + " returned");
                    pass = false;
                }
                if (messageReceived.getBooleanProperty("TESTBOOLEAN") == bool) {
                    logger.log(System.Logger.Level.TRACE, "Pass: getBooleanProperty returned correct value");
                } else {
                    logger.log(System.Logger.Level.INFO, "Error: incorrect value returned from getBooleanProperty");
                    pass = false;
                }
                if (messageReceived.getByteProperty("TESTBYTE") == bValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: getByteProperty returned correct value");
                } else {
                    logger.log(System.Logger.Level.INFO, "Error: incorrect value returned from getByteProperty");
                    pass = false;
                }
                if (messageReceived.getLongProperty("TESTLONG") == nLong) {
                    logger.log(System.Logger.Level.TRACE, "Pass: getLongProperty returned correct value");
                } else {
                    logger.log(System.Logger.Level.INFO, "Error: incorrect value returned from getLongProperty");
                    pass = false;
                }
                if (messageReceived.getStringProperty("TESTSTRING").equals(testString)) {
                    logger.log(System.Logger.Level.TRACE, "Pass: getStringProperty returned correct value");
                } else {
                    logger.log(System.Logger.Level.INFO, "Error: incorrect value returned from getStringProperty");
                    pass = false;
                }
                if (messageReceived.getDoubleProperty("TESTDOUBLE") == nDouble) {
                    logger.log(System.Logger.Level.TRACE, "Pass: getDoubleProperty returned correct value");
                } else {
                    logger.log(System.Logger.Level.INFO, "Error: incorrect value returned from getDoubleProperty");
                    pass = false;
                }
                if (messageReceived.getFloatProperty("TESTFLOAT") == nFloat) {
                    logger.log(System.Logger.Level.TRACE, "Pass: getFloatProperty returned correct value");
                } else {
                    logger.log(System.Logger.Level.INFO, "Error: incorrect value returned from getFloatProperty");
                    pass = false;
                }
                if (messageReceived.getIntProperty("TESTINT") == nInt) {
                    logger.log(System.Logger.Level.TRACE, "Pass: getIntProperty returned correct value");
                } else {
                    logger.log(System.Logger.Level.INFO, "Error: incorrect value returned from getIntProperty");
                    pass = false;
                }
                if (messageReceived.getShortProperty("TESTSHORT") == nShort) {
                    logger.log(System.Logger.Level.TRACE, "Pass: getShortProperty returned correct value");
                } else {
                    logger.log(System.Logger.Level.INFO, "Error: incorrect value returned from getShortProperty");
                    pass = false;
                }
                String value = messageReceived.getStringProperty("TESTDUMMY");
                if (value == null) {
                    logger.log(System.Logger.Level.TRACE, "Pass: getStringProperty returned correct value");
                } else {
                    logger.log(System.Logger.Level.INFO, "Error: expected a null return from getStringProperty for invalid property");
                    pass = false;
                }
                Boolean aBool = (Boolean)messageReceived.getObjectProperty("TESTDUMMY");
                if (aBool == null) {
                    logger.log(System.Logger.Level.TRACE, "Pass: getObjectProperty returned correct value for Boolean");
                } else {
                    logger.log(System.Logger.Level.INFO, "Error: expected a null return from getObjectProperty for invalid property");
                    pass = false;
                }
                Boolean boolValue = (Boolean)messageReceived.getObjectProperty("OBJTESTBOOLEAN");
                if (boolValue == bool) {
                    logger.log(System.Logger.Level.TRACE, "Pass: getObjectProperty returned correct value for Boolean");
                } else {
                    logger.log(System.Logger.Level.INFO, "Error: incorrect value returned for Boolean");
                    pass = false;
                }
                Byte byteValue = (Byte)messageReceived.getObjectProperty("OBJTESTBYTE");
                if (byteValue == bValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: getObjectProperty returned correct Byte value");
                } else {
                    logger.log(System.Logger.Level.INFO, "Error: incorrect value returned from Byte");
                    pass = false;
                }
                Long lValue = (Long)messageReceived.getObjectProperty("OBJTESTLONG");
                if (lValue == nLong) {
                    logger.log(System.Logger.Level.TRACE, "Pass: getObjectProperty returned correct value for Long");
                } else {
                    logger.log(System.Logger.Level.INFO, "Error: getObjectProperty returned incorrect value returned for Long");
                    pass = false;
                }
                if (messageReceived.getObjectProperty("OBJTESTSTRING").equals(testString)) {
                    logger.log(System.Logger.Level.TRACE, "Pass: getObjectProperty returned correct value for String");
                } else {
                    logger.log(System.Logger.Level.INFO, "Error: getObjectProperty returned incorrect value for String");
                    pass = false;
                }
                Double dValue = (Double)messageReceived.getObjectProperty("OBJTESTDOUBLE");
                if (dValue == nDouble) {
                    logger.log(System.Logger.Level.TRACE, "Pass: getObjectProperty returned correct value for Double");
                } else {
                    logger.log(System.Logger.Level.INFO, "Error: getObjectProperty returned incorrect value for Double");
                    pass = false;
                }
                Float fValue = (Float)messageReceived.getObjectProperty("OBJTESTFLOAT");
                if (fValue.floatValue() == nFloat) {
                    logger.log(System.Logger.Level.TRACE, "Pass: getObjectProperty returned correct value for Float");
                } else {
                    logger.log(System.Logger.Level.INFO, "Error: getObjectProperty returned incorrect value for Float");
                    pass = false;
                }
                Integer iValue = (Integer)messageReceived.getObjectProperty("OBJTESTINT");
                if (iValue == nInt) {
                    logger.log(System.Logger.Level.TRACE, "Pass: getObjectProperty returned correct value for Integer");
                } else {
                    logger.log(System.Logger.Level.INFO, "Error: getObjectProperty returned incorrect value for Integer");
                    pass = false;
                }
                Short sValue = (Short)messageReceived.getObjectProperty("OBJTESTSHORT");
                if (sValue == nShort) {
                    logger.log(System.Logger.Level.TRACE, "Pass: getObjectProperty returned correct value for Short");
                } else {
                    logger.log(System.Logger.Level.INFO, "Error: getObjectProperty returned incorrect value for Short");
                    pass = false;
                }
                messageReceived.clearProperties();
                Long aLong = (Long)messageReceived.getObjectProperty("OBJTESTLONG");
                if (aLong == null) {
                    logger.log(System.Logger.Level.TRACE, "Pass: property was cleared");
                } else {
                    logger.log(System.Logger.Level.INFO, "Error: getObjectProperty should have returned null for cleared property");
                    pass = false;
                }
                try {
                    short aShort = messageReceived.getShortProperty("TESTSHORT");
                    logger.log(System.Logger.Level.INFO, "Error: NullPointerException should have occurred for getShortProperty");
                    logger.log(System.Logger.Level.INFO, "Properties have been cleared!");
                    pass = false;
                }
                catch (NullPointerException np) {
                    TestUtil.printStackTrace((Throwable)np);
                    logger.log(System.Logger.Level.TRACE, "Pass: NullPointerException");
                }
                catch (NumberFormatException nf) {
                    logger.log(System.Logger.Level.TRACE, "Pass: NumberFormatException as expected ");
                }
                try {
                    String newEntry = "new entry";
                    logger.log(System.Logger.Level.TRACE, "Verify that you can set a property after clearProperty");
                    messageReceived.setStringProperty("TESTSTRING", "new entry");
                    if (messageReceived.getStringProperty("TESTSTRING").equals(newEntry)) {
                        logger.log(System.Logger.Level.TRACE, "Pass: able to set a cleared property");
                    } else {
                        logger.log(System.Logger.Level.TRACE, "Error: was not able to new property setting after clearProperty");
                        pass = false;
                    }
                }
                catch (Exception ex) {
                    logger.log(System.Logger.Level.TRACE, "Unexpected Exception caught while testing set after clearProperty");
                    pass = false;
                    TestUtil.printStackTrace((Throwable)ex);
                }
                logger.log(System.Logger.Level.INFO, "Message body is : " + messageReceived.getText());
                if (messageReceived.getText().equals(testMessageBody)) {
                    logger.log(System.Logger.Level.TRACE, "Pass: able to read message body after clearProperties");
                } else {
                    logger.log(System.Logger.Level.INFO, "Error: unable to read message body after clearProperties");
                    pass = false;
                }
                try {
                    ConnectionMetaData data = this.qConnection.getMetaData();
                    Enumeration cmd = data.getJMSXPropertyNames();
                    if (cmd == null) {
                        logger.log(System.Logger.Level.INFO, "Error: no JMSX property names were returned!");
                        logger.log(System.Logger.Level.INFO, "expected JMSXGroupID and JMSXGroupSeq at a miniumum");
                        pass = false;
                        break block78;
                    }
                    int iCount = 0;
                    do {
                        String propName = (String)cmd.nextElement();
                        logger.log(System.Logger.Level.TRACE, propName);
                        if (!propName.equals("JMSXGroupID") && !propName.equals("JMSXGroupSeq")) continue;
                        ++iCount;
                    } while (cmd.hasMoreElements());
                    if (iCount > 1) {
                        logger.log(System.Logger.Level.TRACE, "Pass:");
                        break block78;
                    }
                    logger.log(System.Logger.Level.INFO, "Error: Expected property names not returned");
                    pass = false;
                }
                catch (Exception ee) {
                    TestUtil.printStackTrace((Throwable)ee);
                    logger.log(System.Logger.Level.INFO, "attempting to read JMSX property names.");
                    logger.log(System.Logger.Level.INFO, "Error: unexpected exception: " + ee.getClass().getName() + " was thrown");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
            finally {
                this.sendTestResults(testCase, pass);
            }
        }
    }

    private void msgPropertiesConversionQTestCreate() {
        boolean pass = true;
        boolean bool = true;
        byte bValue = 127;
        short nShort = 10;
        int nInt = 5;
        long nLong = 333L;
        float nFloat = 1.0f;
        double nDouble = 100.0;
        String testString = "test";
        String testMessageBody = "Testing...";
        boolean ntest = false;
        try {
            this.messageSent.setText(testMessageBody);
            this.messageSent.setBooleanProperty("TESTBOOLEAN", bool);
            this.messageSent.setByteProperty("TESTBYTE", bValue);
            this.messageSent.setShortProperty("TESTSHORT", nShort);
            this.messageSent.setIntProperty("TESTINT", nInt);
            this.messageSent.setFloatProperty("TESTFLOAT", nFloat);
            this.messageSent.setDoubleProperty("TESTDOUBLE", nDouble);
            this.messageSent.setStringProperty("TESTSTRING", "test");
            this.messageSent.setLongProperty("TESTLONG", nLong);
            this.messageSent.setStringProperty("TESTSTRINGTRUE", "true");
            this.messageSent.setStringProperty("TESTSTRINGFALSE", "false");
            this.messageSent.setStringProperty("TESTSTRING1", "1");
            this.messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgPropertiesConversionQTest");
            this.messageSent.setStringProperty("TestCase", "msgPropertiesConversionQTest");
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)this.messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void msgPropertiesConversionQTest(Message messageReceived) {
        boolean pass = true;
        boolean bool = true;
        byte bValue = 127;
        short nShort = 10;
        int nInt = 5;
        long nLong = 333L;
        float nFloat = 1.0f;
        double nDouble = 100.0;
        String testString = "test";
        String testMessageBody = "Testing...";
        boolean ntest = false;
        String testCase = "msgPropertiesConversionQTest";
        try {
            String myBool = messageReceived.getStringProperty("TESTBOOLEAN");
            if (Boolean.valueOf(myBool) == bool) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from boolean to string - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from boolean to string failed");
                pass = false;
            }
            try {
                messageReceived.getByteProperty("TESTBOOLEAN");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: boolean to byte ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- boolean to byte");
                pass = false;
            }
            try {
                messageReceived.getShortProperty("TESTBOOLEAN");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: boolean to short ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- boolean to short");
                pass = false;
            }
            try {
                messageReceived.getIntProperty("TESTBOOLEAN");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: boolean to int ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception --boolean to int ");
                pass = false;
            }
            try {
                messageReceived.getLongProperty("TESTBOOLEAN");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: boolean to long ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- boolean to long");
                pass = false;
            }
            try {
                messageReceived.getFloatProperty("TESTBOOLEAN");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: boolean to float ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- boolean to float");
                pass = false;
            }
            try {
                messageReceived.getDoubleProperty("TESTBOOLEAN");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: boolean to double ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- boolean to double");
                pass = false;
            }
            String myByte = messageReceived.getStringProperty("TESTBYTE");
            if (Byte.valueOf(myByte) == bValue) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from byte to string - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from byte to string failed");
                pass = false;
            }
            if (messageReceived.getShortProperty("TESTBYTE") == bValue) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from byte to short - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from byte to short failed");
                pass = false;
            }
            if (messageReceived.getIntProperty("TESTBYTE") == bValue) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from byte to int - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from byte to int failed");
                pass = false;
            }
            if (messageReceived.getLongProperty("TESTBYTE") == (long)bValue) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from byte to long - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from byte to long failed");
                pass = false;
            }
            try {
                messageReceived.getBooleanProperty("TESTBYTE");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: byte to boolean ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- byte to boolean");
                pass = false;
            }
            try {
                messageReceived.getFloatProperty("TESTBYTE");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: byte to float ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception --byte to float ");
                pass = false;
            }
            try {
                messageReceived.getDoubleProperty("TESTBYTE");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: byte to double ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- byte to double");
                pass = false;
            }
            String myshort = messageReceived.getStringProperty("TESTSHORT");
            if (Short.valueOf(myshort) == nShort) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from short to string - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from short to string failed");
                pass = false;
            }
            if (messageReceived.getIntProperty("TESTSHORT") == nShort) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from short to int - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from short to int failed");
                pass = false;
            }
            if (messageReceived.getLongProperty("TESTSHORT") == (long)nShort) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from short to long - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from short to long failed");
                pass = false;
            }
            try {
                messageReceived.getBooleanProperty("TESTSHORT");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: short to boolean ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- short to boolean");
                pass = false;
            }
            try {
                messageReceived.getByteProperty("TESTSHORT");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: short to byte ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- short to byte");
                pass = false;
            }
            try {
                messageReceived.getFloatProperty("TESTSHORT");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: short to float ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- short to float");
                pass = false;
            }
            try {
                messageReceived.getDoubleProperty("TESTSHORT");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: short to double ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- short to double");
                pass = false;
            }
            if (Integer.valueOf(messageReceived.getStringProperty("TESTINT")) == nInt) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from int to string - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from int to string failed");
                pass = false;
            }
            if (messageReceived.getLongProperty("TESTINT") == (long)nInt) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from int to long - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from int to long failed");
                pass = false;
            }
            try {
                messageReceived.getBooleanProperty("TESTINT");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: int to boolean ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- int to boolean");
                pass = false;
            }
            try {
                messageReceived.getByteProperty("TESTINT");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: int to byte ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception --  int to byte");
                pass = false;
            }
            try {
                messageReceived.getShortProperty("TESTINT");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: int to short ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected -- int to short ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception ");
                pass = false;
            }
            try {
                messageReceived.getFloatProperty("TESTINT");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: int to float ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- int to float");
                pass = false;
            }
            try {
                messageReceived.getDoubleProperty("TESTINT");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: int to double ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- int to double");
                pass = false;
            }
            if (Long.valueOf(messageReceived.getStringProperty("TESTLONG")) == nLong) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from long to string - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from long to string failed");
                pass = false;
            }
            try {
                messageReceived.getBooleanProperty("TESTLONG");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: long to boolean ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- long to boolean");
                pass = false;
            }
            try {
                messageReceived.getByteProperty("TESTLONG");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: long to byte ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- long to byte");
                pass = false;
            }
            try {
                messageReceived.getShortProperty("TESTLONG");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: long to short ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- long to short ");
                pass = false;
            }
            try {
                messageReceived.getIntProperty("TESTLONG");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: long to int ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- long to int");
                pass = false;
            }
            try {
                messageReceived.getFloatProperty("TESTLONG");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: long to float ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- long to float");
                pass = false;
            }
            try {
                messageReceived.getDoubleProperty("TESTLONG");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: long to double ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- long to double");
                pass = false;
            }
            if (Float.valueOf(messageReceived.getStringProperty("TESTFLOAT")).floatValue() == nFloat) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from float to string - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from float to string failed");
                pass = false;
            }
            if (messageReceived.getDoubleProperty("TESTFLOAT") == (double)nFloat) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from long to double - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from long to double failed");
                pass = false;
            }
            try {
                messageReceived.getBooleanProperty("TESTFLOAT");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: float to boolean ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- float to boolean ");
                pass = false;
            }
            try {
                messageReceived.getByteProperty("TESTFLOAT");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: float to byte ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- float to byte");
                pass = false;
            }
            try {
                messageReceived.getShortProperty("TESTFLOAT");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: float to short ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception - float to short ");
                pass = false;
            }
            try {
                messageReceived.getIntProperty("TESTFLOAT");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: float to int ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception --- float to int");
                pass = false;
            }
            try {
                messageReceived.getLongProperty("TESTFLOAT");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: float to long ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception --  float to long");
                pass = false;
            }
            if (Double.valueOf(messageReceived.getStringProperty("TESTDOUBLE")) == nDouble) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from double to string - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from double to string failed");
                pass = false;
            }
            try {
                messageReceived.getBooleanProperty("TESTDOUBLE");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: double to boolean ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- double to boolean ");
                pass = false;
            }
            try {
                messageReceived.getByteProperty("TESTDOUBLE");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: double to byte ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- double to byte ");
                pass = false;
            }
            try {
                messageReceived.getShortProperty("TESTDOUBLE");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: double to short ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- double to short");
                pass = false;
            }
            try {
                messageReceived.getIntProperty("TESTDOUBLE");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: double to int ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception --- double to int ");
                pass = false;
            }
            try {
                messageReceived.getLongProperty("TESTDOUBLE");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: double to long ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- double to long");
                pass = false;
            }
            try {
                messageReceived.getFloatProperty("TESTDOUBLE");
                logger.log(System.Logger.Level.INFO, "Error: MessageFormatException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "unsupported conversion: double to float ");
                pass = false;
            }
            catch (MessageFormatException me) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, ee.getMessage());
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                logger.log(System.Logger.Level.INFO, "Error: did not catch expected Exception -- double to float");
                pass = false;
            }
            if (messageReceived.getBooleanProperty("TESTSTRINGTRUE")) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from string to boolean - expect true - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from string to boolean - expect true  - failed");
                pass = false;
            }
            if (!messageReceived.getBooleanProperty("TESTSTRINGFALSE")) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from string to boolean expect false - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from string to boolean expect false - failed");
                pass = false;
            }
            if (messageReceived.getByteProperty("TESTSTRING1") == 1) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from string to byte - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from string to byte failed");
                pass = false;
            }
            if (messageReceived.getShortProperty("TESTSTRING1") == 1) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from string to short - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from string to short failed");
                pass = false;
            }
            if (messageReceived.getIntProperty("TESTSTRING1") == 1) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from string to int - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from string to int failed");
                pass = false;
            }
            if (messageReceived.getLongProperty("TESTSTRING1") == 1L) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from string to long - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from string to long failed");
                pass = false;
            }
            if (messageReceived.getFloatProperty("TESTSTRING1") == 1.0f) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from string to float - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from string to float failed");
                pass = false;
            }
            if (messageReceived.getDoubleProperty("TESTSTRING1") == 1.0) {
                logger.log(System.Logger.Level.TRACE, "Pass: conversion from string to double - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: conversion from string to double failed");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    private void sendTestResults(String testCase, boolean results) {
        TextMessage msg = null;
        try {
            this.mSender = this.qSession.createSender(this.queueR);
            msg = this.qSession.createTextMessage();
            msg.setStringProperty("TestCase", testCase);
            msg.setText(testCase);
            if (results) {
                msg.setStringProperty("Status", "Pass");
            } else {
                msg.setStringProperty("Status", "Fail");
            }
            System.out.println("Sending response message");
            System.out.println("==================================Test Results from: " + testCase);
            System.out.println("==================================Status: " + results);
            this.mSender.send((Message)msg);
        }
        catch (JMSException je) {
            TestUtil.printStackTrace((Throwable)je);
            System.out.println("Error: " + ((Object)((Object)je)).getClass().getName() + " was thrown");
        }
        catch (Exception ee) {
            TestUtil.printStackTrace((Throwable)ee);
            System.out.println("Error: " + ee.getClass().getName() + " was thrown");
        }
    }

    public void setMessageDrivenContext(MessageDrivenContext mdc) {
        System.out.println("jms.ee.mdb.mdb_msgPropsQ  In MsgBeanMsgTestPropsQ::setMessageDrivenContext()!!");
        this.mdc = mdc;
    }

    public void ejbRemove() {
        System.out.println("jms.ee.mdb.mdb_msgPropsQ  In MsgBeanMsgTestPropsQ::remove()!!");
    }
}

