/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core20.appclient.listenerexceptiontests;

import jakarta.jms.CompletionListener;
import jakarta.jms.Connection;
import jakarta.jms.IllegalStateException;
import jakarta.jms.Message;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.ArrayList;

public class MyCompletionListener
implements CompletionListener {
    private String name = null;
    private Message message = null;
    private Connection connection = null;
    private Session session = null;
    private ArrayList<Message> messages = new ArrayList();
    private Exception exception = null;
    private int numMessages = 1;
    private int countMessages = 0;
    boolean complete = false;
    boolean gotCorrectException = false;
    boolean gotException = false;
    private static final System.Logger logger = System.getLogger(MyCompletionListener.class.getName());

    public MyCompletionListener() {
        this("MyCompletionListener");
    }

    public MyCompletionListener(String name) {
        this.name = name;
    }

    public MyCompletionListener(int numMessages) {
        this.numMessages = numMessages;
        this.messages.clear();
    }

    public MyCompletionListener(Connection connection) {
        this.connection = connection;
    }

    public MyCompletionListener(Session session) {
        this.session = session;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Message getMessage() {
        return this.message;
    }

    public Message getMessage(int index) {
        return this.messages.get(index);
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean gotCorrectException() {
        return this.gotCorrectException;
    }

    public boolean gotException() {
        return this.gotException;
    }

    public boolean gotAllMsgs() {
        return this.messages.size() == this.numMessages;
    }

    public boolean haveMsg(int i) {
        return this.messages.size() > i;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public void onCompletion(Message message) {
        try {
            logger.log(System.Logger.Level.INFO, "onCompletion(): Got Message: " + ((TextMessage)message).getText());
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
        }
        this.message = message;
        this.messages.add(message);
        if (message instanceof TextMessage) {
            TextMessage tMsg = (TextMessage)message;
            try {
                if (tMsg.getText().equals("Call connection close method")) {
                    logger.log(System.Logger.Level.INFO, "Calling Connection.close() MUST throw IllegalStateException");
                    if (this.connection != null) {
                        this.connection.close();
                    }
                } else if (tMsg.getText().equals("Call session close method")) {
                    logger.log(System.Logger.Level.INFO, "Calling Session.close() MUST throw IllegalStateException");
                    if (this.session != null) {
                        this.session.close();
                    }
                }
            }
            catch (IllegalStateException e) {
                logger.log(System.Logger.Level.INFO, "onCompletion(): Caught expected IllegalStateException");
                this.gotCorrectException = true;
                this.gotException = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "onCompletion(): Caught unexpected exception: " + e);
                this.gotCorrectException = false;
                this.gotException = true;
                this.exception = e;
            }
        }
        this.complete = true;
        logger.log(System.Logger.Level.INFO, "onCompletion(): Leaving");
    }

    public void onException(Message message, Exception exception) {
        logger.log(System.Logger.Level.INFO, "Got Exception: " + exception);
        logger.log(System.Logger.Level.INFO, "With Message: " + message);
        this.exception = exception;
        this.message = message;
        this.complete = true;
    }
}

