/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core20.appclient.jmscontexttopictests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import com.sun.ts.tests.jms.core20.appclient.jmscontexttopictests.MyCompletionListener;
import com.sun.ts.tests.jms.core20.appclient.jmscontexttopictests.MyCompletionListener2;
import com.sun.ts.tests.jms.core20.appclient.jmscontexttopictests.MyExceptionListener;
import jakarta.jms.BytesMessage;
import jakarta.jms.CompletionListener;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.IllegalStateRuntimeException;
import jakarta.jms.InvalidClientIDRuntimeException;
import jakarta.jms.InvalidDestinationRuntimeException;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSProducer;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageFormatRuntimeException;
import jakarta.jms.ObjectMessage;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClientIT {
    private static final String testName = "com.sun.ts.tests.jms.core20.appclient.jmscontexttopictests.ClientIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private static final System.Logger logger = System.getLogger(ClientIT.class.getName());
    private transient JmsTool tool = null;
    private transient JmsTool tool2 = null;
    private transient ConnectionFactory cf = null;
    private transient ConnectionFactory cf2 = null;
    private transient Topic topic = null;
    private transient Destination destination = null;
    private transient JMSContext context = null;
    private transient JMSContext context2 = null;
    private transient JMSContext contextD = null;
    private transient JMSConsumer consumer = null;
    private transient JMSProducer producer = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    private static final int numMessages = 3;
    private static final int iterations = 5;
    ArrayList connections = null;

    private String printSessionMode(int sessionMode) {
        switch (sessionMode) {
            case 0: {
                return "SESSION_TRANSACTED";
            }
            case 1: {
                return "AUTO_ACKNOWLEDGE";
            }
            case 2: {
                return "CLIENT_ACKNOWLEDGE";
            }
            case 3: {
                return "DUPS_OK_ACKNOWLEDGE";
            }
        }
        return "UNEXPECTED_SESSIONMODE";
    }

    @BeforeEach
    public void setup() throws Exception {
        try {
            String lookupDurableTopicFactory = "DURABLE_SUB_CONNECTION_FACTORY";
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' is null ");
            }
            if (this.password == null) {
                throw new Exception("'password' is null ");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' is null");
            }
            this.connections = new ArrayList(5);
            logger.log(System.Logger.Level.INFO, "Setup JmsTool for COMMON_T setup");
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.cf = this.tool.getConnectionFactory();
            this.destination = this.tool.getDefaultDestination();
            this.topic = (Topic)this.destination;
            this.tool.getDefaultConnection().close();
            logger.log(System.Logger.Level.INFO, "Create JMSContext with AUTO_ACKNOWLEDGE");
            this.context = this.cf.createContext(this.user, this.password, 1);
            logger.log(System.Logger.Level.INFO, "Setup JmsTool for COMMON_T and durable topic connection factory");
            this.tool2 = new JmsTool(14, this.user, this.password, lookupDurableTopicFactory, this.mode);
            this.tool2.getDefaultConnection().close();
            this.cf2 = this.tool2.getConnectionFactory();
            this.contextD = this.cf2.createContext(this.user, this.password, 1);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            throw new Exception("setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.INFO, "Close JMSContext objects");
            if (this.context != null) {
                this.context.close();
                this.context = null;
            }
            if (this.contextD != null) {
                this.contextD.close();
                this.contextD = null;
            }
            logger.log(System.Logger.Level.INFO, "Close JMSConsumer objects");
            if (this.consumer != null) {
                this.consumer.close();
                this.consumer = null;
            }
            this.tool.closeAllResources();
            this.tool2.closeAllResources();
            this.producer = null;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            throw new Exception("cleanup failed!", e);
        }
    }

    @Test
    public void setGetClientIDTest() throws Exception {
        boolean pass = true;
        try {
            String clientid = "myclientid";
            logger.log(System.Logger.Level.INFO, "Calling setClientID(" + clientid + ")");
            this.context.setClientID(clientid);
            logger.log(System.Logger.Level.INFO, "Calling getClientID and expect " + clientid + " to be returned");
            String cid = this.context.getClientID();
            if (!cid.equals(clientid)) {
                logger.log(System.Logger.Level.ERROR, "getClientID() returned " + cid + ", expected " + clientid);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            throw new Exception("setGetClientIDTest");
        }
        if (!pass) {
            throw new Exception("setGetClientIDTest failed");
        }
    }

    @Test
    public void setClientIDLateTest() throws Exception {
        boolean pass = true;
        try {
            String message = "This is my message.";
            logger.log(System.Logger.Level.INFO, "Creating JMSConsumer");
            this.consumer = this.context.createConsumer(this.destination);
            logger.log(System.Logger.Level.INFO, "Creating JMSProducer");
            this.producer = this.context.createProducer();
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "setClientIDLateTest");
            logger.log(System.Logger.Level.INFO, "Calling JMSProduce.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "Receive TextMessage");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage != null) {
                logger.log(System.Logger.Level.INFO, "actTextMessage=" + actTextMessage.getText());
            }
            logger.log(System.Logger.Level.TRACE, "Attempt to set Client ID too late (expect IllegalStateRuntimeException)");
            try {
                this.context.setClientID("setClientIDLateTest");
                pass = false;
                logger.log(System.Logger.Level.ERROR, "IllegalStateRuntimeException was not thrown");
            }
            catch (IllegalStateRuntimeException is) {
                logger.log(System.Logger.Level.INFO, "IllegalStateRuntimeException thrown as expected");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Incorrect exception received: " + e);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("setClientIDLateTest", e);
        }
        if (!pass) {
            throw new Exception("setClientIDLateTest failed");
        }
    }

    @Test
    public void setClientIDOnAdminConfiguredIDTest() throws Exception {
        boolean pass = true;
        try {
            String clientid = "myclientid";
            logger.log(System.Logger.Level.INFO, "Try setting ClientID on JMSContext administratively configured with ClientID (expect IllegalStateRuntimeException)");
            this.contextD.setClientID(clientid);
            logger.log(System.Logger.Level.ERROR, "Did not throw expected IllegalStateRuntimeException");
            pass = false;
            String cid = this.contextD.getClientID();
            if (cid == null) {
                logger.log(System.Logger.Level.ERROR, "getClientID returned null (expected cts)");
                pass = false;
            } else if (!cid.equals("cts")) {
                logger.log(System.Logger.Level.ERROR, "getClientID() returned " + cid + ", expected cts");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "getClientID returned cts (Correct)");
            }
        }
        catch (IllegalStateRuntimeException is) {
            logger.log(System.Logger.Level.INFO, "IllegalStateRuntimeException thrown as expected");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Incorrect exception received: " + e);
            throw new Exception("setClientIDOnAdminConfiguredIDTest");
        }
        if (!pass) {
            throw new Exception("setClientIDOnAdminConfiguredIDTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void setGetChangeClientIDTest() throws Exception {
        boolean pass = true;
        String lookup = "MyTopicConnectionFactory";
        try {
            logger.log(System.Logger.Level.INFO, "Create second JMSContext with AUTO_ACKNOWLEDGE");
            this.context2 = this.cf.createContext(this.user, this.password, 1);
            logger.log(System.Logger.Level.INFO, "Setting clientID!");
            this.context.setClientID("ctstest");
            logger.log(System.Logger.Level.INFO, "Getting clientID!");
            String clientid = this.context.getClientID();
            if (!clientid.equals("ctstest")) {
                logger.log(System.Logger.Level.ERROR, "getClientID() returned " + clientid + ", expected ctstest");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "setClientID/getClientID correct");
            }
            logger.log(System.Logger.Level.INFO, "Resetting clientID! (expect IllegalStateRuntimeException)");
            this.context.setClientID("changeIt");
            logger.log(System.Logger.Level.ERROR, "No exception was thrown on ClientID reset");
            pass = false;
        }
        catch (IllegalStateRuntimeException e) {
            logger.log(System.Logger.Level.INFO, "IllegalStateRuntimeException thrown as expected");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Incorrect exception received: " + e);
            pass = false;
        }
        try {
            logger.log(System.Logger.Level.INFO, "Set clientID on second context to value of clientID on first context (expect InvalidClientIDRuntimeException)");
            this.context2.setClientID("ctstest");
            logger.log(System.Logger.Level.ERROR, "No exception was thrown on ClientID that already exists");
            pass = false;
        }
        catch (InvalidClientIDRuntimeException e) {
            logger.log(System.Logger.Level.INFO, "InvalidClientIDRuntimeException thrown as expected");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Incorrect exception received: " + e);
            pass = false;
        }
        finally {
            try {
                if (this.context2 != null) {
                    this.context2.close();
                    this.context2 = null;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught exception in finally block: " + e);
                throw new Exception("setGetChangeClientIDTest", e);
            }
        }
        if (!pass) {
            throw new Exception("setGetChangeClientIDTest");
        }
    }

    @Test
    public void setGetExceptionListenerTest() throws Exception {
        boolean pass = true;
        try {
            MyExceptionListener expExceptionListener = new MyExceptionListener();
            logger.log(System.Logger.Level.INFO, "Calling setExceptionListener(" + expExceptionListener + ")");
            this.context.setExceptionListener((ExceptionListener)expExceptionListener);
            logger.log(System.Logger.Level.INFO, "Calling getExceptionListener and expect " + expExceptionListener + " to be returned");
            MyExceptionListener actExceptionListener = (MyExceptionListener)this.context.getExceptionListener();
            if (!actExceptionListener.equals(expExceptionListener)) {
                logger.log(System.Logger.Level.ERROR, "getExceptionListener() returned " + actExceptionListener + ", expected " + expExceptionListener);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Calling setExceptionListener(null)");
            this.context.setExceptionListener(null);
            if (this.context.getExceptionListener() != null) {
                logger.log(System.Logger.Level.ERROR, "getExceptionListener() returned " + this.context.getExceptionListener() + ", expected null");
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("setGetExceptionListenerTest");
        }
        if (!pass) {
            throw new Exception("setGetExceptionListenerTest failed");
        }
    }

    @Test
    public void setGetAsyncTest() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "Creating JMSProducer");
            this.producer = this.context.createProducer();
            MyCompletionListener expCompletionListener = new MyCompletionListener();
            logger.log(System.Logger.Level.INFO, "Calling JMSProducer.setAsync(" + expCompletionListener + ")");
            this.producer.setAsync((CompletionListener)expCompletionListener);
            logger.log(System.Logger.Level.INFO, "Calling JMSProducer.getAsync() and expect " + expCompletionListener + " to be returned");
            MyCompletionListener actCompletionListener = (MyCompletionListener)this.producer.getAsync();
            if (!actCompletionListener.equals(expCompletionListener)) {
                logger.log(System.Logger.Level.ERROR, "getAsync() returned " + actCompletionListener + ", expected " + expCompletionListener);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Calling setAsync(null)");
            this.producer.setAsync(null);
            logger.log(System.Logger.Level.INFO, "Calling JMSProducer.getAsync() and expect NULL to be returned");
            if (this.producer.getAsync() != null) {
                logger.log(System.Logger.Level.ERROR, "getAsync() returned " + this.producer.getAsync() + ", expected null");
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("setGetAsyncTest");
        }
        if (!pass) {
            throw new Exception("setGetAsyncTest failed");
        }
    }

    @Test
    public void startStopTest() throws Exception {
        boolean pass = true;
        try {
            TextMessage tempMsg = null;
            logger.log(System.Logger.Level.INFO, "Create JMSConsumer");
            this.consumer = this.context.createConsumer(this.destination);
            logger.log(System.Logger.Level.INFO, "Call stop() to stop delivery of incoming messages");
            this.context.stop();
            logger.log(System.Logger.Level.INFO, "Creating JMSProducer");
            this.producer = this.context.createProducer();
            logger.log(System.Logger.Level.INFO, "Send 3 messages to Topic");
            for (int i = 1; i <= 3; ++i) {
                tempMsg = this.context.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "startStopTest" + i);
                this.producer.send(this.destination, (Message)tempMsg);
                logger.log(System.Logger.Level.INFO, "Message " + i + " sent");
            }
            logger.log(System.Logger.Level.INFO, "Try consuming a message on a STOPPED connection");
            tempMsg = (TextMessage)this.consumer.receive(this.timeout);
            if (tempMsg != null) {
                logger.log(System.Logger.Level.ERROR, "Received a message on a STOPPED connection");
                logger.log(System.Logger.Level.ERROR, "Message is: " + tempMsg.getText());
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Call start() to start delivery of incoming messages");
            this.context.start();
            logger.log(System.Logger.Level.INFO, "Consume all the messages in the Topic on a STARTED connection");
            for (int msgCount = 1; msgCount <= 3; ++msgCount) {
                tempMsg = (TextMessage)this.consumer.receive(this.timeout);
                if (tempMsg == null) {
                    logger.log(System.Logger.Level.ERROR, "JMSConsumer.receive() returned NULL");
                    logger.log(System.Logger.Level.ERROR, "Message " + msgCount + " missing from Topic");
                    pass = false;
                    continue;
                }
                if (!tempMsg.getText().equals("Message " + msgCount)) {
                    logger.log(System.Logger.Level.ERROR, "Received [" + tempMsg.getText() + "] expected [Message " + msgCount + "]");
                    pass = false;
                    continue;
                }
                logger.log(System.Logger.Level.INFO, "Received message: " + tempMsg.getText());
            }
            logger.log(System.Logger.Level.INFO, "Topic should now be empty");
            logger.log(System.Logger.Level.INFO, "Try consuming one more message should return NULL");
            tempMsg = (TextMessage)this.consumer.receive(this.timeout);
            if (tempMsg != null) {
                logger.log(System.Logger.Level.ERROR, "JMSConsumer.receive() did not return NULL");
                logger.log(System.Logger.Level.ERROR, "JMSConsumer.receive() returned a message (unexpected)");
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("startStopTest");
        }
        if (!pass) {
            throw new Exception("startStopTest failed");
        }
    }

    @Test
    public void createContextTest() throws Exception {
        boolean pass = true;
        try {
            JMSContext newContext = null;
            int[] expSessionMode = new int[]{0, 1, 2, 3};
            for (int i = 0; i < expSessionMode.length; ++i) {
                logger.log(System.Logger.Level.INFO, "Creating context with session mode (" + this.printSessionMode(expSessionMode[i]) + ")");
                logger.log(System.Logger.Level.INFO, "Call API TopicConnectionFactory.createContext(int)");
                newContext = this.context.createContext(expSessionMode[i]);
                logger.log(System.Logger.Level.INFO, "Now call API JMSContext.getSessionMode()");
                logger.log(System.Logger.Level.INFO, "Calling getSessionMode and expect " + this.printSessionMode(expSessionMode[i]) + " to be returned");
                int actSessionMode = newContext.getSessionMode();
                if (actSessionMode != expSessionMode[i]) {
                    logger.log(System.Logger.Level.ERROR, "getSessionMode() returned " + this.printSessionMode(actSessionMode) + ", expected " + this.printSessionMode(expSessionMode[i]));
                    pass = false;
                }
                newContext.close();
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("createContextTest");
        }
        if (!pass) {
            throw new Exception("createContextTest failed");
        }
    }

    @Test
    public void sendAndRecvCLTest1() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        boolean bool = true;
        byte bValue = 127;
        short nShort = 10;
        int nInt = 5;
        long nLong = 333L;
        float nFloat = 1.0f;
        double nDouble = 100.0;
        String testString = "test";
        try {
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvCLTest1");
            MyCompletionListener listener = new MyCompletionListener();
            logger.log(System.Logger.Level.INFO, "Creating JMSProducer");
            this.producer = this.context.createProducer();
            logger.log(System.Logger.Level.INFO, "Set primitive property types on JMSProducer");
            this.producer.setProperty("TESTBOOLEAN", bool);
            this.producer.setProperty("TESTBYTE", bValue);
            this.producer.setProperty("TESTDOUBLE", nDouble);
            this.producer.setProperty("TESTFLOAT", nFloat);
            this.producer.setProperty("TESTINT", nInt);
            this.producer.setProperty("TESTLONG", nLong);
            this.producer.setProperty("TESTSHORT", nShort);
            this.producer.setProperty("TESTSTRING", "test");
            logger.log(System.Logger.Level.INFO, "Set Object property types on JMSProducer");
            this.producer.setProperty("OBJTESTBOOLEAN", (Object)bool);
            this.producer.setProperty("OBJTESTBYTE", (Object)bValue);
            this.producer.setProperty("OBJTESTDOUBLE", (Object)nDouble);
            this.producer.setProperty("OBJTESTFLOAT", (Object)Float.valueOf(nFloat));
            this.producer.setProperty("OBJTESTINT", (Object)nInt);
            this.producer.setProperty("OBJTESTLONG", (Object)nLong);
            this.producer.setProperty("OBJTESTSHORT", (Object)nShort);
            this.producer.setProperty("OBJTESTSTRING", "test");
            logger.log(System.Logger.Level.INFO, "Calling JMSProducer.setAsync(CompletionListener)");
            this.producer.setAsync((CompletionListener)listener);
            logger.log(System.Logger.Level.INFO, "Calling JMSProducer.send(Destination,Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "Poll listener until we receive TextMessage");
            TextMessage actTextMessage = null;
            for (int i = 0; !listener.isComplete() && i < 60; ++i) {
                logger.log(System.Logger.Level.INFO, "Loop " + i + ": sleep 2 seconds waiting for messages to arrive at listener");
                TestUtil.sleepSec((int)2);
            }
            if (listener.isComplete()) {
                actTextMessage = (TextMessage)listener.getMessage();
            }
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Retrieve and verify that TextMessage message properties were set correctly");
            if (actTextMessage.getBooleanProperty("TESTBOOLEAN") == bool) {
                logger.log(System.Logger.Level.INFO, "Pass: getBooleanProperty returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect value returned from getBooleanProperty");
                pass = false;
            }
            if (actTextMessage.getByteProperty("TESTBYTE") == bValue) {
                logger.log(System.Logger.Level.INFO, "Pass: getByteProperty returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect value returned from getByteProperty");
                pass = false;
            }
            if (actTextMessage.getLongProperty("TESTLONG") == nLong) {
                logger.log(System.Logger.Level.INFO, "Pass: getLongProperty returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect value returned from getLongProperty");
                pass = false;
            }
            if (actTextMessage.getStringProperty("TESTSTRING").equals(testString)) {
                logger.log(System.Logger.Level.INFO, "Pass: getStringProperty returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect value returned from getStringProperty");
                pass = false;
            }
            if (actTextMessage.getDoubleProperty("TESTDOUBLE") == nDouble) {
                logger.log(System.Logger.Level.INFO, "Pass: getDoubleProperty returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect value returned from getDoubleProperty");
                pass = false;
            }
            if (actTextMessage.getFloatProperty("TESTFLOAT") == nFloat) {
                logger.log(System.Logger.Level.INFO, "Pass: getFloatProperty returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect value returned from getFloatProperty");
                pass = false;
            }
            if (actTextMessage.getIntProperty("TESTINT") == nInt) {
                logger.log(System.Logger.Level.INFO, "Pass: getIntProperty returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect value returned from getIntProperty");
                pass = false;
            }
            if (actTextMessage.getShortProperty("TESTSHORT") == nShort) {
                logger.log(System.Logger.Level.INFO, "Pass: getShortProperty returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect value returned from getShortProperty");
                pass = false;
            }
            if ((Boolean)actTextMessage.getObjectProperty("OBJTESTBOOLEAN") == bool) {
                logger.log(System.Logger.Level.INFO, "Pass: getObjectProperty returned correct Boolean value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect Boolean value returned from getObjectProperty");
                pass = false;
            }
            if ((Byte)actTextMessage.getObjectProperty("OBJTESTBYTE") == bValue) {
                logger.log(System.Logger.Level.INFO, "Pass: getObjectProperty returned correct Byte value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect Byte value returned from getObjectProperty");
                pass = false;
            }
            if ((Long)actTextMessage.getObjectProperty("OBJTESTLONG") == nLong) {
                logger.log(System.Logger.Level.INFO, "Pass: getObjectProperty returned correct Long value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect Long value returned from getObjectProperty");
                pass = false;
            }
            if (((String)actTextMessage.getObjectProperty("OBJTESTSTRING")).equals(testString)) {
                logger.log(System.Logger.Level.INFO, "Pass: getObjectProperty returned correct String value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect String value returned from getObjectProperty");
                pass = false;
            }
            if ((Double)actTextMessage.getObjectProperty("OBJTESTDOUBLE") == nDouble) {
                logger.log(System.Logger.Level.INFO, "Pass: getObjectProperty returned correct Double value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect Double value returned from getObjectProperty");
                pass = false;
            }
            if (((Float)actTextMessage.getObjectProperty("OBJTESTFLOAT")).floatValue() == nFloat) {
                logger.log(System.Logger.Level.INFO, "Pass: getObjectProperty returned correct Float value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect Float value returned from getObjectProperty");
                pass = false;
            }
            if ((Integer)actTextMessage.getObjectProperty("OBJTESTINT") == nInt) {
                logger.log(System.Logger.Level.INFO, "Pass: getObjectProperty returned correct Integer value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect Integer value returned from getObjectProperty");
                pass = false;
            }
            if ((Short)actTextMessage.getObjectProperty("OBJTESTSHORT") == nShort) {
                logger.log(System.Logger.Level.INFO, "Pass: getObjectProperty returned correct Short value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect Short value returned from getObjectProperty");
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("sendAndRecvCLTest1", e);
        }
        if (!pass) {
            throw new Exception("sendAndRecvCLTest1 failed");
        }
    }

    @Test
    public void sendAndRecvCLTest2() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvCLTest2");
            MyCompletionListener listener = new MyCompletionListener();
            logger.log(System.Logger.Level.INFO, "Creating JMSProducer");
            this.producer = this.context.createProducer();
            logger.log(System.Logger.Level.INFO, "Calling JMSProducer.setAsync(CompletionListener)");
            this.producer.setAsync((CompletionListener)listener);
            logger.log(System.Logger.Level.INFO, "Set delivery mode, priority, and time to live");
            this.producer.setDeliveryMode(2);
            this.producer.setPriority(4);
            this.producer.setTimeToLive(0L);
            logger.log(System.Logger.Level.INFO, "Calling JMSProducer.send(Destination,Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "Poll listener until we receive TextMessage");
            TextMessage actTextMessage = null;
            for (int i = 0; !listener.isComplete() && i < 60; ++i) {
                logger.log(System.Logger.Level.INFO, "Loop " + i + ": sleep 2 seconds waiting for messages to arrive at listener");
                TestUtil.sleepSec((int)2);
            }
            if (listener.isComplete()) {
                actTextMessage = (TextMessage)listener.getMessage();
            }
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the values in TextMessage, deliverymode, priority, time to live");
            if (!actTextMessage.getText().equals(expTextMessage.getText()) || actTextMessage.getJMSDeliveryMode() != 2 || actTextMessage.getJMSPriority() != 4 || actTextMessage.getJMSExpiration() != 0L) {
                logger.log(System.Logger.Level.ERROR, "Didn't get the right message.");
                logger.log(System.Logger.Level.ERROR, "text=" + actTextMessage.getText() + ", expected " + expTextMessage.getText());
                logger.log(System.Logger.Level.ERROR, "DeliveryMode=" + actTextMessage.getJMSDeliveryMode() + ", expected " + expTextMessage.getJMSDeliveryMode());
                logger.log(System.Logger.Level.ERROR, "Priority=" + actTextMessage.getJMSPriority() + ", expected " + expTextMessage.getJMSPriority());
                logger.log(System.Logger.Level.ERROR, "TimeToLive=" + actTextMessage.getJMSExpiration() + ", expected " + expTextMessage.getJMSExpiration());
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("sendAndRecvCLTest2", e);
        }
        if (!pass) {
            throw new Exception("sendAndRecvCLTest2 failed");
        }
    }

    @Test
    public void sendAndRecvMsgOfEachTypeCLTest() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            logger.log(System.Logger.Level.INFO, "Send and receive Message");
            Message msg = this.context.createMessage();
            logger.log(System.Logger.Level.INFO, "Set some values in Message");
            msg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgOfEachTypeCLTest");
            msg.setBooleanProperty("booleanProperty", true);
            MyCompletionListener2 listener = new MyCompletionListener2();
            this.producer = this.context.createProducer();
            this.producer.setAsync((CompletionListener)listener);
            this.producer.send(this.destination, msg);
            logger.log(System.Logger.Level.INFO, "Poll listener until we receive Message");
            for (int i = 0; !listener.isComplete() && i < 15; ++i) {
                logger.log(System.Logger.Level.INFO, "Loop " + i + ": sleep 2 seconds waiting for message to arrive at listener");
                TestUtil.sleepSec((int)2);
            }
            Message actMessage = null;
            if (listener.isComplete()) {
                actMessage = listener.getMessage();
            }
            if (actMessage == null) {
                logger.log(System.Logger.Level.ERROR, "Did not receive Message");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Check the values in Message");
                if (actMessage.getBooleanProperty("booleanProperty")) {
                    logger.log(System.Logger.Level.INFO, "booleanproperty is correct");
                } else {
                    logger.log(System.Logger.Level.INFO, "booleanproperty is incorrect");
                    pass = false;
                }
            }
            logger.log(System.Logger.Level.INFO, "Send and receive BytesMessage");
            BytesMessage bMsg = this.context.createBytesMessage();
            logger.log(System.Logger.Level.INFO, "Set some values in BytesMessage");
            bMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgOfEachTypeCLTest");
            bMsg.writeByte((byte)1);
            bMsg.writeInt(22);
            bMsg.reset();
            listener = new MyCompletionListener2();
            this.producer = this.context.createProducer();
            this.producer.setAsync((CompletionListener)listener);
            this.producer.send(this.destination, (Message)bMsg);
            logger.log(System.Logger.Level.INFO, "Poll listener until we receive BytesMessage");
            for (int i = 0; !listener.isComplete() && i < 15; ++i) {
                logger.log(System.Logger.Level.INFO, "Loop " + i + ": sleep 2 seconds waiting for message to arrive at listener");
                TestUtil.sleepSec((int)2);
            }
            BytesMessage bMsgRecv = null;
            if (listener.isComplete()) {
                bMsgRecv = (BytesMessage)listener.getMessage();
            }
            if (bMsgRecv == null) {
                logger.log(System.Logger.Level.ERROR, "Did not receive BytesMessage");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Check the values in BytesMessage");
                if (bMsgRecv.readByte() == 1) {
                    logger.log(System.Logger.Level.INFO, "bytevalue is correct");
                } else {
                    logger.log(System.Logger.Level.INFO, "bytevalue is incorrect");
                    pass = false;
                }
                if (bMsgRecv.readInt() == 22) {
                    logger.log(System.Logger.Level.INFO, "intvalue is correct");
                } else {
                    logger.log(System.Logger.Level.INFO, "intvalue is incorrect");
                    pass = false;
                }
            }
            logger.log(System.Logger.Level.INFO, "Send and receive MapMessage");
            MapMessage mMsg = this.context.createMapMessage();
            logger.log(System.Logger.Level.INFO, "Set some values in MapMessage");
            mMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgOfEachTypeCLTest");
            mMsg.setBoolean("booleanvalue", true);
            mMsg.setInt("intvalue", 10);
            listener = new MyCompletionListener2();
            this.producer = this.context.createProducer();
            this.producer.setAsync((CompletionListener)listener);
            this.producer.send(this.destination, (Message)mMsg);
            logger.log(System.Logger.Level.INFO, "Poll listener until we receive MapMessage");
            for (int i = 0; !listener.isComplete() && i < 15; ++i) {
                logger.log(System.Logger.Level.INFO, "Loop " + i + ": sleep 2 seconds waiting for message to arrive at listener");
                TestUtil.sleepSec((int)2);
            }
            MapMessage mMsgRecv = null;
            if (listener.isComplete()) {
                mMsgRecv = (MapMessage)listener.getMessage();
            }
            if (mMsgRecv == null) {
                logger.log(System.Logger.Level.ERROR, "Did not receive MapMessage");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Check the values in MapMessage");
                Enumeration list = mMsgRecv.getMapNames();
                String name = null;
                while (list.hasMoreElements()) {
                    name = (String)list.nextElement();
                    if (name.equals("booleanvalue")) {
                        if (mMsgRecv.getBoolean(name)) {
                            logger.log(System.Logger.Level.INFO, "booleanvalue is correct");
                            continue;
                        }
                        logger.log(System.Logger.Level.ERROR, "booleanvalue is incorrect");
                        pass = false;
                        continue;
                    }
                    if (name.equals("intvalue")) {
                        if (mMsgRecv.getInt(name) == 10) {
                            logger.log(System.Logger.Level.INFO, "intvalue is correct");
                            continue;
                        }
                        logger.log(System.Logger.Level.ERROR, "intvalue is incorrect");
                        pass = false;
                        continue;
                    }
                    logger.log(System.Logger.Level.ERROR, "Unexpected name of [" + name + "] in MapMessage");
                    pass = false;
                }
            }
            logger.log(System.Logger.Level.INFO, "Send and receive ObjectMessage");
            StringBuffer sb1 = new StringBuffer("This is a StringBuffer");
            logger.log(System.Logger.Level.INFO, "Set some values in ObjectMessage");
            ObjectMessage oMsg = this.context.createObjectMessage();
            oMsg.setObject((Serializable)sb1);
            oMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgOfEachTypeCLTest");
            listener = new MyCompletionListener2();
            this.producer = this.context.createProducer();
            this.producer.setAsync((CompletionListener)listener);
            this.producer.send(this.destination, (Message)oMsg);
            logger.log(System.Logger.Level.INFO, "Poll listener until we receive ObjectMessage");
            for (int i = 0; !listener.isComplete() && i < 15; ++i) {
                logger.log(System.Logger.Level.INFO, "Loop " + i + ": sleep 2 seconds waiting for message to arrive at listener");
                TestUtil.sleepSec((int)2);
            }
            ObjectMessage oMsgRecv = null;
            if (listener.isComplete()) {
                oMsgRecv = (ObjectMessage)listener.getMessage();
            }
            if (oMsgRecv == null) {
                logger.log(System.Logger.Level.ERROR, "Did not receive ObjectMessage");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Check the values in ObjectMessage");
                StringBuffer sb2 = (StringBuffer)oMsgRecv.getObject();
                if (sb2.toString().equals(sb1.toString())) {
                    logger.log(System.Logger.Level.INFO, "objectvalue is correct");
                } else {
                    logger.log(System.Logger.Level.ERROR, "objectvalue is incorrect");
                    pass = false;
                }
            }
            logger.log(System.Logger.Level.INFO, "Send and receive StreamMessage");
            StreamMessage sMsg = this.context.createStreamMessage();
            logger.log(System.Logger.Level.INFO, "Set some values in StreamMessage");
            sMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgOfEachTypeCLTest");
            sMsg.writeBoolean(true);
            sMsg.writeInt(22);
            sMsg.reset();
            listener = new MyCompletionListener2();
            this.producer = this.context.createProducer();
            this.producer.setAsync((CompletionListener)listener);
            this.producer.send(this.destination, (Message)sMsg);
            logger.log(System.Logger.Level.INFO, "Poll listener until we receive StreamMessage");
            for (int i = 0; !listener.isComplete() && i < 15; ++i) {
                logger.log(System.Logger.Level.INFO, "Loop " + i + ": sleep 2 seconds waiting for message to arrive at listener");
                TestUtil.sleepSec((int)2);
            }
            StreamMessage sMsgRecv = null;
            if (listener.isComplete()) {
                sMsgRecv = (StreamMessage)listener.getMessage();
            }
            if (sMsgRecv == null) {
                logger.log(System.Logger.Level.ERROR, "Did not receive StreamMessage");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Check the values in StreamMessage");
                if (sMsgRecv.readBoolean()) {
                    logger.log(System.Logger.Level.INFO, "booleanvalue is correct");
                } else {
                    logger.log(System.Logger.Level.INFO, "booleanvalue is incorrect");
                    pass = false;
                }
                if (sMsgRecv.readInt() == 22) {
                    logger.log(System.Logger.Level.INFO, "intvalue is correct");
                } else {
                    logger.log(System.Logger.Level.INFO, "intvalue is incorrect");
                    pass = false;
                }
            }
            logger.log(System.Logger.Level.INFO, "Send and receive TextMessage");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgOfEachTypeCLTest");
            logger.log(System.Logger.Level.INFO, "Calling JMSProducer.send(Destination,Message)");
            listener = new MyCompletionListener2();
            this.producer = this.context.createProducer();
            this.producer.setAsync((CompletionListener)listener);
            this.producer.send(this.destination, (Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "Poll listener until we receive TextMessage");
            for (int i = 0; !listener.isComplete() && i < 15; ++i) {
                logger.log(System.Logger.Level.INFO, "Loop " + i + ": sleep 2 seconds waiting for message to arrive at listener");
                TestUtil.sleepSec((int)2);
            }
            TextMessage actTextMessage = null;
            if (listener.isComplete()) {
                actTextMessage = (TextMessage)listener.getMessage();
            }
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the values in TextMessage");
            if (!actTextMessage.getText().equals(expTextMessage.getText())) {
                logger.log(System.Logger.Level.ERROR, "Didn't get the right message.");
                logger.log(System.Logger.Level.ERROR, "text=" + actTextMessage.getText() + ", expected " + expTextMessage.getText());
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("sendAndRecvMsgOfEachTypeCLTest", e);
        }
        if (!pass) {
            throw new Exception("sendAndRecvMsgOfEachTypeCLTest failed");
        }
    }

    @Test
    public void messageOrderCLTopicTest() throws Exception {
        boolean pass = true;
        try {
            int i;
            String[] text = new String[3];
            logger.log(System.Logger.Level.INFO, "Creating MyCompletionListener");
            MyCompletionListener listener = new MyCompletionListener(3);
            logger.log(System.Logger.Level.INFO, "Creating JMSProducer");
            this.producer = this.context.createProducer();
            logger.log(System.Logger.Level.INFO, "Calling JMSProducer.setAsync(CompletionListener)");
            this.producer.setAsync((CompletionListener)listener);
            logger.log(System.Logger.Level.INFO, "Sending 3 asynchronous messages to topic");
            for (i = 0; i < 3; ++i) {
                text[i] = "message order test " + i;
                TextMessage sentTextMessage = this.context.createTextMessage();
                sentTextMessage.setText(text[i]);
                sentTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "messageOrderCLTopicTest" + i);
                logger.log(System.Logger.Level.INFO, "Sending TextMessage: " + sentTextMessage.getText());
                this.producer.send(this.destination, (Message)sentTextMessage);
            }
            logger.log(System.Logger.Level.INFO, "Poll listener until we receive all 3 TextMessage's from topic");
            for (i = 0; !listener.gotAllMsgs() && i < 60; ++i) {
                logger.log(System.Logger.Level.INFO, "Loop " + i + ": sleep 2 seconds waiting for messages to arrive at listener");
                TestUtil.sleepSec((int)2);
            }
            for (i = 0; i < 3; ++i) {
                TextMessage actTextMessage = null;
                if (listener.haveMsg(i)) {
                    actTextMessage = (TextMessage)listener.getMessage(i);
                }
                if (actTextMessage == null) {
                    logger.log(System.Logger.Level.INFO, "Did not receive TextMessage " + i + " (unexpected)");
                    pass = false;
                    continue;
                }
                logger.log(System.Logger.Level.INFO, "Received message: " + actTextMessage.getText());
                if (actTextMessage.getText().equals(text[i])) continue;
                logger.log(System.Logger.Level.INFO, "Received message: " + actTextMessage.getText());
                logger.log(System.Logger.Level.INFO, "Should have received: " + text[i]);
                logger.log(System.Logger.Level.ERROR, "Received wrong message (wrong order)");
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("messageOrderCLTopicTest", e);
        }
        if (!pass) {
            throw new Exception("messageOrderCLTopicTest failed");
        }
    }

    @Test
    public void acknowledgeTest() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        JMSContext msgcontext = null;
        JMSProducer msgproducer = null;
        JMSConsumer msgconsumer = null;
        try {
            msgcontext = this.cf.createContext(this.user, this.password, 2);
            msgproducer = msgcontext.createProducer();
            msgconsumer = msgcontext.createConsumer((Destination)this.topic);
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            TextMessage expTextMessage = msgcontext.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "acknowledgeTest");
            logger.log(System.Logger.Level.INFO, "Sending TextMessage via JMSProducer.send(Destination, Message)");
            msgproducer.send(this.destination, (Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "Receive TextMessage");
            TextMessage actTextMessage = (TextMessage)msgconsumer.receive(this.timeout);
            logger.log(System.Logger.Level.INFO, "Received message: " + actTextMessage.getText());
            logger.log(System.Logger.Level.INFO, "Calling acknowlege to acknowledge message.");
            msgcontext.acknowledge();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("acknowledgeTest", e);
        }
        finally {
            try {
                if (msgconsumer != null) {
                    msgconsumer.close();
                }
                if (msgcontext != null) {
                    msgcontext.close();
                }
                msgproducer = null;
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("acknowledgeTest failed");
        }
    }

    @Test
    public void commitRollbackTest() throws Exception {
        boolean pass = true;
        try {
            int i;
            TextMessage tempMsg = null;
            this.context.close();
            logger.log(System.Logger.Level.INFO, "Create transacted JMSContext, JMSConsumer and JMSProducer");
            this.context = this.cf.createContext(this.user, this.password, 0);
            this.producer = this.context.createProducer();
            this.consumer = this.context.createConsumer(this.destination);
            logger.log(System.Logger.Level.INFO, "Send 3 messages to Topic and call rollback()");
            for (i = 1; i <= 3; ++i) {
                tempMsg = this.context.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "commitRollbackTest" + i);
                this.producer.send(this.destination, (Message)tempMsg);
                logger.log(System.Logger.Level.INFO, "Message " + i + " sent");
            }
            logger.log(System.Logger.Level.INFO, "Calling rollback() to rollback the sent messages");
            this.context.rollback();
            logger.log(System.Logger.Level.INFO, "Should not consume any messages in Topic since rollback() was called");
            tempMsg = (TextMessage)this.consumer.receive(this.timeout);
            if (tempMsg != null) {
                logger.log(System.Logger.Level.ERROR, "Received message " + tempMsg.getText() + ", expected NULL (NO MESSAGES)");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Send 3 messages to Topic and call commit()");
            for (i = 1; i <= 3; ++i) {
                tempMsg = this.context.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "commitRollbackTest" + i);
                this.producer.send(this.destination, (Message)tempMsg);
                logger.log(System.Logger.Level.INFO, "Message " + i + " sent");
            }
            logger.log(System.Logger.Level.INFO, "Calling commit() to commit the sent messages");
            this.context.commit();
            logger.log(System.Logger.Level.INFO, "Should consume all messages in Topic since commit() was called");
            for (int msgCount = 1; msgCount <= 3; ++msgCount) {
                tempMsg = (TextMessage)this.consumer.receive(this.timeout);
                if (tempMsg == null) {
                    logger.log(System.Logger.Level.ERROR, "JMSConsumer.receive() returned NULL");
                    logger.log(System.Logger.Level.ERROR, "Message " + msgCount + " missing from Topic");
                    pass = false;
                    continue;
                }
                if (!tempMsg.getText().equals("Message " + msgCount)) {
                    logger.log(System.Logger.Level.ERROR, "Received [" + tempMsg.getText() + "] expected [Message " + msgCount + "]");
                    pass = false;
                    continue;
                }
                logger.log(System.Logger.Level.INFO, "Received message: " + tempMsg.getText());
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("commitRollbackTest");
        }
        if (!pass) {
            throw new Exception("commitRollbackTest failed");
        }
    }

    @Test
    public void invalidDestinationRuntimeExceptionTests() throws Exception {
        boolean pass;
        block9: {
            pass = true;
            Destination invalidDestination = null;
            Object invalidTopic = null;
            String message = "Where are you!";
            HashMap<String, Object> mapMsgSend = new HashMap<String, Object>();
            mapMsgSend.put("StringValue", "sendAndRecvTest7");
            mapMsgSend.put("BooleanValue", true);
            mapMsgSend.put("IntValue", 10);
            try {
                logger.log(System.Logger.Level.INFO, "Creating JMSConsumer");
                this.consumer = this.context.createConsumer(this.destination);
                logger.log(System.Logger.Level.INFO, "Creating JMSProducer");
                this.producer = this.context.createProducer();
                logger.log(System.Logger.Level.INFO, "Creating TextMessage");
                TextMessage expTextMessage = this.context.createTextMessage(message);
                logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
                expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "invalidDestinationRuntimeExceptionTests");
                MyCompletionListener listener = new MyCompletionListener();
                logger.log(System.Logger.Level.INFO, "Testing JMSProducer.send(Destination, Message) for InvalidDestinationRuntimeException");
                try {
                    logger.log(System.Logger.Level.INFO, "Calling JMSProducer.setAsync(CompletionListener)");
                    this.producer.setAsync((CompletionListener)listener);
                    logger.log(System.Logger.Level.INFO, "Calling JMSProducer.send(Destination, Message) -> expect InvalidDestinationRuntimeException");
                    this.producer.send(invalidDestination, (Message)expTextMessage);
                    logger.log(System.Logger.Level.INFO, "Poll listener until we receive exception");
                    Exception exception = null;
                    for (int i = 0; i < 30 && !listener.isComplete(); ++i) {
                        TestUtil.sleepSec((int)2);
                    }
                    exception = listener.getException();
                    if (exception == null) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Didn't throw and exception");
                        break block9;
                    }
                    logger.log(System.Logger.Level.INFO, "Check the value in Exception");
                    if (exception instanceof InvalidDestinationRuntimeException) {
                        logger.log(System.Logger.Level.INFO, "Exception is expected InvalidDestinationRuntimeException");
                        break block9;
                    }
                    logger.log(System.Logger.Level.ERROR, "Exception is incorrect expected InvalidDestinationRuntimeException, received " + exception.getCause());
                    pass = false;
                }
                catch (InvalidDestinationRuntimeException e) {
                    logger.log(System.Logger.Level.INFO, "Got InvalidDestinationRuntimeException as expected.");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Expected InvalidDestinationRuntimeException, received " + e);
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                throw new Exception("invalidDestinationRuntimeExceptionTests", e);
            }
        }
        if (!pass) {
            throw new Exception("invalidDestinationRuntimeExceptionTests failed");
        }
    }

    @Test
    public void messageFormatRuntimeExceptionTests() throws Exception {
        boolean pass;
        block9: {
            pass = true;
            try {
                logger.log(System.Logger.Level.INFO, "Creating JMSConsumer");
                this.consumer = this.context.createConsumer(this.destination);
                logger.log(System.Logger.Level.INFO, "Creating JMSProducer");
                this.producer = this.context.createProducer();
                MyCompletionListener listener = new MyCompletionListener();
                logger.log(System.Logger.Level.INFO, "Testing JMSProducer.send(Destination, Message) for MessageFormatRuntimeException");
                try {
                    logger.log(System.Logger.Level.INFO, "Calling JMSProducer.setAsync(CompletionListener)");
                    this.producer.setAsync((CompletionListener)listener);
                    logger.log(System.Logger.Level.INFO, "Calling JMSProducer.send(Destination, Message) -> expect MessageFormatRuntimeException");
                    this.producer.send(this.destination, (Message)null);
                    logger.log(System.Logger.Level.INFO, "Poll listener until we receive exception");
                    Throwable exception = null;
                    for (int i = 0; i < 30 && !listener.isComplete(); ++i) {
                        TestUtil.sleepSec((int)2);
                    }
                    if (exception == null) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Didn't throw and exception");
                        break block9;
                    }
                    logger.log(System.Logger.Level.INFO, "Check the value in Exception");
                    if (exception instanceof MessageFormatRuntimeException) {
                        logger.log(System.Logger.Level.INFO, "Exception is expected MessageFormatRuntimeException");
                        break block9;
                    }
                    logger.log(System.Logger.Level.ERROR, "Exception is incorrect expected MessageFormatRuntimeException, received " + exception.getCause());
                    pass = false;
                }
                catch (MessageFormatRuntimeException e) {
                    logger.log(System.Logger.Level.INFO, "Got MessageFormatRuntimeException as expected.");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Expected MessageFormatRuntimeException, received " + e);
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                throw new Exception("messageFormatRuntimeExceptionTests", e);
            }
        }
        if (!pass) {
            throw new Exception("messageFormatRuntimeExceptionTests failed");
        }
    }

    @Test
    public void jMSRuntimeExceptionTests() throws Exception {
        boolean pass;
        block17: {
            pass = true;
            String message = "Where are you!";
            try {
                int i;
                Throwable exception;
                logger.log(System.Logger.Level.INFO, "Creating JMSConsumer");
                this.consumer = this.context.createConsumer(this.destination);
                logger.log(System.Logger.Level.INFO, "Creating JMSProducer");
                this.producer = this.context.createProducer();
                MyCompletionListener listener = new MyCompletionListener();
                logger.log(System.Logger.Level.INFO, "Creating TextMessage");
                TextMessage expTextMessage = this.context.createTextMessage(message);
                logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
                expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "jMSRuntimeExceptionTests");
                try {
                    logger.log(System.Logger.Level.INFO, "Set completion listener");
                    logger.log(System.Logger.Level.INFO, "Calling JMSProducer.setAsync(CompletionListener)");
                    this.producer.setAsync((CompletionListener)listener);
                    logger.log(System.Logger.Level.INFO, "Try and set an invalid delivery mode of -1 on send");
                    this.producer.setDeliveryMode(-1);
                    logger.log(System.Logger.Level.INFO, "Calling JMSProducer.send(Destination, Message) -> expect JMSRuntimeException");
                    this.producer.send(this.destination, (Message)expTextMessage);
                    logger.log(System.Logger.Level.INFO, "Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 30 && !listener.isComplete(); ++i) {
                        TestUtil.sleepSec((int)2);
                    }
                    if (exception == null) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Didn't throw and exception");
                    } else {
                        logger.log(System.Logger.Level.INFO, "Check the value in Exception");
                        if (exception instanceof JMSRuntimeException) {
                            logger.log(System.Logger.Level.INFO, "Exception is expected JMSRuntimeException");
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Exception is incorrect expected JMSRuntimeException, received " + exception.getCause());
                            pass = false;
                        }
                    }
                }
                catch (JMSRuntimeException e) {
                    logger.log(System.Logger.Level.INFO, "Caught expected JMSRuntimeException");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Expected JMSRuntimeException, received " + e);
                    pass = false;
                }
                try {
                    logger.log(System.Logger.Level.INFO, "Set completion listener");
                    logger.log(System.Logger.Level.INFO, "Calling JMSProducer.setAsync(CompletionListener)");
                    this.producer.setAsync((CompletionListener)listener);
                    logger.log(System.Logger.Level.INFO, "Try and set an invalid priority of -1 on send");
                    this.producer.setDeliveryMode(1);
                    this.producer.setPriority(-1);
                    logger.log(System.Logger.Level.INFO, "Calling JMSProducer.send(Destination, Message) -> expect JMSRuntimeException");
                    this.producer.send(this.destination, (Message)expTextMessage);
                    logger.log(System.Logger.Level.INFO, "Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 30 && !listener.isComplete(); ++i) {
                        TestUtil.sleepSec((int)2);
                    }
                    if (exception == null) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Didn't throw and exception");
                        break block17;
                    }
                    logger.log(System.Logger.Level.INFO, "Check the value in Exception");
                    if (exception instanceof JMSRuntimeException) {
                        logger.log(System.Logger.Level.INFO, "Exception is expected JMSRuntimeException");
                        break block17;
                    }
                    logger.log(System.Logger.Level.ERROR, "Exception is incorrect expected JMSRuntimeException, received " + exception.getCause());
                    pass = false;
                }
                catch (JMSRuntimeException e) {
                    logger.log(System.Logger.Level.INFO, "Caught expected JMSRuntimeException");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Expected JMSRuntimeException, received " + e);
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                throw new Exception("jMSRuntimeExceptionTests", e);
            }
        }
        if (!pass) {
            throw new Exception("jMSRuntimeExceptionTests failed");
        }
    }
}

