/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core20.appclient.jmscontextqueuetests;

import jakarta.jms.CompletionListener;
import jakarta.jms.IllegalStateRuntimeException;
import jakarta.jms.JMSContext;
import jakarta.jms.Message;
import jakarta.jms.TextMessage;
import java.util.ArrayList;

public class MyCompletionListener
implements CompletionListener {
    private String name = null;
    private Message message = null;
    private JMSContext context = null;
    private ArrayList<Message> messages = new ArrayList();
    private Exception exception = null;
    private int numMessages = 1;
    boolean complete = false;
    boolean gotCorrectException = false;
    boolean gotException = false;
    private static final System.Logger logger = System.getLogger(MyCompletionListener.class.getName());

    public MyCompletionListener() {
        this("MyCompletionListener");
    }

    public MyCompletionListener(String name) {
        this.name = name;
    }

    public MyCompletionListener(int numMessages) {
        this.numMessages = numMessages;
        this.messages.clear();
    }

    public MyCompletionListener(JMSContext context) {
        this.context = context;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Message getMessage() {
        return this.message;
    }

    public Message getMessage(int index) {
        return this.messages.get(index);
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public boolean gotAllMsgs() {
        return this.messages.size() == this.numMessages;
    }

    public boolean haveMsg(int i) {
        return this.messages.size() > i;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean gotCorrectException() {
        return this.gotCorrectException;
    }

    public boolean gotException() {
        return this.gotException;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public void onCompletion(Message message) {
        try {
            logger.log(System.Logger.Level.INFO, "onCompletion(): Got Message: " + ((TextMessage)message).getText());
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
        }
        this.message = message;
        this.messages.add(message);
        if (message instanceof TextMessage) {
            TextMessage tMsg = (TextMessage)message;
            try {
                if (tMsg.getText().equals("Call close method")) {
                    logger.log(System.Logger.Level.INFO, "Calling JMSContext.close() MUST throw IllegalStateRuntimeException");
                    if (this.context != null) {
                        this.context.close();
                    }
                } else if (tMsg.getText().equals("Call stop method")) {
                    logger.log(System.Logger.Level.INFO, "Calling JMSContext.stop() MUST be allowed");
                    if (this.context != null) {
                        this.context.stop();
                    }
                } else if (tMsg.getText().equals("Call commit method")) {
                    logger.log(System.Logger.Level.INFO, "Calling JMSContext.commit() MUST throw IllegalStateRuntimeException");
                    if (this.context != null) {
                        this.context.commit();
                    }
                } else if (tMsg.getText().equals("Call rollback method")) {
                    logger.log(System.Logger.Level.INFO, "Calling JMSContext.rollback() MUST throw IllegalStateRuntimeException");
                    if (this.context != null) {
                        this.context.rollback();
                    }
                }
            }
            catch (IllegalStateRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected IllegalStateRuntimeException");
                this.gotCorrectException = true;
                this.gotException = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                this.gotCorrectException = false;
                this.gotException = true;
                this.exception = e;
            }
        }
        this.complete = true;
    }

    public void onException(Message message, Exception exception) {
        logger.log(System.Logger.Level.INFO, "Got Exception: " + exception);
        logger.log(System.Logger.Level.INFO, "With Message: " + message);
        this.exception = exception;
        this.message = message;
        this.complete = true;
    }
}

