/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.topicConnection;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.Message;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicSession;
import jakarta.jms.TopicSubscriber;
import java.util.ArrayList;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TopicConnectionTestsIT {
    private static final String testName = "com.sun.ts.tests.jms.core.topicConnection.TopicConnectionTestsIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private static final System.Logger logger = System.getLogger(TopicConnectionTestsIT.class.getName());
    private Properties props = null;
    private transient JmsTool tool = null;
    long timeout;
    private String jmsUser;
    private String jmsPassword;
    private String mode;
    ArrayList connections = null;

    private void checkExceptionPass(boolean passed) throws Exception {
        if (!passed) {
            logger.log(System.Logger.Level.INFO, "Didn't get expected exception");
            throw new Exception("Didn't catch expected exception");
        }
    }

    @BeforeEach
    public void setup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "In setup");
            this.jmsUser = System.getProperty("user");
            this.jmsPassword = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            if (this.timeout < 1L) {
                throw new Exception("'timeout' (milliseconds) in must be > 0");
            }
            this.connections = new ArrayList(5);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            if (this.tool != null) {
                logger.log(System.Logger.Level.INFO, "Cleanup: Closing Topic Connections");
                this.tool.closeAllConnections(this.connections);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            logger.log(System.Logger.Level.ERROR, "An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    @Test
    public void connNotStartedTopicTest() throws Exception {
        boolean pass = true;
        String lookup = "MyTopicConnectionFactory";
        int NUM_MSGS = 5;
        try {
            int i;
            Topic topic = null;
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            TopicConnection nonStartedConn = null;
            TopicSession nonStartedSess = null;
            TopicSubscriber nonStartedSub = null;
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.mode);
            topic = this.tool.getDefaultTopic();
            nonStartedConn = (TopicConnection)this.tool.getNewConnection(1, this.jmsUser, this.jmsPassword, lookup);
            this.connections.add(nonStartedConn);
            nonStartedSess = nonStartedConn.createTopicSession(false, 1);
            nonStartedSub = nonStartedSess.createSubscriber(topic);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.INFO, "Creating message");
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "connNotStartedTopicTest");
            logger.log(System.Logger.Level.INFO, "Publishing messages");
            for (i = 0; i < 5; ++i) {
                messageSent.setText("just a test. Msg num " + i);
                this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            }
            logger.log(System.Logger.Level.INFO, "Receive  messages on started connection");
            for (i = 0; i < 5; ++i) {
                messageReceived = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
                if (messageReceived != null) continue;
                logger.log(System.Logger.Level.INFO, "Fail: Did not receive expected message");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Ensure messages not received on non-started connection");
            for (i = 0; i < 5; ++i) {
                messageReceived = (TextMessage)nonStartedSub.receiveNoWait();
                if (messageReceived == null) continue;
                logger.log(System.Logger.Level.INFO, "Fail: Received message on a non-started connection");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Ensure messages received on now started connection");
            nonStartedConn.start();
            for (i = 0; i < 5; ++i) {
                messageReceived = (TextMessage)nonStartedSub.receive(this.timeout);
                if (messageReceived != null) continue;
                logger.log(System.Logger.Level.INFO, "Fail: Did not receive expected message");
                pass = false;
            }
            nonStartedConn.close();
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("connNotStartedTopicTest");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void metaDataTests() throws Exception {
        boolean pass = true;
        ConnectionMetaData data = null;
        try {
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.mode);
            data = this.tool.getDefaultTopicConnection().getMetaData();
            if (!this.verifyMetaData(data)) {
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            try {
                this.tool.getDefaultTopicConnection().close();
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error closing TopicConnection in metaDataTests : ", (Throwable)e);
            }
        }
        try {
            this.tool = new JmsTool(14, this.jmsUser, this.jmsPassword, this.mode);
            data = this.tool.getDefaultConnection().getMetaData();
            if (!this.verifyMetaData(data)) {
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            try {
                this.tool.getDefaultConnection().close();
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error closing Connection in metaDataTests : ", (Throwable)e);
            }
        }
        if (!pass) {
            throw new Exception("Error: metaDataTests failed");
        }
    }

    private boolean verifyMetaData(ConnectionMetaData data) {
        String tmp;
        boolean pass = true;
        try {
            String tmp2 = data.getJMSVersion();
            logger.log(System.Logger.Level.TRACE, "JMSVersion=" + tmp2);
            if (!tmp2.equals("3.1")) {
                logger.log(System.Logger.Level.ERROR, "Error: incorrect JMSVersion=" + tmp2);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error: incorrect type returned for JMSVersion: ", (Throwable)e);
            pass = false;
        }
        try {
            int tmp3 = data.getJMSMajorVersion();
            logger.log(System.Logger.Level.TRACE, "JMSMajorVersion=" + tmp3);
            if (tmp3 != 3) {
                logger.log(System.Logger.Level.ERROR, "Error: incorrect JMSMajorVersion=" + tmp3);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error: incorrect type returned for JMSMajorVersion: ", (Throwable)e);
            pass = false;
        }
        try {
            int tmp4 = data.getJMSMinorVersion();
            logger.log(System.Logger.Level.TRACE, "JMSMinorVersion=" + tmp4);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error: incorrect type returned for JMSMinorVersion: ", (Throwable)e);
            pass = false;
        }
        try {
            tmp = data.getJMSProviderName();
            logger.log(System.Logger.Level.TRACE, "JMSProviderName=" + tmp);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error: incorrect type returned for JMSProviderName: ", (Throwable)e);
            pass = false;
        }
        try {
            tmp = data.getProviderVersion();
            logger.log(System.Logger.Level.TRACE, "JMSProviderVersion=" + tmp);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error: incorrect type returned for ProviderVersion: ", (Throwable)e);
            pass = false;
        }
        try {
            int tmp5 = data.getProviderMajorVersion();
            logger.log(System.Logger.Level.TRACE, "ProviderMajorVersion=" + tmp5);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error: incorrect type returned for ProviderMajorVersion: ", (Throwable)e);
            pass = false;
        }
        try {
            int tmp6 = data.getProviderMinorVersion();
            logger.log(System.Logger.Level.TRACE, "ProviderMinorVersion=" + tmp6);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error: incorrect type returned for ProviderMinorVersion: ", (Throwable)e);
            pass = false;
        }
        return pass;
    }
}

