/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.queueConnection;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.Message;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSession;
import jakarta.jms.TextMessage;
import java.util.ArrayList;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class QueueConnectionTestsIT {
    private static final String testName = "com.sun.ts.tests.jms.core.queueConnection.QueueConnectionTestsIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private static final System.Logger logger = System.getLogger(QueueConnectionTestsIT.class.getName());
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList queues = null;
    ArrayList connections = null;

    @BeforeEach
    public void setup() throws Exception {
        try {
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' is null");
            }
            if (this.password == null) {
                throw new Exception("'password' is null");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' is null");
            }
            this.queues = new ArrayList(2);
            this.connections = new ArrayList(5);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            if (this.tool != null) {
                logger.log(System.Logger.Level.INFO, "Cleanup: Closing Queue Connections");
                this.tool.doClientQueueTestCleanup(this.connections, this.queues);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            logger.log(System.Logger.Level.ERROR, "An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    @Test
    public void connNotStartedQueueTest() throws Exception {
        boolean pass = true;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            QueueReceiver qRec = null;
            QueueConnection newConn = null;
            QueueSession newSess = null;
            QueueReceiver newRec = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueReceiver().close();
            qRec = this.tool.getDefaultQueueSession().createReceiver(this.tool.getDefaultQueue(), "targetMessage = TRUE");
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText("just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "connNotStartedQueueTest");
            logger.log(System.Logger.Level.INFO, "Sending two TextMessages");
            messageSent.setBooleanProperty("targetMessage", false);
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            messageSent.setBooleanProperty("targetMessage", true);
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            logger.log(System.Logger.Level.INFO, "Receiving second message only");
            messageReceived = (TextMessage)qRec.receive(this.timeout);
            if (messageReceived == null) {
                logger.log(System.Logger.Level.ERROR, "Fail: Did not receive any message");
                pass = false;
            } else if (!messageReceived.getBooleanProperty("targetMessage")) {
                logger.log(System.Logger.Level.ERROR, "Fail: Received incorrect message");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Closing receiver, creating new connection without starting");
            qRec.close();
            this.tool.getDefaultQueueConnection().close();
            newConn = (QueueConnection)this.tool.getNewConnection(0, this.user, this.password);
            this.connections.add(newConn);
            newSess = newConn.createQueueSession(false, 1);
            newRec = newSess.createReceiver(this.tool.getDefaultQueue());
            logger.log(System.Logger.Level.INFO, "receiving first message");
            messageReceived = (TextMessage)newRec.receiveNoWait();
            if (messageReceived == null) {
                logger.log(System.Logger.Level.INFO, "Pass: message not recevied");
            } else {
                logger.log(System.Logger.Level.ERROR, "Fail: message received even though connection not started!");
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("connNotStartedQueueTest");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void metaDataTests() throws Exception {
        boolean pass = true;
        ConnectionMetaData data = null;
        try {
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            data = this.tool.getDefaultQueueConnection().getMetaData();
            if (!this.verifyMetaData(data)) {
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            try {
                this.tool.getDefaultQueueConnection().close();
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error closing QueueConnection in metaDataTests : ", (Throwable)e);
            }
        }
        try {
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            data = this.tool.getDefaultConnection().getMetaData();
            if (!this.verifyMetaData(data)) {
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            try {
                this.tool.getDefaultConnection().close();
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error closing Connection in metaDataTests : ", (Throwable)e);
            }
        }
        if (!pass) {
            throw new Exception("Error: metaDataTests failed");
        }
    }

    private boolean verifyMetaData(ConnectionMetaData data) {
        String tmp;
        boolean pass = true;
        try {
            String tmp2 = data.getJMSVersion();
            logger.log(System.Logger.Level.TRACE, "JMSVersion=" + tmp2);
            if (!tmp2.equals("3.1")) {
                logger.log(System.Logger.Level.ERROR, "Error: incorrect JMSVersion=" + tmp2);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error: incorrect type returned for JMSVersion: ", (Throwable)e);
            pass = false;
        }
        try {
            int tmp3 = data.getJMSMajorVersion();
            logger.log(System.Logger.Level.TRACE, "JMSMajorVersion=" + tmp3);
            if (tmp3 != 3) {
                logger.log(System.Logger.Level.ERROR, "Error: incorrect JMSMajorVersion=" + tmp3);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error: incorrect type returned for JMSMajorVersion: ", (Throwable)e);
            pass = false;
        }
        try {
            int tmp4 = data.getJMSMinorVersion();
            logger.log(System.Logger.Level.TRACE, "JMSMinorVersion=" + tmp4);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error: incorrect type returned for JMSMinorVersion: ", (Throwable)e);
            pass = false;
        }
        try {
            tmp = data.getJMSProviderName();
            logger.log(System.Logger.Level.TRACE, "JMSProviderName=" + tmp);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error: incorrect type returned for JMSProviderName: ", (Throwable)e);
            pass = false;
        }
        try {
            tmp = data.getProviderVersion();
            logger.log(System.Logger.Level.TRACE, "JMSProviderVersion=" + tmp);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error: incorrect type returned for ProviderVersion: ", (Throwable)e);
            pass = false;
        }
        try {
            int tmp5 = data.getProviderMajorVersion();
            logger.log(System.Logger.Level.TRACE, "ProviderMajorVersion=" + tmp5);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error: incorrect type returned for ProviderMajorVersion: ", (Throwable)e);
            pass = false;
        }
        try {
            int tmp6 = data.getProviderMinorVersion();
            logger.log(System.Logger.Level.TRACE, "ProviderMinorVersion=" + tmp6);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error: incorrect type returned for ProviderMinorVersion: ", (Throwable)e);
            pass = false;
        }
        return pass;
    }
}

