/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.closedTopicPublisher;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import com.sun.ts.tests.jms.common.MessageTestImpl;
import jakarta.jms.IllegalStateException;
import jakarta.jms.Message;
import jakarta.jms.Topic;
import java.util.ArrayList;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClosedTopicPublisherTestsIT {
    private static final String testName = "com.sun.ts.tests.jms.core.closedTopicPublisher.ClosedTopicPublisherIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private static final System.Logger logger = System.getLogger(ClosedTopicPublisherTestsIT.class.getName());
    private Properties props = null;
    private transient JmsTool tool = null;
    long timeout;
    private String jmsUser;
    private String jmsPassword;
    private String mode;
    ArrayList connections = null;

    private void checkExceptionPass(boolean passed) throws Exception {
        if (!passed) {
            logger.log(System.Logger.Level.INFO, "Didn't get expected exception");
            throw new Exception("Didn't catch expected exception");
        }
    }

    @BeforeEach
    public void setup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "In setup");
            this.jmsUser = System.getProperty("user");
            this.jmsPassword = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            if (this.timeout < 1L) {
                throw new Exception("'timeout' (milliseconds) in must be > 0");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            if (this.tool != null) {
                logger.log(System.Logger.Level.INFO, "Cleanup: Closing Queue and Topic Connections");
                this.tool.closeAllConnections(this.connections);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            logger.log(System.Logger.Level.ERROR, "An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    private void createAndClosePublisher() throws Exception {
        this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.mode);
        this.tool.getDefaultTopicConnection().start();
        logger.log(System.Logger.Level.TRACE, "Closing topic publisher");
        this.tool.getDefaultTopicPublisher().close();
        logger.log(System.Logger.Level.TRACE, "Publisher closed");
    }

    @Test
    public void closedTopicPublisherCloseTest() throws Exception {
        try {
            this.createAndClosePublisher();
            logger.log(System.Logger.Level.TRACE, "Try to call close again");
            this.tool.getDefaultTopicPublisher().close();
        }
        catch (Exception e) {
            throw new Exception("closedTopicPublisherCloseTest", e);
        }
    }

    @Test
    public void closedTopicPublisherGetDeliveryModeTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndClosePublisher();
            logger.log(System.Logger.Level.TRACE, "Try to call getDeliveryMode");
            try {
                int foo = this.tool.getDefaultTopicPublisher().getDeliveryMode();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicPublisherGetDeliveryModeTest", e);
        }
    }

    @Test
    public void closedTopicPublisherGetDisableMessageIDTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndClosePublisher();
            logger.log(System.Logger.Level.TRACE, "Try to call getDisableMessageID");
            try {
                boolean foo = this.tool.getDefaultTopicPublisher().getDisableMessageID();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicPublisherGetDisableMessageIDTest", e);
        }
    }

    @Test
    public void closedTopicPublisherGetDisableMessageTimestampTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndClosePublisher();
            logger.log(System.Logger.Level.TRACE, "Try to call getDisableMessageTimestamp");
            try {
                boolean foo = this.tool.getDefaultTopicPublisher().getDisableMessageTimestamp();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicPublisherGetDisableMessageTimestampTest", e);
        }
    }

    @Test
    public void closedTopicPublisherGetPriorityTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndClosePublisher();
            logger.log(System.Logger.Level.TRACE, "Try to call getPriority");
            try {
                int foo = this.tool.getDefaultTopicPublisher().getPriority();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicPublisherGetPriorityTest", e);
        }
    }

    @Test
    public void closedTopicPublisherGetTimeToLiveTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndClosePublisher();
            logger.log(System.Logger.Level.TRACE, "Try to call getTimeToLive");
            try {
                long foo = this.tool.getDefaultTopicPublisher().getTimeToLive();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicPublisherGetTimeToLiveTest", e);
        }
    }

    @Test
    public void closedTopicPublisherSetDeliveryModeTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndClosePublisher();
            logger.log(System.Logger.Level.TRACE, "Try to call setDeliveryMode");
            try {
                this.tool.getDefaultTopicPublisher().setDeliveryMode(2);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicPublisherSetDeliveryModeTest", e);
        }
    }

    @Test
    public void closedTopicPublisherSetDisableMessageIDTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndClosePublisher();
            logger.log(System.Logger.Level.TRACE, "Try to call setDisableMessageID");
            try {
                this.tool.getDefaultTopicPublisher().setDisableMessageID(true);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicPublisherSetDisableMessageIDTest", e);
        }
    }

    @Test
    public void closedTopicPublisherSetDisableMessageTimestampTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndClosePublisher();
            logger.log(System.Logger.Level.TRACE, "Try to call setDisableMessageTimestamp");
            try {
                this.tool.getDefaultTopicPublisher().setDisableMessageTimestamp(true);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicPublisherSetDisableMessageTimestampTest", e);
        }
    }

    @Test
    public void closedTopicPublisherSetPriorityTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndClosePublisher();
            logger.log(System.Logger.Level.TRACE, "Try to call setPriority");
            try {
                this.tool.getDefaultTopicPublisher().setPriority(4);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicPublisherSetPriorityTest", e);
        }
    }

    @Test
    public void closedTopicPublisherSetTimeToLiveTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndClosePublisher();
            logger.log(System.Logger.Level.TRACE, "Try to call setTimeToLive");
            try {
                this.tool.getDefaultTopicPublisher().setTimeToLive(0L);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicPublisherSetTimeToLiveTest", e);
        }
    }

    @Test
    public void closedTopicPublisherGetTopicTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndClosePublisher();
            logger.log(System.Logger.Level.TRACE, "Try to call getTopic");
            try {
                Topic foo = this.tool.getDefaultTopicPublisher().getTopic();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicPublisherGetTopicTest", e);
        }
    }

    @Test
    public void closedTopicPublisherPublish1Test() throws Exception {
        boolean passed = false;
        try {
            this.createAndClosePublisher();
            logger.log(System.Logger.Level.TRACE, "Try to call publish(Message)");
            try {
                this.tool.getDefaultTopicPublisher().publish((Message)new MessageTestImpl());
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicPublisherPublish1Test", e);
        }
    }

    @Test
    public void closedTopicPublisherPublish2Test() throws Exception {
        boolean passed = false;
        try {
            this.createAndClosePublisher();
            logger.log(System.Logger.Level.TRACE, "Try to call publish(Message,int,int,long)");
            try {
                this.tool.getDefaultTopicPublisher().publish((Message)new MessageTestImpl(), 2, 4, 0L);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedTopicPublisherPublish2Test", e);
        }
    }
}

