/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.closedQueueSession;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import com.sun.ts.tests.jms.common.MessageTestImpl;
import jakarta.jms.BytesMessage;
import jakarta.jms.IllegalStateException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TextMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClosedQueueSessionTestsIT {
    private static final String TestName = "com.sun.ts.tests.jms.core.closedQueueSession.ClosedQueueSessionTestsIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private static final System.Logger logger = System.getLogger(ClosedQueueSessionTestsIT.class.getName());
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList queues = null;
    ArrayList connections = null;

    private void createAndCloseSession(int type, String user, String password) throws Exception {
        if (type == 0 || type == 2) {
            this.tool = new JmsTool(type, user, password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.INFO, "Closing QueueSession");
            this.tool.getDefaultQueueSession().close();
        } else if (type == 15) {
            this.tool = new JmsTool(type, user, password, this.mode);
            this.tool.getDefaultConnection().start();
            logger.log(System.Logger.Level.INFO, "Closing Session");
            this.tool.getDefaultSession().close();
        } else {
            logger.log(System.Logger.Level.ERROR, "Unspecified type");
        }
    }

    @BeforeEach
    public void setup() throws Exception {
        try {
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' is null");
            }
            if (this.password == null) {
                throw new Exception("'password' is null");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' is null");
            }
            this.queues = new ArrayList(2);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            if (this.tool != null) {
                logger.log(System.Logger.Level.INFO, "Cleanup: Closing QueueConnection");
                this.tool.doClientQueueTestCleanup(this.connections, this.queues);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            logger.log(System.Logger.Level.ERROR, "An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    @Test
    public void closedQueueSessionCloseTest() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Before create and close");
            this.createAndCloseSession(0, this.user, this.password);
            logger.log(System.Logger.Level.INFO, "Try to call close on closed session.");
            this.tool.getDefaultQueueSession().close();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, "fault " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedQueueSessionCloseTest");
        }
    }

    @Test
    public void closedQueueSessionCreateBrowserTest() throws Exception {
        String testName = "closedQueueSessionCreateBrowserTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            logger.log(System.Logger.Level.INFO, "Try to create QueueBrowser with closed session.");
            try {
                QueueBrowser queueBrowser = this.tool.getDefaultQueueSession().createBrowser(this.tool.getDefaultQueue());
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.INFO, "Caught expected exception");
                return;
            }
            throw new Exception(testName);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, " " + e.getMessage());
            throw new Exception("closedQueueSessionCreateBrowserTest", e);
        }
    }

    @Test
    public void closedQueueSessionCreateBrowserMsgSelectorTest() throws Exception {
        String testName = "closedQueueSessionCreateBrowserMsgSelectorTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            logger.log(System.Logger.Level.INFO, "Try to create QueueBrowser with closed session.");
            try {
                QueueBrowser queueBrowser = this.tool.getDefaultQueueSession().createBrowser(this.tool.getDefaultQueue(), "TEST = 'test'");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.INFO, "Caught expected exception");
                return;
            }
            throw new Exception(testName);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, " " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedQueueSessionCreateBrowserMsgSelectorTest");
        }
    }

    @Test
    public void closedQueueSessionCreateQueueTest() throws Exception {
        String testName = "closedQueueSessionCreateQueueTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            logger.log(System.Logger.Level.INFO, "Try to create queue with closed session.");
            try {
                Queue queue = this.tool.getDefaultQueueSession().createQueue(testName);
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.INFO, "Caught expected exception");
                return;
            }
            throw new Exception(testName);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, " " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedQueueSessionCreateQueueTest");
        }
    }

    @Test
    public void closedQueueSessionCreateReceiverTest() throws Exception {
        String testName = "closedQueueSessionCreateReceiverTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            logger.log(System.Logger.Level.INFO, "Try to create Receiver with closed session.");
            try {
                QueueReceiver queueReceiver = this.tool.getDefaultQueueSession().createReceiver(this.tool.getDefaultQueue());
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.INFO, "Caught expected exception");
                return;
            }
            throw new Exception(testName);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, " " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedQueueSessionCreateReceiverTest");
        }
    }

    @Test
    public void closedQueueSessionCreateReceiverMsgSelectorTest() throws Exception {
        String testName = "closedQueueSessionCreateReceiverMsgSelectorTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            logger.log(System.Logger.Level.INFO, "Try to create Receiver with closed session.");
            try {
                QueueReceiver queueReceiver = this.tool.getDefaultQueueSession().createReceiver(this.tool.getDefaultQueue(), "TEST = 'test'");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.INFO, "Caught expected exception");
                return;
            }
            throw new Exception(testName);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, " " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedQueueSessionCreateReceiverMsgSelectorTest");
        }
    }

    @Test
    public void closedQueueSessionCreateSenderTest() throws Exception {
        String testName = "closedQueueSessionCreateSenderTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            logger.log(System.Logger.Level.INFO, "Try to create Sender with closed session.");
            try {
                QueueSender queueSender = this.tool.getDefaultQueueSession().createSender(this.tool.getDefaultQueue());
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.INFO, "Caught expected exception");
                return;
            }
            throw new Exception(testName);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, " " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedQueueSessionCreateSenderTest");
        }
    }

    @Test
    public void closedQueueSessionCreateTempQueueTest() throws Exception {
        String testName = "closedQueueSessionCreateTempQueueTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            logger.log(System.Logger.Level.INFO, "Try to create TemporaryQueue with closed session.");
            try {
                TemporaryQueue temporaryQueue = this.tool.getDefaultQueueSession().createTemporaryQueue();
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.INFO, "Caught expected exception");
                return;
            }
            throw new Exception(testName);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, " " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedQueueSessionCreateTempQueueTest");
        }
    }

    @Test
    public void closedQueueSessionCreateMessageTest() throws Exception {
        String testName = "closedQueueSessionCreateMessageTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            logger.log(System.Logger.Level.INFO, "Try to create message with closed session.");
            try {
                Message message = this.tool.getDefaultQueueSession().createMessage();
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.INFO, "Caught expected exception");
                return;
            }
            throw new Exception(testName);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, " " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedQueueSessionCreateMessageTest");
        }
    }

    @Test
    public void closedQueueSessionCreateBytesMessageTest() throws Exception {
        String testName = "closedQueueSessionCreateBytesMessageTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            logger.log(System.Logger.Level.INFO, "Try to create BytesMessage with closed session.");
            try {
                BytesMessage bytesMessage = this.tool.getDefaultQueueSession().createBytesMessage();
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.INFO, "Caught expected exception");
                return;
            }
            throw new Exception(testName);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, " " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedQueueSessionCreateBytesMessageTest");
        }
    }

    @Test
    public void closedQueueSessionCreateMapMessageTest() throws Exception {
        String testName = "closedQueueSessionCreateMapMessageTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            logger.log(System.Logger.Level.INFO, "Try to create MapMessage with closed session.");
            try {
                MapMessage mapMessage = this.tool.getDefaultQueueSession().createMapMessage();
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.INFO, "Caught expected exception");
                return;
            }
            throw new Exception(testName);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, " " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedQueueSessionCreateMapMessageTest");
        }
    }

    @Test
    public void closedQueueSessionCreateObjectMessageTest() throws Exception {
        String testName = "closedQueueSessionCreateObjectMessageTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            logger.log(System.Logger.Level.INFO, "Try to create ObjectMessage with closed session.");
            try {
                ObjectMessage m = this.tool.getDefaultQueueSession().createObjectMessage();
                if (m != null) {
                    logger.log(System.Logger.Level.TRACE, "m=" + m);
                }
                logger.log(System.Logger.Level.TRACE, "FAIL: expected IllegalStateException");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.INFO, "Caught expected exception");
                return;
            }
            throw new Exception(testName);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, " " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedQueueSessionCreateObjectMessageTest");
        }
    }

    @Test
    public void closedQueueSessionCreateObject2MessageTest() throws Exception {
        String testName = "closedQueueSessionCreateObject2MessageTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            logger.log(System.Logger.Level.INFO, "Try to create ObjectMessage(object) with closed session.");
            try {
                String s = "Simple object";
                ObjectMessage m = this.tool.getDefaultQueueSession().createObjectMessage((Serializable)((Object)s));
                if (m != null) {
                    logger.log(System.Logger.Level.TRACE, "m=" + m);
                }
                logger.log(System.Logger.Level.TRACE, "FAIL: expected IllegalStateException");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.INFO, "Caught expected exception");
                return;
            }
            throw new Exception(testName);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, " " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedQueueSessionCreateObject2MessageTest");
        }
    }

    @Test
    public void closedQueueSessionCreateStreamMessageTest() throws Exception {
        String testName = "closedQueueSessionCreateStreamMessageTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            logger.log(System.Logger.Level.INFO, "Try to create StreamMessage with closed session.");
            try {
                StreamMessage streamMessage = this.tool.getDefaultQueueSession().createStreamMessage();
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.INFO, "Caught expected exception");
                return;
            }
            throw new Exception(testName);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, " " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedQueueSessionCreateStreamMessageTest");
        }
    }

    @Test
    public void closedQueueSessionCreateTextMessageTest() throws Exception {
        String testName = "closedQueueSessionCreateTextMessageTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            logger.log(System.Logger.Level.INFO, "Try to create TextMessage with closed session.");
            try {
                TextMessage textMessage = this.tool.getDefaultQueueSession().createTextMessage();
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.INFO, "Caught expected exception");
                return;
            }
            throw new Exception(testName);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, " " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedQueueSessionCreateTextMessageTest");
        }
    }

    @Test
    public void closedQueueSessionCreateText2MessageTest() throws Exception {
        String testName = "closedQueueSessionCreateText2MessageTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            logger.log(System.Logger.Level.INFO, "Try to create TextMessage with closed session.");
            try {
                TextMessage textMessage = this.tool.getDefaultQueueSession().createTextMessage("test message");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.INFO, "Caught expected exception");
                return;
            }
            throw new Exception(testName);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, " " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedQueueSessionCreateText2MessageTest");
        }
    }

    @Test
    public void closedQueueSessionReceiverCloseTest() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call close again");
            this.tool.getDefaultQueueReceiver().close();
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionReceiverCloseTest", e);
        }
    }

    @Test
    public void closedQueueSessionGetMessageSelectorTest() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call getMessageSelector");
            try {
                String foo = this.tool.getDefaultQueueReceiver().getMessageSelector();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new Exception("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionGetMessageSelectorTest", e);
        }
    }

    @Test
    public void closedQueueSessionReceiveTest() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call receive");
            try {
                Message foo = this.tool.getDefaultQueueReceiver().receive();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new Exception("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionReceiveTest", e);
        }
    }

    @Test
    public void closedQueueSessionReceiveTimeoutTest() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call receive(timeout)");
            try {
                Message foo = this.tool.getDefaultQueueReceiver().receive(this.timeout);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new Exception("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionReceiveTimeoutTest", e);
        }
    }

    @Test
    public void closedQueueSessionReceiveNoWaitTest() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call receiveNoWait");
            try {
                Message foo = this.tool.getDefaultQueueReceiver().receiveNoWait();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new Exception("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionReceiveNoWaitTest", e);
        }
    }

    @Test
    public void closedQueueSessionReceiverGetQueueTest() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call getQueue");
            try {
                Queue foo = this.tool.getDefaultQueueReceiver().getQueue();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new Exception("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionReceiverGetQueueTest", e);
        }
    }

    @Test
    public void closedQueueSessionSenderCloseTest() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call close again");
            this.tool.getDefaultQueueSender().close();
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionSenderCloseTest", e);
        }
    }

    @Test
    public void closedQueueSessionGetDeliveryModeTest() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call getDeliveryMode");
            try {
                int foo = this.tool.getDefaultQueueSender().getDeliveryMode();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new Exception("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionGetDeliveryModeTest", e);
        }
    }

    @Test
    public void closedQueueSessionGetDisableMessageIDTest() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call getDisableMessageID");
            try {
                boolean foo = this.tool.getDefaultQueueSender().getDisableMessageID();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new Exception("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionGetDisableMessageIDTest", e);
        }
    }

    @Test
    public void closedQueueSessionGetDisableMessageTimestampTest() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call getDisableMessageTimestamp");
            try {
                boolean foo = this.tool.getDefaultQueueSender().getDisableMessageTimestamp();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new Exception("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionGetDisableMessageTimestampTest", e);
        }
    }

    @Test
    public void closedQueueSessionGetPriorityTest() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call getPriority");
            try {
                int foo = this.tool.getDefaultQueueSender().getPriority();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new Exception("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionGetPriorityTest", e);
        }
    }

    @Test
    public void closedQueueSessionGetTimeToLiveTest() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call getTimeToLive");
            try {
                long foo = this.tool.getDefaultQueueSender().getTimeToLive();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new Exception("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionGetTimeToLiveTest", e);
        }
    }

    @Test
    public void closedQueueSessionSetDeliveryModeTest() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call setDeliveryMode");
            try {
                this.tool.getDefaultQueueSender().setDeliveryMode(2);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new Exception("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionSetDeliveryModeTest", e);
        }
    }

    @Test
    public void closedQueueSessionSetDisableMessageIDTest() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call setDisableMessageID");
            try {
                this.tool.getDefaultQueueSender().setDisableMessageID(true);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new Exception("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionSetDisableMessageIDTest", e);
        }
    }

    @Test
    public void closedQueueSessionSetDisableMessageTimestampTest() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call setDisableMessageTimestamp");
            try {
                this.tool.getDefaultQueueSender().setDisableMessageTimestamp(true);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new Exception("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionSetDisableMessageTimestampTest", e);
        }
    }

    @Test
    public void closedQueueSessionSetPriorityTest() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call setPriority");
            try {
                this.tool.getDefaultQueueSender().setPriority(4);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new Exception("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionSetPriorityTest", e);
        }
    }

    @Test
    public void closedQueueSessionSetTimeToLiveTest() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call setTimeToLive");
            try {
                this.tool.getDefaultQueueSender().setTimeToLive(0L);
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new Exception("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionSetTimeToLiveTest", e);
        }
    }

    @Test
    public void closedQueueSessionSenderGetQueueTest() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call getQueue");
            try {
                Queue foo = this.tool.getDefaultQueueSender().getQueue();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new Exception("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionSenderGetQueueTest", e);
        }
    }

    @Test
    public void closedQueueSessionSend1Test() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call send(Message)");
            try {
                this.tool.getDefaultQueueSender().send((Message)new MessageTestImpl());
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new Exception("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionSend1Test", e);
        }
    }

    @Test
    public void closedQueueSessionSend2Test() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call send(Message,int,int,long)");
            try {
                this.tool.getDefaultQueueSender().send((Message)new MessageTestImpl(), 2, 4, 0L);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new Exception("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionSend2Test", e);
        }
    }

    @Test
    public void closedQueueSessionSend3Test() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call send(Queue,Message)");
            try {
                this.tool.getDefaultQueueSender().send((Message)new MessageTestImpl());
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new Exception("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionSend3Test", e);
        }
    }

    @Test
    public void closedQueueSessionSend4Test() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            logger.log(System.Logger.Level.TRACE, "Try to call send(Queue,Message,int,int,long)");
            try {
                this.tool.getDefaultQueueSender().send((Message)new MessageTestImpl(), 2, 4, 0L);
                logger.log(System.Logger.Level.ERROR, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new Exception("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionSend4Test", e);
        }
    }

    @Test
    public void closedQueueSessionRecoverTest() throws Exception {
        try {
            this.createAndCloseSession(2, this.user, this.password);
            logger.log(System.Logger.Level.INFO, "Try to call recover() with closed session.");
            try {
                this.tool.getDefaultQueueSession().recover();
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.INFO, "Caught expected exception");
                return;
            }
            throw new Exception("closedQueueSessionRecoverTest");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "closedQueueSessionRecoverTest failed: ", (Throwable)e);
            throw new Exception("closedQueueSessionRecoverTest", e);
        }
    }

    @Test
    public void closedSessionRecoverTest() throws Exception {
        String testName = "closedSessionRecoverTest";
        try {
            this.createAndCloseSession(15, this.user, this.password);
            logger.log(System.Logger.Level.INFO, "Try to call recover() with closed session.");
            try {
                this.tool.getDefaultSession().recover();
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.INFO, "Caught expected exception");
                return;
            }
            throw new Exception(testName);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, testName + " failed: ", (Throwable)e);
            throw new Exception(testName);
        }
    }

    @Test
    public void closedQueueSessionCommitTest() throws Exception {
        String testName = "closedQueueSessionCommitTest";
        try {
            this.createAndCloseSession(2, this.user, this.password);
            logger.log(System.Logger.Level.INFO, "Try to call commit with closed session.");
            try {
                this.tool.getDefaultQueueSession().commit();
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.INFO, "Caught expected exception");
                return;
            }
            throw new Exception(testName);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, testName + " failed: ", (Throwable)e);
            throw new Exception(testName);
        }
    }

    @Test
    public void closedQueueSessionGetTransactedTest() throws Exception {
        String testName = "closedQueueSessionGetTransactedTest";
        try {
            this.createAndCloseSession(2, this.user, this.password);
            logger.log(System.Logger.Level.INFO, "Try to call getTransacted() with closed session.");
            try {
                boolean bl = this.tool.getDefaultQueueSession().getTransacted();
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.INFO, "Caught expected exception");
                return;
            }
            throw new Exception(testName);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, testName + " failed: ", (Throwable)e);
            throw new Exception(testName);
        }
    }

    @Test
    public void closedQueueSessionRollbackTest() throws Exception {
        String testName = "closedQueueSessionRollbackTest";
        try {
            this.createAndCloseSession(2, this.user, this.password);
            logger.log(System.Logger.Level.INFO, "Try to call rollback() with closed session.");
            try {
                this.tool.getDefaultQueueSession().rollback();
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.INFO, "Caught expected exception");
                return;
            }
            throw new Exception(testName);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, " " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedQueueSessionRollbackTest");
        }
    }
}

