/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.closedQueueReceiver;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.IllegalStateException;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import java.util.ArrayList;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClosedQueueReceiverTestsIT {
    private static final String TestName = "com.sun.ts.tests.jms.core.closedQueueReceiver.ClosedQueueReceiverTestsIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private static final System.Logger logger = System.getLogger(ClosedQueueReceiverTestsIT.class.getName());
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList queues = null;
    ArrayList connections = null;

    private void createAndCloseReceiver() throws Exception {
        this.tool = new JmsTool(0, this.user, this.password, this.mode);
        this.tool.getDefaultQueueConnection().start();
        logger.log(System.Logger.Level.TRACE, "Closing queue receiver");
        this.tool.getDefaultQueueReceiver().close();
        logger.log(System.Logger.Level.TRACE, "Receiver closed");
    }

    @BeforeEach
    public void setup() throws Exception {
        try {
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' is null");
            }
            if (this.password == null) {
                throw new Exception("'password' is null");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' is null");
            }
            this.queues = new ArrayList(2);
            logger.log(System.Logger.Level.TRACE, "Getting Administrator and deleting any leftover destinations.");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            if (this.tool != null) {
                logger.log(System.Logger.Level.INFO, "Cleanup: Closing Queue and Topic Connections");
                this.tool.doClientQueueTestCleanup(this.connections, this.queues);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            logger.log(System.Logger.Level.ERROR, "An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    @Test
    public void closedQueueReceiverCloseTest() throws Exception {
        try {
            this.createAndCloseReceiver();
            logger.log(System.Logger.Level.TRACE, "Try to call close again");
            this.tool.getDefaultQueueReceiver().close();
        }
        catch (Exception e) {
            throw new Exception("closedQueueReceiverCloseTest", e);
        }
    }

    @Test
    public void closedQueueReceiverGetMessageSelectorTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseReceiver();
            logger.log(System.Logger.Level.TRACE, "Try to call getMessageSelector");
            try {
                String foo = this.tool.getDefaultQueueReceiver().getMessageSelector();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueReceiverGetMessageSelectorTest", e);
        }
    }

    @Test
    public void closedQueueReceiverReceiveTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseReceiver();
            logger.log(System.Logger.Level.TRACE, "Try to call receive");
            try {
                Message foo = this.tool.getDefaultQueueReceiver().receive();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueReceiverReceiveTest", e);
        }
    }

    @Test
    public void closedQueueReceiverReceiveTimeoutTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseReceiver();
            logger.log(System.Logger.Level.TRACE, "Try to call receive(timeout)");
            try {
                Message foo = this.tool.getDefaultQueueReceiver().receive(this.timeout);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueReceiverReceiveTimeoutTest", e);
        }
    }

    @Test
    public void closedQueueReceiverReceiveNoWaitTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseReceiver();
            logger.log(System.Logger.Level.TRACE, "Try to call receiveNoWait");
            try {
                Message foo = this.tool.getDefaultQueueReceiver().receiveNoWait();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueReceiverReceiveNoWaitTest", e);
        }
    }

    @Test
    public void closedQueueReceiverGetQueueTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseReceiver();
            logger.log(System.Logger.Level.TRACE, "Try to call getQueue");
            try {
                Queue foo = this.tool.getDefaultQueueReceiver().getQueue();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueReceiverGetQueueTest", e);
        }
    }
}

