/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.closedQueueConnection;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import com.sun.ts.tests.jms.common.MessageTestImpl;
import jakarta.jms.BytesMessage;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.IllegalStateException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TextMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClosedQueueConnectionTestsIT {
    private static final String TestName = "com.sun.ts.tests.jms.core.closedQueueConnection.ClosedQueueConnectionTestsIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private static final System.Logger logger = System.getLogger(ClosedQueueConnectionTestsIT.class.getName());
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    boolean jmsOptionalApisSupported;
    ArrayList queues = null;
    ArrayList connections = null;

    private void createAndCloseConnection(int type) throws Exception {
        if (type == 0 || type == 2) {
            this.tool = new JmsTool(type, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.TRACE, "Closing queue Connection");
            this.tool.getDefaultQueueConnection().close();
        }
        logger.log(System.Logger.Level.TRACE, "Connection closed");
    }

    @BeforeEach
    public void setup() throws Exception {
        try {
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'users' is null");
            }
            if (this.password == null) {
                throw new Exception("'password' is null");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' is null");
            }
            this.queues = new ArrayList(2);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            if (this.tool != null) {
                logger.log(System.Logger.Level.INFO, "Cleanup: Closing QueueConnections");
                this.tool.doClientQueueTestCleanup(this.connections, this.queues);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            logger.log(System.Logger.Level.ERROR, "An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    @Test
    public void closedQueueConnectionCommitTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(2);
            logger.log(System.Logger.Level.TRACE, "Try to call commit with closed connection.");
            try {
                this.tool.getDefaultQueueSession().commit();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, " " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedQueueConnectionCommitTest");
        }
    }

    @Test
    public void closedQueueConnectionGetTransactedTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to call getTransacted() with closed connection.");
            try {
                boolean b = this.tool.getDefaultQueueSession().getTransacted();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionGetTransactedTest", e);
        }
    }

    @Test
    public void closedQueueConnectionRollbackTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to call rollback() with closed connection.");
            try {
                this.tool.getDefaultQueueSession().rollback();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionRollbackTest", e);
        }
    }

    @Test
    public void closedQueueConnectionRecoverTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to call recover() with closed connection.");
            try {
                this.tool.getDefaultQueueSession().recover();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionRecoverTest", e);
        }
    }

    @Test
    public void closedQueueConnectionCloseTest() throws Exception {
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to call close again");
            this.tool.getDefaultQueueConnection().close();
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionCloseTest", e);
        }
    }

    @Test
    public void closedQueueConnectionGetClientIDTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to call getClientID");
            try {
                String foo = this.tool.getDefaultQueueConnection().getClientID();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionGetClientIDTest", e);
        }
    }

    @Test
    public void closedQueueConnectionGetMetaDataTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to call getMetaData");
            try {
                ConnectionMetaData foo = this.tool.getDefaultQueueConnection().getMetaData();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionGetMetaDataTest", e);
        }
    }

    @Test
    public void closedQueueConnectionStartTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to call start");
            try {
                this.tool.getDefaultQueueConnection().start();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionStartTest", e);
        }
    }

    @Test
    public void closedQueueConnectionCreateQueueSessionTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to call createQueueSession");
            try {
                QueueSession foo = this.tool.getDefaultQueueConnection().createQueueSession(true, 1);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Fail: wrong exception was returned", (Throwable)e);
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionCreateQueueSessionTest", e);
        }
    }

    @Test
    public void closedQueueConnectionSessionCloseTest() throws Exception {
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to close session again.");
            this.tool.getDefaultQueueSession().close();
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionSessionCloseTest", e);
        }
    }

    @Test
    public void closedQueueConnectionCreateBrowserTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to create QueueBrowser with closed connection.");
            try {
                QueueBrowser qB = this.tool.getDefaultQueueSession().createBrowser(this.tool.getDefaultQueue());
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionCreateBrowserTest", e);
        }
    }

    @Test
    public void closedQueueConnectionCreateBrowserMsgSelectorTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to create QueueBrowser with closed Connection.");
            try {
                QueueBrowser qB = this.tool.getDefaultQueueSession().createBrowser(this.tool.getDefaultQueue(), "TEST = 'test'");
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionCreateBrowserMsgSelectorTest", e);
        }
    }

    @Test
    public void closedQueueConnectionCreateQueueTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to create queue with closed Connection.");
            try {
                Queue q = this.tool.getDefaultQueueSession().createQueue("closedQueueConnectionCreateQueueTest");
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionCreateQueueTest", e);
        }
    }

    @Test
    public void closedQueueConnectionCreateReceiverTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to create Receiver with closed Connection.");
            try {
                QueueReceiver qR = this.tool.getDefaultQueueSession().createReceiver(this.tool.getDefaultQueue());
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionCreateReceiverTest", e);
        }
    }

    @Test
    public void closedQueueConnectionCreateReceiverMsgSelectorTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to create Receiver with closed Connection.");
            try {
                QueueReceiver qR = this.tool.getDefaultQueueSession().createReceiver(this.tool.getDefaultQueue(), "TEST = 'test'");
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionCreateReceiverMsgSelectorTest", e);
        }
    }

    @Test
    public void closedQueueConnectionCreateSenderTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to create Sender with closed Connection.");
            try {
                QueueSender qS = this.tool.getDefaultQueueSession().createSender(this.tool.getDefaultQueue());
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionCreateSenderTest", e);
        }
    }

    @Test
    public void closedQueueConnectionCreateTempQueueTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to create TemporaryQueue with closed connection.");
            try {
                TemporaryQueue tQ = this.tool.getDefaultQueueSession().createTemporaryQueue();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionCreateTempQueueTest", e);
        }
    }

    @Test
    public void closedQueueConnectionCreateMessageTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to create message with closed connection.");
            try {
                Message m = this.tool.getDefaultQueueSession().createMessage();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionCreateMessageTest", e);
        }
    }

    @Test
    public void closedQueueConnectionCreateBytesMessageTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to create BytesMessage with closed connection.");
            try {
                BytesMessage m = this.tool.getDefaultQueueSession().createBytesMessage();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionCreateBytesMessageTest", e);
        }
    }

    @Test
    public void closedQueueConnectionCreateMapMessageTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to create MapMessage with closed connection.");
            try {
                MapMessage m = this.tool.getDefaultQueueSession().createMapMessage();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionCreateMapMessageTest", e);
        }
    }

    @Test
    public void closedQueueConnectionCreateObjectMessageTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to create ObjectMessage with closed connection.");
            try {
                ObjectMessage m = this.tool.getDefaultQueueSession().createObjectMessage();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionCreateObjectMessageTest", e);
        }
    }

    @Test
    public void closedQueueConnectionCreateObject2MessageTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to create ObjectMessage(object) with closed connection.");
            try {
                String s = "Simple object";
                ObjectMessage m = this.tool.getDefaultQueueSession().createObjectMessage((Serializable)((Object)s));
                if (m != null) {
                    logger.log(System.Logger.Level.TRACE, "m=" + m);
                }
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionCreateObject2MessageTest", e);
        }
    }

    @Test
    public void closedQueueConnectionCreateStreamMessageTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to create StreamMessage with closed connection.");
            try {
                StreamMessage m = this.tool.getDefaultQueueSession().createStreamMessage();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionCreateStreamMessageTest", e);
        }
    }

    @Test
    public void closedQueueConnectionCreateTextMessageTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to create TextMessage with closed connection.");
            try {
                TextMessage m = this.tool.getDefaultQueueSession().createTextMessage();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionCreateTextMessageTest", e);
        }
    }

    @Test
    public void closedQueueConnectionCreateText2MessageTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to create TextMessage with closed connection.");
            try {
                TextMessage m = this.tool.getDefaultQueueSession().createTextMessage("test message");
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Caught expected exception");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionCreateText2MessageTest", e);
        }
    }

    @Test
    public void closedQueueConnectionReceiverCloseTest() throws Exception {
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to call close again");
            this.tool.getDefaultQueueReceiver().close();
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionReceiverCloseTest", e);
        }
    }

    @Test
    public void closedQueueConnectionGetMessageSelectorTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to call getMessageSelector");
            try {
                String foo = this.tool.getDefaultQueueReceiver().getMessageSelector();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionGetMessageSelectorTest", e);
        }
    }

    @Test
    public void closedQueueConnectionReceiveTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to call receive");
            try {
                Message foo = this.tool.getDefaultQueueReceiver().receive();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionReceiveTest", e);
        }
    }

    @Test
    public void closedQueueConnectionReceiveTimeoutTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to call receive(timeout)");
            try {
                Message foo = this.tool.getDefaultQueueReceiver().receive(this.timeout);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionReceiveTimeoutTest", e);
        }
    }

    @Test
    public void closedQueueConnectionReceiveNoWaitTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to call receiveNoWait");
            try {
                Message foo = this.tool.getDefaultQueueReceiver().receiveNoWait();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionReceiveNoWaitTest", e);
        }
    }

    @Test
    public void closedQueueConnectionReceiverGetQueueTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to call getQueue");
            try {
                Queue foo = this.tool.getDefaultQueueReceiver().getQueue();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionReceiverGetQueueTest", e);
        }
    }

    @Test
    public void closedQueueConnectionSenderCloseTest() throws Exception {
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to call close again");
            this.tool.getDefaultQueueSender().close();
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionSenderCloseTest", e);
        }
    }

    @Test
    public void closedQueueConnectionGetDeliveryModeTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to call getDeliveryMode");
            try {
                int foo = this.tool.getDefaultQueueSender().getDeliveryMode();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionGetDeliveryModeTest", e);
        }
    }

    @Test
    public void closedQueueConnectionGetDisableMessageIDTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to call getDisableMessageID");
            try {
                boolean foo = this.tool.getDefaultQueueSender().getDisableMessageID();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionGetDisableMessageIDTest", e);
        }
    }

    @Test
    public void closedQueueConnectionGetDisableMessageTimestampTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to call getDisableMessageTimestamp");
            try {
                boolean foo = this.tool.getDefaultQueueSender().getDisableMessageTimestamp();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionGetDisableMessageTimestampTest", e);
        }
    }

    @Test
    public void closedQueueConnectionGetPriorityTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to call getPriority");
            try {
                int foo = this.tool.getDefaultQueueSender().getPriority();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionGetPriorityTest", e);
        }
    }

    @Test
    public void closedQueueConnectionGetTimeToLiveTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to call getTimeToLive");
            try {
                long foo = this.tool.getDefaultQueueSender().getTimeToLive();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionGetTimeToLiveTest", e);
        }
    }

    @Test
    public void closedQueueConnectionSetDeliveryModeTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to call setDeliveryMode");
            try {
                this.tool.getDefaultQueueSender().setDeliveryMode(2);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionSetDeliveryModeTest", e);
        }
    }

    @Test
    public void closedQueueConnectionSetDisableMessageIDTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to call setDisableMessageID");
            try {
                this.tool.getDefaultQueueSender().setDisableMessageID(true);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionSetDisableMessageIDTest", e);
        }
    }

    @Test
    public void closedQueueConnectionSetDisableMessageTimestampTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to call setDisableMessageTimestamp");
            try {
                this.tool.getDefaultQueueSender().setDisableMessageTimestamp(true);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionSetDisableMessageTimestampTest", e);
        }
    }

    @Test
    public void closedQueueConnectionSetPriorityTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to call setPriority");
            try {
                this.tool.getDefaultQueueSender().setPriority(4);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionSetPriorityTest", e);
        }
    }

    @Test
    public void closedQueueConnectionSetTimeToLiveTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to call setTimeToLive");
            try {
                this.tool.getDefaultQueueSender().setTimeToLive(0L);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionSetTimeToLiveTest", e);
        }
    }

    @Test
    public void closedQueueConnectionSenderGetQueueTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to call getQueue");
            try {
                Queue foo = this.tool.getDefaultQueueSender().getQueue();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionSenderGetQueueTest", e);
        }
    }

    @Test
    public void closedQueueConnectionSend1Test() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to call send(Message)");
            try {
                this.tool.getDefaultQueueSender().send((Message)new MessageTestImpl());
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionSend1Test", e);
        }
    }

    @Test
    public void closedQueueConnectionSend2Test() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to call send(Message,int,int,long)");
            try {
                this.tool.getDefaultQueueSender().send((Message)new MessageTestImpl(), 2, 4, 0L);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionSend2Test", e);
        }
    }

    @Test
    public void closedQueueConnectionSend3Test() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to call send(Queue,Message)");
            try {
                this.tool.getDefaultQueueSender().send((Message)new MessageTestImpl());
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionSend3Test", e);
        }
    }

    @Test
    public void closedQueueConnectionSend4Test() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to call send(Queue,Message,int,int,long)");
            try {
                this.tool.getDefaultQueueSender().send((Message)new MessageTestImpl(), 2, 4, 0L);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionSend4Test", e);
        }
    }
}

