/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.appclient.txqueuetests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.ArrayList;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TxQueueTestsIT {
    private static final String testName = "com.sun.ts.tests.jms.core.appclient.txqueuetests.TxQueueTestsIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList queues = null;
    ArrayList connections = null;
    private static final System.Logger logger = System.getLogger(TxQueueTestsIT.class.getName());

    @BeforeEach
    public void setup() throws Exception {
        try {
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'timeout' (milliseconds) in must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' is null");
            }
            if (this.password == null) {
                throw new Exception("'password' is null");
            }
            if (this.mode == null) {
                throw new Exception("'mode' is null");
            }
            this.queues = new ArrayList(2);
            this.connections = new ArrayList(2);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            if (this.tool != null) {
                logger.log(System.Logger.Level.INFO, "Cleanup: Closing Queue and Topic Connections");
                this.tool.doClientQueueTestCleanup(this.connections, this.queues);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            logger.log(System.Logger.Level.ERROR, "An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    @Test
    public void simpleSendReceiveTxQueueTest() throws Exception {
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            this.tool = new JmsTool(2, this.user, this.password, this.mode);
            logger.log(System.Logger.Level.INFO, "Start connection");
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.INFO, "Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText("transaction message test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "simpleSendReceiveTxQueueTest");
            logger.log(System.Logger.Level.INFO, "Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            logger.log(System.Logger.Level.INFO, "Call commit");
            this.tool.getDefaultQueueSession().commit();
            logger.log(System.Logger.Level.INFO, "Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            logger.log(System.Logger.Level.INFO, "Call commit");
            this.tool.getDefaultQueueSession().commit();
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new Exception("didn't get the right message");
            }
            logger.log(System.Logger.Level.INFO, "Message text: \"" + messageReceived.getText() + "\"");
            logger.log(System.Logger.Level.INFO, "Received correct message");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("simpleSendReceiveQueueTxTest");
        }
    }

    @Test
    public void commitAckMsgQueueTest() throws Exception {
        try {
            TextMessage mSent = null;
            TextMessage mReceived = null;
            QueueSession qSess = null;
            QueueSender qSender = null;
            QueueReceiver qRec = null;
            String msg = "test message for commitAckMsgTest";
            this.tool = new JmsTool(2, this.user, this.password, this.mode);
            this.tool.getDefaultQueueReceiver().close();
            qSess = this.tool.getDefaultQueueSession();
            qSender = this.tool.getDefaultQueueSender();
            qRec = qSess.createReceiver(this.tool.getDefaultQueue());
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.TRACE, "Send first message");
            mSent = qSess.createTextMessage();
            mSent.setBooleanProperty("lastMessage", false);
            mSent.setText(msg);
            mSent.setStringProperty("COM_SUN_JMS_TESTNAME", "commitAckMsgQueueTest1");
            qSender.send((Message)mSent);
            qSess.commit();
            logger.log(System.Logger.Level.TRACE, "Send second message");
            mSent.setBooleanProperty("lastMessage", true);
            qSender.send((Message)mSent);
            qSess.commit();
            logger.log(System.Logger.Level.TRACE, "Message sent. Receive with tx session, do not call acknowledge().");
            mReceived = (TextMessage)qRec.receive(this.timeout);
            if (mReceived == null) {
                logger.log(System.Logger.Level.INFO, "Did not receive message!");
                throw new Exception("Did not receive message first time");
            }
            logger.log(System.Logger.Level.TRACE, "Received message: \"" + mReceived.getText() + "\"");
            logger.log(System.Logger.Level.TRACE, "Call commit() without calling acknowledge().");
            qSess.commit();
            logger.log(System.Logger.Level.TRACE, "Close session and create new one.");
            qSess.close();
            qSess = this.tool.getDefaultQueueConnection().createQueueSession(false, 1);
            qRec = qSess.createReceiver(this.tool.getDefaultQueue());
            mReceived = (TextMessage)qRec.receive(this.timeout);
            if (mReceived == null) {
                logger.log(System.Logger.Level.INFO, "Did not receive message!");
                throw new Exception("Did not receive expected message");
            }
            if (!mReceived.getBooleanProperty("lastMessage")) {
                logger.log(System.Logger.Level.INFO, "Received orignal message again. Was not acknowledged by commit().");
                throw new Exception("Message not acknowledged by commit");
            }
            if (mReceived.getBooleanProperty("lastMessage")) {
                logger.log(System.Logger.Level.INFO, "Pass: received proper message");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("commitAckMsgQueueTest");
        }
    }

    @Test
    public void rollbackRecoverQueueTest() throws Exception {
        try {
            TextMessage mSent = null;
            TextMessage mReceived = null;
            QueueSession qSess = null;
            QueueSender qSender = null;
            QueueReceiver qRec = null;
            String msg = "test message for rollbackRecoverTest";
            this.tool = new JmsTool(2, this.user, this.password, this.mode);
            this.tool.getDefaultQueueSession().close();
            qSess = this.tool.getDefaultQueueConnection().createQueueSession(true, 0);
            qSender = qSess.createSender(this.tool.getDefaultQueue());
            qRec = qSess.createReceiver(this.tool.getDefaultQueue());
            this.tool.getDefaultQueueConnection().start();
            mSent = qSess.createTextMessage();
            mSent.setText(msg);
            mSent.setStringProperty("COM_SUN_JMS_TESTNAME", "rollbackRecoverQueueTest");
            qSender.send((Message)mSent);
            qSess.commit();
            logger.log(System.Logger.Level.TRACE, "Message sent. Receive with tx session, do not acknowledge.");
            mReceived = (TextMessage)qRec.receive(this.timeout);
            if (mReceived == null) {
                logger.log(System.Logger.Level.INFO, "Did not receive message!");
                throw new Exception("Did not receive message first time");
            }
            logger.log(System.Logger.Level.TRACE, "Received message: \"" + mReceived.getText() + "\"");
            logger.log(System.Logger.Level.TRACE, "Call rollback() without acknowledging message.");
            qSess.rollback();
            logger.log(System.Logger.Level.TRACE, "Close session and create new one.");
            qSess.close();
            qSess = this.tool.getDefaultQueueConnection().createQueueSession(false, 1);
            qRec = qSess.createReceiver(this.tool.getDefaultQueue());
            mReceived = (TextMessage)qRec.receive(this.timeout);
            if (mReceived == null) {
                logger.log(System.Logger.Level.INFO, "Did not receive message!");
                throw new Exception("Did not receive expected message");
            }
            if (!mReceived.getText().equals(msg)) {
                throw new Exception("Received unexpected message");
            }
            logger.log(System.Logger.Level.INFO, "Received orignal message again. Was not acknowledged.");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("rollbackRecoverQueueTest");
        }
    }

    @Test
    public void redeliveredFlagTxQueueTest() throws Exception {
        try {
            TextMessage tMsg = null;
            QueueSession qSess = null;
            QueueReceiver qRec = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueReceiver().close();
            qSess = this.tool.getDefaultQueueConnection().createQueueSession(true, 2);
            qRec = qSess.createReceiver(this.tool.getDefaultQueue());
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.TRACE, "send and receive one message");
            tMsg = this.tool.getDefaultQueueSession().createTextMessage();
            tMsg.setText("test message for redelivered flag");
            tMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "redeliveredFlagTxQueueTest");
            this.tool.getDefaultQueueSender().send((Message)tMsg);
            qSess.commit();
            tMsg = (TextMessage)qRec.receive(this.timeout);
            if (tMsg == null) {
                logger.log(System.Logger.Level.INFO, "Did not receive expected message!");
                throw new Exception("Did not receive message");
            }
            logger.log(System.Logger.Level.TRACE, "Message received. Check redelivered flag.");
            boolean redelivered = tMsg.getJMSRedelivered();
            logger.log(System.Logger.Level.TRACE, "redelivered = " + redelivered);
            if (redelivered) {
                throw new Exception("Message redelivered flag should be false");
            }
            logger.log(System.Logger.Level.TRACE, "calling rollback()");
            qSess.rollback();
            logger.log(System.Logger.Level.TRACE, "receive message again");
            tMsg = (TextMessage)qRec.receive(this.timeout);
            qSess.commit();
            redelivered = tMsg.getJMSRedelivered();
            logger.log(System.Logger.Level.TRACE, "redelivered flag = " + redelivered);
            if (!redelivered) {
                throw new Exception("Message redelivered flag should be true");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.INFO, "Error: " + e);
            throw new Exception("redeliveredFlagTxQueueTest", e);
        }
    }

    @Test
    public void transactionRollbackOnSessionCloseRecQTest() throws Exception {
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            TextMessage messageReceived2 = null;
            this.tool = new JmsTool(2, this.user, this.password, this.mode);
            logger.log(System.Logger.Level.TRACE, "Start connection");
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText("transaction message test");
            logger.log(System.Logger.Level.TRACE, "Sending message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "transactionRollbackOnSessionCloseRecQTest");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            this.tool.getDefaultQueueSession().commit();
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.tool.getDefaultQueueSession().commit();
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new Exception("didn't get the right message");
            }
            logger.log(System.Logger.Level.TRACE, "Message text: \"" + messageReceived.getText() + "\"");
            logger.log(System.Logger.Level.TRACE, "Received correct message");
            QueueSession newQSess = this.tool.getDefaultQueueConnection().createQueueSession(true, 0);
            messageSent.setText("part 2");
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            this.tool.getDefaultQueueSession().commit();
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "close session - don't do a commit on receive");
            this.tool.getDefaultQueueSession().close();
            QueueReceiver qReceiver = newQSess.createReceiver(this.tool.getDefaultQueue());
            messageReceived2 = (TextMessage)qReceiver.receive(this.timeout);
            newQSess.commit();
            if (!messageReceived.getText().equals(messageReceived2.getText())) {
                throw new Exception("received message not rolled back to q on close session");
            }
            logger.log(System.Logger.Level.TRACE, "Message text: \"" + messageReceived.getText() + "\"");
            logger.log(System.Logger.Level.TRACE, "Message2 text: \"" + messageReceived2.getText() + "\"");
            logger.log(System.Logger.Level.TRACE, "Received correct message");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("transactionRollbackOnSessionCloseRecQTest");
        }
    }

    @Test
    public void transactionRollbackOnSendQTest() throws Exception {
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            logger.log(System.Logger.Level.TRACE, "Start connection");
            this.tool.getDefaultQueueConnection().start();
            QueueSession newQSess = this.tool.getDefaultQueueConnection().createQueueSession(true, 0);
            QueueSender newSender = newQSess.createSender(this.tool.getDefaultQueue());
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = newQSess.createTextMessage();
            messageSent.setBooleanProperty("lastMessage", false);
            messageSent.setText("transaction message test");
            logger.log(System.Logger.Level.TRACE, "Sending message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "transactionRollbackOnSendQTest");
            newSender.send((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Call commit");
            newQSess.commit();
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new Exception("didn't get the right message");
            }
            logger.log(System.Logger.Level.TRACE, "Message text: \"" + messageReceived.getText() + "\"");
            logger.log(System.Logger.Level.TRACE, "Received correct message");
            logger.log(System.Logger.Level.TRACE, "Send a message, but then rollback");
            newSender.send((Message)messageSent);
            newQSess.rollback();
            logger.log(System.Logger.Level.TRACE, "Send 3rd message");
            messageSent.setBooleanProperty("lastMessage", true);
            newSender.send((Message)messageSent);
            newQSess.commit();
            logger.log(System.Logger.Level.TRACE, "Attempt to receive last message only");
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("Fail: Should have received message");
            }
            if (messageReceived.getBooleanProperty("lastMessage")) {
                logger.log(System.Logger.Level.TRACE, "Pass: last msg received, proper message was rolledback");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("transactionRollbackOnSendQTest");
        }
    }

    @Test
    public void transactionRollbackOnRecQTest() throws Exception {
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            TextMessage messageReceived2 = null;
            this.tool = new JmsTool(2, this.user, this.password, this.mode);
            logger.log(System.Logger.Level.TRACE, "Start connection");
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText("transaction message test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "transactionRollbackOnRecQTest");
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Call commit");
            this.tool.getDefaultQueueSession().commit();
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "Call commit");
            this.tool.getDefaultQueueSession().commit();
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new Exception("didn't get the right message");
            }
            logger.log(System.Logger.Level.TRACE, "Message text: \"" + messageReceived.getText() + "\"");
            logger.log(System.Logger.Level.TRACE, "Received correct message");
            messageSent.setText("receive rollback");
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            this.tool.getDefaultQueueSession().commit();
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "rollback session on receive");
            this.tool.getDefaultQueueSession().rollback();
            logger.log(System.Logger.Level.TRACE, "Message should have been recovered");
            messageReceived2 = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.tool.getDefaultQueueSession().commit();
            if (messageReceived2 == null) {
                throw new Exception("Fail:  message not recovered");
            }
            if (messageReceived.getText().equals(messageReceived2.getText())) {
                logger.log(System.Logger.Level.TRACE, "Message text: \"" + messageReceived.getText() + "\"");
                logger.log(System.Logger.Level.TRACE, "Message2 text: \"" + messageReceived2.getText() + "\"");
                logger.log(System.Logger.Level.TRACE, "Pass:  Message rolled back to the Q");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("transactionRollbackOnRecQTest");
        }
    }

    @Test
    public void txRollbackOnConnectionCloseRecQTest() throws Exception {
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            TextMessage messageReceived2 = null;
            this.tool = new JmsTool(2, this.user, this.password, this.mode);
            logger.log(System.Logger.Level.TRACE, "Start connection");
            this.tool.getDefaultQueueConnection().start();
            this.tool.getDefaultQueueReceiver().close();
            logger.log(System.Logger.Level.TRACE, "Creating new Connection");
            QueueConnection newQConn = (QueueConnection)this.tool.getNewConnection(0, this.user, this.password);
            this.connections.add(newQConn);
            QueueSession newQSess = newQConn.createQueueSession(true, 1);
            QueueSender qSender = newQSess.createSender(this.tool.getDefaultQueue());
            QueueReceiver qReceiver = newQSess.createReceiver(this.tool.getDefaultQueue());
            newQConn.start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = newQSess.createTextMessage();
            messageSent.setText("transaction message test");
            logger.log(System.Logger.Level.TRACE, "Sending message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "txRollbackOnConnectionCloseRecQTest");
            qSender.send((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Call commit");
            newQSess.commit();
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (TextMessage)qReceiver.receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "Call commit");
            newQSess.commit();
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new Exception("didn't get the right message");
            }
            logger.log(System.Logger.Level.TRACE, "Message text: \"" + messageReceived.getText() + "\"");
            logger.log(System.Logger.Level.TRACE, "Received correct message");
            messageSent.setText("part 2");
            logger.log(System.Logger.Level.TRACE, "Sending message");
            qSender.send((Message)messageSent);
            newQSess.commit();
            messageReceived = (TextMessage)qReceiver.receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "close connection - don't do a commit on receive");
            newQConn.close();
            this.tool.getDefaultQueueConnection().start();
            QueueReceiver qR = this.tool.getDefaultQueueSession().createReceiver(this.tool.getDefaultQueue());
            messageReceived2 = (TextMessage)qR.receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "Receive was not commited, message should be restored");
            this.tool.getDefaultQueueSession().commit();
            if (messageReceived == null) {
                throw new Exception("Fail:received message not rolled back to q on close session");
            }
            if (messageReceived.getText().equals(messageReceived2.getText())) {
                logger.log(System.Logger.Level.TRACE, "Message text: \"" + messageReceived.getText() + "\"");
                logger.log(System.Logger.Level.TRACE, "Message2 text: \"" + messageReceived2.getText() + "\"");
                logger.log(System.Logger.Level.TRACE, "Pass: message restored to Q");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("txRollbackOnConnectionCloseRecQTest");
        }
    }

    @Test
    public void txCloseRolledBackSessionRecQTest() throws Exception {
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            TextMessage messageReceived2 = null;
            this.tool = new JmsTool(2, this.user, this.password, this.mode);
            logger.log(System.Logger.Level.TRACE, "Start connection");
            this.tool.getDefaultQueueConnection().start();
            QueueSession newQSess = this.tool.getDefaultQueueConnection().createQueueSession(true, 1);
            QueueSender qSender = newQSess.createSender(this.tool.getDefaultQueue());
            this.tool.getDefaultQueueReceiver().close();
            QueueReceiver qReceiver = newQSess.createReceiver(this.tool.getDefaultQueue());
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = newQSess.createTextMessage();
            messageSent.setText("transaction message test");
            logger.log(System.Logger.Level.TRACE, "Sending message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "txCloseRolledBackSessionRecQTest");
            qSender.send((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Call commit");
            newQSess.commit();
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (TextMessage)qReceiver.receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "Call commit");
            newQSess.commit();
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new Exception("didn't get the right message");
            }
            logger.log(System.Logger.Level.TRACE, "Message text: \"" + messageReceived.getText() + "\"");
            logger.log(System.Logger.Level.TRACE, "Received correct message");
            messageSent.setText("part 2");
            logger.log(System.Logger.Level.TRACE, "Sending message");
            qSender.send((Message)messageSent);
            newQSess.commit();
            messageReceived = (TextMessage)qReceiver.receive(this.timeout);
            newQSess.rollback();
            logger.log(System.Logger.Level.TRACE, "close session - don't do a commit on receive");
            newQSess.close();
            this.tool.getDefaultQueueConnection().start();
            QueueReceiver qR = this.tool.getDefaultQueueSession().createReceiver(this.tool.getDefaultQueue());
            messageReceived2 = (TextMessage)qR.receive(this.timeout);
            this.tool.getDefaultQueueSession().commit();
            if (!messageReceived.getText().equals(messageReceived2.getText())) {
                throw new Exception("received message not rolled back to q on close session");
            }
            logger.log(System.Logger.Level.TRACE, "Message text: \"" + messageReceived.getText() + "\"");
            logger.log(System.Logger.Level.TRACE, "Message2 text: \"" + messageReceived2.getText() + "\"");
            logger.log(System.Logger.Level.TRACE, "Received correct message");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("txCloseRolledBackSessionRecQTest");
        }
    }

    @Test
    public void txMultiQTest() throws Exception {
        try {
            TextMessage messageSent = null;
            TextMessage messageSent2 = null;
            TextMessage messageReceived = null;
            this.tool = new JmsTool(2, this.user, this.password, this.mode);
            logger.log(System.Logger.Level.TRACE, "Start connection");
            this.tool.getDefaultQueueConnection().start();
            QueueSession newQSess = this.tool.getDefaultQueueConnection().createQueueSession(true, 1);
            QueueSession newQSess1 = this.tool.getDefaultQueueConnection().createQueueSession(false, 1);
            Queue newQueue = this.tool.createNewQueue("Q2");
            QueueSender qSender = newQSess.createSender(newQueue);
            QueueReceiver qReceiver = newQSess1.createReceiver(newQueue);
            this.queues.add(newQueue);
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText("This is from MY_QUEUE");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "txMultiQTest");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            this.tool.getDefaultQueueSession().commit();
            messageSent2 = newQSess.createTextMessage();
            messageSent2.setText("This is from Q2");
            messageSent2.setStringProperty("COM_SUN_JMS_TESTNAME", "txMultiQTest");
            qSender.send((Message)messageSent2);
            logger.log(System.Logger.Level.TRACE, "Verify there is no msg to receive");
            messageReceived = (TextMessage)qReceiver.receive(this.timeout);
            if (messageReceived != null) {
                throw new Exception("Error: Did not commit send - should not have received a msg!");
            }
            newQSess.commit();
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("Did not get the committed msg from MY_QUEUE!");
            }
            logger.log(System.Logger.Level.TRACE, " msg received for default q is: " + messageReceived.getText());
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new Exception("This was not the expected message!!");
            }
            logger.log(System.Logger.Level.TRACE, "Message text: \"" + messageReceived.getText() + "\"");
            this.tool.getDefaultQueueSession().commit();
            logger.log(System.Logger.Level.TRACE, "Now there should be a message to receive");
            messageReceived = (TextMessage)qReceiver.receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("Error: Should have received a msg!");
            }
            logger.log(System.Logger.Level.TRACE, "Msg recvd = " + messageReceived);
            logger.log(System.Logger.Level.TRACE, " msg received for Q2 is: " + messageReceived.getText());
            if (!messageReceived.getText().equals(messageSent2.getText())) {
                throw new Exception("This was not the expected message!!");
            }
            logger.log(System.Logger.Level.TRACE, "Message text: \"" + messageReceived.getText() + "\"");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("txMultiQTest");
        }
    }

    @Test
    public void commitRollbackMultiMsgsTest() throws Exception {
        boolean pass = true;
        int numMessages = 3;
        try {
            int i;
            TextMessage tempMsg = null;
            this.tool = new JmsTool(15, this.user, this.password, this.mode);
            Destination destination = this.tool.getDefaultDestination();
            Session session = this.tool.getDefaultSession();
            Connection connection = this.tool.getDefaultConnection();
            MessageProducer producer = this.tool.getDefaultProducer();
            MessageConsumer consumer = this.tool.getDefaultConsumer();
            Queue queue = (Queue)destination;
            connection.start();
            this.queues.add(queue);
            logger.log(System.Logger.Level.INFO, "Send " + numMessages + " messages to Queue and call rollback()");
            for (i = 1; i <= numMessages; ++i) {
                tempMsg = session.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "commitRollbackMultiMsgsTest" + i);
                producer.send((Message)tempMsg);
                logger.log(System.Logger.Level.INFO, "Message " + i + " sent");
            }
            session.rollback();
            logger.log(System.Logger.Level.INFO, "Should not consume any messages in Queue since rollback() was called");
            tempMsg = (TextMessage)consumer.receive(this.timeout);
            if (tempMsg != null) {
                logger.log(System.Logger.Level.ERROR, "Received message " + tempMsg.getText() + ", expected NULL (NO MESSAGES)");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Send " + numMessages + " messages to Queue and call commit()");
            for (i = 1; i <= numMessages; ++i) {
                tempMsg = session.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "commitRollbackMultiMsgsTest" + i);
                producer.send((Message)tempMsg);
                logger.log(System.Logger.Level.INFO, "Message " + i + " sent");
            }
            session.commit();
            logger.log(System.Logger.Level.INFO, "Should consume all messages in Queue since commit() was called");
            for (int msgCount = 1; msgCount <= numMessages; ++msgCount) {
                tempMsg = (TextMessage)consumer.receive(this.timeout);
                if (tempMsg == null) {
                    logger.log(System.Logger.Level.ERROR, "MessageConsumer.receive() returned NULL");
                    logger.log(System.Logger.Level.ERROR, "Message " + msgCount + " missing from Queue");
                    pass = false;
                    continue;
                }
                if (!tempMsg.getText().equals("Message " + msgCount)) {
                    logger.log(System.Logger.Level.ERROR, "Received [" + tempMsg.getText() + "] expected [Message " + msgCount + "]");
                    pass = false;
                    continue;
                }
                logger.log(System.Logger.Level.INFO, "Received message: " + tempMsg.getText());
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("commitRollbackMultiMsgsTest");
        }
        if (!pass) {
            throw new Exception("commitRollbackMultiMsgsTest failed");
        }
    }
}

