/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.appclient.topictests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.DoneLatch;
import com.sun.ts.tests.jms.common.JmsTool;
import com.sun.ts.tests.jms.common.SerialTestMessageListenerImpl;
import com.sun.ts.tests.jms.common.SessionThread;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.IllegalStateException;
import jakarta.jms.InvalidClientIDException;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.QueueConnection;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicRequestor;
import jakarta.jms.TopicSession;
import jakarta.jms.TopicSubscriber;
import java.util.ArrayList;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TopicTestsIT {
    private static final String testName = "com.sun.ts.tests.jms.core.appclient.topictests.TopicTestsIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private static final System.Logger logger = System.getLogger(TopicTestsIT.class.getName());
    private transient JmsTool tool = null;
    ArrayList topics = null;
    ArrayList connections = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    private static final int numMessages = 3;
    private static final int iterations = 5;

    @BeforeEach
    public void setup() throws Exception {
        try {
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'timeout' (milliseconds) in must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' is null ");
            }
            if (this.password == null) {
                throw new Exception("'password' is null ");
            }
            if (this.mode == null) {
                throw new Exception("'mode' is null");
            }
            this.connections = new ArrayList(5);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            if (this.tool != null) {
                this.tool.closeAllConnections(this.connections);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            logger.log(System.Logger.Level.ERROR, "An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    @Test
    public void receiveNullClosedSessionTopicTest() throws Exception {
        int waitTime = 15;
        try {
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            logger.log(System.Logger.Level.INFO, "Close default TopicSubscriber");
            this.tool.getDefaultTopicSubscriber().close();
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.INFO, "Create TopicRequestor");
            TopicRequestor qReq = new TopicRequestor(this.tool.getDefaultTopicSession(), this.tool.getDefaultTopic());
            logger.log(System.Logger.Level.INFO, "Create SessionThread");
            SessionThread sT = new SessionThread((QueueConnection)null, this.tool.getDefaultTopicConnection());
            logger.log(System.Logger.Level.INFO, "Tell SessionThread to respond to messages");
            sT.setReplyToMessages(true);
            logger.log(System.Logger.Level.INFO, "Create Subscriber in SessionThread");
            sT.createConsumer((Destination)this.tool.getDefaultTopic());
            logger.log(System.Logger.Level.INFO, "Tell receiver to keep receiving\n(it will throw an exception and stop when it receives the null message)");
            sT.setStayAlive(true);
            logger.log(System.Logger.Level.INFO, "Start the SessionThread");
            sT.start();
            logger.log(System.Logger.Level.INFO, "Send one message and receive reply");
            Message tempMsg = this.tool.getDefaultTopicSession().createMessage();
            tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "receiveNullClosedSessionTopicTest");
            qReq.request(tempMsg);
            logger.log(System.Logger.Level.INFO, "Wait " + waitTime + " seconds for receive() to start again before closing session...");
            for (int i = 0; i < 100000; ++i) {
            }
            logger.log(System.Logger.Level.INFO, "Close the SessionThread's TopicSession");
            sT.getTopicSession().close();
            logger.log(System.Logger.Level.INFO, "Wait for thread to close (will close after receiving null message)");
            sT.join();
            if (sT.isAlive()) {
                logger.log(System.Logger.Level.ERROR, "thread still waiting on receive() -- BAD [could be timing problem]");
                throw new Exception("receive() call still waiting");
            }
            logger.log(System.Logger.Level.INFO, "receive() properly received a null message -- GOOD");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("receiveNullClosedSessionTopicTest");
        }
    }

    @Test
    public void setClientIDLateTopicTest() throws Exception {
        boolean booleanValue = true;
        boolean pass = true;
        String lookup = "MyTopicConnectionFactory";
        try {
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            TopicConnection tConn = (TopicConnection)this.tool.getNewConnection(1, this.user, this.password, lookup);
            this.connections.add(tConn);
            TopicSession tSess = tConn.createTopicSession(false, 1);
            Topic topic = this.tool.createNewTopic("MY_TOPIC2");
            TopicPublisher tPublisher = tSess.createPublisher(topic);
            TopicSubscriber tSub = tSess.createSubscriber(topic);
            tConn.start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            MapMessage messageSent = tSess.createMapMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "setClientIDLateTopicTest");
            messageSent.setBoolean("booleanValue", booleanValue);
            logger.log(System.Logger.Level.TRACE, "Sending message");
            tPublisher.publish((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            MapMessage messageReceived = (MapMessage)tSub.receive(this.timeout);
            messageReceived.getBoolean("booleanValue");
            logger.log(System.Logger.Level.TRACE, "Attempt to set Client ID too late");
            try {
                tConn.setClientID("setClientIDLateTopicTest");
                pass = false;
                logger.log(System.Logger.Level.INFO, "Error: Illegal state exception was not thrown");
            }
            catch (IllegalStateException is) {
                logger.log(System.Logger.Level.TRACE, "Pass: IllegalStateException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.INFO, "Error: " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("setClientIDLateTopicTest");
        }
    }

    @Test
    public void autoAckMsgListenerTopicTest() throws Exception {
        try {
            Message messageSent = null;
            AutoAckMsgListener mListener = null;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            logger.log(System.Logger.Level.TRACE, "Create and set MessageListener.");
            mListener = new AutoAckMsgListener(new DoneLatch(), this.tool.getDefaultTopicSession());
            this.tool.getDefaultTopicSubscriber().setMessageListener((MessageListener)mListener);
            logger.log(System.Logger.Level.TRACE, "Send and receive two messages");
            messageSent = this.tool.getDefaultTopicSession().createMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "autoAckMsgListenerTopicTest");
            messageSent.setBooleanProperty("lastMessage", false);
            this.tool.getDefaultTopicPublisher().publish(messageSent);
            messageSent.setBooleanProperty("lastMessage", true);
            this.tool.getDefaultTopicPublisher().publish(messageSent);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.TRACE, "waiting until message has been received by message listener...");
            mListener.monitor.waitTillDone();
            if (!mListener.getPassed()) {
                throw new Exception("failed");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.INFO, "Error: " + e);
            throw new Exception("autoAckMsgListenerTopicTest", e);
        }
    }

    @Test
    public void serialMsgListenerTopicTest() throws Exception {
        try {
            TextMessage[] tMsg = new TextMessage[3];
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicSubscriber().close();
            Topic newT = this.tool.createNewTopic("MY_TOPIC2");
            TopicSubscriber tSub1 = this.tool.getDefaultTopicSession().createSubscriber(this.tool.getDefaultTopic());
            TopicSubscriber tSub2 = this.tool.getDefaultTopicSession().createSubscriber(newT);
            logger.log(System.Logger.Level.INFO, "Create two message listeners");
            SerialTestMessageListenerImpl myListener1 = new SerialTestMessageListenerImpl();
            SerialTestMessageListenerImpl myListener2 = new SerialTestMessageListenerImpl();
            tSub1.setMessageListener((MessageListener)myListener1);
            tSub2.setMessageListener((MessageListener)myListener2);
            TopicPublisher tPublisher1 = this.tool.getDefaultTopicSession().createPublisher(this.tool.getDefaultTopic());
            TopicPublisher tPublisher2 = this.tool.getDefaultTopicSession().createPublisher(newT);
            for (int i = 0; i < 3; ++i) {
                logger.log(System.Logger.Level.INFO, "Create and send message " + i);
                tMsg[i] = this.tool.getDefaultTopicSession().createTextMessage();
                tMsg[i].setText("serialMsgListenerTopicTest" + i);
                tMsg[i].setStringProperty("COM_SUN_JMS_TESTNAME", "serialMsgListenerTopicTest" + i);
                if (i == 2) {
                    tMsg[i].setBooleanProperty("COM_SUN_JMS_TEST_LASTMESSAGE", true);
                    tPublisher1.publish((Message)tMsg[i]);
                    tPublisher2.publish((Message)tMsg[i]);
                    continue;
                }
                tMsg[i].setBooleanProperty("COM_SUN_JMS_TEST_LASTMESSAGE", false);
                if (i % 2 == 0) {
                    tPublisher1.publish((Message)tMsg[i]);
                    continue;
                }
                tPublisher2.publish((Message)tMsg[i]);
            }
            logger.log(System.Logger.Level.INFO, "Start connection");
            this.tool.getDefaultTopicConnection().start();
            myListener1.monitor.waitTillDone();
            myListener2.monitor.waitTillDone();
            if (myListener1.testFailed || myListener2.testFailed) {
                logger.log(System.Logger.Level.INFO, "Test failed in message listener");
                throw new Exception("Concurrent use of MessageListener or JMSException");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("serialMsgListenerTopicTest");
        }
    }

    @Test
    public void setGetChangeClientIDTopicTest() throws Exception {
        boolean pass = true;
        TopicConnection tc2 = null;
        String lookup = "MyTopicConnectionFactory";
        try {
            this.tool = new JmsTool(8, this.user, this.password, this.mode);
            TopicConnection tc = (TopicConnection)this.tool.getNewConnection(1, this.user, this.password, lookup);
            this.connections.add(tc);
            tc2 = (TopicConnection)this.tool.getNewConnection(1, this.user, this.password, lookup);
            this.connections.add(tc2);
            logger.log(System.Logger.Level.INFO, "Setting clientID!");
            tc.setClientID("ctstest");
            logger.log(System.Logger.Level.INFO, "Getting clientID!");
            String clientid = tc.getClientID();
            if (!clientid.equals("ctstest")) {
                logger.log(System.Logger.Level.ERROR, "getClientID() returned " + clientid + ", expected ctstest");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "setClientID/getClientID correct");
            }
            logger.log(System.Logger.Level.INFO, "Resetting clientID! (excpect IllegalStateException)");
            tc.setClientID("changeIt");
            logger.log(System.Logger.Level.ERROR, "Failed: No exception on ClientID reset");
            pass = false;
        }
        catch (InvalidClientIDException e) {
            logger.log(System.Logger.Level.ERROR, "Incorrect exception received: " + e.getMessage());
            pass = false;
        }
        catch (IllegalStateException ee) {
            logger.log(System.Logger.Level.INFO, "Expected Exception received: " + ee.getMessage());
        }
        catch (Exception eee) {
            logger.log(System.Logger.Level.ERROR, "Incorrect exception received: " + eee.getMessage());
            pass = false;
        }
        try {
            logger.log(System.Logger.Level.INFO, "Set clientID on second connection to value of clientID on first connection");
            logger.log(System.Logger.Level.INFO, "Expect InvalidClientIDException");
            tc2.setClientID("ctstest");
            logger.log(System.Logger.Level.ERROR, "Failed: No exception on ClientID when one already exists");
            pass = false;
        }
        catch (InvalidClientIDException e) {
            logger.log(System.Logger.Level.INFO, "Expected exception received: " + e.getMessage());
        }
        catch (Exception eee) {
            logger.log(System.Logger.Level.ERROR, "Incorrect exception received: " + eee.getMessage());
            pass = false;
        }
        if (!pass) {
            throw new Exception("setGetChangeClientIDTopicTest");
        }
    }

    @Test
    public void setGetExceptionListenerTest() throws Exception {
        boolean pass = true;
        Object tc = null;
        try {
            logger.log(System.Logger.Level.INFO, "Setup JmsTool for TOPIC");
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            logger.log(System.Logger.Level.INFO, "Create ExceptionListener");
            ExceptionListener foo = new ExceptionListener(){

                public void onException(JMSException e) {
                }
            };
            logger.log(System.Logger.Level.INFO, "Call setExceptionListener on Connection object");
            this.tool.getDefaultTopicConnection().setExceptionListener(foo);
            ExceptionListener foo2 = this.tool.getDefaultTopicConnection().getExceptionListener();
            if (!foo2.equals(foo)) {
                logger.log(System.Logger.Level.ERROR, "getExceptionListener doesn't match setExceptionListener");
                pass = false;
            }
        }
        catch (Exception eee) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception received: " + eee.getMessage());
            pass = false;
        }
        if (!pass) {
            throw new Exception("setGetExceptionListenerTest");
        }
    }

    @Test
    public void reverseReceiveClientAckTest() throws Exception {
        boolean pass = true;
        try {
            int i;
            int i2;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            Topic[] t = new Topic[3];
            TopicPublisher[] tPublisher = new TopicPublisher[3];
            TopicSubscriber[] tSubscriber = new TopicSubscriber[3];
            Message[] msg = new Message[3];
            for (i2 = 0; i2 < 3; ++i2) {
                logger.log(System.Logger.Level.INFO, "Creating Topic " + i2 + " of 2 (3 total)");
                t[i2] = this.tool.createNewTopic("testT" + i2);
            }
            logger.log(System.Logger.Level.INFO, "Creating 3 senders");
            for (i2 = 0; i2 < 3; ++i2) {
                logger.log(System.Logger.Level.INFO, "sender " + i2);
                tPublisher[i2] = this.tool.getDefaultTopicSession().createPublisher(t[i2]);
            }
            logger.log(System.Logger.Level.INFO, "Creating CLIENT_ACKNOWLEDGE session for receiving");
            TopicSession receiveSession = this.tool.getDefaultTopicConnection().createTopicSession(false, 2);
            logger.log(System.Logger.Level.INFO, "Creating 3 receivers in receive session");
            for (int i3 = 0; i3 < 3; ++i3) {
                logger.log(System.Logger.Level.INFO, "receiver " + i3);
                tSubscriber[i3] = receiveSession.createSubscriber(t[i3]);
            }
            this.tool.getDefaultTopicConnection().start();
            Message tempMsg = null;
            for (i = 0; i < 3; ++i) {
                logger.log(System.Logger.Level.INFO, "Sending message " + i);
                tempMsg = this.tool.getDefaultTopicSession().createMessage();
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "reverseReceiveClientAckTest");
                tPublisher[i].publish(tempMsg);
            }
            logger.log(System.Logger.Level.INFO, "Receive messages 0-2 in reverse order");
            for (i = 2; i >= 0; --i) {
                logger.log(System.Logger.Level.INFO, "Receive message " + i);
                msg[i] = tSubscriber[i].receive(this.timeout);
                if (msg[i] == null) {
                    logger.log(System.Logger.Level.ERROR, "Did not receive message from subscriber[" + i + "]");
                    pass = false;
                } else {
                    logger.log(System.Logger.Level.INFO, "msg = " + msg[i]);
                    logger.log(System.Logger.Level.INFO, "Acknowledge message " + i);
                    msg[i].acknowledge();
                }
                if (i != 2) continue;
                logger.log(System.Logger.Level.INFO, "session.recover()");
                receiveSession.recover();
            }
            logger.log(System.Logger.Level.INFO, "Try receiving message from all subscribers again (should not receive any)");
            for (i = 2; i >= 0; --i) {
                msg[i] = tSubscriber[i].receive(this.timeout);
                if (msg[i] == null) continue;
                logger.log(System.Logger.Level.ERROR, "Received message from subscriber[" + i + "], expected none");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("reverseReceiveClientAckTest");
        }
        if (!pass) {
            throw new Exception("reverseReceiveClientAckTest");
        }
    }

    @Test
    public void clientAckTopicTest() throws Exception {
        boolean pass = true;
        try {
            TextMessage sent1 = null;
            TextMessage sent2 = null;
            TextMessage sent3 = null;
            TextMessage sent4 = null;
            TextMessage rec2 = null;
            TextMessage rec4 = null;
            TopicSession tSess = null;
            TopicSubscriber tSub = null;
            TopicPublisher tPublisher = null;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicSubscriber().close();
            this.tool.getDefaultTopicSession().close();
            tSess = this.tool.getDefaultTopicConnection().createTopicSession(false, 2);
            logger.log(System.Logger.Level.INFO, "Start connection");
            this.tool.getDefaultTopicConnection().start();
            sent1 = tSess.createTextMessage();
            sent1.setText("test message 1");
            sent1.setStringProperty("COM_SUN_JMS_TESTNAME", "clientAckTopicTest1");
            sent2 = tSess.createTextMessage();
            sent2.setText("test message 2");
            sent2.setStringProperty("COM_SUN_JMS_TESTNAME", "clientAckTopicTest2");
            sent3 = tSess.createTextMessage();
            sent3.setText("test message 3");
            sent3.setStringProperty("COM_SUN_JMS_TESTNAME", "clientAckTopicTest3");
            sent4 = tSess.createTextMessage();
            sent4.setText("test message 4");
            sent4.setStringProperty("COM_SUN_JMS_TESTNAME", "clientAckTopicTest4");
            tSub = tSess.createSubscriber(this.tool.getDefaultTopic());
            tPublisher = tSess.createPublisher(this.tool.getDefaultTopic());
            logger.log(System.Logger.Level.TRACE, "Send three messages");
            tPublisher.publish((Message)sent1);
            tPublisher.publish((Message)sent2);
            tPublisher.publish((Message)sent3);
            logger.log(System.Logger.Level.TRACE, "Receive three messages");
            tSub.receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "Received the first message");
            rec2 = (TextMessage)tSub.receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "Received the second message");
            tSub.receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "Received the third message");
            logger.log(System.Logger.Level.TRACE, "Acknowledging the second message");
            rec2.acknowledge();
            logger.log(System.Logger.Level.TRACE, "Send the fourth message");
            tPublisher.publish((Message)sent4);
            logger.log(System.Logger.Level.TRACE, "Receive the fourth message");
            rec4 = (TextMessage)tSub.receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "Received the fourth message");
            logger.log(System.Logger.Level.TRACE, "Call session.recover()");
            tSess.recover();
            logger.log(System.Logger.Level.TRACE, "Attempt to receive unacked message - the fourth message again");
            rec4 = (TextMessage)tSub.receive(this.timeout);
            if (rec4 == null) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Did not receive unacked message");
            } else {
                if (!rec4.getText().equals(sent4.getText())) {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Received wrong message: " + rec4.getText());
                } else {
                    logger.log(System.Logger.Level.INFO, "Re-received message: " + rec4.getText());
                }
                logger.log(System.Logger.Level.TRACE, "Acknowledge the received message");
                rec4.acknowledge();
            }
            if (!pass) {
                throw new Exception("clientAckTopicTest Failed!!");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error: ", (Throwable)e);
            throw new Exception("clientAckTopicTest", e);
        }
    }

    @Test
    public void nonAckMsgsRedeliveredTopicTest() throws Exception {
        boolean pass = true;
        try {
            TextMessage tempMsg;
            int i;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            logger.log(System.Logger.Level.TRACE, "Close TopicSubscriber in default session -- only want one for Topic");
            this.tool.getDefaultTopicSubscriber().close();
            this.tool.getDefaultTopicSession().close();
            TopicSession tSession = this.tool.getDefaultTopicConnection().createTopicSession(false, 2);
            TopicSubscriber tSubscriber = tSession.createSubscriber(this.tool.getDefaultTopic());
            TopicPublisher tPublisher = tSession.createPublisher(this.tool.getDefaultTopic());
            this.tool.getDefaultTopicConnection().start();
            for (i = 0; i < 3; ++i) {
                tempMsg = tSession.createTextMessage();
                tempMsg.setText("test message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "nonAckMsgsRedeliveredTopicTest" + i);
                tPublisher.publish((Message)tempMsg);
                logger.log(System.Logger.Level.TRACE, "sent message " + i);
            }
            for (i = 0; i < 3; ++i) {
                tempMsg = (TextMessage)tSubscriber.receive(this.timeout);
                if (tempMsg == null) {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Did not receive message " + i);
                    continue;
                }
                logger.log(System.Logger.Level.TRACE, "received message " + i);
            }
            logger.log(System.Logger.Level.TRACE, "Call session recover()");
            tSession.recover();
            for (i = 0; i < 3; ++i) {
                tempMsg = (TextMessage)tSubscriber.receive(this.timeout);
                if (tempMsg != null) {
                    tempMsg.acknowledge();
                }
                if (tempMsg == null) {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Did not receive message " + i);
                    continue;
                }
                logger.log(System.Logger.Level.TRACE, "received message \"" + tempMsg.getText() + "\" second time");
            }
            tempMsg = (TextMessage)tSubscriber.receive(this.timeout);
            if (tempMsg != null) {
                logger.log(System.Logger.Level.ERROR, "Should not have received a message");
                pass = false;
            }
            tPublisher.close();
            tSubscriber.close();
            tSession.close();
            if (!pass) {
                throw new Exception("nonAckMsgsRedeliveredTopicTest failed!!!");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "nonAckMsgsRedeliveredTopicTest failed: ", (Throwable)e);
            throw new Exception("nonAckMsgsRedeliveredTopicTest failed", e);
        }
    }

    @Test
    public void topicRequestorSimpleSendAndRecvTest() throws Exception {
        boolean pass = true;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            TopicRequestor treq = null;
            logger.log(System.Logger.Level.INFO, "Set up JmsTool for TOPIC");
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.INFO, "Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setText("This is the request message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "topicRequestorSimpleSendAndRecvTest");
            logger.log(System.Logger.Level.INFO, "Set up MessageListener");
            this.tool.getDefaultTopicSubscriber().setMessageListener((MessageListener)new RequestorMsgListener(this.tool.getDefaultTopicSession()));
            logger.log(System.Logger.Level.INFO, "Set up TopicRequestor for request/response message exchange");
            TopicSession newts = this.tool.getDefaultTopicConnection().createTopicSession(false, 1);
            treq = new TopicRequestor(newts, this.tool.getDefaultTopic());
            logger.log(System.Logger.Level.INFO, "Send message request and receive message response using TopicRequestor");
            logger.log(System.Logger.Level.INFO, "Message request text: \"" + messageSent.getText() + "\"");
            messageReceived = (TextMessage)treq.request((Message)messageSent);
            logger.log(System.Logger.Level.INFO, "Message response text: \"" + messageReceived.getText() + "\"");
            if (messageReceived.getText().equals("This is the response message")) {
                logger.log(System.Logger.Level.INFO, "Received correct response message");
            } else {
                logger.log(System.Logger.Level.ERROR, "Received incorrect response message");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Close TopicRequestor");
            treq.close();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("topicRequestorSimpleSendAndRecvTest");
        }
        if (!pass) {
            throw new Exception("topicRequestorSimpleSendAndRecvTest failed");
        }
    }

    @Test
    public void topicRequestorExceptionTests() throws Exception {
        boolean pass = true;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            Topic invalidDest = null;
            TopicRequestor treq = null;
            logger.log(System.Logger.Level.INFO, "Set up JmsTool for TOPIC");
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.INFO, "Set up MessageListener");
            this.tool.getDefaultTopicSubscriber().setMessageListener((MessageListener)new RequestorMsgListener(this.tool.getDefaultTopicSession()));
            TopicSession newts = this.tool.getDefaultTopicConnection().createTopicSession(false, 1);
            try {
                logger.log(System.Logger.Level.INFO, "Set up TopicRequestor with InvalidDestination");
                treq = new TopicRequestor(newts, invalidDest);
                logger.log(System.Logger.Level.ERROR, "Didn't throw InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected InvalidDestinationException");
            }
            try {
                logger.log(System.Logger.Level.INFO, "Set up TopicRequestor with a closed TopicSession");
                newts.close();
                treq = new TopicRequestor(newts, this.tool.getDefaultTopic());
                logger.log(System.Logger.Level.ERROR, "Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected JMSException");
            }
            this.tool.closeAllConnections(this.connections);
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.INFO, "Set up TopicRequestor");
            treq = new TopicRequestor(this.tool.getDefaultTopicSession(), this.tool.getDefaultTopic());
            logger.log(System.Logger.Level.INFO, "Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setText("just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "topicRequestorExceptionTests");
            logger.log(System.Logger.Level.INFO, "Close TopicRequestor");
            treq.close();
            logger.log(System.Logger.Level.INFO, "Try a request/response message exchange on a closed TopicRequestor");
            try {
                messageReceived = (TextMessage)treq.request((Message)messageSent);
                if (messageReceived != null) {
                    logger.log(System.Logger.Level.INFO, "messageReceived=" + messageReceived.getText());
                }
                logger.log(System.Logger.Level.ERROR, "Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected JMSException");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("topicRequestorExceptionTests");
        }
        if (!pass) {
            throw new Exception("topicRequestorExceptionTests failed");
        }
    }

    private static class AutoAckMsgListener
    implements MessageListener {
        private boolean passed;
        TopicSession session;
        final DoneLatch monitor;

        public AutoAckMsgListener(DoneLatch latch, TopicSession tSession) {
            this.monitor = latch;
            this.session = tSession;
        }

        public boolean getPassed() {
            return this.passed;
        }

        public void onMessage(Message message) {
            try {
                if (!message.getBooleanProperty("lastMessage")) {
                    logger.log(System.Logger.Level.TRACE, "Received first message.");
                    if (message.getJMSRedelivered()) {
                        logger.log(System.Logger.Level.INFO, "Error: received first message twice");
                        this.passed = false;
                    }
                } else if (!message.getJMSRedelivered()) {
                    logger.log(System.Logger.Level.TRACE, "Received second message. Calling recover()");
                    this.session.recover();
                } else {
                    logger.log(System.Logger.Level.TRACE, "Received second message again as expected");
                    this.passed = true;
                    this.monitor.allDone();
                }
            }
            catch (JMSException e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.INFO, "Exception caught in message listener:\n" + e);
                this.passed = false;
                this.monitor.allDone();
            }
        }
    }

    private static class RequestorMsgListener
    implements MessageListener {
        TopicSession session = null;
        boolean pass = false;

        public RequestorMsgListener(TopicSession session) {
            this.session = session;
        }

        public boolean getPass() {
            return this.pass;
        }

        public void onMessage(Message message) {
            try {
                logger.log(System.Logger.Level.INFO, "RequestorMsgListener.onMessage()");
                if (message instanceof TextMessage) {
                    TextMessage tmsg = (TextMessage)message;
                    logger.log(System.Logger.Level.INFO, "Request message=" + tmsg.getText());
                    if (tmsg.getText().equals("This is the request message")) {
                        logger.log(System.Logger.Level.INFO, "Received request message is correct");
                        this.pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Received request message is incorrect");
                        this.pass = false;
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Received request message is not a TextMessage");
                    this.pass = false;
                }
                Topic replyT = (Topic)message.getJMSReplyTo();
                TopicPublisher publisher = this.session.createPublisher(replyT);
                TextMessage responseMsg = this.session.createTextMessage();
                responseMsg.setText("This is the response message");
                responseMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "RequestorMsgListenerResponseMsg");
                logger.log(System.Logger.Level.INFO, "Sending back response message");
                publisher.publish((Message)responseMsg);
            }
            catch (JMSException e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.INFO, "Exception caught in RequestorMsgListener:\n" + e);
            }
        }
    }
}

