/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.connector.whitebox;

import com.sun.ts.tests.common.connector.whitebox.DataElement;
import com.sun.ts.tests.common.connector.whitebox.TSConnection;
import com.sun.ts.tests.common.connector.whitebox.TSEISException;
import com.sun.ts.tests.common.connector.whitebox.TSeis;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class TSXaTransaction {
    static final int NOTRANSACTION = 0;
    static final int STARTED = 1;
    static final int SUSPENDED = 2;
    static final int ENDFAILED = 3;
    static final int ENDSUCCESSFUL = 4;
    static final int PREPARED = 5;
    private int status = 0;
    private Hashtable connections = new Hashtable();
    private Xid xid;

    public TSXaTransaction(Xid id) {
        this.xid = id;
    }

    public void addConnection(TSConnection con) {
        this.connections.put(con, "");
    }

    Hashtable getConnections() {
        return this.connections;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    public int prepare() throws XAException {
        System.out.println("TsXaTransaction.prepare");
        Hashtable ht = this.prepareTempTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            System.out.println("TSXaTransaction.prepare.inTheLoop");
            String key = (String)e.nextElement();
            DataElement de = (DataElement)ht.get(key);
            if (de.getStatus() == 4) {
                try {
                    TSeis.getTSeis().prepareInsert(de, this.xid);
                }
                catch (TSEISException ex) {
                    throw new XAException(100);
                }
            }
            if (de.getStatus() != 5 && de.getStatus() != 3) continue;
            System.out.println("TSXaTransaction.prepare.updatePrepare");
            try {
                TSeis.getTSeis().prepareChange(de, this.xid);
            }
            catch (TSEISException ex) {
                throw new XAException(100);
            }
        }
        return 0;
    }

    private Hashtable prepareTempTable() {
        System.out.println("TSXaTransaction.prepareTempTable");
        Hashtable<String, DataElement> temptable = new Hashtable<String, DataElement>();
        Enumeration e = this.connections.keys();
        while (e.hasMoreElements()) {
            System.out.println("TSXaTransaction.prepareTempTable.inTheLoop");
            TSConnection con = (TSConnection)e.nextElement();
            Hashtable temp = con.getTempTable();
            Enumeration e1 = temp.keys();
            while (e1.hasMoreElements()) {
                String key = (String)e1.nextElement();
                DataElement de = (DataElement)temp.get(key);
                if (temptable.containsKey(key)) {
                    DataElement de1 = (DataElement)temptable.get(key);
                    if (de.getVersion() < de1.getVersion()) continue;
                    temptable.put(key, de);
                    continue;
                }
                temptable.put(key, de);
            }
            con.rollback();
        }
        return temptable;
    }

    public void commit(boolean onePhase) throws XAException {
        System.out.println("TsXaTransaction.commit." + onePhase);
        if (onePhase) {
            Hashtable ht = this.prepareTempTable();
            Enumeration e = ht.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                DataElement de = (DataElement)ht.get(key);
                if (de.getStatus() == 4) {
                    try {
                        TSeis.getTSeis().actualInsert(de);
                    }
                    catch (TSEISException ex) {
                        throw new XAException(100);
                    }
                }
                if (de.getStatus() == 5) {
                    try {
                        TSeis.getTSeis().actualUpdate(de);
                    }
                    catch (TSEISException ex) {
                        throw new XAException(100);
                    }
                }
                if (de.getStatus() != 3) continue;
                try {
                    TSeis.getTSeis().actualDelete(de.getKey());
                }
                catch (TSEISException ex) {
                    throw new XAException(100);
                }
            }
        } else {
            TSeis.getTSeis().commit(this.xid);
        }
    }

    public void rollback() {
        if (this.status == 5) {
            TSeis.getTSeis().rollback(this.xid);
        } else {
            Enumeration e = this.connections.keys();
            while (e.hasMoreElements()) {
                TSConnection con = (TSConnection)e.nextElement();
                con.rollback();
            }
        }
    }

    public DataElement read(String elementkey) throws TSEISException {
        Hashtable<String, DataElement> temptable = new Hashtable<String, DataElement>();
        Enumeration e = this.connections.keys();
        while (e.hasMoreElements()) {
            TSConnection con = (TSConnection)e.nextElement();
            Hashtable temp = con.getTempTable();
            Enumeration e1 = temp.keys();
            while (e1.hasMoreElements()) {
                String key = (String)e1.nextElement();
                DataElement de = (DataElement)temp.get(key);
                if (temptable.containsKey(key)) {
                    DataElement de1 = (DataElement)temptable.get(key);
                    if (de.getVersion() < de1.getVersion()) continue;
                    temptable.put(key, de);
                    continue;
                }
                temptable.put(key, de);
            }
        }
        if (temptable.containsKey(elementkey)) {
            DataElement de = (DataElement)temptable.get(elementkey);
            if (de.getStatus() == 3) {
                throw new TSEISException("Data deleted");
            }
            return de;
        }
        return null;
    }
}

