/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.connector.localTx.transinflow;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.common.connector.whitebox.TSConnection;
import com.sun.ts.tests.common.connector.whitebox.TSDataSource;
import com.sun.ts.tests.connector.util.DBSupport;
import java.io.Serializable;
import java.util.Properties;
import java.util.Vector;

public class transinflowClient1
extends ServiceEETest
implements Serializable {
    private TSNamingContext nctx = null;
    private TSConnection con = null;
    private String whitebox_tx = null;
    private String whitebox_mdcomplete = null;
    private TSDataSource ds1 = null;
    private TSDataSource ds2 = null;
    private DBSupport dbutil = null;

    public static void main(String[] args) {
        transinflowClient1 theTests = new transinflowClient1();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.whitebox_tx = p.getProperty("whitebox-tx");
        this.whitebox_mdcomplete = p.getProperty("whitebox-mdcomplete");
        this.logMsg("Using: " + this.whitebox_tx);
        this.logMsg("Using: " + this.whitebox_mdcomplete);
        try {
            this.dbutil = new DBSupport();
        }
        catch (Exception e) {
            throw new Exception("Exception constructing DBSupport object: " + e.getMessage(), e);
        }
        try {
            this.nctx = new TSNamingContext();
            this.ds2 = (TSDataSource)this.nctx.lookup(this.whitebox_mdcomplete);
            this.ds1 = (TSDataSource)this.nctx.lookup(this.whitebox_tx);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logMsg((String)("Exception during JNDI lookup: " + e.getMessage()));
        }
    }

    public void testGetTransactionSupport() throws Exception {
        Vector log = null;
        boolean b1 = false;
        TestUtil.logMsg((String)"establishing connection to rar...");
        try {
            TestUtil.logMsg((String)"Getting RA log.");
            this.ds2.setLogFlag(true);
            this.con = this.ds2.getConnection();
            log = this.ds2.getStateLog();
            TestUtil.logTrace((String)"Got RA log and connection.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new Exception(sqle.getMessage(), sqle);
        }
        String toCheck1 = "MDCompleteMCF.getTransactionSupport called";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (!str.startsWith(toCheck1)) continue;
            b1 = true;
        }
        if (!b1) {
            throw new Exception("testGetTransactionSupport is incorrectly implemented");
        }
        TestUtil.logMsg((String)"Methods called correctly");
        TestUtil.logMsg((String)"Performing end to end verification...");
        try {
            this.dbutil.insertIntoTable(this.con);
            TestUtil.logMsg((String)"Values inserted into table!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception inserting into table.");
            throw new Exception(sqle.getMessage(), sqle);
        }
        try {
            this.dbutil.dropTable(this.con);
            TestUtil.logMsg((String)"Table has been dropped!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception dropping table.");
            throw new Exception(sqle.getMessage(), sqle);
        }
    }

    public void testSetResourceAdapterMethod() throws Exception {
        Vector log = null;
        boolean b1 = false;
        boolean b2 = false;
        TestUtil.logMsg((String)"establishing connection to rar...");
        try {
            TestUtil.logMsg((String)"Got RA log.");
            this.ds2.setLogFlag(true);
            this.con = this.ds2.getConnection();
            log = this.ds2.getStateLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new Exception(sqle.getMessage(), sqle);
        }
        String toCheck1 = "MDCompleteMCF setResourceAdapter 1";
        String toCheck2 = "MDCompleteMCF setResourceAdapter 2";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (str.startsWith(toCheck1)) {
                b1 = true;
            }
            if (!str.startsWith(toCheck2)) continue;
            b2 = true;
        }
        if (!(b1 & !b2)) {
            throw new Exception("testSetResourceAdapterMethod found errors with invocation of setResourceAdapter method.");
        }
        TestUtil.logMsg((String)"testSetResourceAdapterMethod called correctly");
        TestUtil.logMsg((String)"Performing end to end verification...");
        try {
            this.dbutil.insertIntoTable(this.con);
            TestUtil.logMsg((String)"Values inserted into table!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception inserting into table.");
            throw new Exception(sqle.getMessage(), sqle);
        }
        try {
            this.dbutil.dropTable(this.con);
            TestUtil.logMsg((String)"Table has been dropped!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception dropping table.");
            throw new Exception(sqle.getMessage(), sqle);
        }
    }

    public void testXATerminator() throws Exception {
        Vector log = null;
        boolean b1 = false;
        boolean b2 = false;
        boolean b3 = false;
        TestUtil.logMsg((String)"establishing connection to rar...");
        try {
            TestUtil.logMsg((String)"Got RA log.");
            this.ds1.setLogFlag(true);
            this.con = this.ds1.getConnection();
            log = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new Exception(sqle.getMessage(), sqle);
        }
        String toCheck1 = "WorkXid Submitted";
        String toCheck2 = "XATerminator is not null";
        String toCheck3 = "Xid Committed";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (str.startsWith(toCheck1)) {
                b1 = true;
            }
            if (str.startsWith(toCheck2)) {
                b2 = true;
            }
            if (!str.startsWith(toCheck3)) continue;
            b3 = true;
        }
        if (!(b1 && b2 && b3)) {
            throw new Exception("TransactionInflow is incorrectly implemented");
        }
        TestUtil.logMsg((String)"Methods called correctly");
        TestUtil.logMsg((String)"Performing end to end verification...");
        try {
            this.dbutil.insertIntoTable(this.con);
            TestUtil.logMsg((String)"Values inserted into table!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception inserting into table.");
            throw new Exception(sqle.getMessage(), sqle);
        }
        try {
            this.dbutil.dropTable(this.con);
            TestUtil.logMsg((String)"Table has been dropped!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception dropping table.");
            throw new Exception(sqle.getMessage(), sqle);
        }
    }

    public void testTransactionSynchronizationRegistry() throws Exception {
        Vector log = null;
        boolean b1 = false;
        TestUtil.logMsg((String)"establishing connection to rar...");
        try {
            TestUtil.logMsg((String)"Got RA log.");
            this.ds1.setLogFlag(true);
            this.con = this.ds1.getConnection();
            log = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new Exception(sqle.getMessage(), sqle);
        }
        String toCheck1 = "getTransactionSynchronizationRegistry supported by Server";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (!str.startsWith(toCheck1)) continue;
            b1 = true;
        }
        if (!b1) {
            throw new Exception("TransactionInflow is incorrectly implemented");
        }
        TestUtil.logMsg((String)"Methods called correctly");
    }

    public void testConcurrentWorkXid() throws Exception {
        Vector log = null;
        boolean b1 = false;
        TestUtil.logMsg((String)"establishing connection to rar...");
        try {
            TestUtil.logMsg((String)"Got RA log.");
            this.ds1.setLogFlag(true);
            this.con = this.ds1.getConnection();
            log = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new Exception(sqle.getMessage(), sqle);
        }
        String toCheck1 = "WorkException.TX_CONCURRENT_WORK_DISALLOWED caught";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (!str.startsWith(toCheck1)) continue;
            b1 = true;
        }
        if (!b1) {
            throw new Exception("WorkException.TX_CONCURRENT_WORK_DISALLOWED not caught");
        }
        TestUtil.logMsg((String)"Methods called correctly");
        TestUtil.logMsg((String)"Performing end to end verification...");
        try {
            this.dbutil.insertIntoTable(this.con);
            TestUtil.logMsg((String)"Values inserted into table!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception inserting into table.");
            throw new Exception(sqle.getMessage(), sqle);
        }
        try {
            this.dbutil.dropTable(this.con);
            TestUtil.logMsg((String)"Table has been dropped!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception dropping table.");
            throw new Exception(sqle.getMessage(), sqle);
        }
    }

    public void cleanup() throws Exception {
        TestUtil.logMsg((String)"Cleanup");
        if (this.ds1 != null) {
            this.ds1.clearLog();
        }
        if (this.ds2 != null) {
            this.ds2.clearLog();
        }
        try {
            if (this.con != null) {
                this.con.close();
            }
        }
        catch (Exception sqle) {
            TestUtil.logErr((String)("Exception on cleanup: " + sqle.getMessage()), (Throwable)sqle);
        }
    }
}

