/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.common.util;

import ee.jakarta.tck.pages.common.util.JspTestUtil;
import jakarta.servlet.jsp.tagext.TagData;
import jakarta.servlet.jsp.tagext.TagExtraInfo;
import jakarta.servlet.jsp.tagext.ValidationMessage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class BaseTCKExtraInfo
extends TagExtraInfo {
    private static boolean _wasCalled = false;
    private TagData _data = null;

    public ValidationMessage[] validate(TagData tagData) {
        BaseTCKExtraInfo.debug("In validate().  Setting _wasCalled to true.");
        _wasCalled = true;
        this._data = tagData;
        String message = null;
        String testMethod = tagData.getAttributeString("test");
        ValidationMessage[] msg = null;
        try {
            Method tMethod = ((Object)((Object)this)).getClass().getMethod(testMethod, new Class[0]);
            BaseTCKExtraInfo.debug("Invoking test method " + testMethod + "() on " + ((Object)((Object)this)).getClass().getName());
            String result = (String)tMethod.invoke((Object)this, new Object[0]);
            if (result != null) {
                msg = JspTestUtil.getValidationMessage(tagData.getId(), result);
            }
        }
        catch (Throwable t) {
            if (t instanceof InvocationTargetException) {
                Throwable root = ((InvocationTargetException)t).getTargetException();
                message = "Test FAILED.  Unexpected TargetInvocationException.  Root cause: " + root.toString() + " : " + root.getMessage();
            } else {
                message = "Test FAILED.  Unexpected exception during test invocation.  " + t.toString() + " : " + t.getMessage();
            }
            msg = JspTestUtil.getValidationMessage(tagData.getId(), message);
        }
        return msg;
    }

    public static boolean teiWasCalled() {
        return _wasCalled;
    }

    public static void reset() {
        BaseTCKExtraInfo.debug("Resetting _wasCalled to false.");
        _wasCalled = false;
    }

    protected TagData getTagData() {
        return this._data;
    }

    private static void debug(String message) {
        JspTestUtil.debug("[BaseTCKExtraInfo] " + message);
    }
}

