/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee20.resourcedefs.descriptor;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSProducer;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnectionFactory;
import java.util.Properties;

public class Client
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.ee20.resourcedefs.descriptor.Client";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient ConnectionFactory cf = null;
    private transient ConnectionFactory cfra = null;
    private transient QueueConnectionFactory qcf = null;
    private transient TopicConnectionFactory tcf = null;
    private transient TopicConnectionFactory dtcf = null;
    private transient Topic topic = null;
    private transient Topic topica = null;
    private transient Queue queue = null;
    private transient JMSContext context = null;
    private transient JMSConsumer consumerQ = null;
    private transient JMSProducer producerQ = null;
    private transient JMSConsumer consumerT = null;
    private transient JMSProducer producerT = null;
    private boolean queueTest = false;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    String vehicle;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            this.vehicle = p.getProperty("vehicle");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must not be null ");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must not be null ");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' in ts.jte must not be null");
            }
            TestUtil.logMsg((String)"Lookup JMS factories defined in Deployment Descriptors");
            TestUtil.logMsg((String)"Lookup JMS destinations defined in Deployment Descriptors");
            TestUtil.logMsg((String)"See <jms-connectionfactory> and <jms-destination> tags in DD's");
            TSNamingContext namingctx = new TSNamingContext();
            String prefix = null;
            if (this.vehicle.equals("appclient")) {
                prefix = "AppClient";
            } else if (this.vehicle.equals("ejb")) {
                prefix = "EJB";
            } else if (this.vehicle.equals("servlet")) {
                prefix = "Servlet";
            } else if (this.vehicle.equals("jsp")) {
                prefix = "JSP";
            }
            TestUtil.logMsg((String)("Lookup java:global/" + prefix + "MyTestConnectionFactory"));
            this.cf = (ConnectionFactory)namingctx.lookup("java:global/" + prefix + "MyTestConnectionFactory");
            TestUtil.logMsg((String)("Lookup java:app/" + prefix + "MyTestQueueConnectionFactory"));
            this.qcf = (QueueConnectionFactory)namingctx.lookup("java:app/" + prefix + "MyTestQueueConnectionFactory");
            TestUtil.logMsg((String)("Lookup java:module/" + prefix + "MyTestTopicConnectionFactory"));
            this.tcf = (TopicConnectionFactory)namingctx.lookup("java:module/" + prefix + "MyTestTopicConnectionFactory");
            TestUtil.logMsg((String)("Lookup java:comp/env/jms/" + prefix + "MyTestDurableTopicConnectionFactory"));
            this.dtcf = (TopicConnectionFactory)namingctx.lookup("java:comp/env/jms/" + prefix + "MyTestDurableTopicConnectionFactory");
            TestUtil.logMsg((String)("Lookup java:global/env/" + prefix + "MyTestQueue"));
            this.queue = (Queue)namingctx.lookup("java:global/env/" + prefix + "MyTestQueue");
            TestUtil.logMsg((String)("Lookup java:app/env/" + prefix + "MyTestTopic"));
            this.topic = (Topic)namingctx.lookup("java:app/env/" + prefix + "MyTestTopic");
            TestUtil.logMsg((String)"Create JMSContext, JMSProducer's and JMSConsumer's");
            this.context = this.cf.createContext(this.user, this.password, 1);
            this.producerQ = this.context.createProducer();
            this.consumerQ = this.context.createConsumer((Destination)this.queue);
            this.producerT = this.context.createProducer();
            this.consumerT = this.context.createConsumer((Destination)this.topic);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new Exception("setup failed!", e);
        }
    }

    public void cleanup() throws Exception {
        try {
            if (this.queueTest && this.consumerQ != null) {
                TestUtil.logMsg((String)"Flush any messages left on Queue");
                Message rmsg = this.consumerQ.receive(this.timeout);
                while (rmsg != null) {
                    rmsg = this.consumerQ.receiveNoWait();
                    if (rmsg != null) continue;
                    rmsg = this.consumerQ.receiveNoWait();
                }
                this.consumerQ.close();
            }
            if (this.consumerT != null) {
                this.consumerT.close();
            }
            TestUtil.logMsg((String)"Close JMSContext Objects");
            if (this.context != null) {
                this.context.close();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new Exception("cleanup failed!", e);
        }
    }

    public void sendAndRecvQueueTest() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            this.queueTest = true;
            TestUtil.logMsg((String)"Creating TextMessage via JMSContext.createTextMessage(String)");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvQueueTest");
            TestUtil.logMsg((String)"Sending TextMessage via JMSProducer.send(Destination, Message)");
            this.producerQ.send((Destination)this.queue, (Message)expTextMessage);
            TestUtil.logMsg((String)"Receive TextMessage via JMSconsumer.receive(long)");
            TextMessage actTextMessage = (TextMessage)this.consumerQ.receive(this.timeout);
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                TestUtil.logMsg((String)"TextMessage is correct");
            } else {
                TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new Exception("sendAndRecvQueueTest", e);
        }
        if (!pass) {
            throw new Exception("sendAndRecvQueueTest failed");
        }
    }

    public void sendAndRecvTopicTest() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            this.queueTest = false;
            TestUtil.logMsg((String)"Creating TextMessage via JMSContext.createTextMessage(String)");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvTopicTest");
            TestUtil.logMsg((String)"Sending TextMessage via JMSProducer.send(Destination, Message)");
            this.producerT.send((Destination)this.topic, (Message)expTextMessage);
            TestUtil.logMsg((String)"Receive TextMessage via JMSconsumer.receive(long)");
            TextMessage actTextMessage = (TextMessage)this.consumerT.receive(this.timeout);
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                TestUtil.logMsg((String)"TextMessage is correct");
            } else {
                TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new Exception("sendAndRecvTopicTest", e);
        }
        if (!pass) {
            throw new Exception("sendAndRecvTopicTest failed");
        }
    }

    public void checkClientIDOnDurableConnFactoryTest() throws Exception {
        boolean pass = true;
        JMSContext context = null;
        try {
            this.queueTest = false;
            TestUtil.logMsg((String)"Create JMSContext from durable topic connection factory");
            TestUtil.logMsg((String)"Check the client id which is configured as MyClientID in the deployment descriptors");
            context = this.dtcf.createContext(this.user, this.password, 1);
            String clientid = context.getClientID();
            if (clientid == null) {
                TestUtil.logErr((String)"Client ID value is null (expected MyClientID)");
                pass = false;
            } else if (clientid.equals("MyClientID")) {
                TestUtil.logMsg((String)"Client ID value is correct (MyClientID)");
            } else {
                TestUtil.logErr((String)("Client ID value is incorrect (expected MyClientID, got " + clientid + ")"));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new Exception("checkClientIDOnDurableConnFactoryTest", e);
        }
        finally {
            try {
                if (context != null) {
                    context.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("checkClientIDOnDurableConnFactoryTest failed");
        }
    }
}

